/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.assistbalance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.util.BiTreeNode;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.report.assistbalance.AssistBalanceContext;
import kd.fi.gl.report.assistbalance.model.AssistBalanceKey;
import kd.fi.gl.report.assistbalance.model.AssistBalanceSubtotal;
import kd.fi.gl.report.assistbalance.model.AssistTreeCategoryVO;
import kd.fi.gl.util.FastKey;

public class BalanceSubtotalSorter {
    private static final Log LOG = LogFactory.getLog(BalanceSubtotalSorter.class);
    private static final char LONG_NUMBER_CANCAT = '_';
    private static final Comparator _comparator = new Comparator<FastKey>(){

        @Override
        public int compare(FastKey o1, FastKey o2) {
            for (int i = 0; i < o1.getFactors().size(); ++i) {
                Object o1Value = o1.getFactors().get(i);
                Object o2Value = o2.getFactors().get(i);
                int diffIndex = 0;
                if (null == o1Value || null == o2Value) {
                    if (null != o1Value) {
                        diffIndex = 1;
                    } else if (null != o2Value) {
                        diffIndex = -1;
                    }
                    if (DebugTrace.enable()) {
                        LOG.info("null_factor\uff1ao1 - {}, o2 - {}", (Object)o1, (Object)o2);
                    }
                } else if (o1Value instanceof Long) {
                    diffIndex = Long.compare((Long)o1Value, (Long)o2Value);
                } else if (o1Value instanceof String) {
                    diffIndex = ((String)o1Value).compareTo((String)o2Value);
                } else if (o1Value instanceof Integer) {
                    diffIndex = Integer.compare((Integer)o1Value, (Integer)o2Value);
                } else {
                    Object invalidValue = o1Value;
                    LOG.error("invalid value is\uff1a{}", invalidValue);
                    if (null != invalidValue) {
                        LOG.error("invalid type is\uff1a{}", invalidValue.getClass());
                    }
                    throw new KDBizException(GLErrorCode.NOT_IMPLEMENT, new Object[0]);
                }
                if (diffIndex == 0) continue;
                return diffIndex > 0 ? 1 : -1;
            }
            return 0;
        }
    };
    private final List<Map<Long, String>> assistIdNumMapList;

    public BalanceSubtotalSorter(List<Map<Long, String>> assistIdNumMapList) {
        this.assistIdNumMapList = assistIdNumMapList;
    }

    public List<AssistBalanceSubtotal> executeForAssist(Collection<AssistBalanceSubtotal> subtotals, boolean isShowCurrency) {
        TreeMap<FastKey, AssistBalanceSubtotal> accSubtotalSortMap = new TreeMap<FastKey, AssistBalanceSubtotal>(_comparator);
        for (AssistBalanceSubtotal subtotal : subtotals) {
            FastKey fastKey = this.buildSortKeyForAssist(subtotal, isShowCurrency);
            accSubtotalSortMap.put(fastKey, subtotal);
        }
        if (subtotals.size() != accSubtotalSortMap.size()) {
            throw new KDBizException(GLErrorCode.BIZ_ERR, new Object[]{"wrong sort method which swallow some items."});
        }
        return new ArrayList<AssistBalanceSubtotal>(accSubtotalSortMap.values());
    }

    private FastKey buildSortKeyForAssist(AssistBalanceSubtotal x, boolean isShowCurrency) {
        FastKey fastKey = new FastKey(new Object[0]);
        AssistBalanceKey balanceKey = x.getSampleBalanceKey();
        List<Object> assistValues = balanceKey.getAssistValues();
        for (int i = 0; i < assistValues.size(); ++i) {
            fastKey.addFactor(assistValues.get(i));
        }
        fastKey.addFactor((Object)AssistBalanceContext.getAccountVOById(balanceKey.getAccountId()).getNumber());
        fastKey.addFactor((Object)balanceKey.getAccountId());
        if (isShowCurrency) {
            fastKey.addFactor((Object)balanceKey.getCurrencyId());
        }
        return fastKey;
    }

    public List<AssistBalanceSubtotal> executeForFlat(Collection<AssistBalanceSubtotal> subtotals, boolean isShowCurrency) {
        TreeMap<FastKey, AssistBalanceSubtotal> accSubtotalSortMap = new TreeMap<FastKey, AssistBalanceSubtotal>(_comparator);
        for (AssistBalanceSubtotal subtotal : subtotals) {
            FastKey fastKey = BalanceSubtotalSorter.buildSortKeyForFlat(subtotal, this.assistIdNumMapList, isShowCurrency);
            accSubtotalSortMap.put(fastKey, subtotal);
        }
        if (subtotals.size() != accSubtotalSortMap.size()) {
            throw new KDBizException(GLErrorCode.BIZ_ERR, new Object[]{"wrong sort method which swallow some items."});
        }
        return new ArrayList<AssistBalanceSubtotal>(accSubtotalSortMap.values());
    }

    private static FastKey buildSortKeyForFlat(AssistBalanceSubtotal x, List<Map<Long, String>> assistNumbers, boolean isShowCurrency) {
        FastKey fastKey = new FastKey(new Object[0]);
        AssistBalanceKey balanceKey = x.getSampleBalanceKey();
        List<Object> assistValues = balanceKey.getAssistValues();
        for (int i = 0; i < assistValues.size(); ++i) {
            Map<Long, String> idNumberMap = assistNumbers.get(i);
            if (assistValues.get(i) instanceof Long) {
                fastKey.addFactor((Object)idNumberMap.get(assistValues.get(i)));
                fastKey.addFactor(assistValues.get(i));
                continue;
            }
            fastKey.addFactor(assistValues.get(i));
        }
        fastKey.addFactor((Object)AssistBalanceContext.getAccountVOById(balanceKey.getAccountId()).getNumber());
        fastKey.addFactor((Object)balanceKey.getAccountId());
        if (isShowCurrency) {
            fastKey.addFactor((Object)balanceKey.getCurrencyId());
        }
        return fastKey;
    }

    public List<AssistBalanceSubtotal> executeForTreeStyle(Collection<AssistBalanceSubtotal> subtotals, int treeAssistIndex, BiTreeNode<Long, AssistTreeCategoryVO> assistTree, boolean isShowCurrency) {
        TreeMap<FastKey, AssistBalanceSubtotal> accSubtotalSortMap = new TreeMap<FastKey, AssistBalanceSubtotal>(_comparator);
        HashMap<Long, String> assistLongNumberMap = new HashMap<Long, String>(8);
        assistTree.preTravel(x -> {
            long assistId = (Long)x.getId();
            BiTreeNode parentNode = x.getParent();
            StringBuilder sb = new StringBuilder();
            if (null != parentNode) {
                sb.append(parentNode.getPropValue("longnumber")).append('_');
            }
            sb.append(assistId);
            String longNumber = sb.toString();
            x.setPropValue("longnumber", (Object)longNumber);
            assistLongNumberMap.put(assistId, longNumber);
        });
        for (AssistBalanceSubtotal subtotal : subtotals) {
            FastKey fastKey = BalanceSubtotalSorter.buildSortKeyForTreeStyle(subtotal, this.assistIdNumMapList, treeAssistIndex, assistLongNumberMap, isShowCurrency);
            accSubtotalSortMap.put(fastKey, subtotal);
        }
        if (subtotals.size() != accSubtotalSortMap.size()) {
            throw new KDBizException(GLErrorCode.BIZ_ERR, new Object[]{"wrong sort method which swallow some items."});
        }
        return new ArrayList<AssistBalanceSubtotal>(accSubtotalSortMap.values());
    }

    private static FastKey buildSortKeyForTreeStyle(AssistBalanceSubtotal x, List<Map<Long, String>> assistNumbers, int treeAssistIndex, Map<Long, String> assistLongNumberMap, boolean isShowCurrency) {
        FastKey fastKey = new FastKey(new Object[0]);
        AssistBalanceKey balanceKey = x.getSampleBalanceKey();
        fastKey.addFactor((Object)AssistBalanceContext.getAccountVOById(balanceKey.getAccountId()).getNumber());
        fastKey.addFactor((Object)balanceKey.getAccountId());
        List<Object> assistValues = balanceKey.getAssistValues();
        Long categoryAssistId = x.getAssistTreeCategoryVO().getId();
        String longNumber = assistLongNumberMap.getOrDefault(categoryAssistId, String.valueOf(assistValues.get(treeAssistIndex)));
        fastKey.addFactor((Object)longNumber);
        for (int i = 0; i < assistValues.size(); ++i) {
            Map<Long, String> idNumberMap = assistNumbers.get(i);
            if (assistValues.get(i) instanceof Long) {
                fastKey.addFactor((Object)idNumberMap.get(assistValues.get(i)));
                fastKey.addFactor(assistValues.get(i));
                continue;
            }
            fastKey.addFactor(assistValues.get(i));
        }
        if (isShowCurrency) {
            fastKey.addFactor((Object)balanceKey.getCurrencyId());
        }
        return fastKey;
    }
}

