/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.assistbalance;

import java.util.HashMap;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.assistbalance.AssistBalanceContext;
import kd.fi.gl.report.assistbalance.model.AssistBalanceAmountRow;
import kd.fi.gl.report.assistbalance.model.AssistSubtotalKey;

public class QuickTotalService {
    private static final Log LOG = LogFactory.getLog(QuickTotalService.class);
    private Map<AssistSubtotalKey, AssistBalanceAmountRow> dimensionBalances = new HashMap<AssistSubtotalKey, AssistBalanceAmountRow>(128);
    private final MulOrgQPRpt qParam;
    private final Boolean isSkipOriginCurrency;

    public QuickTotalService(MulOrgQPRpt qParam) {
        this.qParam = qParam;
        this.isSkipOriginCurrency = AssistBalanceContext.get().getIsEnableCurrencyGroup() == false;
    }

    public void accept(AssistSubtotalKey subtotalKey, AssistBalanceAmountRow balanceRow) {
        AssistBalanceAmountRow existBalance = this.dimensionBalances.get(subtotalKey);
        if (null == existBalance) {
            this.dimensionBalances.put(subtotalKey, balanceRow);
        } else {
            existBalance.merge(balanceRow, this.isSkipOriginCurrency);
        }
    }

    public Map<Long, AssistBalanceAmountRow> calculatedTotal() {
        HashMap<Long, AssistBalanceAmountRow> result = new HashMap<Long, AssistBalanceAmountRow>(8);
        for (Map.Entry<AssistSubtotalKey, AssistBalanceAmountRow> entry : this.dimensionBalances.entrySet()) {
            Long currency;
            AssistBalanceAmountRow total;
            AssistSubtotalKey subtotalKey = entry.getKey();
            AssistBalanceAmountRow amountRow = entry.getValue();
            if (!this.qParam.isShowDataByDC()) {
                amountRow.autoAdjustByAmountDc();
            }
            if (null == (total = (AssistBalanceAmountRow)result.get(currency = subtotalKey.getCurrencyId()))) {
                try {
                    AssistBalanceAmountRow cloneAmount = amountRow.clone();
                    cloneAmount.resetToZero();
                    cloneAmount.merge(amountRow, this.isSkipOriginCurrency);
                    result.put(currency, cloneAmount);
                    continue;
                }
                catch (Exception e) {
                    throw new KDBizException(GLErrorCode.BIZ_ERR, new Object[0]);
                }
            }
            total.merge(amountRow, this.isSkipOriginCurrency);
        }
        return result;
    }

    public Map<AssistSubtotalKey, AssistBalanceAmountRow> getDimensionBalances() {
        return this.dimensionBalances;
    }

    public int getTotalComposeAmount() {
        return this.dimensionBalances.size();
    }

    public void clear() {
        this.dimensionBalances.clear();
    }
}

