/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.assistbalance;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.report.CurType;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.OrgType;
import kd.fi.gl.report.assistbalance.AccountIndex;
import kd.fi.gl.report.assistbalance.AssistBalanceContext;
import kd.fi.gl.report.assistbalance.GroupOptions;
import kd.fi.gl.report.assistbalance.model.AccountVO;
import kd.fi.gl.report.assistbalance.model.AssistBalanceKey;
import kd.fi.gl.report.assistbalance.model.AssistBalanceSubtotal;
import kd.fi.gl.report.assistbalance.model.BalanceRow;
import kd.fi.gl.report.assistbalance.model.SubtotalType;
import kd.fi.gl.util.FastKey;

public class SubTotalCalculator {
    private static final Log LOG = LogFactory.getLog(SubTotalCalculator.class);
    protected final MulOrgQPRpt qParam;

    public SubTotalCalculator(MulOrgQPRpt qParam) {
        this.qParam = qParam;
    }

    public List<AssistBalanceSubtotal> calculateSubtotal(List<BalanceRow> balanceRows) {
        List<AssistBalanceSubtotal> accSubtotals;
        if (CollectionUtils.isEmpty(balanceRows)) {
            return Collections.EMPTY_LIST;
        }
        HashMap<Long, String> unitIdNameMap = new HashMap<Long, String>();
        if (this.qParam.isShowQty()) {
            Set measureUnitIds = balanceRows.stream().map(x -> x.getBalanceKey().getMeasureUnitId()).collect(Collectors.toSet());
            DataSet _measureUnitDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_measureunits", (String)"id,name", (QFilter[])new QFilter("id", "in", measureUnitIds).toArray(), null);
            while (_measureUnitDS.hasNext()) {
                Row row = _measureUnitDS.next();
                unitIdNameMap.put(row.getLong("id"), row.getString("name"));
            }
        }
        if (!(accSubtotals = this.calculateSubtotalByAccount(balanceRows)).isEmpty()) {
            boolean isNeedCalOrg;
            ArrayList<SubtotalType> types = new ArrayList<SubtotalType>(3);
            if (this.qParam.getCurType() == CurType.ALL) {
                types.add(SubtotalType.Currency);
            }
            boolean bl = isNeedCalOrg = this.qParam.getOrgType() != OrgType.ENTITY && this.qParam.isShowOrg();
            if (isNeedCalOrg) {
                types.add(SubtotalType.Org);
            }
            if (this.qParam.isShowQty()) {
                types.add(SubtotalType.MeasureUnit);
            }
            if (!this.qParam.getComAssistEntityList().isEmpty()) {
                types.add(SubtotalType.ComAssist);
            }
            for (AssistBalanceSubtotal accSubtotal : accSubtotals) {
                List<AssistBalanceSubtotal> parentSubtotals = Collections.singletonList(accSubtotal);
                for (int i = 0; i < types.size(); ++i) {
                    SubtotalType currentType = (SubtotalType)((Object)types.get(i));
                    ArrayList<AssistBalanceSubtotal> newSubtotals = new ArrayList<AssistBalanceSubtotal>(128);
                    for (AssistBalanceSubtotal parentSubtotal : parentSubtotals) {
                        List<AssistBalanceSubtotal> childSubtotals;
                        if (SubtotalType.Currency == currentType) {
                            childSubtotals = this.calculateSubtotalByCurrency(parentSubtotal.getDetailRows());
                        } else if (SubtotalType.Org == currentType) {
                            childSubtotals = this.calculateSubtotalByOrg(parentSubtotal.getDetailRows());
                        } else if (SubtotalType.MeasureUnit == currentType) {
                            childSubtotals = this.calculateSubtotalByMeasureUnit(parentSubtotal.getDetailRows());
                            childSubtotals.stream().forEach(x -> {
                                AssistBalanceKey key = x.getSampleBalanceKey();
                                key.setMeasureUnitName((String)unitIdNameMap.get(key.getMeasureUnitId()));
                            });
                        } else if (SubtotalType.ComAssist == currentType) {
                            childSubtotals = this.calculateSubtotalByComAssist(parentSubtotal.getDetailRows());
                        } else {
                            throw new KDBizException(GLErrorCode.NOT_IMPLEMENT, new Object[0]);
                        }
                        parentSubtotal.setNestSubtotals(childSubtotals);
                        newSubtotals.addAll(childSubtotals);
                    }
                    parentSubtotals = newSubtotals;
                }
            }
        }
        accSubtotals.forEach(x -> x.clearDetailRows());
        return accSubtotals;
    }

    public List<AssistBalanceSubtotal> calculateTotalFromSubtotal(List<AssistBalanceSubtotal> accSubtotals) {
        AccountIndex accountIndex = AssistBalanceContext.get().getAccountIndex();
        Map<String, Integer> accNumbers = accSubtotals.stream().map(x -> accountIndex.getAccountVO(x.getSampleBalanceKey().getAccountId())).collect(Collectors.toMap(x -> x.getNumber(), x -> x.getLevel(), (s, a) -> s));
        List accNumList = accNumbers.entrySet().stream().map(x -> Tuple.create(x.getKey(), x.getValue())).collect(Collectors.toList());
        accNumList.sort((x, y) -> Integer.compare((Integer)x.item2, (Integer)y.item2));
        HashSet<String> topLevelAccNums = new HashSet<String>(8);
        for (int i = 0; i < accNumList.size(); ++i) {
            String curAccNum = (String)((Tuple)accNumList.get((int)i)).item1;
            int curAccLevel = (Integer)((Tuple)accNumList.get((int)i)).item2;
            if (!accNumList.subList(0, i).stream().noneMatch(e -> {
                String _accNum = (String)e.item1;
                int _accLevel = (Integer)e.item2;
                return !curAccNum.equals(_accNum) && curAccNum.startsWith(_accNum) && curAccLevel > _accLevel;
            })) continue;
            topLevelAccNums.add(curAccNum);
        }
        if (DebugTrace.enable()) {
            LOG.info("all accounts used to final total list as:  {}", topLevelAccNums);
        }
        Predicate<AssistBalanceSubtotal> levelFilter = this.qParam.isShowLeafAccount() ? x -> accountIndex.getAccountVO(x.getSampleBalanceKey().getAccountId()).isLeaf() : x -> {
            AccountVO accountVO = accountIndex.getAccountVO(x.getSampleBalanceKey().getAccountId());
            int level = accountVO.getLevel();
            boolean isLeaf = accountVO.isLeaf();
            return Objects.equals(level, this.qParam.getAccountLevel()) || level < this.qParam.getAccountLevel() && isLeaf;
        };
        List detailRows = accSubtotals.stream().filter(levelFilter).collect(Collectors.toList());
        if (this.qParam.isShowOrg()) {
            ArrayList orgAaccSubtotals = new ArrayList(8);
            detailRows.stream().forEach(x -> orgAaccSubtotals.addAll(x.collect()));
            detailRows = orgAaccSubtotals.stream().filter(x -> x.getType() == SubtotalType.Org).collect(Collectors.toList());
        }
        List<BalanceRow> balanceRows = detailRows.stream().map(x -> {
            try {
                return new BalanceRow(x.getSampleBalanceKey(), x.getAmount().clone());
            }
            catch (CloneNotSupportedException e) {
                LOG.error("failed to clone on :" + e.getMessage(), (Throwable)e);
                throw new KDBizException("failed to clone:" + e.getMessage());
            }
        }).collect(Collectors.toList());
        if (!this.qParam.isShowDataByDC()) {
            balanceRows.stream().forEach(x -> x.getAmount().autoAdjustByAmountDc());
        }
        return this.calculateTotal(balanceRows);
    }

    private List<AssistBalanceSubtotal> calculateTotal(List<BalanceRow> balanceRows) {
        Function<AssistBalanceKey, FastKey> groupFunc;
        if (CollectionUtils.isEmpty(balanceRows)) {
            return Collections.EMPTY_LIST;
        }
        GroupOptions groupOptions = new GroupOptions();
        if (AssistBalanceContext.get().getIsEnableCurrencyGroup().booleanValue()) {
            groupFunc = x -> new FastKey(new Object[]{x.getCurrencyId()});
        } else {
            groupFunc = x -> FastKey.EMPTY;
            groupOptions.setSkipOriginCur(true);
        }
        groupOptions.setGroupKeyFunc(groupFunc);
        return this.groupByCondition(SubtotalType.Total, balanceRows, groupOptions);
    }

    private List<AssistBalanceSubtotal> calculateSubtotalByAccount(List<BalanceRow> assistBalances) {
        GroupOptions groupOptions = this.getSubtotalFunctionByAccount();
        if (groupOptions.getGroupKeyFunc().isPresent()) {
            return this.groupByCondition(SubtotalType.Account, assistBalances, groupOptions);
        }
        return Collections.EMPTY_LIST;
    }

    private List<AssistBalanceSubtotal> calculateSubtotalByCurrency(List<BalanceRow> assistBalances) {
        GroupOptions groupOptions = this.getSubtotalFunctionByCurrency();
        if (groupOptions.getGroupKeyFunc().isPresent()) {
            List<AssistBalanceSubtotal> subtotals = this.groupByCondition(SubtotalType.Currency, assistBalances, groupOptions);
            Collections.sort(subtotals, Comparator.comparing(AssistBalanceSubtotal::getSampleBalanceKey, Comparator.comparingLong(AssistBalanceKey::getCurrencyId)));
            return subtotals;
        }
        return Collections.EMPTY_LIST;
    }

    private List<AssistBalanceSubtotal> calculateSubtotalByOrg(List<BalanceRow> assistBalances) {
        GroupOptions groupOptions = this.getSubtotalFunctionByOrg();
        if (groupOptions.getGroupKeyFunc().isPresent()) {
            List<AssistBalanceSubtotal> subtotals = this.groupByCondition(SubtotalType.Org, assistBalances, groupOptions);
            Collections.sort(subtotals, Comparator.comparing(AssistBalanceSubtotal::getSampleBalanceKey, Comparator.comparingLong(AssistBalanceKey::getOrgId)));
            return subtotals;
        }
        return Collections.EMPTY_LIST;
    }

    private List<AssistBalanceSubtotal> calculateSubtotalByMeasureUnit(List<BalanceRow> assistBalances) {
        GroupOptions groupOptions = this.getSubtotalFunctionByMeasureUnit();
        if (groupOptions.getGroupKeyFunc().isPresent()) {
            List<AssistBalanceSubtotal> subtotals = this.groupByCondition(SubtotalType.MeasureUnit, assistBalances, groupOptions);
            Collections.sort(subtotals, Comparator.comparing(AssistBalanceSubtotal::getSampleBalanceKey, Comparator.comparingLong(AssistBalanceKey::getMeasureUnitId)));
            return subtotals;
        }
        return Collections.EMPTY_LIST;
    }

    private List<AssistBalanceSubtotal> calculateSubtotalByComAssist(List<BalanceRow> assistBalances) {
        GroupOptions groupOptions = this.getSubtotalFunctionByComAssist();
        if (groupOptions.getGroupKeyFunc().isPresent()) {
            List<AssistBalanceSubtotal> subtotals = this.groupByCondition(SubtotalType.ComAssist, assistBalances, groupOptions);
            return subtotals;
        }
        return Collections.EMPTY_LIST;
    }

    public GroupOptions getSubtotalFunctionByAccount() {
        GroupOptions groupOptions = new GroupOptions();
        if (AssistBalanceContext.get().getIsEnableCurrencyGroup().booleanValue()) {
            groupOptions.setGroupKeyFunc(x -> {
                FastKey fastKey = new FastKey(new Object[0]);
                fastKey.addFactor(x.getAssistValues());
                fastKey.addFactor((Object)AssistBalanceContext.getAccountVOById(x.getAccountId()).convertTo());
                fastKey.addFactor((Object)x.getCurrencyId());
                return fastKey;
            });
        } else {
            groupOptions.setGroupKeyFunc(x -> {
                FastKey fastKey = new FastKey(new Object[0]);
                fastKey.addFactor(x.getAssistValues());
                fastKey.addFactor((Object)AssistBalanceContext.getAccountVOById(x.getAccountId()).convertTo());
                return fastKey;
            });
            groupOptions.setSkipOriginCur(true);
        }
        return groupOptions;
    }

    private GroupOptions getSubtotalFunctionByCurrency() {
        GroupOptions groupOptions = new GroupOptions();
        if (CurType.ALL == this.qParam.getCurType()) {
            groupOptions.setGroupKeyFunc(x -> {
                FastKey fastKey = new FastKey(new Object[0]);
                fastKey.addFactor(x.getAssistValues());
                fastKey.addFactor((Object)AssistBalanceContext.getAccountVOById(x.getAccountId()).convertTo());
                fastKey.addFactor((Object)x.getCurrencyId());
                return fastKey;
            });
        }
        return groupOptions;
    }

    private GroupOptions getSubtotalFunctionByOrg() {
        GroupOptions groupOptions = new GroupOptions();
        if (this.qParam.getOrgType() != OrgType.ENTITY) {
            if (CurType.BASE == this.qParam.getCurType()) {
                groupOptions.setGroupKeyFunc(x -> {
                    FastKey fastKey = new FastKey(new Object[0]);
                    fastKey.addFactor(x.getAssistValues());
                    fastKey.addFactor((Object)x.getOrgId());
                    fastKey.addFactor((Object)AssistBalanceContext.getAccountVOById(x.getAccountId()).convertTo());
                    return fastKey;
                });
                groupOptions.setSkipOriginCur(true);
            } else {
                groupOptions.setGroupKeyFunc(x -> {
                    FastKey fastKey = new FastKey(new Object[0]);
                    fastKey.addFactor(x.getAssistValues());
                    fastKey.addFactor((Object)x.getOrgId());
                    fastKey.addFactor((Object)AssistBalanceContext.getAccountVOById(x.getAccountId()).convertTo());
                    fastKey.addFactor((Object)x.getCurrencyId());
                    return fastKey;
                });
            }
        }
        return groupOptions;
    }

    private GroupOptions getSubtotalFunctionByMeasureUnit() {
        GroupOptions groupOptions = new GroupOptions();
        groupOptions.setGroupKeyFunc(x -> {
            FastKey fastKey = new FastKey(new Object[0]);
            fastKey.addFactor((Object)x.getMeasureUnitId());
            fastKey.addFactor((Object)x.getMeasureUnitName());
            return fastKey;
        });
        return groupOptions;
    }

    private GroupOptions getSubtotalFunctionByComAssist() {
        GroupOptions groupOptions = new GroupOptions();
        groupOptions.setGroupKeyFunc(x -> {
            FastKey fastKey = new FastKey(new Object[0]);
            for (Long val : x.getComAssistVals()) {
                fastKey.addFactor((Object)val);
            }
            return fastKey;
        });
        return groupOptions;
    }

    private List<AssistBalanceSubtotal> groupByCondition(SubtotalType type, List<BalanceRow> detailData, GroupOptions groupOptions) {
        HashMap<FastKey, AssistBalanceSubtotal> subtotalMap = new HashMap<FastKey, AssistBalanceSubtotal>(8);
        for (BalanceRow entry : detailData) {
            AssistBalanceKey balanceKey = entry.getBalanceKey();
            if (SubtotalType.Total != type && !this.qParam.isShowLeafAccount() && AssistBalanceContext.getAccountVOById(balanceKey.getAccountId()).getLevel() > this.qParam.getAccountLevel()) continue;
            FastKey groupKey = groupOptions.getGroupKeyFunc().get().apply(balanceKey);
            AssistBalanceSubtotal subtotal = (AssistBalanceSubtotal)subtotalMap.get(groupKey);
            if (null == subtotal) {
                subtotal = new AssistBalanceSubtotal(type, balanceKey, groupKey);
                subtotalMap.put(groupKey, subtotal);
            }
            subtotal.accept(entry, groupOptions.isSkipOriginCur());
        }
        return new ArrayList<AssistBalanceSubtotal>(subtotalMap.values());
    }
}

