/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.assistbalance.export;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.report.ReportList;
import kd.fi.bd.model.Context;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.gl.report.assistbalance.AssistBalQueryRpt;
import kd.fi.gl.report.assistbalance.export.AssistBalConverter;
import kd.fi.gl.report.assistbalance.export.AssistBalRowTransformer;
import kd.fi.gl.report.export.ExportOption;
import kd.fi.gl.report.export.convert.IDatasetRowTypeConverter;
import kd.fi.gl.report.export.processor.BatchProcessorChain;
import kd.fi.gl.report.export.processor.IBatchTransformer;
import kd.fi.gl.report.export.processor.ReportExcelTransformer;

public class AssistBalReportExporter {
    private static final Log logger = LogFactory.getLog(AssistBalReportExporter.class);

    public static Context exportAssistBal(ReportQueryParam reportQueryParam, ReportList reportList, ExportOption exportOption) {
        long tick = System.currentTimeMillis();
        AssistBalQueryRpt assistBalQueryRpt = new AssistBalQueryRpt();
        try {
            BatchProcessorChain chain = new BatchProcessorChain.Builder(exportOption, null, (IBatchTransformer)new AssistBalRowTransformer(2000)).appendLast((IBatchTransformer)new ReportExcelTransformer(reportList, 2000)).build();
            int batchSize = BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"fi.gl.report.assistbal.batchlimit", (int)100000);
            long singleTick = System.currentTimeMillis();
            DataSet balanceDataSet = assistBalQueryRpt.queryExportBalance(reportQueryParam, chain.getContext());
            List flexFieldNames = (List)chain.getContext().query("flexFieldNames");
            logger.info("assistbal_exportall query all balance dataSet cost:{}ms", (Object)(System.currentTimeMillis() - singleTick));
            int batch = 0;
            ArrayList<Row> batchList = new ArrayList<Row>(batchSize);
            Object[] preAssistValues = new Object[flexFieldNames.size()];
            AssistBalConverter balRowConverter = new AssistBalConverter();
            chain.setDatasetRowTypeConverter((IDatasetRowTypeConverter)balRowConverter);
            RowMeta rowMeta = balanceDataSet.getRowMeta();
            while (balanceDataSet.hasNext()) {
                Row row = balanceDataSet.next();
                Object[] assistValues = new Object[flexFieldNames.size()];
                for (int i = 0; i < flexFieldNames.size(); ++i) {
                    assistValues[i] = row.get((String)flexFieldNames.get(i));
                }
                if (batchList.size() >= batchSize && !Arrays.equals(preAssistValues, assistValues)) {
                    singleTick = System.currentTimeMillis();
                    chain.registerContext("finalDataSetBatch", (Object)false);
                    DataSet calculatedDataSet = assistBalQueryRpt.batchCalExportBalance(reportQueryParam, chain.getContext(), batchList);
                    chain.getProcessors().forEach(processor -> processor.reset());
                    RowMeta cachedRowMeta = (RowMeta)chain.getContextProp("rowMeta");
                    if (Objects.isNull(cachedRowMeta)) {
                        chain.registerRowMeta(calculatedDataSet.getRowMeta());
                    }
                    chain.feed((Iterator)calculatedDataSet);
                    logger.info("assistbal_exportall dataSet{},batchSize:{} cost:{}ms", new Object[]{++batch, batchList.size(), System.currentTimeMillis() - singleTick});
                    batchList.clear();
                }
                batchList.add(balRowConverter.convertTo(rowMeta, row));
                preAssistValues = assistValues;
            }
            singleTick = System.currentTimeMillis();
            chain.registerContext("finalDataSetBatch", (Object)true);
            DataSet calculatedDataSet = assistBalQueryRpt.batchCalExportBalance(reportQueryParam, chain.getContext(), batchList);
            chain.getProcessors().forEach(processor -> processor.reset());
            RowMeta cachedRowMeta = (RowMeta)chain.getContextProp("rowMeta");
            if (Objects.isNull(cachedRowMeta)) {
                chain.registerRowMeta(calculatedDataSet.getRowMeta());
            }
            chain.setFinalDataSetFlag(true);
            chain.feed((Iterator)calculatedDataSet);
            logger.info("assistbal_exportall dataSet{},batchSize:{} cost:{}ms", new Object[]{++batch, batchList.size(), System.currentTimeMillis() - singleTick});
            logger.info("assistbal_exportall total cost:{}ms", (Object)(System.currentTimeMillis() - tick));
            return chain.getContext();
        }
        catch (Throwable e) {
            logger.error(e);
            throw new KDBizException(e.getMessage());
        }
    }
}

