/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.assistbalance.model;

import java.util.List;
import java.util.Objects;
import kd.bos.cache.ThreadCache;
import kd.fi.gl.report.assistbalance.model.AccountDistinctKey;
import kd.fi.gl.util.MultiIndexTreeCache;

public class AssistSubtotalKey {
    private static final String _CACHE_KEY = "fi.gl.assistbalance.assistsubtotalkey.cache";
    public static int INIT_COUNT = 0;
    private final List<Object> assistValues;
    private final AccountDistinctKey accountKey;
    private Long currencyId = null;

    private AssistSubtotalKey(List<Object> assistValues, AccountDistinctKey accountKey, Long currencyId) {
        this.assistValues = assistValues;
        this.accountKey = accountKey;
        this.currencyId = currencyId;
        ++INIT_COUNT;
    }

    public static AssistSubtotalKey retrievalFromCacheOrBuild(List<Object> assistValues, AccountDistinctKey accountKey, Long currencyId) {
        MultiIndexTreeCache _keyCache = (MultiIndexTreeCache)ThreadCache.get((Object)_CACHE_KEY, () -> new MultiIndexTreeCache("AssistSubtotalKey", 100000));
        AssistSubtotalKey value = (AssistSubtotalKey)_keyCache.retrieval(new Object[]{assistValues, accountKey, currencyId});
        if (null != value) {
            return value;
        }
        return new AssistSubtotalKey(assistValues, accountKey, currencyId);
    }

    public static void clearAll() {
        ((MultiIndexTreeCache)ThreadCache.get((Object)_CACHE_KEY)).clearAll();
    }

    public List<Object> getAssistValues() {
        return this.assistValues;
    }

    public AccountDistinctKey getAccountKey() {
        return this.accountKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssistSubtotalKey that = (AssistSubtotalKey)o;
        return this.assistValues.equals(that.assistValues) && this.accountKey.equals(that.accountKey) && Objects.equals(this.currencyId, that.currencyId);
    }

    public int hashCode() {
        return Objects.hash(this.assistValues, this.accountKey, this.currencyId);
    }

    public String toString() {
        return "AssistSubtotalKey{assistValues=" + this.assistValues + ", accountKey=" + this.accountKey + ", currencyId=" + this.currencyId + '}';
    }

    public Long getCurrencyId() {
        return this.currencyId;
    }
}

