/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.assistbalance.model;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.function.Predicate;
import kd.fi.gl.enums.CurrencyType;

public class BalanceUnitVO
implements Cloneable,
Serializable {
    private static volatile Predicate<BigDecimal> isNotEqZero = x -> BigDecimal.ZERO.compareTo((BigDecimal)x) != 0;
    public static int INIT_COUNT = 0;
    private static final int DC_DEBIT = 1;
    private static volatile Predicate<BigDecimal> isExceedZero = x -> BigDecimal.ZERO.compareTo((BigDecimal)x) < 0;
    private static volatile Predicate<BigDecimal> isLessZero = x -> BigDecimal.ZERO.compareTo((BigDecimal)x) > 0;
    private final CurrencyType type;
    private BigDecimal yearBeginDebit;
    private BigDecimal yearBeginCredit;
    private BigDecimal beginDebit;
    private BigDecimal beginCredit;
    private BigDecimal debit;
    private BigDecimal credit;
    private BigDecimal yearDebit;
    private BigDecimal yearCredit;
    private BigDecimal endDebit;
    private BigDecimal endCredit;

    public BalanceUnitVO(CurrencyType type) {
        ++INIT_COUNT;
        this.type = type;
    }

    public BalanceUnitVO(CurrencyType type, boolean isShowByDC, int dc, BigDecimal debit, BigDecimal credit, BigDecimal begin, BigDecimal end, BigDecimal yearDebit, BigDecimal yearCredit) {
        ++INIT_COUNT;
        this.type = type;
        this.debit = debit;
        this.credit = credit;
        BigDecimal yearBeginDebitRawVal = end.subtract(yearDebit).add(yearCredit);
        if (isShowByDC) {
            if (dc == 1) {
                this.yearBeginDebit = yearBeginDebitRawVal;
                this.yearBeginCredit = BigDecimal.ZERO;
                this.beginDebit = begin;
                this.beginCredit = BigDecimal.ZERO;
                this.endDebit = end;
                this.endCredit = BigDecimal.ZERO;
            } else {
                this.yearBeginDebit = BigDecimal.ZERO;
                this.yearBeginCredit = yearBeginDebitRawVal.negate();
                this.beginDebit = BigDecimal.ZERO;
                this.beginCredit = begin.negate();
                this.endDebit = BigDecimal.ZERO;
                this.endCredit = end.negate();
            }
        } else {
            this.yearBeginDebit = isExceedZero.test(yearBeginDebitRawVal) ? yearBeginDebitRawVal : BigDecimal.ZERO;
            this.yearBeginCredit = isLessZero.test(yearBeginDebitRawVal) ? yearBeginDebitRawVal.negate() : BigDecimal.ZERO;
            this.beginDebit = isExceedZero.test(begin) ? begin : BigDecimal.ZERO;
            this.beginCredit = isLessZero.test(begin) ? begin.negate() : BigDecimal.ZERO;
            this.endDebit = isExceedZero.test(end) ? end : BigDecimal.ZERO;
            this.endCredit = isLessZero.test(end) ? end.negate() : BigDecimal.ZERO;
        }
        this.yearDebit = yearDebit;
        this.yearCredit = yearCredit;
    }

    public void autoAdjustByAmountDc() {
        BigDecimal beginDiff = this.beginDebit.subtract(this.beginCredit);
        if (isExceedZero.test(beginDiff)) {
            this.setBeginDebit(beginDiff);
            this.setBeginCredit(BigDecimal.ZERO);
        } else {
            this.setBeginDebit(BigDecimal.ZERO);
            this.setBeginCredit(beginDiff.abs());
        }
        BigDecimal endDiff = this.endDebit.subtract(this.endCredit);
        if (isExceedZero.test(endDiff)) {
            this.setEndDebit(endDiff);
            this.setEndCredit(BigDecimal.ZERO);
        } else {
            this.setEndDebit(BigDecimal.ZERO);
            this.setEndCredit(endDiff.abs());
        }
        BigDecimal yearBeginDiff = this.yearBeginDebit.subtract(this.yearBeginCredit);
        if (isExceedZero.test(yearBeginDiff)) {
            this.setYearBeginDebit(yearBeginDiff);
            this.setYearBeginCredit(BigDecimal.ZERO);
        } else {
            this.setYearBeginDebit(BigDecimal.ZERO);
            this.setYearBeginCredit(yearBeginDiff.abs());
        }
    }

    public void adaptForPLVoucher() {
        this.yearBeginDebit = this.yearBeginDebit.negate();
        this.yearBeginCredit = this.yearBeginCredit.negate();
        this.debit = this.debit.negate();
        this.credit = this.credit.negate();
        this.beginDebit = this.beginDebit.negate();
        this.beginCredit = this.beginCredit.negate();
        this.yearDebit = this.yearDebit.negate();
        this.yearCredit = this.yearCredit.negate();
        this.endDebit = this.endDebit.negate();
        this.endCredit = this.endCredit.negate();
    }

    protected BalanceUnitVO clone() throws CloneNotSupportedException {
        return (BalanceUnitVO)super.clone();
    }

    public void resetToZero() {
        this.setDebit(BigDecimal.ZERO);
        this.setCredit(BigDecimal.ZERO);
        this.setBeginDebit(BigDecimal.ZERO);
        this.setBeginCredit(BigDecimal.ZERO);
        this.setEndDebit(BigDecimal.ZERO);
        this.setEndCredit(BigDecimal.ZERO);
        this.setYearBeginDebit(BigDecimal.ZERO);
        this.setYearBeginCredit(BigDecimal.ZERO);
        this.setYearDebit(BigDecimal.ZERO);
        this.setYearCredit(BigDecimal.ZERO);
    }

    public void negate() {
        if (!BigDecimal.ZERO.equals(this.getDebit())) {
            this.setDebit(this.getDebit().negate());
        }
        if (!BigDecimal.ZERO.equals(this.getCredit())) {
            this.setCredit(this.getCredit().negate());
        }
        if (!BigDecimal.ZERO.equals(this.getBeginDebit())) {
            this.setBeginDebit(this.getBeginDebit().negate());
        }
        if (!BigDecimal.ZERO.equals(this.getBeginCredit())) {
            this.setBeginCredit(this.getBeginCredit().negate());
        }
        if (!BigDecimal.ZERO.equals(this.getEndDebit())) {
            this.setEndDebit(this.getEndDebit().negate());
        }
        if (!BigDecimal.ZERO.equals(this.getEndCredit())) {
            this.setEndCredit(this.getEndCredit().negate());
        }
        if (!BigDecimal.ZERO.equals(this.getYearBeginDebit())) {
            this.setYearBeginDebit(this.getYearBeginDebit().negate());
        }
        if (!BigDecimal.ZERO.equals(this.getYearBeginCredit())) {
            this.setYearBeginCredit(this.getYearBeginCredit().negate());
        }
        if (!BigDecimal.ZERO.equals(this.getYearDebit())) {
            this.setYearDebit(this.getYearDebit().negate());
        }
        if (!BigDecimal.ZERO.equals(this.getYearCredit())) {
            this.setYearCredit(this.getYearCredit().negate());
        }
    }

    public void merge(BalanceUnitVO anotherUnit) {
        Preconditions.checkArgument((null != anotherUnit ? 1 : 0) != 0);
        Preconditions.checkState((this.type == anotherUnit.type ? 1 : 0) != 0);
        this.yearBeginDebit = this.yearBeginDebit.add(anotherUnit.yearBeginDebit);
        this.yearBeginCredit = this.yearBeginCredit.add(anotherUnit.yearBeginCredit);
        this.beginDebit = this.beginDebit.add(anotherUnit.beginDebit);
        this.beginCredit = this.beginCredit.add(anotherUnit.beginCredit);
        this.debit = this.debit.add(anotherUnit.debit);
        this.credit = this.credit.add(anotherUnit.credit);
        this.yearDebit = this.yearDebit.add(anotherUnit.yearDebit);
        this.yearCredit = this.yearCredit.add(anotherUnit.yearCredit);
        this.endDebit = this.endDebit.add(anotherUnit.endDebit);
        this.endCredit = this.endCredit.add(anotherUnit.endCredit);
    }

    public String toString() {
        return "type: " + this.type + ": yearBeginDebit=" + this.yearBeginDebit + ", yearBeginCredit=" + this.yearBeginCredit + ", beginDebit=" + this.beginDebit + ", beginCredit=" + this.beginCredit + ", debit=" + this.debit + ", credit=" + this.credit + ", yearDebit=" + this.yearDebit + ", yearCredit=" + this.yearCredit + ", endDebit=" + this.endDebit + ", endCredit=" + this.endCredit;
    }

    public BigDecimal getYearBeginDebit() {
        return this.yearBeginDebit;
    }

    public void setYearBeginDebit(BigDecimal yearBeginDebit) {
        this.yearBeginDebit = yearBeginDebit;
    }

    public BigDecimal getYearBeginCredit() {
        return this.yearBeginCredit;
    }

    public void setYearBeginCredit(BigDecimal yearBeginCredit) {
        this.yearBeginCredit = yearBeginCredit;
    }

    public BigDecimal getBeginDebit() {
        return this.beginDebit;
    }

    public void setBeginDebit(BigDecimal beginDebit) {
        this.beginDebit = beginDebit;
    }

    public BigDecimal getBeginCredit() {
        return this.beginCredit;
    }

    public void setBeginCredit(BigDecimal beginCredit) {
        this.beginCredit = beginCredit;
    }

    public BigDecimal getDebit() {
        return this.debit;
    }

    public void setDebit(BigDecimal debit) {
        this.debit = debit;
    }

    public BigDecimal getCredit() {
        return this.credit;
    }

    public void setCredit(BigDecimal credit) {
        this.credit = credit;
    }

    public BigDecimal getYearDebit() {
        return this.yearDebit;
    }

    public void setYearDebit(BigDecimal yearDebit) {
        this.yearDebit = yearDebit;
    }

    public BigDecimal getYearCredit() {
        return this.yearCredit;
    }

    public void setYearCredit(BigDecimal yearCredit) {
        this.yearCredit = yearCredit;
    }

    public BigDecimal getEndDebit() {
        return this.endDebit;
    }

    public void setEndDebit(BigDecimal endDebit) {
        this.endDebit = endDebit;
    }

    public BigDecimal getEndCredit() {
        return this.endCredit;
    }

    public void setEndCredit(BigDecimal endCredit) {
        this.endCredit = endCredit;
    }

    public boolean isBalanceNotEqZero() {
        BigDecimal endDiff = this.endDebit.subtract(this.endCredit);
        return isNotEqZero.test(endDiff);
    }

    public void autoAdjustAmount(boolean isShowByDC, int dc) {
        BigDecimal beginDiff = this.beginDebit.subtract(this.beginCredit);
        BigDecimal endDiff = this.endDebit.subtract(this.endCredit);
        BigDecimal yearBeginDiff = this.yearBeginDebit.subtract(this.yearBeginCredit);
        if (isShowByDC) {
            if (dc == 1) {
                this.yearBeginDebit = yearBeginDiff;
                this.yearBeginCredit = BigDecimal.ZERO;
                this.beginDebit = beginDiff;
                this.beginCredit = BigDecimal.ZERO;
                this.endDebit = endDiff;
                this.endCredit = BigDecimal.ZERO;
            } else {
                this.yearBeginDebit = BigDecimal.ZERO;
                this.yearBeginCredit = yearBeginDiff.negate();
                this.beginDebit = BigDecimal.ZERO;
                this.beginCredit = beginDiff.negate();
                this.endDebit = BigDecimal.ZERO;
                this.endCredit = endDiff.negate();
            }
        } else {
            if (isExceedZero.test(beginDiff)) {
                this.setBeginDebit(beginDiff);
                this.setBeginCredit(BigDecimal.ZERO);
            } else {
                this.setBeginDebit(BigDecimal.ZERO);
                this.setBeginCredit(beginDiff.abs());
            }
            if (isExceedZero.test(endDiff)) {
                this.setEndDebit(endDiff);
                this.setEndCredit(BigDecimal.ZERO);
            } else {
                this.setEndDebit(BigDecimal.ZERO);
                this.setEndCredit(endDiff.abs());
            }
            if (isExceedZero.test(yearBeginDiff)) {
                this.setYearBeginDebit(yearBeginDiff);
                this.setYearBeginCredit(BigDecimal.ZERO);
            } else {
                this.setYearBeginDebit(BigDecimal.ZERO);
                this.setYearBeginCredit(yearBeginDiff.abs());
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BalanceUnitVO that = (BalanceUnitVO)o;
        return this.type == that.type && Objects.equals(this.yearBeginDebit, that.yearBeginDebit) && Objects.equals(this.yearBeginCredit, that.yearBeginCredit) && Objects.equals(this.beginDebit, that.beginDebit) && Objects.equals(this.beginCredit, that.beginCredit) && Objects.equals(this.debit, that.debit) && Objects.equals(this.credit, that.credit) && Objects.equals(this.yearDebit, that.yearDebit) && Objects.equals(this.yearCredit, that.yearCredit) && Objects.equals(this.endDebit, that.endDebit) && Objects.equals(this.endCredit, that.endCredit);
    }
}

