/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.assistbalance.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.cache.ThreadCache;
import kd.bos.exception.KDBizException;
import kd.bos.util.CollectionUtils;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.util.MultiIndexTreeCache;

public class TreeGroupKey {
    private static final String _CACHE_KEY = "fi.gl.assistbalance.treegroupkey.cache";
    public static int INIT_COUNT = 0;
    private final List<Object> assistValues;
    private final List<Long> comAssistValues;
    private final Long measureUnitId;
    private final Long currencyId;

    private TreeGroupKey(List<Object> assistValues, List<Long> comAssistValues, Long currencyId, Long measureUnitId) {
        if (null == assistValues) {
            throw new KDBizException(GLErrorCode.BIZ_ERR, new Object[0]);
        }
        this.assistValues = assistValues;
        this.comAssistValues = comAssistValues;
        this.currencyId = currencyId;
        this.measureUnitId = measureUnitId;
        ++INIT_COUNT;
    }

    static TreeGroupKey retrievalFromCacheOrBuild(List<Object> assistValues, List<Long> comAssistValues, Long currencyId, Long measureUnitId) {
        TreeGroupKey value;
        MultiIndexTreeCache _keyCache = (MultiIndexTreeCache)ThreadCache.get((Object)_CACHE_KEY, () -> new MultiIndexTreeCache("TreeGroupKey", 100000));
        ArrayList<Object> _factors = new ArrayList<Object>(6);
        _factors.addAll(assistValues);
        if (!CollectionUtils.isEmpty(comAssistValues)) {
            _factors.addAll(comAssistValues);
        }
        if (null != currencyId) {
            _factors.add(currencyId);
        }
        if (null != measureUnitId) {
            _factors.add(measureUnitId);
        }
        if (null != (value = (TreeGroupKey)_keyCache.retrieval(_factors.toArray()))) {
            return value;
        }
        TreeGroupKey treeGroupKey = new TreeGroupKey(assistValues, comAssistValues, currencyId, measureUnitId);
        ((MultiIndexTreeCache)ThreadCache.get((Object)_CACHE_KEY)).addData((Object)treeGroupKey, _factors.toArray());
        return treeGroupKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreeGroupKey groupKey = (TreeGroupKey)o;
        return this.assistValues.equals(groupKey.assistValues) && Objects.equals(this.comAssistValues, groupKey.comAssistValues) && Objects.equals(this.measureUnitId, groupKey.measureUnitId) && Objects.equals(this.currencyId, groupKey.currencyId);
    }

    public String toString() {
        return "TreeGroupKey{assistValues=" + this.assistValues + "comAssistValues=" + this.comAssistValues + ", measureUnitId=" + this.measureUnitId + ", currencyId=" + this.currencyId + '}';
    }

    public int hashCode() {
        return Objects.hash(this.assistValues, this.comAssistValues, this.measureUnitId, this.currencyId);
    }

    public List<Object> getAssistValues() {
        return this.assistValues;
    }

    public List<Long> getComAssistValues() {
        return this.comAssistValues;
    }

    public Long getMeasureUnitId() {
        return this.measureUnitId;
    }

    public Long getCurrencyId() {
        return this.currencyId;
    }

    public static void clearAll() {
        ((MultiIndexTreeCache)ThreadCache.get((Object)_CACHE_KEY)).clearAll();
    }
}

