/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.cashflow;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.accountref.AccountRefUtils;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.bd.vo.CommonAssist;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.comassist.service.ComAssistService;
import kd.fi.gl.dataset.TreeNode;
import kd.fi.gl.exception.BOSException;
import kd.fi.gl.report.CashFlowQueryParam;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.cashflow.CashFlowBalanceFunction;
import kd.fi.gl.report.cashflow.CashFlowCollector;
import kd.fi.gl.report.cashflow.CashFlowItemFunction;
import kd.fi.gl.report.cashflow.CashFlowVouFunction;
import kd.fi.gl.report.common.CollectorParam;
import kd.fi.gl.report.common.DataSchema;
import kd.fi.gl.report.common.SumSchema;
import kd.fi.gl.util.CashFlowItemHelper;
import kd.fi.gl.util.GLUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.Triple;

public class CashFlowParallelQuery {
    private static final Log logger = LogFactory.getLog(CashFlowParallelQuery.class);
    private static final int PARALLELISM = Runtime.getRuntime().availableProcessors() + 1;
    private CashFlowQueryParam queryParam;
    private Map<Object, TreeNode> cfMasterIdMap;
    private Map<Object, TreeNode> cfNumMap;
    private Map<Object, TreeNode> cfItemIdMap;
    private Map<Object, TreeNode> allCfIdMap;
    private Map<Object, TreeNode> accMasterIdMap;
    private Map<Object, TreeNode> accIdMap;
    private RowMeta outPutRowMeta;
    private RowMeta outPutAccountRowMeta;
    private boolean queryByPeriod;
    private Set<Long> intAssgrpIds = null;
    private boolean isUnShowInsideCf;
    private boolean isOnlyShowInsideCf;
    private static final String[] grpBy = new String[]{"cfitem", "orgid", "assgrp"};

    public DataSet execute() {
        List<QFilter> filters = this.getCFFilter();
        List cfFilters = QueryParamRpt.splitQFilter((QFilter[])filters.toArray(new QFilter[0]), (String)"org", (int)PARALLELISM);
        List voucherFilters = new ArrayList();
        if (!this.queryByPeriod) {
            voucherFilters = QueryParamRpt.splitQFilter((QFilter[])this.getVoucherFilter(), (String)"org", (int)PARALLELISM);
        }
        List balanceFilters = QueryParamRpt.splitQFilter((QFilter[])this.getBalanceFilter(), (String)"org", (int)PARALLELISM);
        if (this.isUnShowInsideCf || this.isOnlyShowInsideCf) {
            this.intAssgrpIds = this.getIntBaseAssgrp(this.queryParam.getFilteredChildOrg());
        }
        CollectorParam param = new CollectorParam(this.outPutRowMeta, this.accIdMap, this.cfMasterIdMap, this.getSumSchema(), (MulOrgQPRpt)this.queryParam);
        CashFlowCollector collector = new CashFlowCollector(param, this.outPutAccountRowMeta, this.getAccSumSchema(), this.queryParam.getComAssistValsList().stream().map(comassist -> (String)comassist.t1).collect(Collectors.toSet()), this.queryParam.getPorg(), this.queryParam.getPeriodEndIdByQueryType(), this.cfNumMap, this.allCfIdMap);
        CountDownLatch cdl = new CountDownLatch(cfFilters.size() + balanceFilters.size() + voucherFilters.size());
        for (QFilter[] voucherFilter : voucherFilters) {
            ThreadService.execute(() -> {
                try {
                    logger.info("getVoucher--begin");
                    try (DataSet vouSet = this.getVoucherSet(voucherFilter);){
                        logger.info("getVoucher--put");
                        collector.setAccIdMap(this.accIdMap);
                        if (this.isUnShowInsideCf || this.isOnlyShowInsideCf) {
                            List cols = GLUtil.getDataSetCols((DataSet)vouSet);
                            DataSet hgDs = this.createDatSet(CashFlowParallelQuery.class, Collections.singletonList("hg"), Collections.singletonList(DataType.LongType), this.intAssgrpIds);
                            DataSet cfSetJoinHg = this.isUnShowInsideCf ? vouSet.join(hgDs, JoinType.LEFT).on("maincfassgrp", "hg").select(cols.toArray(new String[0]), new String[]{"hg"}).finish().filter("hg is null").select(cols.toArray(new String[0])) : vouSet.join(hgDs, JoinType.INNER).on("maincfassgrp", "hg").select(cols.toArray(new String[0])).finish();
                            collector.putData(cfSetJoinHg, new CashFlowVouFunction(cfSetJoinHg.getRowMeta(), param, this.cfItemIdMap, this.queryParam.getAssgrpIds(), this.outPutAccountRowMeta));
                        } else {
                            collector.putData(vouSet, new CashFlowVouFunction(vouSet.getRowMeta(), param, this.cfItemIdMap, this.queryParam.getAssgrpIds(), this.outPutAccountRowMeta));
                        }
                    }
                    logger.info("getVoucher--end");
                }
                catch (Exception e) {
                    logger.error("CashFlowCollector_voucherError\uff1a" + e.getMessage(), (Throwable)e);
                    collector.getErrorMap().put(Thread.currentThread().getName(), GLUtil.printError((Throwable)e));
                    throw e;
                }
                finally {
                    cdl.countDown();
                }
            }, (TaskType)TaskType.GL_CASH_FLOW_QUERY_DATA);
        }
        for (QFilter[] cfFilter : cfFilters) {
            ThreadService.execute(() -> {
                try {
                    logger.info("getCF--begin");
                    try (DataSet cfSet = this.getCFSet(cfFilter);){
                        logger.info("getCF--put");
                        if (this.isUnShowInsideCf || this.isOnlyShowInsideCf) {
                            List cols = GLUtil.getDataSetCols((DataSet)cfSet);
                            ArrayList colsRemoveAss = new ArrayList(cols);
                            if (!this.queryParam.isShowAssist()) {
                                colsRemoveAss.remove("assgrp");
                            }
                            DataSet hgDs = this.createDatSet(CashFlowParallelQuery.class, Collections.singletonList("hg"), Collections.singletonList(DataType.LongType), this.intAssgrpIds);
                            DataSet cfSetJoinHg = this.isUnShowInsideCf ? cfSet.join(hgDs, JoinType.LEFT).on("assgrp", "hg").select(cols.toArray(new String[0]), new String[]{"hg"}).finish().filter("hg is null").select(colsRemoveAss.toArray(new String[0])) : cfSet.join(hgDs, JoinType.INNER).on("assgrp", "hg").select(colsRemoveAss.toArray(new String[0])).finish();
                            collector.putData(cfSetJoinHg, new CashFlowItemFunction(cfSetJoinHg.getRowMeta(), param, this.cfItemIdMap));
                        } else {
                            collector.putData(cfSet, new CashFlowItemFunction(cfSet.getRowMeta(), param, this.cfItemIdMap));
                        }
                    }
                    logger.info("getCF--end");
                }
                catch (Exception e) {
                    logger.error("CashFlowCollector_cashflowError\uff1a" + e.getMessage(), (Throwable)e);
                    collector.getErrorMap().put(Thread.currentThread().getName(), GLUtil.printError((Throwable)e));
                    throw e;
                }
                finally {
                    cdl.countDown();
                }
            }, (TaskType)TaskType.GL_CASH_FLOW_QUERY_DATA);
        }
        for (QFilter[] balFilter : balanceFilters) {
            ThreadService.execute(() -> {
                try {
                    logger.info("getbalance--begin");
                    try (DataSet balSet = this.getAccBalance(balFilter);){
                        logger.info("getbalance--putData");
                        if (this.isUnShowInsideCf || this.isOnlyShowInsideCf) {
                            List cols = GLUtil.getDataSetCols((DataSet)balSet);
                            ArrayList colsRemoveAss = new ArrayList(cols);
                            if (!this.queryParam.isShowAssist()) {
                                colsRemoveAss.remove("assgrp");
                            }
                            DataSet hgDs = this.createDatSet(CashFlowParallelQuery.class, Collections.singletonList("hg"), Collections.singletonList(DataType.LongType), this.intAssgrpIds);
                            DataSet balSetJoinHg = this.isUnShowInsideCf ? balSet.join(hgDs, JoinType.LEFT).on("assgrp", "hg").select(cols.toArray(new String[0]), new String[]{"hg"}).finish().filter("hg is null").select(colsRemoveAss.toArray(new String[0])) : balSet.join(hgDs, JoinType.INNER).on("assgrp", "hg").select(colsRemoveAss.toArray(new String[0])).finish();
                            collector.putData(balSetJoinHg, new CashFlowBalanceFunction(balSetJoinHg.getRowMeta(), param, this.accMasterIdMap, this.outPutAccountRowMeta));
                        } else {
                            collector.putData(balSet, new CashFlowBalanceFunction(balSet.getRowMeta(), param, this.accMasterIdMap, this.outPutAccountRowMeta));
                        }
                    }
                    logger.info("getbalance--end");
                }
                catch (Exception e) {
                    logger.error("CashFlowCollector_balanceError\uff1a" + e.getMessage(), (Throwable)e);
                    collector.getErrorMap().put(Thread.currentThread().getName(), GLUtil.printError((Throwable)e));
                    throw e;
                }
                finally {
                    cdl.countDown();
                }
            }, (TaskType)TaskType.GL_CASH_FLOW_QUERY_DATA);
        }
        if (this.queryParam.isQueryFromInit()) {
            DataSet profitCashflow = this.getProfitCashflow(Collections.singletonList(this.queryParam.getPorg()), this.queryParam.getStartPeriod(), "id");
            if (profitCashflow != null && !profitCashflow.isEmpty()) {
                collector.putData(profitCashflow, new CashFlowItemFunction(profitCashflow.getRowMeta(), param, this.cfItemIdMap));
            }
        } else {
            QFilter orgQf = new QFilter("org", "in", (Object)this.queryParam.getChildOrg());
            QFilter bookTypeQf = new QFilter("bookstype", "=", (Object)this.queryParam.getBookType());
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"gl_accountbook", (String)"org,cashinitperiod", (QFilter[])new QFilter[]{orgQf, bookTypeQf});
            HashMap orgBooks = new HashMap(coll.size());
            coll.forEach(e -> orgBooks.compute(e.getLong("cashinitperiod"), (k, v) -> {
                if (CollectionUtils.isEmpty((Collection)v)) {
                    v = new ArrayList<Long>();
                }
                v.add(e.getLong("org"));
                return v;
            }));
            for (Map.Entry entry : orgBooks.entrySet()) {
                DataSet profitCashflow;
                Long cashIitPeriod = (Long)entry.getKey();
                boolean isCurrYear = cashIitPeriod / GLUtil.YEAR_PERIOD_L == this.queryParam.getPeriodEndIdByQueryType() / GLUtil.YEAR_PERIOD_L;
                if (!isCurrYear || (profitCashflow = this.getProfitCashflow((List)entry.getValue(), cashIitPeriod, "masterid")) == null || profitCashflow.isEmpty()) continue;
                collector.putData(profitCashflow, new CashFlowItemFunction(profitCashflow.getRowMeta(), param, this.cfItemIdMap));
            }
        }
        try {
            cdl.await();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new BOSException((Throwable)ex);
        }
        if (collector.getErrorMap().size() > 0) {
            Map<String, String> errorMap = collector.getErrorMap();
            errorMap.values().forEach(value -> {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u8868\u8ba1\u7b97\u51fa\u9519\uff1a%s\u3002", (String)"CashFlowParallelQuery_0", (String)"fi-gl-report", (Object[])new Object[0]), value));
            });
        }
        return collector.finish();
    }

    private List<QFilter> getCFFilter() {
        List<QFilter> list = this.queryParam.isQueryFromInit() ? this.getInitCashFlowFilter() : this.getCashFlowBaseFilter();
        list.addAll(this.getComassistFilter());
        return list;
    }

    public CashFlowParallelQuery(CashFlowQueryParam param) {
        this.queryParam = param;
        this.setCfitemParam();
        this.setAccountParam();
        this.outPutRowMeta = this.getOutPutRowMeta();
        this.outPutAccountRowMeta = this.getOutPutAccountRowMeta();
        this.queryByPeriod = this.queryParam.isQueryByPeriod();
        this.isUnShowInsideCf = this.queryParam.isUnShowInsideCf();
        this.isOnlyShowInsideCf = this.queryParam.isOnlyShowInsideCf();
    }

    private void setAccountParam() {
        DataSet accDS = this.getAccountSet();
        this.setAccountMap(accDS);
    }

    private DataSet getAccountSet() {
        QFilter filter = new QFilter("accounttable", "=", (Object)this.queryParam.getAccountTable());
        String sel = "id,masterid,parent,iscash,isbank,iscashequivalent iscasheq,dc,pltype";
        return QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".account"), (String)"bd_accountview", (String)sel, (QFilter[])filter.toArray(), null);
    }

    private void setAccountMap(DataSet accDS) {
        this.accIdMap = new HashMap<Object, TreeNode>();
        this.accMasterIdMap = new HashMap<Object, TreeNode>();
        for (Row row : accDS) {
            Long id = row.getLong("id");
            TreeNode node = new TreeNode(id.longValue());
            node.setMasterId(row.getLong("masterid").longValue());
            node.setParentId(row.getLong("parent").longValue());
            node.setPropValue("iscash", (Object)row.getBoolean("iscash"));
            node.setPropValue("isbank", (Object)row.getBoolean("isbank"));
            node.setPropValue("iscasheq", (Object)row.getBoolean("iscasheq"));
            node.setPropValue("dc", (Object)row.getString("dc"));
            node.setPropValue("pltype", (Object)row.getInteger("pltype"));
            this.accIdMap.put(id, node);
        }
        this.putIt(this.accIdMap, this.accMasterIdMap);
    }

    private void setCfitemParam() {
        String sel = this.getCFItemSel();
        Set allCfitemIds = CashFlowItemHelper.getAllCfitemIdsByOrg((long)this.queryParam.getPorg(), (long)this.queryParam.getOrgViewId(), (long)this.queryParam.getPeriodEndIdByQueryType(), (boolean)false, (boolean)false);
        if (this.queryParam.isQueryFromInit()) {
            allCfitemIds.addAll(this.getExcCfitemIds(this.queryParam.getPorg(), this.queryParam.getOrgViewId()));
        }
        DataSet cfItemSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_cashflowitem", (String)sel, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)allCfitemIds)}, (String)"number");
        this.setCashFlowItemMap(cfItemSet);
    }

    private void setCashFlowItemMap(DataSet accDS) {
        this.cfItemIdMap = new HashMap<Object, TreeNode>();
        this.cfMasterIdMap = new HashMap<Object, TreeNode>();
        this.allCfIdMap = new HashMap<Object, TreeNode>();
        this.cfNumMap = new HashMap<Object, TreeNode>();
        HashSet<String> nums = new HashSet<String>(10);
        String str = "";
        for (Row row : accDS) {
            Long id = row.getLong("id");
            TreeNode treeNode = this.buildNode(row);
            this.cfItemIdMap.put(id, treeNode);
            String number = row.getString("number");
            this.cfNumMap.put(number, treeNode);
            if (StringUtils.isEmpty((String)str)) {
                nums.add(number);
                str = number;
                continue;
            }
            if (number.equalsIgnoreCase(str) || number.startsWith(str)) continue;
            nums.add(number);
            str = number;
        }
        this.putItByNum(this.cfNumMap, this.cfMasterIdMap);
        if (this.isVirtualOrg()) {
            HashMap<String, TreeNode> numTreeNode = new HashMap<String, TreeNode>(100);
            Set allCfitemIds = CashFlowItemHelper.getAllCfitemIdsByOrg((long)this.queryParam.getPorg(), (long)this.queryParam.getOrgViewId(), (long)0L, (boolean)true, (boolean)false);
            DataSet cfItemSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_cashflowitem", (String)this.getCFItemSel(), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)allCfitemIds)}, null);
            for (Row row : cfItemSet) {
                long masterId;
                long id = row.getLong("id");
                if (id != (masterId = row.getLong("masterid").longValue())) continue;
                String number = row.getString("number");
                for (String num : nums) {
                    if (!number.startsWith(num)) continue;
                    TreeNode node = this.buildNode(row);
                    this.allCfIdMap.put(id, node);
                    numTreeNode.put(number, node);
                }
            }
            for (Map.Entry<Object, TreeNode> entry : this.allCfIdMap.entrySet()) {
                if (entry.getValue().getParentId() == 0L) continue;
                TreeNode node = null;
                String pnum = (String)entry.getValue().getPropValue("pnum");
                node = this.cfNumMap.get(pnum) != null ? this.cfNumMap.get(pnum) : (TreeNode)numTreeNode.get(pnum);
                entry.getValue().setParent(node);
            }
        }
    }

    private TreeNode buildNode(Row row) {
        TreeNode node = new TreeNode(row.getLong("id").longValue());
        node.setMasterId(row.getLong("masterid").longValue());
        node.setParentId(row.getLong("parent").longValue());
        node.setPropValue("pnum", (Object)row.getString("pnum"));
        node.setPropValue("level", (Object)row.getInteger("level"));
        node.setPropValue("isleaf", (Object)row.getBoolean("isleaf"));
        node.setPropValue("number", (Object)row.getString("number"));
        node.setPropValue("direction", (Object)row.getString("direction"));
        node.setPropValue("type", (Object)row.getString("type"));
        node.setPropValue("isprefit", (Object)row.getBoolean("isprefit"));
        return node;
    }

    private void putIt(Map<Object, TreeNode> cfItemIdMap, Map<Object, TreeNode> cfMasterIdMap) {
        for (TreeNode node : cfItemIdMap.values()) {
            TreeNode parentNode = cfItemIdMap.get(node.getParentId());
            node.setParent(parentNode);
            cfMasterIdMap.compute(node.getMasterId(), (k, v) -> {
                if (v == null || node.getId() == node.getMasterId()) {
                    return node;
                }
                return v;
            });
        }
    }

    private void putItByNum(Map<Object, TreeNode> cfNumMap, Map<Object, TreeNode> cfMasterIdMap) {
        for (TreeNode node : this.cfItemIdMap.values()) {
            TreeNode parentNode = cfNumMap.get(node.getPropValue("pnum"));
            node.setParent(parentNode);
            cfMasterIdMap.compute(node.getMasterId(), (k, v) -> {
                if (v == null || node.getId() == node.getMasterId()) {
                    return node;
                }
                return v;
            });
        }
    }

    private String getCFItemSel() {
        return "id,masterid,parent,parent.longnumber pnum,longnumber number,name,level,isleaf,type,direction,isdealactivity,isexchangerate,isprefit";
    }

    private DataSet getCFSet(QFilter[] filters) {
        String sel = this.getCashFlowSel();
        Triple cashflowOrmInfo = this.queryParam.getCashflowOrmInfo();
        if (cashflowOrmInfo == null || CollectionUtils.isEmpty((Collection)((Collection)cashflowOrmInfo.getMiddle()))) {
            return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)(this.queryParam.isQueryFromInit() ? "gl_initcashflow" : "gl_cashflow"), (String)sel, (QFilter[])filters, null);
        }
        this.logFilter("getCFSet", filters);
        QFilterBuilder mainQFilterBuilder = QFilterBuilder.create((QFilter[])filters).add("cfitem", "in", (Object)this.queryParam.getCashFlowItemIdsByAssistType()).add((List)cashflowOrmInfo.getMiddle());
        DataSet mainDataSet = GLUtil.queryBalanceByAssist((MainEntityType)((MainEntityType)cashflowOrmInfo.getLeft()), (String)String.join((CharSequence)",", sel), (QFilter[])mainQFilterBuilder.toArray(new QFilter[0]), null, (int)-1, (String)"gl_cashflow");
        QFilterBuilder suppQFilterBuilder = QFilterBuilder.create((QFilter[])filters).add("cfitem.type", "=", (Object)"3");
        DataSet suppDataSet = GLUtil.queryBalanceByAssist((MainEntityType)((MainEntityType)cashflowOrmInfo.getLeft()), (String)String.join((CharSequence)",", sel), (QFilter[])suppQFilterBuilder.toArray(new QFilter[0]), null, (int)-1, (String)"gl_cashflow");
        return mainDataSet.union(suppDataSet);
    }

    private void logFilter(String funcName, QFilter[] filters) {
        if (!this.isUnShowInsideCf && !this.isOnlyShowInsideCf) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(funcName).append("filters:");
        if (null != filters && filters.length > 0) {
            for (QFilter filter : filters) {
                sb.append(filter).append(", ");
            }
        }
        logger.info(sb.toString());
    }

    private DataSet getAccBalance(QFilter[] filters) {
        String selectFields = "account,beginlocal,endlocal,yeardebitlocal,yearcreditlocal,period,endperiod";
        StringBuilder ass = new StringBuilder(selectFields);
        if (this.queryParam.isUnShowInsideCf() || this.queryParam.isOnlyShowInsideCf()) {
            ass.append(",assgrp");
        }
        List commonAssists = this.queryParam.getCommonAssistKeys();
        for (String comassist : commonAssists) {
            ass.append(",").append(comassist);
        }
        selectFields = ass.toString();
        this.logFilter("getAccBalance", filters);
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_balance", (String)selectFields, (QFilter[])filters, null);
    }

    private QFilter[] getBalanceFilter() {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("org", "in", (Object)this.queryParam.getFilteredChildOrg()));
        list.add(new QFilter("booktype", "=", (Object)this.queryParam.getBookType()));
        list.add(new QFilter("accounttable", "=", (Object)this.queryParam.getAccountTable()));
        Long periodId = this.queryParam.getPeriodIdByQueryType();
        Long periodEndId = this.queryParam.getPeriodEndIdByQueryType();
        list.add(new QFilter("endperiod", "in", (Object)PeriodUtil.getAvailableEndPeriodIds((String)">", (Long)periodId, (Long[])this.queryParam.getFilteredChildOrg().toArray(new Long[0]))));
        list.add(new QFilter("period", "<=", (Object)periodEndId));
        list.add(new QFilter("period", ">=", (Object)(periodId / GLUtil.TYPE_PERIOD_L * GLUtil.TYPE_PERIOD_L)));
        list.addAll(this.getComassistFilter());
        return list.toArray(new QFilter[0]);
    }

    private SumSchema getAccSumSchema() {
        DataSchema leaf = new DataSchema(new int[]{3, 4, 5}, new int[]{0, 1, 2});
        return new SumSchema(leaf, null, null);
    }

    private RowMeta getOutPutAccountRowMeta() {
        ArrayList<Field> fieldList = new ArrayList<Field>(8);
        fieldList.add(new Field("beginlocal", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("endlocal", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("yearlocal", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("iscash", (DataType)DataType.BooleanType));
        fieldList.add(new Field("isbank", (DataType)DataType.BooleanType));
        fieldList.add(new Field("iscasheq", (DataType)DataType.BooleanType));
        List commonAssists = this.queryParam.getCommonAssistKeys();
        for (String comassist : commonAssists) {
            fieldList.add(new Field(comassist, (DataType)DataType.LongType));
        }
        return new RowMeta(fieldList.toArray(new Field[0]));
    }

    private DataSet getVoucherSet(QFilter[] qFilters) {
        this.logFilter("getVoucherSet", qFilters);
        DataSet voucherDs = VoucherQueryUtils.queryDataSet((String)this.getVoucherSel(), (QFilter[])qFilters, null, (int)-1);
        return voucherDs;
    }

    private String getVoucherSel() {
        ArrayList<String> sels = new ArrayList<String>(12);
        sels.add("org");
        sels.add("bookeddate");
        sels.add("entries.account account");
        sels.add("entries.debitlocal debitlocal");
        sels.add("entries.creditlocal creditlocal");
        sels.add("entries.maincfitem maincfitem");
        sels.add("entries.maincfassgrp maincfassgrp");
        sels.add("entries.maincfamount maincfamount");
        sels.add("entries.suppcfitem suppcfitem");
        sels.add("entries.suppcfamount suppcfamount");
        List commonAssists = this.queryParam.getCommonAssistKeys();
        for (String comassist : commonAssists) {
            sels.add("entries." + comassist + " " + comassist);
        }
        logger.info("getVoucherSel : " + ((Object)sels).toString());
        return ((Object)sels).toString().replace("[", "").replace("]", "");
    }

    private QFilter[] getVoucherFilter() {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("org", "in", (Object)this.queryParam.getFilteredChildOrg()));
        list.add(new QFilter("booktype", "=", (Object)this.queryParam.getBookType()));
        list.add(new QFilter("period", "in", (Object)new Long[]{this.queryParam.getPeriodIdByQueryType(), this.queryParam.getPeriodEndIdByQueryType()}));
        QFilter dateBegin = new QFilter("bookeddate", "<", (Object)this.queryParam.getDateBegin());
        QFilter dataEnd = new QFilter("bookeddate", ">", (Object)this.queryParam.getDateEnd());
        dateBegin.or(dataEnd);
        list.add(dateBegin);
        list.add(new QFilter("billstatus", "in", (Object)new String[]{"B", "C"}));
        List<QFilter> comassistFilter = this.getComassistFilter();
        comassistFilter.forEach(fiter -> {
            if (fiter.getProperty().startsWith("comassist")) {
                fiter.__setProperty("entries." + fiter.getProperty());
            }
        });
        list.addAll(comassistFilter);
        return list.toArray(new QFilter[0]);
    }

    private Set<Long> getIntBaseAssgrp(Set<Long> orgIds) {
        long startTime = System.currentTimeMillis();
        DataSet customerDs = this.getIntCustomer();
        DataSet supplierDs = this.getIntSupplier();
        DataSet orgDs = this.getIntOrg(orgIds);
        DataSet bizPartnerDs = this.getIntBizPartner();
        DataSet assistBdHG = this.getGLAssistBdIds();
        logger.info("CashFlowParallelQuery_queryInternalBaseData:{}", (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        DataSet intcustomerHG = customerDs.join(assistBdHG, JoinType.INNER).on("flexfield", "asstype").on("id", "assval").select(new String[]{"hg"}).finish();
        DataSet intSupplierDs = supplierDs.join(assistBdHG, JoinType.INNER).on("flexfield", "asstype").on("id", "assval").select(new String[]{"hg"}).finish();
        DataSet intOrgDs = orgDs.join(assistBdHG, JoinType.INNER).on("flexfield", "asstype").on("id", "assval").select(new String[]{"hg"}).finish();
        DataSet intBizPartnerDs = bizPartnerDs.join(assistBdHG, JoinType.INNER).on("flexfield", "asstype").on("id", "assval").select(new String[]{"hg"}).finish();
        HashSet<Long> hgs = new HashSet<Long>(16);
        for (Row row : intcustomerHG) {
            if (row == null) continue;
            hgs.add(row.getLong("hg"));
        }
        for (Row row : intSupplierDs) {
            if (row == null) continue;
            hgs.add(row.getLong("hg"));
        }
        for (Row row : intOrgDs) {
            if (row == null) continue;
            hgs.add(row.getLong("hg"));
        }
        for (Row row : intBizPartnerDs) {
            if (row == null) continue;
            hgs.add(row.getLong("hg"));
        }
        logger.info("CashFlowParallelQuery_getAssistBdHGIds:{}", (Object)(System.currentTimeMillis() - startTime));
        intcustomerHG.close();
        intSupplierDs.close();
        intOrgDs.close();
        intBizPartnerDs.close();
        return hgs;
    }

    private DataSet getGLAssistBdIds() {
        Set cashflowItems;
        List<Object> flexfieldList = this.getBaseFlwxfield();
        SqlBuilder sb = new SqlBuilder();
        sb.append("select g.fflexfield asstype, g.fvalue assval, g.fid hg from t_gl_assist_bd g inner join t_gl_cashflow c on g.fid  = c.fassgrpid", new Object[0]);
        sb.appendIn(" where g.fflexfield", flexfieldList);
        sb.appendIn(" and c.forgid", this.queryParam.getFilteredChildOrg().toArray(new Object[0]));
        sb.append(" and c.fbooktypeid = ?", new Object[]{this.queryParam.getBookType()});
        sb.append(" and c.fcfitemid != 0", new Object[0]);
        sb.append(" and c.fcurrencyid = ?", new Object[]{this.queryParam.getCurrency()});
        Long periodId = this.queryParam.getPeriodIdByQueryType();
        Long periodEndId = this.queryParam.getPeriodEndIdByQueryType();
        sb.appendIn(" and c.FENDPERIODID", PeriodUtil.getPeriodIds((String)">", (Long)periodId).toArray(new Object[0]));
        sb.append(" and c.FPERIODID <= ?", new Object[]{periodEndId});
        sb.append(" and c.FPERIODID >= ?", new Object[]{periodId / GLUtil.TYPE_PERIOD_L * GLUtil.TYPE_PERIOD_L});
        if (this.queryParam.isShowAssist() && (cashflowItems = this.queryParam.getCashFlowItemIdsByAssistType()) != null && !cashflowItems.isEmpty()) {
            sb.appendIn(" and c.fcfitemid", cashflowItems.toArray(new Object[0]));
        }
        DataSet glAssistBdDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sb);
        return glAssistBdDataSet;
    }

    private List<Object> getBaseFlwxfield() {
        ArrayList<Object> flexfield = new ArrayList<Object>(3);
        QFilter sourceF = new QFilter("valuesource", "in", (Object)new String[]{"bd_customer", "bd_supplier", "bos_org", "bd_bizpartner"});
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"", (String)"bd_asstacttype", (String)"flexfield", (QFilter[])new QFilter[]{sourceF}, null);){
            for (Row row : ds) {
                flexfield.add(row.getString("flexfield"));
            }
        }
        return flexfield;
    }

    private DataSet getIntCustomer() {
        QFilter uFilter = new QFilter("internal_company", "!=", (Object)0);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter[] qFilters = new QFilter[]{uFilter, statusFilter, enableFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getIntCustomer", (String)"bd_customer", (String)"id", (QFilter[])qFilters, null);){
            DataSet ds;
            QFilter valuesourceFilter = new QFilter("valuesource", "=", (Object)"bd_customer");
            DataSet bdAsstacttypeDataSet = QueryServiceHelper.queryDataSet((String)"getIntCustomer", (String)"bd_asstacttype", (String)"flexfield", (QFilter[])new QFilter[]{valuesourceFilter}, null);
            DataSet dataSet2 = ds = dataSet.join(bdAsstacttypeDataSet, JoinType.CROSS).select(new String[]{"id"}, new String[]{"flexfield"}).finish();
            return dataSet2;
        }
    }

    private DataSet getIntSupplier() {
        QFilter uFilter = new QFilter("internal_company", "!=", (Object)0);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter[] qFilters = new QFilter[]{uFilter, statusFilter, enableFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getIntCustomer", (String)"bd_supplier", (String)"id", (QFilter[])qFilters, null);){
            DataSet ds;
            QFilter valuesourceFilter = new QFilter("valuesource", "=", (Object)"bd_supplier");
            DataSet bdAsstacttypeDataSet = QueryServiceHelper.queryDataSet((String)"getIntCustomer", (String)"bd_asstacttype", (String)"flexfield", (QFilter[])new QFilter[]{valuesourceFilter}, null);
            DataSet dataSet2 = ds = dataSet.join(bdAsstacttypeDataSet, JoinType.CROSS).select(new String[]{"id"}, new String[]{"flexfield"}).finish();
            return dataSet2;
        }
    }

    private DataSet getIntBizPartner() {
        QFilter uFilter = new QFilter("internal_company", "!=", (Object)0);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter[] qFilters = new QFilter[]{uFilter, statusFilter, enableFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getIntBizPartner", (String)"bd_bizpartner", (String)"id", (QFilter[])qFilters, null);){
            DataSet ds;
            QFilter valuesourceFilter = new QFilter("valuesource", "=", (Object)"bd_bizpartner");
            DataSet bdAsstacttypeDataSet = QueryServiceHelper.queryDataSet((String)"getIntCustomer", (String)"bd_asstacttype", (String)"flexfield", (QFilter[])new QFilter[]{valuesourceFilter}, null);
            DataSet dataSet2 = ds = dataSet.join(bdAsstacttypeDataSet, JoinType.CROSS).select(new String[]{"id"}, new String[]{"flexfield"}).finish();
            return dataSet2;
        }
    }

    private DataSet getIntOrg(Set<Long> orgcoll) {
        QFilter idFilter = new QFilter("id", "in", orgcoll);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter[] qFilters = new QFilter[]{statusFilter.and(enableFilter).and(idFilter)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getIntCustomer", (String)"bos_org", (String)"id,name", (QFilter[])qFilters, null);){
            DataSet ds;
            QFilter valuesourceFilter = new QFilter("valuesource", "=", (Object)"bos_org");
            DataSet bdAsstacttypeDataSet = QueryServiceHelper.queryDataSet((String)"getIntCustomer", (String)"bd_asstacttype", (String)"flexfield", (QFilter[])new QFilter[]{valuesourceFilter}, null);
            DataSet dataSet2 = ds = dataSet.join(bdAsstacttypeDataSet, JoinType.CROSS).select(new String[]{"id"}, new String[]{"flexfield"}).finish();
            return dataSet2;
        }
    }

    private SumSchema getSumSchema() {
        DataSchema leafSchema = this.put(null, this.getLeafSchema());
        leafSchema = this.put(leafSchema, this.getOrgSchema());
        leafSchema = this.put(leafSchema, this.getCashFlowSchema());
        leafSchema = this.put(leafSchema, this.getComAssistSchema());
        DataSchema parentSchema = this.getCashFlowSchema();
        DataSchema totalSchema = this.getTotalSchema();
        return new SumSchema(leafSchema, parentSchema, totalSchema);
    }

    private DataSchema put(DataSchema result, DataSchema input) {
        if (result == null) {
            result = input;
        } else {
            result.setParent(input);
        }
        return result;
    }

    private DataSchema getTotalSchema() {
        String[] grpBy = new String[]{};
        String[] sumBy = new String[]{"amount", "yearamount"};
        return this.getDataSchema(grpBy, sumBy);
    }

    private DataSchema getCashFlowSchema() {
        String[] grpBy = new String[]{"cfitem"};
        String[] sumBy = new String[]{"amount", "yearamount"};
        return this.getDataSchema(grpBy, sumBy);
    }

    private DataSchema getComAssistSchema() {
        ArrayList grpBy = new ArrayList(2);
        grpBy.addAll(this.queryParam.getComAssistValsList().stream().map(comassist -> (String)comassist.t1).collect(Collectors.toList()));
        String[] sumBy = new String[]{"amount", "yearamount"};
        return this.getDataSchema(grpBy.toArray(new String[0]), sumBy);
    }

    private DataSchema getOrgSchema() {
        if (!this.queryParam.isShowOrg()) {
            return null;
        }
        String[] grpBy = new String[]{"cfitem", "orgid"};
        String[] sumBy = new String[]{"amount", "yearamount"};
        return this.getDataSchema(grpBy, sumBy);
    }

    private DataSchema getLeafSchema() {
        List commonAssists = this.queryParam.getCommonAssistKeys();
        if (CollectionUtils.isEmpty((Collection)commonAssists) && !this.queryParam.isShowAssist()) {
            return null;
        }
        String[] sumBy = new String[]{"amount", "yearamount"};
        if (!CollectionUtils.isEmpty((Collection)commonAssists)) {
            ArrayList<String> newGrpBy = new ArrayList<String>();
            newGrpBy.add("cfitem");
            newGrpBy.addAll(commonAssists);
            newGrpBy.add("orgid");
            if (this.queryParam.isShowAssist()) {
                newGrpBy.add("assgrp");
            }
            return this.getDataSchema(newGrpBy.toArray(new String[0]), sumBy);
        }
        return this.getDataSchema(grpBy, sumBy);
    }

    private DataSchema getDataSchema(String[] groupBy, String[] sumBy) {
        return DataSchema.getDataSchema(groupBy, sumBy, this.outPutRowMeta);
    }

    private List<QFilter> getCashFlowBaseFilter() {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("org", "in", (Object)this.queryParam.getFilteredChildOrg()));
        list.add(new QFilter("booktype", "=", (Object)this.queryParam.getBookType()));
        list.add(new QFilter("cfitem", ">", (Object)0));
        list.add(new QFilter("currency", "=", (Object)this.queryParam.getCurrency()));
        Long periodId = this.queryParam.getPeriodIdByQueryType();
        Long periodEndId = this.queryParam.getPeriodEndIdByQueryType();
        list.add(new QFilter("endperiod", "in", (Object)PeriodUtil.getPeriodIds((String)">", (Long)periodId)));
        list.add(new QFilter("period", "<=", (Object)periodEndId));
        list.add(new QFilter("period", ">=", (Object)(periodId / GLUtil.TYPE_PERIOD_L * GLUtil.TYPE_PERIOD_L)));
        return list;
    }

    private List<QFilter> getInitCashFlowFilter() {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("org", "in", (Object)this.queryParam.getFilteredChildOrg()));
        list.add(new QFilter("booktype", "=", (Object)this.queryParam.getBookType()));
        list.add(new QFilter("cfitem", "!=", (Object)0));
        list.add(new QFilter("currency", "=", (Object)this.queryParam.getCurrency()));
        list.add(new QFilter("tabdelete", "=", (Object)"0"));
        return list;
    }

    private String getCashFlowSel() {
        ArrayList<String> sels = new ArrayList<String>(10);
        if (!this.queryParam.isQueryFromInit()) {
            sels.add("amount");
        }
        sels.add("yearamount");
        sels.add("cfitem");
        if (this.queryParam.isShowOrg()) {
            sels.add("org orgid");
        }
        if (this.queryParam.isShowAssist() || this.queryParam.isUnShowInsideCf() || this.queryParam.isOnlyShowInsideCf()) {
            sels.add("assgrp");
        }
        if (!this.queryParam.isQueryFromInit()) {
            sels.add("period");
            sels.add("endperiod");
        }
        List commonAssists = this.queryParam.getCommonAssistKeys();
        for (String comassist : commonAssists) {
            sels.add(comassist);
        }
        return ((Object)sels).toString().replace("[", "").replace("]", "");
    }

    private RowMeta getOutPutRowMeta() {
        ArrayList<Field> fieldList = new ArrayList<Field>(8);
        fieldList.add(new Field("amount", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("yearamount", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("cfitem", (DataType)DataType.LongType));
        if (this.queryParam.isShowOrg()) {
            fieldList.add(new Field("orgid", (DataType)DataType.LongType));
        }
        if (this.queryParam.isShowAssist()) {
            fieldList.add(new Field("assgrp", (DataType)DataType.LongType));
        }
        List commonAssists = this.queryParam.getCommonAssistKeys();
        for (String comassist : commonAssists) {
            fieldList.add(new Field(comassist, (DataType)DataType.LongType));
        }
        return new RowMeta(fieldList.toArray(new Field[0]));
    }

    private DataSet createDatSet(Class clazz, List<String> fields, List<DataType> dataType, Set<Long> fValList) {
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fields.toArray(new String[fields.size()]), (DataType[])dataType.toArray(new DataType[dataType.size()]));
        Algo algo = Algo.create((String)(Objects.isNull(clazz) ? "" : clazz.getName()));
        DataSetBuilder builder = algo.createDataSetBuilder(rowMeta);
        for (Long row : fValList) {
            builder.append(new Object[]{row});
        }
        return builder.build();
    }

    private List<QFilter> getComassistFilter() {
        List comAssistValsList = this.queryParam.getComAssistValsList();
        HashMap<String, QFilter> map = new HashMap<String, QFilter>(comAssistValsList.size());
        for (Tuple2 comAssistVals : comAssistValsList) {
            String comassist = (String)comAssistVals.t1;
            Set values = (Set)comAssistVals.t2;
            if (CollectionUtils.isEmpty((Collection)values)) continue;
            ArrayList filterValues = new ArrayList(values.size());
            values.forEach(e -> {
                if (e > 0L) {
                    filterValues.add(e);
                }
            });
            if (CollectionUtils.isEmpty(filterValues)) continue;
            map.put(comassist, new QFilter(comassist, "in", filterValues));
        }
        List orgs = CollectionUtils.isEmpty((Collection)this.queryParam.getOrgs()) ? Lists.newArrayList((Object[])new Long[]{this.queryParam.getPorg()}) : this.queryParam.getOrgs();
        this.queryParam.getCommonAssists().forEach(commonAssist -> ComAssistService.getDataPermIds((CommonAssist)commonAssist, (List)orgs, (String)"id").ifPresent(ids -> {
            if (!map.containsKey(commonAssist.key)) {
                map.put(commonAssist.key, new QFilter(commonAssist.key, "in", ids));
            }
        }));
        logger.info("getComassistFilter filters :" + map.values());
        return Lists.newArrayList(map.values());
    }

    private DataSet getProfitCashflow(List<Long> orgs, long period, String itemIdKey) {
        HashMap<Long, Long> orgProfits = new HashMap<Long, Long>(orgs.size());
        for (long org : orgs) {
            QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)org);
            DynamicObject prefitDyn = QueryServiceHelper.queryOne((String)"gl_cashflowitem", (String)itemIdKey, (QFilter[])new QFilter[]{new QFilter("isprefit", "=", (Object)true), orgFilter});
            if (prefitDyn == null) continue;
            orgProfits.put(org, prefitDyn.getLong(itemIdKey));
        }
        if (MapUtils.isNotEmpty(orgProfits)) {
            StringBuilder selector = new StringBuilder("org,account,beginlocal,endlocal,yeardebitlocal,yearcreditlocal");
            List comassistList = this.queryParam.isShowComassist() ? this.queryParam.getComAssistValsList() : new ArrayList();
            ArrayList<QFilter> comassistQfs = new ArrayList<QFilter>(comassistList.size());
            ArrayList<Object> groupBys = new ArrayList<Object>(comassistList.size() + 1);
            groupBys.add("org");
            for (Tuple2 tuple2 : comassistList) {
                selector.append(",").append((String)tuple2.t1);
                groupBys.add(tuple2.t1);
                if (!((Set)tuple2.t2).stream().anyMatch(e -> e != 0L)) continue;
                comassistQfs.add(new QFilter((String)tuple2.t1, "in", tuple2.t2));
            }
            QueryParam param = new QueryParam();
            QFilter accountFilter = new QFilter("accounttype.accounttype", "=", (Object)"4");
            param.setAccountFilter(accountFilter);
            param.setOnlyLeafAcctBal(Boolean.TRUE.booleanValue());
            param.setSubstractPL(Boolean.TRUE.booleanValue());
            param.getCustomFilter().addAll(comassistQfs);
            logger.info("getProfitCashflow param: " + param.toString());
            Map<Long, List<Long>> accounttableIdByOrgs = this.getAccounttableIdByOrg(orgProfits.keySet(), this.queryParam.getBookType(), period);
            DataSet balanceDs = null;
            for (Map.Entry<Long, List<Long>> entry : accounttableIdByOrgs.entrySet()) {
                DataSet dataSet = BalanceQueryExecutor.getInstance().getBalance(selector.toString(), entry.getValue().toArray(new Long[0]), this.queryParam.getBookType(), entry.getKey().longValue(), period, period, param);
                if (balanceDs == null) {
                    balanceDs = dataSet;
                    continue;
                }
                balanceDs = balanceDs.union(dataSet);
            }
            HashMap<String, BigDecimal> amountMap = new HashMap<String, BigDecimal>();
            if (balanceDs != null) {
                balanceDs = balanceDs.groupBy(groupBys.toArray(new String[0])).sum("beginlocal").sum("endlocal").sum("yeardebitlocal").sum("yearcreditlocal").finish();
                while (balanceDs.hasNext()) {
                    Row row = balanceDs.next();
                    logger.info("getProfitCashflow balanceDs row : " + row.toString());
                    StringBuilder key2 = new StringBuilder(row.getString("org"));
                    for (Tuple2 tuple2 : comassistList) {
                        key2.append("_").append(row.get((String)tuple2.t1));
                    }
                    amountMap.compute(key2.toString(), (k, v) -> {
                        if (v == null) {
                            v = BigDecimal.ZERO;
                        }
                        BigDecimal yearAmount = row.getBigDecimal("yearcreditlocal").subtract(row.getBigDecimal("yeardebitlocal"));
                        BigDecimal amount = row.getBigDecimal("endlocal").subtract(row.getBigDecimal("beginlocal"));
                        v = v.add(yearAmount.add(amount));
                        return v;
                    });
                }
            }
            logger.info("getProfitCashflow amountMap : " + ((Object)amountMap).toString());
            ArrayList objs = new ArrayList(amountMap.size());
            amountMap.forEach((key, amount) -> {
                ArrayList<Object> fieldList = new ArrayList<Object>(10);
                String[] s = key.split("_");
                long org = Long.parseLong(s[0]);
                fieldList.add(0);
                fieldList.add(amount);
                fieldList.add(orgProfits.get(org));
                if (this.queryParam.isShowOrg()) {
                    fieldList.add(org);
                }
                if (!this.queryParam.isQueryFromInit()) {
                    fieldList.add(period);
                    fieldList.add(GLUtil.MAX_PERIOD);
                }
                for (int i = 1; i <= comassistList.size(); ++i) {
                    fieldList.add(s[i]);
                }
                objs.add(fieldList.toArray(new Object[0]));
            });
            DataSet profitBalance = Algo.create((String)this.getClass().getName()).createDataSet(objs.iterator(), this.getRowProfitMata());
            if (this.isUnShowInsideCf || this.isOnlyShowInsideCf) {
                List cols = GLUtil.getDataSetCols((DataSet)profitBalance);
                ArrayList colsRemoveAss = new ArrayList(cols);
                if (!this.queryParam.isShowAssist()) {
                    colsRemoveAss.remove("assgrp");
                    profitBalance = profitBalance.select(colsRemoveAss.toArray(new String[0]));
                }
            }
            return profitBalance;
        }
        return null;
    }

    private RowMeta getRowProfitMata() {
        ArrayList<Field> fieldList = new ArrayList<Field>(8);
        fieldList.add(new Field("amount", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("yearamount", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("cfitem", (DataType)DataType.LongType));
        if (this.queryParam.isShowOrg()) {
            fieldList.add(new Field("orgid", (DataType)DataType.LongType));
        }
        if (!this.queryParam.isQueryFromInit()) {
            fieldList.add(new Field("period", (DataType)DataType.LongType));
            fieldList.add(new Field("endperiod", (DataType)DataType.LongType));
        }
        List commonAssists = this.queryParam.getCommonAssistKeys();
        for (String comassist : commonAssists) {
            fieldList.add(new Field(comassist, (DataType)DataType.LongType));
        }
        return new RowMeta(fieldList.toArray(new Field[0]));
    }

    private Map<Long, List<Long>> getAccounttableIdByOrg(Set<Long> orgIds, Long bookTypeId, long periodId) {
        HashMap<Long, List<Long>> accountTableIdAndOrgs = new HashMap<Long, List<Long>>();
        for (Long orgId : orgIds) {
            accountTableIdAndOrgs.compute(AccountRefUtils.getCurPeriodAccountTableId((long)orgId, (long)bookTypeId, (long)periodId), (k, v) -> {
                if (v == null) {
                    v = new ArrayList<Long>(orgIds.size());
                }
                v.add(orgId);
                return v;
            });
        }
        return accountTableIdAndOrgs;
    }

    private Set<Long> getExcCfitemIds(long orgId, long orgViewId) {
        HashSet<Long> itemIds = new HashSet<Long>();
        HashSet<Long> orgParent = new HashSet<Long>();
        orgParent.add(orgId);
        Set childOrgIds = AccSysUtil.getChildOrgId((String)"10", (Long)orgViewId, orgParent, (boolean)true);
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT fdataid  FROM T_GL_CASHFLOWITEMEXC  WHERE", new Object[0]);
        sql.appendIn(" fuseorgid", new ArrayList(childOrgIds));
        try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sql);){
            for (Row row : ds) {
                itemIds.add(row.getLong("fdataid"));
            }
        }
        return itemIds;
    }

    private boolean isVirtualOrg() {
        HashSet<Long> orgParent = new HashSet<Long>();
        orgParent.add(this.queryParam.getPorg());
        Set childOrgId = AccSysUtil.getChildOrgId((String)"10", (Long)this.queryParam.getOrgViewId(), orgParent, (boolean)false);
        return !CollectionUtils.isEmpty((Collection)childOrgId);
    }
}

