/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.common;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.dataset.TreeNode;
import kd.fi.gl.report.CurType;
import kd.fi.gl.report.DailyRptQueryParam;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.OrgType;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.ReportMulLang;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.report.common.BalanceFetchFunction;
import kd.fi.gl.report.common.BalanceLogFetchFunction;
import kd.fi.gl.report.common.CollectorParam;
import kd.fi.gl.report.common.DailyRptCollector;
import kd.fi.gl.report.common.DataFetchFunction;
import kd.fi.gl.report.common.DataSchema;
import kd.fi.gl.report.common.SumSchema;
import kd.fi.gl.report.common.VoucherFetchFunction;
import kd.fi.gl.util.DateUtils;
import kd.fi.gl.util.GLUtil;

public class DailyRptParallelQuery {
    private static final Log logger = LogFactory.getLog(DailyRptParallelQuery.class);
    private static final int PARALLELISM = Runtime.getRuntime().availableProcessors() + 1;
    private static final String CT_PROP = "debitcount,creditcount";
    private static final String AMOUNT_FIELD = "predebit#,precredit#,debit#,credit#,todebit#,tocredit#";
    private DailyRptQueryParam qpRpt;
    private RowMeta outPutRowMeta;
    private String[] groupByFields;
    private Map<String, BigDecimal[]> chartDataMap;
    private Map<Object, TreeNode> accMasterIdMap;
    private Map<Object, TreeNode> accIdMap;
    private static final String SIMP_ACCT_SELECTOR = "id,masterid,parent.id parent,parent.number pnum,number,level,isleaf,dc,isassist,isqty";
    private static final String[] orgGrp = new String[]{"account", "currencyid", "orgid"};
    private static final String[] leafGrp = new String[]{"account", "currencyid", "orgid", "assgrp", "measureunit"};
    private static final String[] parentGrp = new String[]{"account", "currencyid", "orgid", "measureunit"};

    public DailyRptParallelQuery(DailyRptQueryParam qParam) {
        this.qpRpt = qParam;
        this.setAccountParam();
        this.outPutRowMeta = this.getOutPutRowMeta();
        this.chartDataMap = new ConcurrentHashMap<String, BigDecimal[]>();
        qParam.setCustomParam("groupByFields", (Object)this.groupByFields);
    }

    private void excute(CountDownLatch cdl, DailyRptCollector collector, DataSet dt, DataFetchFunction function, CollectorParam param) {
        try (DataSet voucherDataSet = dt;){
            collector.collectData(voucherDataSet, function);
        }
    }

    public DataSet query() {
        DataSet dt;
        List balanceFilters = QueryParamRpt.splitQFilter((QFilter[])this.getBalanceFilters(), (String)"org", (int)PARALLELISM);
        List voucherFilters = QueryParamRpt.splitQFilter((QFilter[])this.getVoucherFilter(), (String)"org", (int)PARALLELISM);
        List balanceLogFilters = QueryParamRpt.splitQFilter((QFilter[])this.getBalanceLogFilters(), (String)"org", (int)PARALLELISM);
        List plvoucherFilters = new ArrayList();
        List initBalFilters = new ArrayList();
        if (this.qpRpt.isSubstractPL()) {
            plvoucherFilters = QueryParamRpt.splitQFilter((QFilter[])this.getPlVoucherFilter(), (String)"org", (int)PARALLELISM);
            initBalFilters = QueryParamRpt.splitQFilter((QFilter[])this.getInitBalFilter(), (String)"org", (int)PARALLELISM);
        }
        CountDownLatch cdl = new CountDownLatch(balanceFilters.size() + voucherFilters.size() + plvoucherFilters.size() + initBalFilters.size() + balanceLogFilters.size());
        CollectorParam param = new CollectorParam(this.outPutRowMeta, this.accIdMap, this.accMasterIdMap, this.getSumSchema(), (MulOrgQPRpt)this.qpRpt);
        DailyRptCollector collector = new DailyRptCollector(param);
        if (this.qpRpt.isSubstractPL()) {
            for (QFilter[] filters : initBalFilters) {
                dt = this.getInitBalSet(filters);
                this.excute(cdl, collector, dt, new VoucherFetchFunction(param, this.accMasterIdMap, this.chartDataMap, dt.getRowMeta(), true, true), param);
            }
            for (QFilter[] voucherFilter : plvoucherFilters) {
                dt = this.getVoucherSet(voucherFilter);
                this.excute(cdl, collector, dt, new VoucherFetchFunction(param, this.accMasterIdMap, this.chartDataMap, dt.getRowMeta(), true, false), param);
            }
        }
        for (QFilter[] voucherFilter : voucherFilters) {
            dt = this.getVoucherSet(voucherFilter);
            this.excute(cdl, collector, dt, new VoucherFetchFunction(param, this.accMasterIdMap, this.chartDataMap, dt.getRowMeta(), false, false), param);
        }
        for (QFilter[] balanceFilter : balanceFilters) {
            dt = this.getAcctBalance(balanceFilter);
            this.excute(cdl, collector, dt, new BalanceFetchFunction(param, this.accMasterIdMap, dt.getRowMeta()), param);
        }
        for (QFilter[] blFilter : balanceLogFilters) {
            dt = this.getBalLogSet(blFilter);
            this.excute(cdl, collector, dt, new BalanceLogFetchFunction(param, this.accMasterIdMap, dt.getRowMeta()), param);
        }
        if (collector.getErrorMap().size() > 0) {
            Map<String, String> errorMap = collector.getErrorMap();
            errorMap.values().forEach(value -> {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e5\u62a5\u8868\u8ba1\u7b97\u51fa\u9519\uff1a%s", (String)"DailyRptParallelQuery_0", (String)"fi-gl-report", (Object[])new Object[0]), value));
            });
        }
        this.cacheDailyChartData();
        return this.getResult(collector.finish());
    }

    private DataSet getResult(DataSet finish) {
        Field[] fields;
        boolean isShowOrgField;
        finish = this.setSumupName(finish);
        finish = this.qpRpt.addCurLocal("orgid", finish);
        if (this.qpRpt.isShowRpt()) {
            finish = finish.addField("" + this.qpRpt.getCurRpt(), "currencyrptid");
        }
        finish = (isShowOrgField = Arrays.stream(fields = finish.getRowMeta().getFields()).anyMatch(x -> x.getAlias().equals("orgid"))) && this.qpRpt.isShowOrg() ? finish.addField("orgid", "flexorgid") : finish.addField(String.valueOf(this.qpRpt.getOrgs().get(0)), "flexorgid");
        DynamicObject period = PeriodUtil.getPeriodByPeriodId((long)this.qpRpt.getEndPeriod(), (String)"enddate");
        Date nameCtrlDate = period.getDate("enddate");
        finish = finish.addField(DateUtils.getYearMonthDayFuncStr((Date)nameCtrlDate), "namectrldate");
        return finish;
    }

    private DataSet setSumupName(DataSet ds) {
        List cols = ReportUtils.getDataSetCols((DataSet)ds);
        ArrayList<String> list = new ArrayList<String>();
        for (String col : cols) {
            if (col.equalsIgnoreCase("name")) {
                list.add("case account when null then '" + ReportMulLang.getHeJi() + "' else name end as name");
                continue;
            }
            list.add(col);
        }
        return ds.select(list.toArray(new String[0]));
    }

    private void cacheDailyChartData() {
        if (this.qpRpt.getOrgType() == OrgType.VIRTUAL_M) {
            CacheHelper.getDistributeCache((CacheModule)CacheModule.report).put("dailyQuery-chartMap", null);
            return;
        }
        HashMap map = new HashMap();
        ArrayList<Double> dataList = new ArrayList<Double>();
        ArrayList<String> axisList = new ArrayList<String>();
        ArrayList<String> idxList = new ArrayList<String>();
        long begin = this.isSameDay() && this.qpRpt.getPeriodBeginDate() != null ? this.qpRpt.getPeriodBeginDate().getTime() : this.qpRpt.getDateBegin().getTime();
        long end = this.qpRpt.getDateEnd().getTime();
        DateFormat dFormat = DateFormat.getDateInstance();
        for (long time = begin; time < end; time += 86400000L) {
            String format = dFormat.format(new Date(time));
            axisList.add(format.substring(5));
            idxList.add(format);
        }
        for (String idx : idxList) {
            BigDecimal[] value = this.chartDataMap.get(idx);
            if (value != null) {
                dataList.add(value[0].setScale(2, 4).doubleValue());
                dataList.add(value[1].setScale(2, 4).doubleValue());
                continue;
            }
            dataList.add(0.0);
            dataList.add(0.0);
        }
        map.put("dataList", dataList);
        map.put("axisList", axisList);
        CacheHelper.getDistributeCache((CacheModule)CacheModule.report).put("dailyQuery-chartMap", SerializationUtils.toJsonString(map));
    }

    private boolean isSameDay() {
        DateFormat dFormat = DateFormat.getDateInstance();
        return dFormat.format(this.qpRpt.getDateBegin()).equals(dFormat.format(this.qpRpt.getDateEnd()));
    }

    private SumSchema getSumSchema() {
        DataSchema leafSchema = this.getDataSchema(false);
        DataSchema parentSchema = this.getDataSchema(true);
        DataSchema totalSchema = this.getTotalSchema();
        return new SumSchema(leafSchema, parentSchema, totalSchema);
    }

    private DataSchema getDataSchema(boolean isParent) {
        DataSchema leafSchema = this.put(null, isParent ? this.getParentLeafSchema() : this.getLeafSchema());
        leafSchema = this.put(leafSchema, this.getOrgSchema());
        leafSchema = this.put(leafSchema, this.getCurSchema());
        leafSchema = this.put(leafSchema, this.getAccountSchema());
        return leafSchema;
    }

    private DataSchema put(DataSchema result, DataSchema input) {
        if (result == null) {
            result = input;
        } else {
            result.setParent(input);
        }
        return result;
    }

    private RowMeta getOutPutRowMeta() {
        String[] amountQtys;
        ArrayList<Field> fieldList = new ArrayList<Field>(16);
        fieldList.add(new Field("account", (DataType)DataType.LongType));
        if (this.qpRpt.isQueryCurrency()) {
            fieldList.add(new Field("currencyid", (DataType)DataType.LongType));
        }
        if (this.qpRpt.isShowOrg()) {
            fieldList.add(new Field("orgid", (DataType)DataType.LongType));
        }
        if (this.qpRpt.isShowAssist()) {
            fieldList.add(new Field("assgrp", (DataType)DataType.LongType));
        }
        if (this.qpRpt.isShowQty()) {
            fieldList.add(new Field("measureunit", (DataType)DataType.LongType));
        }
        this.groupByFields = (String[])fieldList.stream().map(Field::getName).toArray(String[]::new);
        ArrayList amountField = new ArrayList(8);
        String[] amountLocals = AMOUNT_FIELD.replace("#", "local").split(",");
        Collections.addAll(amountField, amountLocals);
        for (String ct : CT_PROP.split(",")) {
            fieldList.add(new Field(ct, (DataType)DataType.IntegerType));
        }
        if (this.qpRpt.isQueryCurrency()) {
            String[] amountFors = AMOUNT_FIELD.replace("#", "for").split(",");
            Collections.addAll(amountField, amountFors);
        }
        if (this.qpRpt.isShowQty()) {
            amountQtys = AMOUNT_FIELD.replace("#", "qty").split(",");
            Collections.addAll(amountField, amountQtys);
        }
        if (this.qpRpt.isShowRpt()) {
            amountQtys = AMOUNT_FIELD.replace("#", "rpt").split(",");
            Collections.addAll(amountField, amountQtys);
        }
        for (String amount : amountField) {
            fieldList.add(new Field(amount, (DataType)DataType.BigDecimalType));
        }
        return new RowMeta(fieldList.toArray(new Field[0]));
    }

    private DataSchema getTotalSchema() {
        String[] stringArray;
        boolean includeFor = this.isGroupByFor();
        if (includeFor) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "currencyid";
        } else {
            stringArray = new String[]{};
        }
        String[] groupBy = stringArray;
        String[] sumBy = this.getSumBy(includeFor, this.isGroupByLocal(), false);
        return this.getDataSchema(groupBy, sumBy);
    }

    private DataSchema getAccountSchema() {
        String[] stringArray;
        boolean includeFor = this.isGroupByFor();
        if (includeFor) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "account";
            stringArray = stringArray2;
            stringArray2[1] = "currencyid";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "account";
        }
        String[] groupBy = stringArray;
        String[] sumBy = this.getSumBy(includeFor, this.isGroupByLocal(), false);
        return this.getDataSchema(groupBy, sumBy);
    }

    private DataSchema getCurSchema() {
        if (!this.sumUpCur()) {
            return null;
        }
        String[] groupBy = new String[]{"account", "currencyid"};
        String[] sumBy = this.getSumBy(true, this.isGroupByLocal(), false);
        return this.getDataSchema(groupBy, sumBy);
    }

    private DataSchema getOrgSchema() {
        if (!this.sumUpOrg()) {
            return null;
        }
        String[] sumBy = this.getSumBy(true, true, false);
        return this.getDataSchema(orgGrp, sumBy);
    }

    private DataSchema getLeafSchema() {
        if (!this.sumUpLeaf()) {
            return null;
        }
        String[] sumBy = this.getSumBy(true, this.qpRpt.isShowOrg() || this.isGroupByLocal(), true);
        return this.getDataSchema(leafGrp, sumBy);
    }

    private DataSchema getParentLeafSchema() {
        if (!this.qpRpt.isShowQty()) {
            return null;
        }
        String[] sumBy = this.getSumBy(true, this.qpRpt.isShowOrg() || this.isGroupByLocal(), true);
        return this.getDataSchema(parentGrp, sumBy);
    }

    private boolean sumUpLeaf() {
        return this.qpRpt.isShowAssist() || this.qpRpt.isShowQty();
    }

    private boolean sumUpOrg() {
        return this.qpRpt.isShowOrg();
    }

    private boolean sumUpCur() {
        return this.qpRpt.isShowCurrency();
    }

    private DataSchema getDataSchema(String[] groupBy, String[] sumBy) {
        return DataSchema.getDataSchema(groupBy, sumBy, this.outPutRowMeta);
    }

    private String[] getSumBy(boolean includeFor, boolean includeLocal, boolean includeQty) {
        String str = CT_PROP;
        if (includeFor) {
            str = str + "," + AMOUNT_FIELD.replace("#", "for");
        }
        if (includeLocal) {
            str = str + "," + AMOUNT_FIELD.replace("#", "local");
        }
        if (includeQty) {
            str = str + "," + AMOUNT_FIELD.replace("#", "qty");
        }
        if (this.qpRpt.isShowRpt()) {
            str = str + "," + AMOUNT_FIELD.replace("#", "rpt");
        }
        return str.split(",");
    }

    private boolean isGroupByLocal() {
        return this.qpRpt.getOrgType() != OrgType.VIRTUAL_M;
    }

    private boolean isGroupByFor() {
        return this.qpRpt.getCurType() == CurType.FOREIGN || this.qpRpt.getCurType() == CurType.BASE;
    }

    private DataSet getVoucherSet(QFilter[] filters) {
        return VoucherQueryUtils.queryDataSet((String)this.getVoucherSel(), (QFilter[])filters, null, (int)-1);
    }

    private DataSet getInitBalSet(QFilter[] filters) {
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_initbalance", (String)this.getInitBalSel(), (QFilter[])filters, null);
    }

    private DataSet getBalLogSet(QFilter[] filters) {
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_balance_log", (String)this.getBalLogSel(), (QFilter[])filters, null);
    }

    private QFilter[] getInitBalFilter() {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        Set childOrgIds = this.qpRpt.getFilteredChildOrg();
        childOrgIds.retainAll(this.qpRpt.getClosedInitOrgs());
        list.add(new QFilter("org", "in", (Object)childOrgIds));
        list.add(new QFilter("booktype", "=", (Object)this.qpRpt.getBookType()));
        if (this.qpRpt.getMasterIdSet() != null) {
            list.add(new QFilter("account.masterid", "in", this.accMasterIdMap.keySet()));
        }
        list.add(new QFilter("account.pltype", "!=", (Object)"0"));
        if (!this.qpRpt.isSynCurrency() && !this.qpRpt.isAllCurrency()) {
            list.add(new QFilter("currency", "=", (Object)this.qpRpt.getCurrency()));
        }
        return list.toArray(new QFilter[0]);
    }

    private String getInitBalSel() {
        ArrayList<String> sels = new ArrayList<String>();
        sels.add("account.masterid account");
        if (this.qpRpt.isQueryCurrency()) {
            sels.add("currency currencyid");
        }
        if (this.qpRpt.isShowOrg()) {
            sels.add("org orgid");
        }
        if (this.qpRpt.isShowAssist()) {
            sels.add("assgrp");
        }
        if (this.qpRpt.isShowQty()) {
            sels.add("measureunit");
        }
        sels.add("now() bookeddate");
        sels.add("1 entrydc");
        sels.add("yeardebitlocal-yearprofitdebitlocal debitlocal");
        sels.add("yearcreditlocal-yearprofitcreditlocal creditlocal");
        if (this.qpRpt.isQueryCurrency()) {
            sels.add("yeardebitfor-yearprofitdebitfor debitfor");
            sels.add("yearcreditfor-yearprofitcreditfor creditfor");
        }
        if (this.qpRpt.isShowQty()) {
            sels.add("yeardebitqty-yearprofitdebitqty debitqty");
            sels.add("yearcreditqty-yearprofitcreditqty creditqty");
        }
        if (this.qpRpt.isShowRpt() && !this.qpRpt.isShowOrg()) {
            sels.add("org orgid");
        }
        return ((Object)sels).toString().replace("[", "").replace("]", "");
    }

    private String getVoucherSel() {
        ArrayList<String> sels = new ArrayList<String>();
        sels.add("entries.account.masterid account");
        if (this.qpRpt.isQueryCurrency()) {
            sels.add("entries.currency currencyid");
        }
        if (this.qpRpt.isShowOrg()) {
            sels.add("org orgid");
        }
        if (this.qpRpt.isShowAssist()) {
            sels.add("entries.assgrp assgrp");
        }
        if (this.qpRpt.isShowQty()) {
            sels.add("entries.measureunit measureunit");
        }
        sels.add("bookeddate");
        sels.add("entries.entrydc entrydc");
        sels.add("entries.debitlocal debitlocal");
        sels.add("entries.creditlocal creditlocal");
        if (this.qpRpt.isQueryCurrency()) {
            sels.add("entries.debitori debitfor");
            sels.add("entries.creditori creditfor");
        }
        if (this.qpRpt.isShowQty()) {
            sels.add("entries.quantity debitqty");
            sels.add("entries.quantity creditqty");
        }
        if (this.qpRpt.isShowRpt() && !this.qpRpt.isShowOrg()) {
            sels.add("org orgid");
        }
        return ((Object)sels).toString().replace("[", "").replace("]", "");
    }

    private QFilter[] getPlVoucherFilter() {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("org", "in", (Object)this.qpRpt.getFilteredChildOrg()));
        list.add(new QFilter("booktype", "=", (Object)this.qpRpt.getBookType()));
        list.add(new QFilter("period", ">=", GLUtil.getCurYearMinPeriod((Object)this.qpRpt.getStartPeriod()).getPkValue()));
        list.add(new QFilter("period", "<=", (Object)this.qpRpt.getStartPeriod()));
        list.add(new QFilter("bookeddate", "<", (Object)this.qpRpt.getPeriodBeginDate()));
        list.add(new QFilter("billstatus", "in", (Object)new String[]{"B", "C"}));
        if (this.qpRpt.getMasterIdSet() != null) {
            list.add(new QFilter("entries.account.masterid", "in", this.accMasterIdMap.keySet()));
        }
        if (!this.qpRpt.isSynCurrency() && !this.qpRpt.isAllCurrency()) {
            list.add(new QFilter("entries.currency", "=", (Object)this.qpRpt.getCurrency()));
        }
        list.add(new QFilter("sourcetype", "=", (Object)"1"));
        return list.toArray(new QFilter[0]);
    }

    private QFilter[] getVoucherFilter() {
        DynamicObject endPeriod;
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("org", "in", (Object)this.qpRpt.getFilteredChildOrg()));
        list.add(new QFilter("booktype", "=", (Object)this.qpRpt.getBookType()));
        DynamicObject beginPeriod = GLUtil.getPeriodByDate((Date)this.qpRpt.getPeriodBeginDate(), (long)this.qpRpt.getPeriodType());
        if (beginPeriod != null) {
            list.add(new QFilter("period", ">=", (Object)beginPeriod.getLong("id")));
        }
        if ((endPeriod = GLUtil.getPeriodByDate((Date)this.qpRpt.getPeriodEndDate(), (long)this.qpRpt.getPeriodType())) != null) {
            list.add(new QFilter("period", "<=", (Object)endPeriod.getLong("id")));
        }
        list.add(new QFilter("bookeddate", ">=", (Object)this.qpRpt.getPeriodBeginDate()));
        list.add(new QFilter("bookeddate", "<=", (Object)this.qpRpt.getDateEnd()));
        list.add(new QFilter("billstatus", "in", (Object)new String[]{"B", "C"}));
        if (this.qpRpt.getMasterIdSet() != null) {
            list.add(new QFilter("entries.account.masterid", "in", this.accMasterIdMap.keySet()));
        }
        if (!this.qpRpt.isSynCurrency() && !this.qpRpt.isAllCurrency()) {
            list.add(new QFilter("entries.currency", "=", (Object)this.qpRpt.getCurrency()));
        }
        if (this.qpRpt.isSubstractPL()) {
            list.add(new QFilter("sourcetype", "!=", (Object)"1"));
        }
        return list.toArray(new QFilter[0]);
    }

    private DataSet getAcctBalance(QFilter[] filters) {
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_balance", (String)this.getBalanceSel(), (QFilter[])filters, null);
    }

    private String getBalanceSel() {
        ArrayList<String> sels = new ArrayList<String>();
        sels.add("account");
        if (this.qpRpt.isQueryCurrency()) {
            sels.add("currency currencyid");
        }
        if (this.qpRpt.isShowOrg()) {
            sels.add("org orgid");
        }
        if (this.qpRpt.isShowAssist()) {
            sels.add("assgrp");
        }
        if (this.qpRpt.isShowQty()) {
            sels.add("measureunit");
        }
        sels.add("period");
        sels.add("beginlocal");
        sels.add("endlocal");
        if (this.qpRpt.isQueryCurrency()) {
            sels.add("beginfor");
            sels.add("endfor");
        }
        if (this.qpRpt.isShowQty()) {
            sels.add("beginqty");
            sels.add("endqty");
        }
        if (this.qpRpt.isShowRpt() && !this.qpRpt.isShowOrg()) {
            sels.add("org orgid");
        }
        return ((Object)sels).toString().replace("[", "").replace("]", "");
    }

    private String getBalLogSel() {
        ArrayList<String> sels = new ArrayList<String>();
        sels.add("account");
        if (this.qpRpt.isQueryCurrency()) {
            sels.add("currency currencyid");
        }
        if (this.qpRpt.isShowOrg()) {
            sels.add("org orgid");
        }
        if (this.qpRpt.isShowAssist()) {
            sels.add("assgrp");
        }
        if (this.qpRpt.isShowQty()) {
            sels.add("measureunit");
        }
        sels.add("period");
        sels.add("debitlocal-creditlocal beginlocal");
        sels.add("debitlocal-creditlocal endlocal");
        if (this.qpRpt.isQueryCurrency()) {
            sels.add("debitfor-creditfor beginfor");
            sels.add("debitfor-creditfor endfor");
        }
        if (this.qpRpt.isShowQty()) {
            sels.add("debitqty-creditqty beginqty");
            sels.add("debitqty-creditqty endqty");
        }
        if (this.qpRpt.isShowRpt() && !this.qpRpt.isShowOrg()) {
            sels.add("org orgid");
        }
        return ((Object)sels).toString().replace("[", "").replace("]", "");
    }

    private QFilter[] getBalanceFilters() {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("org", "in", (Object)this.qpRpt.getFilteredChildOrg()));
        list.add(new QFilter("booktype", "=", (Object)this.qpRpt.getBookType()));
        list.add(new QFilter("accounttable", "=", (Object)this.qpRpt.getAccountTable()));
        list.add(new QFilter("endperiod", "in", (Object)PeriodUtil.getAvailableEndPeriodIds((String)">", (Long)this.qpRpt.getPeriodId(), (Long[])this.qpRpt.getFilteredChildOrg().toArray(new Long[0]))));
        list.add(new QFilter("period", "<=", (Object)this.qpRpt.getPeriodId()));
        list.add(new QFilter("period", ">=", (Object)(this.qpRpt.getPeriodId() / GLUtil.TYPE_PERIOD_L * GLUtil.TYPE_PERIOD_L)));
        if (this.qpRpt.getMasterIdSet() != null) {
            list.add(new QFilter("account", "in", this.accMasterIdMap.keySet()));
        }
        if (!this.qpRpt.isSynCurrency() && !this.qpRpt.isAllCurrency()) {
            list.add(new QFilter("currency", "=", (Object)this.qpRpt.getCurrency()));
        }
        return list.toArray(new QFilter[0]);
    }

    private QFilter[] getBalanceLogFilters() {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("org", "in", (Object)this.qpRpt.getFilteredChildOrg()));
        list.add(new QFilter("booktype", "=", (Object)this.qpRpt.getBookType()));
        list.add(new QFilter("accounttable", "=", (Object)this.qpRpt.getAccountTable()));
        list.add(new QFilter("period", "<=", (Object)this.qpRpt.getPeriodId()));
        list.add(new QFilter("period", ">=", (Object)(this.qpRpt.getPeriodId() / GLUtil.TYPE_PERIOD_L * GLUtil.TYPE_PERIOD_L)));
        list.add(new QFilter("calculated", "=", (Object)"0"));
        if (this.qpRpt.getMasterIdSet() != null) {
            list.add(new QFilter("account", "in", this.accMasterIdMap.keySet()));
        }
        if (!this.qpRpt.isSynCurrency() && !this.qpRpt.isAllCurrency()) {
            list.add(new QFilter("currency", "=", (Object)this.qpRpt.getCurrency()));
        }
        return list.toArray(new QFilter[0]);
    }

    private void setAccountParam() {
        DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"enddate", (QFilter[])new QFilter("id", "=", (Object)this.qpRpt.getEndPeriod()).toArray());
        QFilter atFilter = new QFilter("startdate", "<=", (Object)period.getDate("enddate"));
        atFilter.and(new QFilter("enddate", ">=", (Object)period.getDate("enddate")));
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(atFilter);
        Set masterIdSet = this.qpRpt.getMasterIdSet();
        if (Objects.nonNull(masterIdSet) && !masterIdSet.isEmpty()) {
            filters.add(new QFilter("masterid", "in", (Object)masterIdSet));
        }
        DataSet accDS = AccountUtils.queryAccountDataSet((long)this.qpRpt.getPorg(), (long)this.qpRpt.getAccountTable(), (String)SIMP_ACCT_SELECTOR, filters);
        if (this.hasAccIdFilter()) {
            HashSet<String> selAcctSet = new HashSet<String>();
            for (Row row : accDS.copy()) {
                selAcctSet.add(row.getString("number"));
            }
            accDS = kd.fi.gl.util.AccountUtils.getAllLeafAcct(selAcctSet, (Long)this.qpRpt.getEndPeriod(), (Long)this.qpRpt.getPorg(), (Long)this.qpRpt.getAccountTable());
        }
        this.setAccountMap(accDS);
    }

    private void setAccountMap(DataSet accDS) {
        this.accIdMap = new HashMap<Object, TreeNode>(10);
        this.accMasterIdMap = new HashMap<Object, TreeNode>(10);
        HashMap<String, TreeNode> numMap = new HashMap<String, TreeNode>(10);
        for (Row row : accDS) {
            Long id = row.getLong("id");
            TreeNode treeNode = new TreeNode(id.longValue());
            treeNode.setMasterId(row.getLong("masterid").longValue());
            treeNode.setParentId(row.getLong("parent").longValue());
            treeNode.setPropValue("pnum", (Object)row.getString("pnum"));
            treeNode.setPropValue("number", (Object)row.getString("number"));
            treeNode.setPropValue("level", (Object)row.getInteger("level"));
            treeNode.setPropValue("isleaf", (Object)row.getBoolean("isleaf"));
            treeNode.setPropValue("dc", (Object)row.getString("dc"));
            treeNode.setPropValue("isassist", (Object)row.getBoolean("isassist"));
            treeNode.setPropValue("isqty", (Object)row.getBoolean("isqty"));
            this.accIdMap.put(id, treeNode);
        }
        HashMap<Long, Boolean> hasAssistMap = new HashMap<Long, Boolean>(10);
        HashMap<Long, Boolean> hasQtyMap = new HashMap<Long, Boolean>(10);
        for (TreeNode treeNode : this.accIdMap.values()) {
            hasAssistMap.put(treeNode.getId(), (Boolean)treeNode.getPropValue("isassist"));
            hasQtyMap.put(treeNode.getId(), (Boolean)treeNode.getPropValue("isqty"));
            numMap.put((String)treeNode.getPropValue("number"), treeNode);
            this.accMasterIdMap.put(treeNode.getMasterId(), treeNode);
        }
        for (TreeNode treeNode : this.accIdMap.values()) {
            TreeNode parentNode = (TreeNode)numMap.get(treeNode.getPropValue("pnum"));
            treeNode.setParent(parentNode);
        }
        for (Map.Entry entry : this.accIdMap.entrySet()) {
            ((TreeNode)entry.getValue()).setPropValue("isLeafHasAssist", hasAssistMap.get(entry.getKey()));
            ((TreeNode)entry.getValue()).setPropValue("isLeafHasQty", hasQtyMap.get(entry.getKey()));
        }
    }

    private DataSet getAllLeafAcctDataSet(DataSet selAllAcctDS, Set<Long> parentId, QFilter dateFilter) {
        QFilter qFilter = new QFilter("parent", "in", parentId);
        qFilter.and(dateFilter);
        DataSet ds = this.getAccountSet(qFilter);
        DataSet copy = ds.copy();
        if (copy.hasNext()) {
            HashSet<Long> leafAccList = new HashSet<Long>();
            for (Row row : copy) {
                Long id = row.getLong("id");
                leafAccList.add(id);
            }
            selAllAcctDS = selAllAcctDS.union(ds);
            return this.getAllLeafAcctDataSet(selAllAcctDS, leafAccList, dateFilter);
        }
        return selAllAcctDS;
    }

    private boolean hasAccIdFilter() {
        return this.qpRpt.getMasterIdSet() != null;
    }

    private DataSet getAccountSet(QFilter filter) {
        return QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".account"), (String)"bd_accountview", (String)SIMP_ACCT_SELECTOR, (QFilter[])(filter == null ? null : filter.toArray()), null);
    }

    private QFilter getAccountFilter(QFilter qFilter) {
        Set masterIdSet = this.qpRpt.getMasterIdSet();
        QFilter atFilter = new QFilter("accounttable", "=", (Object)this.qpRpt.getAccountTable());
        atFilter.and(qFilter);
        if (masterIdSet == null) {
            return atFilter;
        }
        return new QFilter("masterid", "in", (Object)masterIdSet).and(atFilter);
    }
}

