/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.common;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.fi.bd.service.balance.AppHelper;
import kd.fi.gl.dataset.GroupKey;
import kd.fi.gl.report.common.RptUtil;

public class DataSchema {
    private int level = 1;
    private int[] groupIndex;
    private int[] sumIndex;
    private int[] allIndex;
    private DataSchema parent;
    private Map<GroupKey, Object[]> data;
    private int MAX_SIZE = Integer.parseInt(AppHelper.getSystemProperty((String)"fi.gl.report.dataschema.limit", (String)String.valueOf(262144)));
    private boolean hasEnoughData;

    public DataSchema(int[] groupIndex, int[] sumIndex) {
        this.groupIndex = groupIndex;
        this.sumIndex = sumIndex;
        this.allIndex = new int[groupIndex.length + sumIndex.length];
        System.arraycopy(groupIndex, 0, this.allIndex, 0, groupIndex.length);
        System.arraycopy(sumIndex, 0, this.allIndex, groupIndex.length, sumIndex.length);
        this.data = new ConcurrentHashMap<GroupKey, Object[]>(1000);
    }

    public Map<GroupKey, Object[]> getData() {
        return this.data;
    }

    public Object[] outPutData(Object[] values, Function<Map<?, ?>, Boolean> filter, boolean putIfPresent) {
        Object[] keyId = this.getKey(values);
        Object[] vals = this.getValue(values);
        GroupKey key = new GroupKey(keyId);
        if (this.filterIt(filter)) {
            return this.data.compute(key, (k, v) -> {
                if (v == null) {
                    return vals;
                }
                return this.sum((Object[])v, vals);
            });
        }
        if (putIfPresent) {
            return this.data.computeIfPresent(key, (k, v) -> this.sum((Object[])v, vals));
        }
        return values;
    }

    public Object[] outPutData(Object[] values) {
        Object[] keyId = this.getKey(values);
        Object[] vals = this.getValue(values);
        GroupKey key = new GroupKey(keyId);
        if (this.filterIt(x -> true)) {
            return this.data.compute(key, (k, v) -> {
                if (v == null) {
                    return vals;
                }
                return this.sum((Object[])v, vals);
            });
        }
        return this.data.computeIfPresent(key, (k, v) -> this.sum((Object[])v, vals));
    }

    private boolean filterIt(Function<Map<?, ?>, Boolean> filter) {
        if (!this.hasEnoughData && this.data.size() <= this.MAX_SIZE) {
            return filter.apply(this.data);
        }
        this.hasEnoughData = true;
        return false;
    }

    public Object[] outPutData(Object[] values, int customLimit) {
        Object[] keyId = this.getKey(values);
        Object[] vals = this.getValue(values);
        GroupKey key = new GroupKey(keyId);
        if (this.filterIt(x -> true, customLimit)) {
            return this.data.compute(key, (k, v) -> {
                if (v == null) {
                    return vals;
                }
                return this.sum((Object[])v, vals);
            });
        }
        return this.data.computeIfPresent(key, (k, v) -> this.sum((Object[])v, vals));
    }

    private boolean filterIt(Function<Map<?, ?>, Boolean> filter, int customLimit) {
        if (!this.hasEnoughData && this.data.size() <= customLimit) {
            return filter.apply(this.data);
        }
        this.hasEnoughData = true;
        return false;
    }

    private Object[] getKey(Object[] values) {
        Object[] result = new Object[this.groupIndex.length + 1];
        result[0] = this.level;
        for (int i = 0; i < this.groupIndex.length; ++i) {
            result[i + 1] = values[this.groupIndex[i]];
        }
        return result;
    }

    private Object[] getValue(Object[] values) {
        Object[] result = new Object[values.length];
        for (int index : this.allIndex) {
            result[index] = values[index];
        }
        return result;
    }

    public Object[] sum(Object[] oldValue, Object[] newValue) {
        for (int index : this.sumIndex) {
            oldValue[index] = RptUtil.sum(oldValue[index], newValue[index]);
        }
        return oldValue;
    }

    public DataSchema getParent() {
        return this.parent;
    }

    public void setParent(DataSchema p) {
        if (p == null) {
            return;
        }
        ++this.level;
        if (this.parent == null) {
            this.parent = p;
        } else {
            this.parent.setParent(p);
        }
    }

    public int[] getGroupIndex() {
        return this.groupIndex;
    }

    public int[] getSumIndex() {
        return this.sumIndex;
    }

    public static DataSchema getDataSchema(String[] groupBy, String[] sumBy, RowMeta outPutRowMeta) {
        int i;
        List fieldNames = Stream.of(outPutRowMeta.getFields()).map(Field::getName).collect(Collectors.toList());
        groupBy = (String[])Stream.of(groupBy).filter(fieldNames::contains).toArray(String[]::new);
        sumBy = (String[])Stream.of(sumBy).filter(fieldNames::contains).toArray(String[]::new);
        int[] grpIdx = new int[groupBy.length];
        int[] sumIdx = new int[sumBy.length];
        for (i = 0; i < groupBy.length; ++i) {
            grpIdx[i] = fieldNames.indexOf(groupBy[i]);
        }
        for (i = 0; i < sumBy.length; ++i) {
            sumIdx[i] = fieldNames.indexOf(sumBy[i]);
        }
        return new DataSchema(grpIdx, sumIdx);
    }

    public DataSchema copy() {
        return new DataSchema(this.groupIndex, this.sumIndex);
    }
}

