/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.util.BaseDataUtil;
import kd.fi.gl.util.DateUtils;
import kd.fi.gl.vo.NameHistoryVO;

public class RptUtil {
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final Log logger = LogFactory.getLog(RptUtil.class);
    private static final String ASSIST_TYPE = "bd_asstacttype";

    public static List<QFilter[]> splitQFilterByFixedSize(QFilter[] filters, String propertyName, int splitSize) {
        ArrayList<QFilter[]> result = new ArrayList<QFilter[]>();
        Object[] values = null;
        for (QFilter qf : filters) {
            if (!qf.getProperty().equals(propertyName)) continue;
            values = ((Set)qf.getValue()).toArray();
            break;
        }
        if (values == null || values.length < splitSize) {
            result.add(filters);
            return result;
        }
        int len = filters.length;
        Lists.partition(new ArrayList(Arrays.asList(values)), (int)splitSize).forEach(ids -> {
            QFilter[] qfs = new QFilter[len];
            for (int i = 0; i < len; ++i) {
                QFilter qf = filters[i];
                qfs[i] = qf.getProperty().equals(propertyName) ? new QFilter(propertyName, "in", ids) : qf;
            }
            result.add(qfs);
        });
        return result;
    }

    public static Object sum(Object val1, Object val2) {
        if (val1 == null) {
            return val2;
        }
        if (val2 == null) {
            return val1;
        }
        if (val1 instanceof BigDecimal) {
            return ((BigDecimal)val1).add((BigDecimal)val2);
        }
        if (val1 instanceof Integer) {
            return (Integer)val1 + (Integer)val2;
        }
        if (val1 instanceof Double || val1 instanceof Float || val1 instanceof Long) {
            return new BigDecimal(val1.toString()).add(new BigDecimal(val2.toString()));
        }
        throw new KDBizException("value type not support1");
    }

    public static Object subtract(Object val1, Object val2) {
        if (val1 == null) {
            if (val2 == null) {
                return null;
            }
            if (val2 instanceof BigDecimal) {
                return ((BigDecimal)val2).negate();
            }
            if (val2 instanceof Integer) {
                return -((Integer)val2).intValue();
            }
            if (val2 instanceof Double || val2 instanceof Float || val2 instanceof Long) {
                return new BigDecimal(val2.toString()).negate();
            }
            throw new KDBizException("value type not support2");
        }
        if (val2 == null) {
            return val1;
        }
        if (val1 instanceof BigDecimal) {
            return ((BigDecimal)val1).subtract((BigDecimal)val2);
        }
        if (val1 instanceof Integer) {
            return (Integer)val1 - (Integer)val2;
        }
        if (val1 instanceof Double || val1 instanceof Float || val1 instanceof Long) {
            return new BigDecimal(val1.toString()).subtract(new BigDecimal(val2.toString()));
        }
        throw new KDBizException("value type not support3");
    }

    public static Map<Long, Long> getAllLeafAccountByMasterId(Set<Long> masterIdSet, Long accountTableId) {
        HashMap<Long, Long> result = new HashMap<Long, Long>();
        QFilter atFilter = new QFilter("accounttable", "=", (Object)accountTableId);
        atFilter.and(new QFilter("masterid", "in", masterIdSet));
        try (DataSet accDS = RptUtil.getAccountSet(atFilter);){
            HashSet<Long> selAcctSet = new HashSet<Long>();
            for (Row row : accDS.copy()) {
                selAcctSet.add(row.getLong("id"));
            }
            try (DataSet dd = RptUtil.getAllLeafAcctDataSet(accDS, selAcctSet);){
                for (Row row : dd) {
                    result.put(row.getLong("id"), row.getLong("masterid"));
                }
            }
        }
        return result;
    }

    private static DataSet getAccountSet(QFilter filter) {
        return QueryServiceHelper.queryDataSet((String)(RptUtil.class.getName() + ".account"), (String)"bd_accountview", (String)"id,masterid,parent", (QFilter[])(filter == null ? null : filter.toArray()), null);
    }

    private static DataSet getAllLeafAcctDataSet(DataSet selAllAcctDS, Set<Long> parentId) {
        QFilter qFilter = new QFilter("parent", "in", parentId);
        DataSet ds = RptUtil.getAccountSet(qFilter);
        try (DataSet copy = ds.copy();){
            if (copy.hasNext()) {
                HashSet<Long> leafAccList = new HashSet<Long>();
                for (Row row : copy) {
                    Long id = row.getLong("id");
                    leafAccList.add(id);
                }
                selAllAcctDS = selAllAcctDS.union(ds);
                Iterator iterator = RptUtil.getAllLeafAcctDataSet(selAllAcctDS, leafAccList);
                return iterator;
            }
            DataSet dataSet = selAllAcctDS;
            return dataSet;
        }
    }

    public static Map<Long, Map<String, Map<String, String>>> getAssgrpNameById(Set<Long> assgrpIdSet, Map<String, List<String>> flexFieldAndPropMap, NameHistoryVO nameHistoryVO) {
        HashMap<Long, Map<String, Map<String, String>>> result = new HashMap<Long, Map<String, Map<String, String>>>(16);
        HashMap<String, Set<Object>> entityValues = new HashMap<String, Set<Object>>(8);
        List<Tuple2<Long, Map<String, Object>>> flexProp = RptUtil.getFlexProp(assgrpIdSet);
        List list = flexProp.stream().flatMap(x -> ((Map)x.t2).entrySet().stream()).collect(Collectors.toList());
        for (Map.Entry entry : list) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            entityValues.computeIfAbsent(key, k -> new HashSet()).add(value);
        }
        Map<String, Map<Object, Map<String, String>>> propMap = RptUtil.getEntityIdNames(entityValues, flexFieldAndPropMap, nameHistoryVO);
        for (Tuple2<Long, Map<String, Object>> tuple2 : flexProp) {
            Long id = (Long)tuple2.t1;
            Map ffToIdMap = (Map)tuple2.t2;
            HashMap<String, Map<String, String>> ffToPropMap = new HashMap<String, Map<String, String>>();
            for (Map.Entry entry : ffToIdMap.entrySet()) {
                String ff = (String)entry.getKey();
                Object val = entry.getValue();
                Map<Object, Map<String, String>> idToPropMap = propMap.get(ff);
                if (idToPropMap != null) {
                    Map<String, String> props = idToPropMap.get(val);
                    ffToPropMap.put(ff, props);
                    continue;
                }
                ffToPropMap.put(ff, new HashMap(3));
                logger.error("\u6838\u7b97\u7ef4\u5ea6\u7c7b\u578b\u627e\u4e0d\u5230\uff1aflexfield: " + ff + ";assgrp: " + id);
            }
            result.put(id, ffToPropMap);
        }
        return result;
    }

    public static Map<String, Map<String, Map<String, String>>> getAssgrpNameById(Table<Long, Date, Set<Long>> orgBookedDateAssgrpId, Map<String, List<String>> flexFieldAndPropMap) {
        HashMap<String, Map<String, Map<String, String>>> assgrpProps = new HashMap<String, Map<String, Map<String, String>>>(64);
        orgBookedDateAssgrpId.rowKeySet().stream().forEach(x -> {
            Map bookedDateAssgrpId = orgBookedDateAssgrpId.row(x);
            bookedDateAssgrpId.entrySet().stream().forEach(entry -> {
                NameHistoryVO nameHistoryVO = new NameHistoryVO();
                nameHistoryVO.setOrgId(x);
                nameHistoryVO.setNameCtrlDate((Date)entry.getKey());
                Map<Long, Map<String, Map<String, String>>> assgrpNameById = RptUtil.getAssgrpNameById((Set)entry.getValue(), flexFieldAndPropMap, nameHistoryVO);
                assgrpNameById.entrySet().stream().forEach(assgrpName -> {
                    Long assgrpId = (Long)assgrpName.getKey();
                    String assgrpKey = RptUtil.buildAssgrpKey(x, (Date)entry.getKey(), assgrpId);
                    assgrpProps.put(assgrpKey, (Map<String, Map<String, String>>)assgrpName.getValue());
                });
            });
        });
        return assgrpProps;
    }

    public static String buildAssgrpKey(Long orgId, Date bookedDate, Long assgrpId) {
        String bookedDateStr = DateUtils.formatString((Date)bookedDate, (String)"yyyy-MM-dd");
        String assgrpKey = String.format("%s_%s_%s", orgId, bookedDateStr, assgrpId);
        return assgrpKey;
    }

    private static Map<String, Map<Object, Map<String, String>>> getEntityIdNames(Map<String, Set<Object>> entityValues, Map<String, List<String>> flexFieldAndPropMap, NameHistoryVO nameHistoryVO) {
        HashMap<String, Map<Object, Map<String, String>>> result = new HashMap<String, Map<Object, Map<String, String>>>(16);
        Set<String> names = entityValues.keySet();
        QFilter flexfieldFilter = new QFilter("flexfield", "in", names);
        String asstacttypeSelectFields = "flexfield,name,valuesource";
        DataSet asstypeDs = QueryServiceHelper.queryDataSet((String)(RptUtil.class.getName() + "getEntityIdNames"), (String)ASSIST_TYPE, (String)asstacttypeSelectFields, (QFilter[])flexfieldFilter.toArray(), null);
        for (Row row : asstypeDs) {
            boolean specialNameProcess;
            String[] splits;
            String flexfield = row.getString("flexfield");
            String assEntity = row.getString("valuesource");
            FlexProperty flexProp = FlexEntityMetaUtils.getFlexProperty((String)flexfield);
            String displayProperty = flexProp.getDisplayStyle().getDisplayProperty().getValue();
            String valueType = flexProp.getValueType();
            Set<Object> assvalSet = entityValues.get(flexfield);
            if ("3".equals(valueType)) {
                if (assvalSet == null) continue;
                HashMap map = new HashMap(16);
                for (Object val : assvalSet) {
                    HashMap<String, String> propAndValMap = new HashMap<String, String>(16);
                    propAndValMap.put(NAME, val.toString());
                    map.put(val, propAndValMap);
                }
                result.put(flexfield, map);
                continue;
            }
            if (StringUtils.isEmpty((String)assEntity)) continue;
            assEntity = "bos_assistantdatagroup".equals(assEntity) ? "bos_assistantdata_detail" : assEntity;
            QFilter idFilter = new QFilter("id", "in", assvalSet);
            HashSet<String> selectFields = new HashSet<String>(32);
            selectFields.add("id");
            String showName = RptUtil.showName(displayProperty, assEntity);
            for (String split : splits = showName.split(",")) {
                selectFields.add(split);
            }
            List<String> props = flexFieldAndPropMap.get(flexfield);
            if (props != null && !props.isEmpty()) {
                selectFields.addAll(props);
            }
            boolean bl = specialNameProcess = Objects.equals("1", valueType) && selectFields.contains(NAME);
            if (specialNameProcess) {
                BasedataEntityType entity = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)assEntity);
                String nameProp = entity.getNameProperty();
                nameHistoryVO.setSelectFields(String.format("id,%s name", nameProp));
                nameHistoryVO.setEntityId(assEntity);
                nameHistoryVO.getAssIdNameMap().clear();
                assvalSet.forEach(x -> nameHistoryVO.addAssId((Long)x));
                List<NameHistoryVO> nameHistoryVOS = Collections.singletonList(nameHistoryVO);
                BaseDataUtil.queryBaseDataByDate(nameHistoryVOS);
            }
            DataSet ds = QueryServiceHelper.queryDataSet((String)"AccBalanceFormRpt.analyzeAssgrpNameById", (String)assEntity, (String)String.join((CharSequence)",", selectFields), (QFilter[])idFilter.toArray(), null);
            Throwable throwable = null;
            try {
                HashMap map = new HashMap();
                for (Row r : ds) {
                    StringBuilder sb = new StringBuilder();
                    HashMap<String, String> propAndValMap = new HashMap<String, String>(32);
                    for (String s : splits) {
                        if (Objects.equals(s, NAME) && specialNameProcess) {
                            sb.append((String)nameHistoryVO.getAssIdNameMap().get(r.getLong("id")));
                        } else {
                            sb.append(r.getString(s));
                        }
                        sb.append(" ");
                    }
                    String name = sb.toString().trim();
                    propAndValMap.put(flexfield, name);
                    if (props != null && !props.isEmpty()) {
                        for (String prop : props) {
                            if (Objects.equals(prop, NAME) && specialNameProcess) {
                                propAndValMap.put(prop, (String)nameHistoryVO.getAssIdNameMap().get(r.getLong("id")));
                                continue;
                            }
                            propAndValMap.put(prop, r.getString(prop));
                        }
                    }
                    map.put(r.get("id"), propAndValMap);
                }
                result.put(flexfield, map);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds == null) continue;
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ds.close();
            }
        }
        return result;
    }

    private static String showName(String displayProperty, String entity) {
        String name = NAME;
        String number = NUMBER;
        if (!entity.equals("bos_assistantdata_detail")) {
            BasedataEntityType entityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)entity);
            name = entityType.getNameProperty();
            number = entityType.getNumberProperty();
        }
        switch (displayProperty) {
            case "1": {
                return number;
            }
            case "2": {
                return name;
            }
            case "3": {
                return name + "," + number;
            }
        }
        return name;
    }

    public static List<Map<String, String>> getAllAssgrpName(Set<Long> assgrpIds) {
        ArrayList<Map<String, String>> assgrpName = new ArrayList<Map<String, String>>();
        HashSet numbers = new HashSet();
        List<Tuple2<Long, Map<String, Object>>> flexProp = RptUtil.getFlexProp(assgrpIds);
        for (Tuple2<Long, Map<String, Object>> tuple2 : flexProp) {
            Map map = (Map)tuple2.t2;
            numbers.addAll(map.keySet());
        }
        String asstacttypeSelectFields = "flexfield, name";
        QFilter numberFilter = new QFilter("flexfield", "in", numbers);
        DataSet asstypeDs = QueryServiceHelper.queryDataSet((String)(RptUtil.class.getName() + "getAllAssgrpName2"), (String)ASSIST_TYPE, (String)asstacttypeSelectFields, (QFilter[])numberFilter.toArray(), (String)"flexfield asc");
        for (Row asstype : asstypeDs) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(NUMBER, asstype.getString("flexfield"));
            map.put(NAME, asstype.getString(NAME));
            assgrpName.add(map);
        }
        return assgrpName;
    }

    public static Map<Long, Tuple<String, String>> getIdNameMap(String entityId, Set<Long> ids) {
        HashMap<Long, Tuple<String, String>> result = new HashMap<Long, Tuple<String, String>>();
        QFilter[] filter = new QFilter[]{new QFilter("id", "in", ids)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(RptUtil.class.getName() + ".getIdNameMap"), (String)entityId, (String)"id,name,number", (QFilter[])filter, null);){
            for (Row row : dataSet) {
                result.put(row.getLong("id"), (Tuple<String, String>)new Tuple((Object)row.getString(NAME), (Object)row.getString(NUMBER)));
            }
        }
        return result;
    }

    public static Map<Long, String> getIdFnumberMap(String entityId, Set<Long> ids) {
        HashMap<Long, String> result = new HashMap<Long, String>();
        QFilter[] filter = new QFilter[]{new QFilter("id", "in", ids)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(RptUtil.class.getName() + ".getIdNameMap"), (String)entityId, (String)"id,number", (QFilter[])filter, null);){
            for (Row row : dataSet) {
                result.put(row.getLong("id"), row.getString(NUMBER));
            }
        }
        return result;
    }

    private static List<Tuple2<Long, Map<String, Object>>> getFlexProp(Collection<Long> assgrpIds) {
        ArrayList<Tuple2<Long, Map<String, Object>>> result = new ArrayList<Tuple2<Long, Map<String, Object>>>();
        QFilter fvalue = new QFilter("id", "in", assgrpIds);
        String str = null;
        Long id = null;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)RptUtil.class.getName(), (String)"gl_assist", (String)"id,assvals", (QFilter[])new QFilter[]{fvalue}, null);){
            for (Row d : ds) {
                str = d.getString("assvals");
                id = d.getLong("id");
                if (str == null) continue;
                Map cast = (Map)JSONUtils.cast((String)str, LinkedHashMap.class);
                LinkedHashMap map = new LinkedHashMap();
                for (Map.Entry entry : cast.entrySet()) {
                    Object value = entry.getValue();
                    if (value instanceof Integer) {
                        Integer v = (Integer)value;
                        map.put(entry.getKey(), v.longValue());
                        continue;
                    }
                    map.put(entry.getKey(), (Long)entry.getValue());
                }
                Tuple2 tuple2 = new Tuple2((Object)id, map);
                result.add((Tuple2<Long, Map<String, Object>>)tuple2);
            }
        }
        catch (IOException e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u89e3\u6790\u9519\u8bef\uff1aID: %1$s%2$s%3$s\u3002", (String)"RptUtil_0", (String)"fi-gl-report", (Object[])new Object[0]), id, ";values: ", str));
        }
        return result;
    }

    public static String fillAssistTypeName(String propName) {
        QFilter qFilter = new QFilter("flexfield", "=", (Object)propName);
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)ASSIST_TYPE, (String)"name,valuesource,valuetype", (QFilter[])new QFilter[]{qFilter});
        String valType = queryOne.getString("valuetype");
        String entityId = null;
        switch (valType) {
            case "1": {
                entityId = queryOne.getString("valuesource");
                break;
            }
            case "2": {
                entityId = "bos_assistantdata_detail";
                break;
            }
        }
        return entityId;
    }

    public static Map<Long, Long> getAllLeafAccountByNums(Set<String> numbers, Long acctTableID, QFilter extF) {
        return RptUtil.getAllLeafAccountByNums(numbers, acctTableID, null, extF);
    }

    public static Map<Long, Long> getAllLeafAccountByNums(Set<String> numbers, Long acctTableID, List<Long> orgIDs, QFilter extF) {
        HashMap<Long, Long> res = new HashMap<Long, Long>(100);
        QFilter acctTableF = new QFilter("accounttable", "=", (Object)acctTableID);
        Optional.ofNullable(extF).ifPresent(arg_0 -> ((QFilter)acctTableF).and(arg_0));
        if (orgIDs != null) {
            acctTableF.and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", orgIDs, (boolean)false));
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)(ReportUtils.class.getSimpleName() + "getAllLeafAcctMIDByNumber"), (String)"bd_accountview", (String)"id, longnumber, masterid", (QFilter[])new QFilter[]{acctTableF}, null);
        for (Row row : dataSet) {
            String[] split;
            String longnumber = row.getString("longnumber");
            for (String s : split = longnumber.split("_")) {
                if (!numbers.contains(s)) continue;
                res.put(row.getLong("id"), row.getLong("masterid"));
            }
        }
        return res;
    }
}

