/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.init;

import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.ext.fi.accountref.AccountRefUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.report.CashFlowQueryParam;
import kd.fi.gl.report.InitCashFlowQueryParam;
import kd.fi.gl.report.OrgType;
import kd.fi.gl.report.cashflow.CashFlowParallelQuery;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.GLUtil;

public class InitCFItemQueryRpt
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        CashFlowQueryParam queryParam = this.getCFParam(reportQueryParam);
        if (queryParam != null) {
            return new CashFlowParallelQuery(queryParam).execute();
        }
        String select = "id,number,name,level,isleaf,type,parent,direction,isdealactivity,isexchangerate,isprefit";
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_cashflowitem", (String)select, (QFilter[])new QFilter[]{new QFilter("1", "!=", (Object)"1", true)}, null);
    }

    private CashFlowQueryParam getCFParam(ReportQueryParam param) {
        AccountBookInfo defaultBookFromAccSys;
        InitCashFlowQueryParam qParam = new InitCashFlowQueryParam();
        FilterInfo filter = param.getFilter();
        long orgId = filter.getLong("org.id");
        HashSet<Long> orgIdSet = new HashSet<Long>();
        orgIdSet.add(orgId);
        qParam.setPorg(orgId);
        qParam.setFilteredChildOrg(orgIdSet);
        long bookTypeId = filter.getLong("booktype.id");
        if (bookTypeId == 0L && (defaultBookFromAccSys = AccSysUtil.getDefaultBookFromAccSys((Long)orgId)) != null) {
            bookTypeId = defaultBookFromAccSys.getBookTypeId();
        }
        qParam.setBookType(bookTypeId);
        QFilter[] qf = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("bookstype", "=", (Object)qParam.getBookType())};
        DynamicObject book = BusinessDataServiceHelper.loadSingle((String)"gl_accountbook", (String)"accounttable,basecurrency,curperiod,startperiod,cashinitperiod", (QFilter[])qf);
        if (book != null) {
            qParam.setAccountTable(AccountRefUtils.getCurPeriodAccountTableId((long)orgId, (long)bookTypeId, (long)book.getLong("cashinitperiod.id")));
            qParam.setCurrency(book.getLong("basecurrency.id"));
            int itemMaxLevel = GLUtil.getCFItemMaxLevel((Object)orgId);
            qParam.setItemLevel(itemMaxLevel);
            long curperiod = book.getLong("curperiod.id");
            long cashinitperiod = book.getLong("cashinitperiod.id");
            if (cashinitperiod == 0L) {
                cashinitperiod = curperiod;
            }
            qParam.setQueryByPeriod(true);
            qParam.setStartPeriod(cashinitperiod);
            qParam.setEndPeriod(cashinitperiod);
            qParam.setOrgType(OrgType.ENTITY);
            qParam.setEntityId("gl_initcashflow");
            qParam.setShowAssist(true);
            qParam.setQueryFromInit(true);
            qParam.setShowComassist(true);
            qParam.setOrgViewId(AccSysUtil.getMainViewByOrgAndBT((Long)orgId, (Long)bookTypeId));
            List comAssistValSource = CommonAssistUtil.getComAssistValSource((long)orgId, (long)qParam.getBookType());
            for (int i = 1; i <= comAssistValSource.size(); ++i) {
                String comassistKey = "comassist" + i;
                HashSet<Long> ids = new HashSet<Long>();
                ids.add(filter.getLong(comassistKey + ".id"));
                qParam.getComAssistValsList().add(new Tuple2((Object)comassistKey, ids));
            }
            return qParam;
        }
        return null;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List cols = super.getColumns(columns);
        Long org = null;
        Long booksType = null;
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        List filterItems = filterInfo.getFilterItems();
        for (FilterItemInfo item : filterItems) {
            String propName = item.getPropName();
            if ("org.id".equals(propName)) {
                org = (Long)item.getValue();
                continue;
            }
            if (!"booktype.id".equals(propName)) continue;
            booksType = (Long)item.getValue();
        }
        List comassist = CommonAssistUtil.getComAssistValSource((long)org, (long)booksType);
        int i = 1;
        int index = 2;
        for (String field : comassist) {
            String entity = "";
            if (field.startsWith("bos_assistantdata_detail")) {
                String[] str = field.split("-");
                entity = str[0];
            } else {
                entity = field;
            }
            ReportColumn column = new ReportColumn();
            column.setCaption(new LocaleString(CommonAssistUtil.getComAssistEntityName((long)org, (long)booksType, (String)field)));
            column.setEntityId(entity);
            column.setFieldKey(CommonAssistUtil.getComassistField((int)i++));
            column.setFieldType("basedata");
            cols.add(index++, column);
        }
        return cols;
    }
}

