/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.notice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.ext.fi.util.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.report.notice.NoticeRptQueryParam;
import kd.fi.gl.util.QFBuilder;

public class NoticeRptQueryUtils {
    private static final String LOCAL_CHECK = "1";
    private static final String ACNOTICE_SELECTED_FIELDS = "id, org, voucher, sendorg, receiveorg, bookeddate, billno, account, assgrp, entrydc, creator, checkstatus, voucherentry";
    private static final String CFNOTICE_SELECTED_FILEDS = "id, org, voucher, sendorg, receiveorg, bookeddate, billno, maincfitem cashflowitem, currency, entrydc, creator, checkstatus, voucherentry, amount";
    private static final String VOUCHER_SELECTED_FIELDS = "id voucherid, period, billno voucherno, vouchertype, entries.id, entries.edescription descprition";
    private static final String JOIN_FIELDS = "id,voucherid,receiveorg,sendorg,descprition,billno,period,voucherno,vouchertype,currency,entrydc,amount,creator,checkstatus,bookeddate";
    private static final Map<String, Tuple<String, Class<?>>> noticeMap = new HashMap();
    private static final Map<String, Tuple<String, Class<?>>> vchMap = new HashMap();

    private NoticeRptQueryUtils() {
    }

    protected static DataSet getACNoticeAndVoucherJoinDataSet(NoticeRptQueryParam noticeRptQueryParam) {
        if (LOCAL_CHECK.equals(noticeRptQueryParam.getNoticeCheckType())) {
            return NoticeRptQueryUtils.getNoticeAndVoucherJoinDataSet(noticeRptQueryParam, "id, org, voucher, sendorg, receiveorg, bookeddate, billno, account, assgrp, entrydc, creator, checkstatus, voucherentry, localcur currency, locamount amount");
        }
        return NoticeRptQueryUtils.getNoticeAndVoucherJoinDataSet(noticeRptQueryParam, "id, org, voucher, sendorg, receiveorg, bookeddate, billno, account, assgrp, entrydc, creator, checkstatus, voucherentry, currency, amount");
    }

    protected static DataSet getCFNoticeAndVoucherJoinDataSet(NoticeRptQueryParam noticeRptQueryParam) {
        return NoticeRptQueryUtils.getNoticeAndVoucherJoinDataSet(noticeRptQueryParam, CFNOTICE_SELECTED_FILEDS);
    }

    private static DataSet getNoticeAndVoucherJoinDataSet(NoticeRptQueryParam noticeRptQueryParam, String selectFields) {
        String[] stringArray;
        Boolean includeCheckOutNotices;
        String checkStatus;
        String type = noticeRptQueryParam.getType();
        Long opOrgId = noticeRptQueryParam.getOpOrgId();
        List<FilterItemInfo> tableHeadFilters = noticeRptQueryParam.getTableHeadFilters();
        QFBuilder noticeFilters = new QFBuilder();
        ArrayList<QFilter> vchFilterList = new ArrayList<QFilter>(tableHeadFilters.size() + 10);
        if (opOrgId > 0L) {
            noticeFilters.add("peerorg.id", "=", (Object)opOrgId);
        }
        if ("0".equals(checkStatus = noticeRptQueryParam.getCheckStatus()) || LOCAL_CHECK.equals(checkStatus)) {
            noticeFilters.add("checkstatus", "=", (Object)checkStatus);
        }
        if (!(includeCheckOutNotices = noticeRptQueryParam.getIncludeCheckOutNotices()).booleanValue()) {
            noticeFilters.add("checkout", "=", (Object)"0");
        }
        String currencyField = noticeRptQueryParam.getNoticeCheckType().equals("0") ? "currency.id" : "localcur.id";
        noticeFilters.add("booktype", "=", (Object)AccSysUtil.getMainBookTypeId());
        noticeFilters.add("org_id", "=", (Object)noticeRptQueryParam.getOrgId());
        noticeFilters.add("bookeddate", ">=", (Object)noticeRptQueryParam.getStartDate());
        noticeFilters.add("bookeddate", "<=", (Object)noticeRptQueryParam.getEndDate());
        noticeFilters.add(currencyField, "=", (Object)noticeRptQueryParam.getCurrencyId());
        noticeFilters.add("noticetype", "=", (Object)type);
        String currentFormId = noticeRptQueryParam.getFormId();
        noticeFilters.add(NoticeRptQueryUtils.getHeadFilters(tableHeadFilters, currentFormId));
        vchFilterList.addAll(NoticeRptQueryUtils.getHeadFilters(tableHeadFilters, "gl_voucher"));
        DataSet noticeDs = QueryServiceHelper.queryDataSet((String)"NoticeRptQueryUtils.noticeDs", (String)currentFormId, (String)selectFields, (QFilter[])noticeFilters.toArray(), (String)"");
        HashSet voucherSet = new HashSet();
        DataSet copy = noticeDs.copy();
        copy.forEach(row -> voucherSet.add(row.getLong("voucher")));
        vchFilterList.add(new QFilter("id", "in", voucherSet));
        DataSet voucherDs = VoucherQueryUtils.queryDataSet((String)VOUCHER_SELECTED_FIELDS, (QFilter[])vchFilterList.toArray(new QFilter[0]), null, (int)-1);
        String joinFields = "";
        if (currentFormId.equals("gl_acnotice")) {
            joinFields = "id,voucherid,receiveorg,sendorg,descprition,billno,period,voucherno,vouchertype,currency,entrydc,amount,creator,checkstatus,bookeddate,account,assgrp";
        } else if (currentFormId.equals("gl_cfnotice")) {
            joinFields = "id,voucherid,receiveorg,sendorg,descprition,billno,period,voucherno,vouchertype,currency,entrydc,amount,creator,checkstatus,bookeddate,cashflowitem";
        }
        String paramSortInfo = noticeRptQueryParam.getSortInfo();
        if (StringUtils.isEmpty((String)paramSortInfo)) {
            if (type.equals(LOCAL_CHECK)) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "receiveorg desc";
                stringArray = stringArray2;
                stringArray2[1] = "bookeddate desc";
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "sendorg desc";
                stringArray = stringArray3;
                stringArray3[1] = "bookeddate desc";
            }
        } else if (type.equals(LOCAL_CHECK)) {
            if (paramSortInfo.contains("receive")) {
                String[] stringArray4 = new String[1];
                stringArray = stringArray4;
                stringArray4[0] = "receiveorg desc";
            } else {
                String[] stringArray5 = new String[2];
                stringArray5[0] = "receiveorg desc";
                stringArray = stringArray5;
                stringArray5[1] = paramSortInfo.replace("send", "");
            }
        } else if (paramSortInfo.contains("send")) {
            String[] stringArray6 = new String[1];
            stringArray = stringArray6;
            stringArray6[0] = "sendorg desc";
        } else {
            String[] stringArray7 = new String[2];
            stringArray7[0] = "sendorg desc";
            stringArray = stringArray7;
            stringArray7[1] = paramSortInfo.replace("receive", "");
        }
        String[] sortInfo = stringArray;
        DataSet datas = noticeDs.join(voucherDs).on("voucherentry", "entries.id").select(joinFields.split(",")).finish().distinct().addField(LOCAL_CHECK, "ROWTYPE").orderBy(sortInfo);
        DataSet total = NoticeRptQueryUtils.createEmptyTotalDataSet(datas, noticeRptQueryParam);
        if (Objects.isNull(total)) {
            return datas;
        }
        return datas.union(total);
    }

    private static DataSet createEmptyTotalDataSet(DataSet datas, NoticeRptQueryParam noticeRptQueryParam) {
        if (null == datas) {
            return null;
        }
        try (DataSet tempDatas = datas.copy();){
            RowMeta rowMeta = datas.getRowMeta();
            String[] fields = rowMeta.getFieldNames();
            if (tempDatas.isEmpty()) {
                Algo algo = Algo.create((String)NoticeRptQueryUtils.class.getName());
                DataSetBuilder dataSetBuilder = algo.createDataSetBuilder(rowMeta);
                Object[] row = new Object[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    String field = fields[i];
                    row[i] = "DESCPRITION".equalsIgnoreCase(field) ? ResManager.loadKDString((String)"\u5408\u8ba1", (String)"NoticeRptQueryUtils_0", (String)"fi-gl-report", (Object[])new Object[0]) : ("AMOUNT".equalsIgnoreCase(field) ? BigDecimal.ZERO : ("CURRENCY".equalsIgnoreCase(field) ? noticeRptQueryParam.getCurrencyId() : ("ROWTYPE".equalsIgnoreCase(field) ? "2" : null)));
                }
                dataSetBuilder.append(row);
                DataSet dataSet = dataSetBuilder.build();
                return dataSet;
            }
            List<String> nullFields = Stream.of(fields).collect(Collectors.toList());
            nullFields.remove("amount");
            nullFields.remove("descprition");
            nullFields.remove("rowtype");
            nullFields.remove("currency");
            datas = datas.select("case when ENTRYDC == '-1' or ENTRYDC == 'o' then AMOUNT * -1 else AMOUNT end as FORWARDAMOUNT");
            DataSet dataSet = datas.groupBy().sum("FORWARDAMOUNT", "AMOUNT").finish().addNullField(nullFields.toArray(new String[0])).addField(ResManager.loadKDString((String)"'\u5408\u8ba1'", (String)"NoticeRptQueryUtils_1", (String)"fi-gl-report", (Object[])new Object[0]), "DESCPRITION").addField(noticeRptQueryParam.getCurrencyId().toString(), "CURRENCY").addField("2", "ROWTYPE").select(fields);
            return dataSet;
        }
    }

    private static List<QFilter> getHeadFilters(List<FilterItemInfo> tableHeadFilters, String formId) {
        switch (formId) {
            case "gl_acnotice": 
            case "gl_cfnotice": {
                return ReportUtils.tableHeadFilter2QFilters(tableHeadFilters, noticeMap);
            }
            case "gl_voucher": {
                return ReportUtils.tableHeadFilter2QFilters(tableHeadFilters, vchMap);
            }
        }
        return Collections.emptyList();
    }

    static {
        noticeMap.put("sendamount", Tuple.create((Object)"amount", BigDecimal.class));
        noticeMap.put("receiveamount", Tuple.create((Object)"amount", BigDecimal.class));
        noticeMap.put("sendbillno", Tuple.create((Object)"billno", String.class));
        noticeMap.put("receivebillno", Tuple.create((Object)"billno", String.class));
        noticeMap.put("sendcreator", Tuple.create((Object)"creator.name", String.class));
        noticeMap.put("receivecreator", Tuple.create((Object)"creator.name", String.class));
        noticeMap.put("sendaccount", Tuple.create((Object)"account.number", String.class));
        noticeMap.put("receiveaccount", Tuple.create((Object)"account.number", String.class));
        noticeMap.put("sendcashflowitem", Tuple.create((Object)"maincfitem.name", String.class));
        noticeMap.put("receivecashflowitem", Tuple.create((Object)"maincfitem.name", String.class));
        noticeMap.put("senddc", Tuple.create((Object)"entrydc", String.class));
        noticeMap.put("receivedc", Tuple.create((Object)"entrydc", String.class));
        noticeMap.put("sendassgrp", Tuple.create((Object)"assgrp", String.class));
        noticeMap.put("receiveassgrp", Tuple.create((Object)"assgrp", String.class));
        vchMap.put("sendperiod", Tuple.create((Object)"period.name", String.class));
        vchMap.put("receiveperiod", Tuple.create((Object)"period.name", String.class));
        vchMap.put("senddesc", Tuple.create((Object)"entries.edescription", String.class));
        vchMap.put("receivedesc", Tuple.create((Object)"entries.edescription", String.class));
        vchMap.put("sendvoucherno", Tuple.create((Object)"billno", String.class));
        vchMap.put("receivevoucherno", Tuple.create((Object)"billno", String.class));
        vchMap.put("sendvouchertype", Tuple.create((Object)"vouchertype.name", String.class));
        vchMap.put("receivevouchertype", Tuple.create((Object)"vouchertype.name", String.class));
    }
}

