/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.qing;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.qing.IQingDataProvider;
import kd.bos.entity.qing.QingData;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.entity.qing.QingLinkageInfo;
import kd.bos.entity.qing.QingMeta;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.report.AccBalanceQueryRpt;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.ReportHelper;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.report.ShowByAccountDCParam;
import kd.fi.gl.report.common.RptUtil;
import kd.fi.gl.report.qing.util.QingBalanceLinkUtils;
import kd.fi.gl.report.subsidiary.SubsidiaryPeriod;
import kd.fi.gl.report.subsidiary.SubsidiaryReportDatasetBuilder;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.vo.NameHistoryVO;

public class AccBalQingDataProvider
extends AbstractFormPlugin
implements IQingDataProvider {
    private static final String FLEX_PROP_CACHE = "flexprop_cache";
    private static final String FLEXFIELD = "flexfield";
    private static final String FIELDNAME = "fieldname";
    private static final String ASS_PROP = "assprop";
    private static final Log logger = LogFactory.getLog(AccBalQingDataProvider.class);
    private static final String CACHE_ID = "AccBalQingDataProvider_cacheId";
    private static final String COM_ASSIST_ENTITY = "comAssistEntity";
    private static final String CACHE_QUERY_PARAM = "queryparam";
    private static final String QING_META = "AccBalQingDataProvider_qingMeta";
    private static final String NAME_HISTORY_VO = "AccBalQingDataProvider_nameHistoryVO";
    private static final String YEAR_BEGIN_DEBIT = "yearbdebit";
    private static final String YEAR_BEGIN_CREIT = "yearbcredit";
    private static final String BEGIN_DEBIT = "begindebit";
    private static final String BEGIN_CREIT = "begincredit";
    private static final String END_DEBIT = "enddebit";
    private static final String END_CREIT = "endcredit";
    private static final String ASS_PROP_FIELD = "assistpropfield";
    private static final int MAX_SIZE = 499999;

    public void setFilterParameter(String filterParameter) {
        this.getPageCache().put(CACHE_QUERY_PARAM, filterParameter);
    }

    public String getFilterParameter() {
        return this.getPageCache().get(CACHE_QUERY_PARAM);
    }

    public QingMeta getMeta(String pageId) {
        try {
            return this._getQingMeta(pageId);
        }
        catch (Exception e) {
            String s = GLUtil.printError((Throwable)e);
            logger.error(s);
            throw new KDBizException(s);
        }
    }

    public List<QingLinkageInfo> getLinkageInfo(String pageId, String ctrKey) {
        return QingBalanceLinkUtils.getLinkageInfo(pageId, ctrKey);
    }

    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        ReportQueryParam queryParam = (ReportQueryParam)SerializationUtils.deSerializeFromBase64((String)this.getFilterParameter());
        QingBalanceLinkUtils.fireLinkageInfo(ids, pageId, formId, appId, queryParam, this.getView());
    }

    private QingMeta _getQingMeta(String pageId) {
        IPageCache pageCache = this.getPageCache(pageId);
        ReportQueryParam queryParam = this.getReportQueryParam(pageCache);
        MulOrgQPRpt qpRpt = new MulOrgQPRpt(queryParam.getFilter(), "gl_rpt_accbalance_qing");
        qpRpt.setOnlyShowDetailData(true);
        Map<Long, DynamicObject> allPeriods = this.getAllPeriods(qpRpt);
        qpRpt.setPeriods(allPeriods.keySet());
        pageCache.put("periods", SerializationUtils.serializeToBase64(allPeriods));
        AccBalanceQueryRpt accQueryRpt = new AccBalanceQueryRpt(qpRpt);
        DataSet dataSet = accQueryRpt.query(null, null);
        boolean showPrice = this.isShowPrice(queryParam, qpRpt.getPorg());
        if (showPrice) {
            String field = "yearbdebit#,yearbcredit#,begindebit#,begincredit#,debit#,credit#,enddebit#,endcredit#,yeardebit#,yearcredit#";
            Field[] fields = dataSet.getRowMeta().getFields();
            ArrayList<String> list = new ArrayList<String>(fields.length);
            for (Field field2 : fields) {
                if (field2.getAlias().endsWith("price")) continue;
                list.add(field2.getAlias());
            }
            for (String string : field.split(",")) {
                String qty = string.replace("#", "qty");
                String amt = string.replace("#", qpRpt.isQueryCurrency() ? "for" : "local");
                String price = string.replace("#", "price");
                String priceField = String.format("case when %s != 0 then %s/%s else 0 end as %s", qty, amt, qty, price);
                list.add(priceField);
            }
            dataSet = dataSet.select(list.toArray(new String[0]));
        }
        dataSet = QingBalanceLinkUtils.addIdField(dataSet);
        List<AbstractReportColumn> assgrpColList = this.getAssgrpColList(dataSet.copy(), qpRpt.isShowAssist());
        CachedDataSet cachedDataSet = dataSet.cache(CacheHint.getDefault());
        String cacheId = cachedDataSet.getCacheId();
        pageCache.put(CACHE_ID, SerializationUtils.serializeToBase64((Object)cacheId));
        HashMap hashMap = new HashMap(qpRpt.getComAssistEntityList().size());
        qpRpt.getComAssistEntityList().stream().forEach(x -> {
            String cfr_ignored_0 = (String)comAssistEntity.put(x.t1, x.t2);
        });
        pageCache.put(COM_ASSIST_ENTITY, SerializationUtils.toJsonString(hashMap));
        ArrayList<AbstractReportColumn> columnList = new ArrayList<AbstractReportColumn>();
        columnList.add((AbstractReportColumn)ReportHelper.createColumn(new LocaleString(ResManager.loadKDString((String)"\u79d1\u76ee", (String)"AccBalQingDataProvider_0", (String)"fi-gl-report", (Object[])new Object[0])), "number", "text"));
        columnList.add((AbstractReportColumn)ReportHelper.createColumn(new LocaleString(ResManager.loadKDString((String)"\u79d1\u76ee\u540d\u79f0", (String)"AccBalQingDataProvider_1", (String)"fi-gl-report", (Object[])new Object[0])), "name", "text"));
        columnList.add((AbstractReportColumn)ReportHelper.createColumn(new LocaleString(ResManager.loadKDString((String)"\u5e01\u79cd", (String)"AccBalQingDataProvider_2", (String)"fi-gl-report", (Object[])new Object[0])), "currency", "text"));
        columnList.add((AbstractReportColumn)ReportHelper.createColumn(new LocaleString(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"AccBalQingDataProvider_3", (String)"fi-gl-report", (Object[])new Object[0])), "org", "text"));
        columnList.add((AbstractReportColumn)ReportHelper.createColumn(new LocaleString(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6", (String)"AccBalQingDataProvider_4", (String)"fi-gl-report", (Object[])new Object[0])), "assgrp", "basedata"));
        columnList.add((AbstractReportColumn)ReportHelper.createColumn(new LocaleString(ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"AccBalQingDataProvider_5", (String)"fi-gl-report", (Object[])new Object[0])), "measureunit", "text"));
        if (qpRpt.isShowOrg()) {
            ReportColumn column = ReportHelper.createColumn(new LocaleString(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u7f16\u7801", (String)"AccBalQingDataProvider_9", (String)"fi-gl-report", (Object[])new Object[0])), "orgnumber", "text");
            columnList.add((AbstractReportColumn)column);
        }
        columnList.add((AbstractReportColumn)ReportHelper.createColumn(new LocaleString(ResManager.loadKDString((String)"\u79d1\u76eeid", (String)"AccBalQingDataProvider_6", (String)"fi-gl-report", (Object[])new Object[0])), "account", "basedata"));
        if (queryParam.getFilter().getBoolean("showperiod")) {
            columnList.add((AbstractReportColumn)ReportHelper.createColumn(new LocaleString(ResManager.loadKDString((String)"\u671f\u95f4\u540d\u79f0", (String)"AccBalQingDataProvider_7", (String)"fi-gl-report", (Object[])new Object[0])), "periodname", "text"));
            columnList.add((AbstractReportColumn)ReportHelper.createColumn(new LocaleString(ResManager.loadKDString((String)"\u671f\u95f4\u7f16\u7801", (String)"AccBalQingDataProvider_8", (String)"fi-gl-report", (Object[])new Object[0])), "periodnumber", "text"));
        }
        columnList.add((AbstractReportColumn)ReportHelper.createColumn(new LocaleString("AccBalQingDataProvider_id"), "AccBalQingDataProvider_id", "text"));
        columnList.addAll(assgrpColList);
        List<AbstractReportColumn> assistPropCols = this.getAssistPropCols(queryParam, pageCache);
        columnList.addAll(assistPropCols);
        List<AbstractReportColumn> list = accQueryRpt.getColumns(columnList);
        List<ReportColumn> allReportColumns = this.getAllReportColumns(list, null);
        ArrayList<String> needHideFields = new ArrayList<String>();
        needHideFields.add("assgrp");
        needHideFields.add("account");
        needHideFields.add("AccBalQingDataProvider_id");
        QingMeta qingMeta = this.createQingMeta(allReportColumns, needHideFields);
        pageCache.put(QING_META, SerializationUtils.serializeToBase64((Object)qingMeta));
        Map periodMap = SubsidiaryReportDatasetBuilder.initPeriodMap((Long)qpRpt.getEndPeriod(), (Long)qpRpt.getEndPeriod());
        Date nameCtrlDate = ((SubsidiaryPeriod)periodMap.get(qpRpt.getEndPeriod())).getEnddate();
        NameHistoryVO nameHistoryVO = new NameHistoryVO();
        nameHistoryVO.setOrgId(Long.valueOf(qpRpt.getPorg()));
        nameHistoryVO.setNameCtrlDate(nameCtrlDate);
        pageCache.put(NAME_HISTORY_VO, SerializationUtils.serializeToBase64((Object)nameHistoryVO));
        return qingMeta;
    }

    private boolean isShowPrice(ReportQueryParam queryParam, long orgId) {
        boolean showQty = queryParam.getFilter().getBoolean("showqty");
        if (!showQty) {
            return false;
        }
        Boolean showPrice = (Boolean)GLUtil.getSystemParam((String)"p_showprice", (Long)orgId);
        return showPrice == null ? false : showPrice;
    }

    private List<AbstractReportColumn> getAssistPropCols(ReportQueryParam queryParam, IPageCache pageCache) {
        List flexProps = (List)queryParam.getFilter().getFilterItem(ASS_PROP).getValue();
        ArrayList<AbstractReportColumn> result = new ArrayList<AbstractReportColumn>(8);
        if (flexProps == null || flexProps.isEmpty()) {
            return result;
        }
        HashMap flexFieldAndPropMap = new HashMap(flexProps.size());
        for (DynamicObject flexProp : flexProps) {
            DynamicObject field = flexProp.getDynamicObject(FIELDNAME);
            if (field == null) continue;
            String flexName = field.getString("name");
            String flexField = field.getString(FLEXFIELD);
            String fieldValues = flexProp.getString(ASS_PROP_FIELD);
            if (kd.bos.util.StringUtils.isEmpty((String)fieldValues)) continue;
            Map map = (Map)GLUtil.fromSerializedString((String)fieldValues);
            ArrayList props = new ArrayList(map.size());
            for (Map.Entry entry : map.entrySet()) {
                String propAlias = flexField + "." + (String)entry.getKey();
                result.add((AbstractReportColumn)ReportHelper.createColumn(new LocaleString(flexName + "." + (String)entry.getValue()), propAlias, "text"));
                props.add(entry.getKey());
            }
            flexFieldAndPropMap.put(flexField, props);
        }
        pageCache.put(FLEX_PROP_CACHE, GLUtil.toSerializedString(flexFieldAndPropMap));
        return result;
    }

    private ReportQueryParam getReportQueryParam(IPageCache pageCache) {
        String filterStr = pageCache.get(CACHE_QUERY_PARAM);
        return (ReportQueryParam)SerializationUtils.deSerializeFromBase64((String)filterStr);
    }

    private List<AbstractReportColumn> getAssgrpColList(DataSet ds, boolean showAssist) {
        ArrayList<AbstractReportColumn> result = new ArrayList<AbstractReportColumn>();
        if (showAssist) {
            HashSet<Long> assgrpIds = new HashSet<Long>();
            HashSet<Map<String, String>> assgrpNames = new HashSet<Map<String, String>>();
            for (Row row : ds) {
                if (row.getLong("assgrp") == null) continue;
                assgrpIds.add(row.getLong("assgrp"));
                if (assgrpIds.size() <= 499999) continue;
                assgrpNames.addAll(RptUtil.getAllAssgrpName(assgrpIds));
                assgrpIds.clear();
            }
            if (assgrpIds.size() > 0) {
                assgrpNames.addAll(RptUtil.getAllAssgrpName(assgrpIds));
                for (Map map : assgrpNames) {
                    result.add((AbstractReportColumn)ReportHelper.createColumn(new LocaleString((String)map.get("name")), (String)map.get("number"), "text"));
                }
            }
        }
        return result;
    }

    private IPageCache getPageCache(String pageId) {
        return new PageCache(pageId, false);
    }

    private QingMeta createQingMeta(List<ReportColumn> columns, List<String> needHideFields) {
        QingMeta qingMeta = new QingMeta();
        for (AbstractReportColumn abstractReportColumn : columns) {
            ReportColumn reportColumn = (ReportColumn)abstractReportColumn;
            if (reportColumn.isHide()) continue;
            String fieldKey = reportColumn.getFieldKey();
            LocaleString caption = reportColumn.getCaption();
            String fieldType = reportColumn.getFieldType();
            int qingType = this.getQingType(fieldType);
            String entity = null;
            if (qingType == QingFieldType.BaseData.toNumber()) {
                entity = ((ReportColumn)abstractReportColumn).getEntityId();
            }
            qingMeta.addColumn(this.createFieldObj(fieldKey, caption, qingType, needHideFields.contains(fieldKey), entity));
        }
        return qingMeta;
    }

    private int getQingType(String fieldType) {
        switch (fieldType) {
            case "basedata": {
                return QingFieldType.Int.toNumber();
            }
            case "price": 
            case "qty": 
            case "amount": {
                return QingFieldType.Number.toNumber();
            }
            case "text": {
                return QingFieldType.String.toNumber();
            }
            case "integer": {
                return QingFieldType.Int.toNumber();
            }
            case "date": {
                return QingFieldType.Date.toNumber();
            }
        }
        return 0;
    }

    private kd.bos.entity.qing.Field createFieldObj(String key, LocaleString name, int fieldType, boolean hide, String entity) {
        kd.bos.entity.qing.Field field = new kd.bos.entity.qing.Field();
        field.setKey(key);
        field.setName(name);
        field.setFieldType(fieldType);
        field.setHide(hide);
        field.setEntity(entity);
        return field;
    }

    private List<ReportColumn> getAllReportColumns(List<AbstractReportColumn> columns, String parentName) {
        ArrayList<ReportColumn> list = new ArrayList<ReportColumn>();
        for (AbstractReportColumn column : columns) {
            if (column instanceof ReportColumn) {
                if (parentName != null) {
                    column.setCaption(new LocaleString(parentName + "-" + column.getCaption().getLocaleValue()));
                }
                list.add((ReportColumn)column);
                continue;
            }
            if (!(column instanceof ReportColumnGroup)) continue;
            ReportColumnGroup group = (ReportColumnGroup)column;
            list.addAll(this.getAllReportColumns(group.getChildren(), group.getCaption().getLocaleValue()));
        }
        return list;
    }

    private QingData getDataStartFromZero(String pageId, int startRow, int limit) {
        IPageCache pageCache = this.getPageCache(pageId);
        QingMeta qingMeta = (QingMeta)SerializationUtils.deSerializeFromBase64((String)pageCache.get(QING_META));
        String cacheId = (String)SerializationUtils.deSerializeFromBase64((String)pageCache.get(CACHE_ID));
        Map comAssistEntity = (Map)SerializationUtils.fromJsonString((String)pageCache.get(COM_ASSIST_ENTITY), Map.class);
        QingData qingData = new QingData();
        Map<String, Integer> fieldMap = AccBalQingDataProvider.buildQingDataIndexMap(qingMeta);
        int size = fieldMap.size();
        ArrayList<Object[]> rowList = new ArrayList<Object[]>();
        Map<String, Set<Long>> baseDataMap = this.initBaseDataMap(fieldMap);
        if (cacheId != null) {
            CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)cacheId);
            int rowCount = cacheDataSet.getRowCount();
            List list = startRow >= rowCount ? new ArrayList(0) : cacheDataSet.getList(startRow, limit);
            String[] fieldNames = cacheDataSet.getRowMeta().getFieldNames();
            Map periods = (Map)SerializationUtils.deSerializeFromBase64((String)pageCache.get("periods"));
            for (Row row : list) {
                for (Map.Entry<String, Set<Long>> entry : baseDataMap.entrySet()) {
                    String key = entry.getKey();
                    Set<Long> ids = entry.getValue();
                    if (row.getLong(key) == null) continue;
                    ids.add(row.getLong(key));
                }
                Object[] data = new Object[size];
                for (String fieldName : fieldNames) {
                    Integer idx = fieldMap.get(fieldName);
                    if (idx == null) continue;
                    data[idx.intValue()] = row.get(fieldName);
                }
                if (fieldMap.containsKey("periodnumber") || fieldMap.containsKey("periodname")) {
                    Long l = row.getLong("period");
                    this.setPeriodField(fieldMap, data, "periodnumber", l, periods);
                    this.setPeriodField(fieldMap, data, "periodname", l, periods);
                }
                rowList.add(data);
            }
        }
        String propCache = pageCache.get(FLEX_PROP_CACHE);
        HashMap<String, List<String>> flexFieldAndPropMap = new HashMap(8);
        if (!kd.bos.util.StringUtils.isEmpty((String)propCache)) {
            flexFieldAndPropMap = (Map)GLUtil.fromSerializedString((String)propCache);
        }
        this.setBaseDataName(rowList, fieldMap, baseDataMap, flexFieldAndPropMap, comAssistEntity, pageCache);
        qingData.setDataindex(fieldMap);
        qingData.setRows(rowList);
        List<String> amountTypes = this.getAmountTypes(fieldMap);
        ReportQueryParam queryParam = this.getReportQueryParam(pageCache);
        ShowByAccountDCParam param = new ShowByAccountDCParam(this.getParentOrg(queryParam), Long.valueOf(queryParam.getFilter().getLong("accounttable")));
        param.setAccountField(fieldMap.get("account").toString());
        param.setAmountTypes(amountTypes);
        param.addBalField(YEAR_BEGIN_DEBIT, YEAR_BEGIN_CREIT);
        param.addBalField(BEGIN_DEBIT, BEGIN_CREIT);
        param.addBalField(END_DEBIT, END_CREIT);
        ReportUtils.showRowDataByActDC((ShowByAccountDCParam)param, rowList, fieldMap);
        return qingData;
    }

    private List<String> getAmountTypes(Map<String, Integer> fieldMap) {
        Set<String> props = fieldMap.keySet();
        ArrayList<String> amountTypes = new ArrayList<String>();
        amountTypes.add("local");
        if (props.contains("begindebitfor")) {
            amountTypes.add("for");
        }
        if (props.contains("begindebitqty")) {
            amountTypes.add("qty");
        }
        if (props.contains("begindebitrpt")) {
            amountTypes.add("rpt");
        }
        return amountTypes;
    }

    private Long getParentOrg(ReportQueryParam queryParam) {
        Map commFilter = queryParam.getFilter().getCommFilter();
        QFilter filter = (QFilter)commFilter.get("parentOrg");
        if (StringUtils.isBlank((Object)filter)) {
            return 0L;
        }
        return Long.parseLong(filter.getValue().toString());
    }

    public QingData getData(String pageId, int startRow, int limit) {
        try {
            return this.getDataStartFromZero(pageId, startRow - 1, limit);
        }
        catch (Exception e) {
            String s = GLUtil.printError((Throwable)e);
            logger.error(s);
            throw new KDBizException(s);
        }
    }

    private void setBaseDataName(List<Object[]> rowList, Map<String, Integer> fieldMap, Map<String, Set<Long>> baseDataMap, Map<String, List<String>> flexFieldAndPropMap, Map<String, String> comAssistEntity, IPageCache pageCache) {
        HashMap<String, String> keyToTypeMap = new HashMap<String, String>();
        keyToTypeMap.put("currency", "bd_currency");
        keyToTypeMap.put("org", "bos_org");
        keyToTypeMap.put("measureunit", "bd_measureunits");
        if (!comAssistEntity.isEmpty()) {
            comAssistEntity.entrySet().stream().forEach(x -> {
                String cfr_ignored_0 = (String)keyToTypeMap.put((String)x.getKey(), (String)x.getValue());
            });
        }
        for (Map.Entry<String, Set<Long>> entry : baseDataMap.entrySet()) {
            String key = entry.getKey();
            Integer idx = fieldMap.get(key);
            Set<Long> ids = entry.getValue();
            if ("assgrp".equals(key)) {
                NameHistoryVO nameHistoryVO = (NameHistoryVO)SerializationUtils.deSerializeFromBase64((String)pageCache.get(NAME_HISTORY_VO));
                Map<Long, Map<String, Map<String, String>>> assgrpPropsById = RptUtil.getAssgrpNameById(ids, flexFieldAndPropMap, nameHistoryVO);
                for (Object[] obj : rowList) {
                    Map<String, Map<String, String>> flexMap;
                    Long assgrp = (Long)obj[idx];
                    if (assgrp == null || assgrp == 0L || (flexMap = assgrpPropsById.get(assgrp)) == null) continue;
                    for (Map.Entry<String, Map<String, String>> ff : flexMap.entrySet()) {
                        Map<String, String> propAndVals = ff.getValue();
                        String flexField = ff.getKey();
                        if (CollectionUtils.isEmpty(propAndVals)) continue;
                        for (Map.Entry<String, String> propAndVal : propAndVals.entrySet()) {
                            String prop = propAndVal.getKey();
                            String fieldKey = "";
                            fieldKey = prop.equals(flexField) ? prop : flexField + "." + prop;
                            Integer ffIndex = fieldMap.get(fieldKey);
                            if (ffIndex == null) continue;
                            obj[ffIndex.intValue()] = propAndVal.getValue();
                        }
                    }
                }
                continue;
            }
            String entityId = (String)keyToTypeMap.get(key);
            Map<Long, Tuple<String, String>> baseDataIdNameMap = RptUtil.getIdNameMap(entityId, ids);
            for (Object[] obj : rowList) {
                Long id = (Long)obj[idx];
                Tuple<String, String> tuple = baseDataIdNameMap.get(id);
                if (tuple != null) {
                    obj[idx.intValue()] = tuple.item1;
                    if (!key.equals("org")) continue;
                    obj[fieldMap.get((Object)"orgnumber").intValue()] = tuple.item2;
                    continue;
                }
                obj[idx.intValue()] = "";
            }
        }
    }

    private Map<String, Set<Long>> initBaseDataMap(Map<String, Integer> fieldMap) {
        HashMap<String, Set<Long>> result = new HashMap<String, Set<Long>>();
        String baseDataStr = "currency,org,assgrp,measureunit";
        for (String str : baseDataStr.split(",")) {
            Integer idx = fieldMap.get(str);
            if (idx == null) continue;
            result.put(str, new HashSet());
        }
        fieldMap.keySet().stream().forEach(x -> {
            if (x.startsWith("comassist")) {
                result.put((String)x, new HashSet());
            }
        });
        return result;
    }

    private static Map<String, Integer> buildQingDataIndexMap(QingMeta qingMeta) {
        LinkedHashMap<String, Integer> qingDataIndexMap = new LinkedHashMap<String, Integer>(16);
        int columnSeqNo = 0;
        for (kd.bos.entity.qing.Field col : qingMeta.getColumns()) {
            qingDataIndexMap.put(col.getKey(), columnSeqNo++);
        }
        return qingDataIndexMap;
    }

    private Map<Long, DynamicObject> getAllPeriods(MulOrgQPRpt qpRpt) {
        QFilter filter = new QFilter("periodtype", "=", (Object)qpRpt.getPeriodType());
        QFilter startPeriod = new QFilter("id", ">=", (Object)qpRpt.getStartPeriod());
        QFilter endPeriod = new QFilter("id", "<=", (Object)qpRpt.getEndPeriod());
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bd_period", (String)"id periodid,name periodname,number periodnumber", (QFilter[])new QFilter[]{filter, startPeriod, endPeriod}, null);
        HashMap<Long, DynamicObject> periods = new HashMap<Long, DynamicObject>(collection.size());
        for (DynamicObject dyn : collection) {
            periods.put(dyn.getLong("periodid"), dyn);
        }
        return periods;
    }

    private void setPeriodField(Map<String, Integer> fieldMap, Object[] data, String fieldName, Long period, Map<Long, DynamicObject> periods) {
        Integer idx = fieldMap.get(fieldName);
        if (idx != null) {
            DynamicObject dyn = periods.get(period);
            data[idx.intValue()] = dyn == null ? "" : dyn.get(fieldName);
        }
    }
}

