/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bd.util.AccountUtils;
import kd.fi.gl.report.subledger.IAccountLevelTransfer;

public class AccountLevelTransfer
implements IAccountLevelTransfer {
    private static final Log LOG = LogFactory.getLog(AccountLevelTransfer.class);
    private final Table<Long, Long, Long> org2Mid2LevelId = HashBasedTable.create();

    public AccountLevelTransfer(Long[] orgIDs, Long acctTableID, Long workPeriodID, int level, QFilter ... extF) {
        LOG.info("work on level " + level);
        DynamicObject periodDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)workPeriodID, (String)"bd_period", (String)"begindate,enddate");
        HashMap number2ID = new HashMap();
        Arrays.stream(orgIDs).forEach(orgID -> {
            ArrayList qFilters = Lists.newArrayList((Object[])extF);
            qFilters.add(new QFilter("accounttable", "=", (Object)acctTableID));
            qFilters.add(new QFilter("startdate", "<=", (Object)periodDyo.getDate("enddate")));
            qFilters.add(new QFilter("enddate", ">=", (Object)periodDyo.getDate("enddate")));
            AccountUtils.queryAccountDataSet((long)orgID, (long)acctTableID, (String)"id, masterid, longnumber, number, level", (List)qFilters, (String)"level asc").forEach(row -> {
                String num = row.getString("number");
                Long mid = row.getLong("masterid");
                Long id = row.getLong("id");
                Integer currentLevel = row.getInteger("level");
                if (currentLevel <= level) {
                    number2ID.put(num, id);
                    this.org2Mid2LevelId.put(orgID, (Object)mid, (Object)id);
                } else {
                    String numOnLevel = row.getString("longnumber").split("_")[level - 1];
                    if (number2ID.containsKey(numOnLevel)) {
                        id = (Long)number2ID.get(numOnLevel);
                    } else {
                        LOG.warn(String.format("wrong with org %s num %s id %s", orgID, num, id));
                    }
                    this.org2Mid2LevelId.put(orgID, (Object)mid, (Object)id);
                }
            });
        });
    }

    @Override
    public Long transfer(Long org, Long mid) {
        Long midOnLevel = (Long)this.org2Mid2LevelId.get((Object)org, (Object)mid);
        return midOnLevel == null ? mid : midOnLevel;
    }

    public Table<Long, Long, Long> getTransferTable() {
        return this.org2Mid2LevelId;
    }
}

