/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger;

import java.math.BigDecimal;
import kd.bos.algo.Row;
import kd.fi.gl.report.common.ICollector;
import kd.fi.gl.report.common.RptUtil;
import kd.fi.gl.report.subledger.SubLedgerBalFunction;
import kd.fi.gl.report.subledger.SubLedgerBalLogSelector;
import kd.fi.gl.report.subledger.SubLedgerCollector;
import kd.fi.gl.report.subledger.SubLedgerOutPutIndex;
import kd.fi.gl.report.subledger.SubLedgerReportQuery;
import kd.fi.gl.util.GLUtil;

public class SubLedgerBalLogFunction
extends SubLedgerBalFunction {
    protected SubLedgerBalLogSelector selector;
    private int fieldCount;
    private long startPeriod;

    public SubLedgerBalLogFunction(SubLedgerBalLogSelector selector) {
        this.selector = selector;
        SubLedgerReportQuery reportQuery = selector.getReportQuery();
        this.opIndex = (SubLedgerOutPutIndex)reportQuery.getOutPutIndex();
        this.fieldCount = reportQuery.getRowMeta().getFieldCount();
        this.startPeriod = reportQuery.getQueryParam().getStartPeriod();
    }

    @Override
    public void output(Row row, ICollector collector) {
        Object[] result = this.getData(row);
        ((SubLedgerCollector)collector).collectBeginData(result);
    }

    @Override
    protected Object[] getData(Row row) {
        SubLedgerBalLogSelector balSelector = this.selector;
        Object[] result = new Object[this.fieldCount];
        Long orgID = row.getLong(balSelector.getOrgIndex());
        result[this.opIndex.getOrgIndex()] = orgID;
        for (int i = 0; i < balSelector.qpRpt.getCommonAssists().size(); ++i) {
            result[this.opIndex.getComAssistIndex((int)i)] = row.get(balSelector.getComAssistIndex(i));
        }
        result[this.opIndex.getAccountIndex()] = this.selector.getReportQuery().getAcctMidOnLevel(orgID, row.getLong(balSelector.getAccountIndex()));
        if (this.opIndex.getCurrencyIndex() != -1) {
            result[this.opIndex.getCurrencyIndex()] = row.get(balSelector.getCurrencyIndex());
        }
        if (this.opIndex.getMeasureunitIndex() != -1) {
            result[this.opIndex.getMeasureunitIndex()] = row.get(balSelector.getMeasureunitIndex());
        }
        int[] opDebitIndexes = this.opIndex.getDebitIndexes();
        int[] opCreditIndexes = this.opIndex.getCreditIndexes();
        int[] opEndIndexes = this.opIndex.getEndIndexesArr();
        int[] debitIndexes = balSelector.getDebitIndexes();
        int[] creditIndexes = balSelector.getCreditIndexes();
        long ipStartPeriod = row.getLong(balSelector.getStartPeriodIndex());
        long yearFlag = this.startPeriod / GLUtil.YEAR_PERIOD_L * GLUtil.YEAR_PERIOD_L;
        String operation = row.getString(balSelector.getOperationIndex());
        BigDecimal flag = operation.equals("submit") || operation.equals("enable") ? new BigDecimal(1) : new BigDecimal(-1);
        for (int i = 0; i < opDebitIndexes.length; ++i) {
            BigDecimal debitVal = flag.multiply(row.getBigDecimal(debitIndexes[i]));
            BigDecimal creditVal = flag.multiply(row.getBigDecimal(creditIndexes[i]));
            if (ipStartPeriod >= this.startPeriod) continue;
            result[opEndIndexes[i]] = RptUtil.subtract(debitVal, creditVal);
            if (ipStartPeriod <= yearFlag) continue;
            result[opDebitIndexes[i]] = debitVal;
            result[opCreditIndexes[i]] = creditVal;
        }
        result[this.opIndex.getRowTypeIndex()] = "1";
        result[this.opIndex.getRowIndex()] = "1";
        result[this.opIndex.getPeriodIndex()] = 0L;
        result[this.opIndex.getBookDateStrIndex()] = "";
        return result;
    }
}

