/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger;

import java.util.ArrayList;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.report.subledger.SubLedgerBalLogFunction;
import kd.fi.gl.report.subledger.SubLedgerBalSelector;
import kd.fi.gl.report.subledger.SubLedgerReportQuery;
import kd.fi.gl.util.MulCurReportUtil;

public class SubLedgerBalLogSelector
extends SubLedgerBalSelector {
    private int operationIndex;

    public SubLedgerBalLogSelector(SubLedgerReportQuery reportQuery) {
        this.reportQuery = reportQuery;
        this.qpRpt = reportQuery.getQueryParam();
        this.qFilters = this.initQFilters();
        this.outPutFunction = new SubLedgerBalLogFunction(this);
        this.initSelField();
    }

    protected int getOperationIndex() {
        return this.operationIndex;
    }

    @Override
    public DataSet getDataSet(QFilter[] filter) {
        return QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".balance_log"), (String)"gl_balance_log", (String)this.selField, (QFilter[])(filter == null ? this.qFilters : filter), null);
    }

    private void initSelField() {
        this.selField = this.initSel();
        this.initIndexes();
    }

    @Override
    protected final String initSel() {
        ArrayList<String> sel = new ArrayList<String>(16);
        sel.add("account");
        if (this.qpRpt.isShowRpt() || this.qpRpt.isShowOrg()) {
            sel.add("org");
        }
        this.qpRpt.getCommonAssists().forEach(commonAssist -> sel.add(commonAssist.key));
        if (this.qpRpt.isQueryCurrency()) {
            sel.add("currency");
        }
        if (this.qpRpt.isShowAssist()) {
            sel.add("assgrp");
        }
        if (this.qpRpt.isShowQty()) {
            sel.add("measureunit");
        }
        sel.add("operation");
        sel.add("0 beginlocal");
        sel.add("0 endlocal");
        MulCurReportUtil.addBalanceLogAmountFields2(sel, (String)this.qpRpt.getLocaleCurType());
        sel.add("0 yeardebitlocal");
        sel.add("0 yearcreditlocal");
        if (this.qpRpt.isQueryCurrency()) {
            sel.add("0 beginfor");
            sel.add("0 endfor");
            sel.add("debitfor");
            sel.add("creditfor");
            sel.add("0 yeardebitfor");
            sel.add("0 yearcreditfor");
        }
        if (this.qpRpt.isShowQty()) {
            sel.add("0 beginqty");
            sel.add("0 endqty");
            sel.add("debitqty");
            sel.add("creditqty");
            sel.add("0 yeardebitqty");
            sel.add("0 yearcreditqty");
        }
        sel.add("period");
        this.queryField = sel.stream().map(x -> x.contains(" ") ? x.split(" ")[1] : x).collect(Collectors.toList());
        return ((Object)sel).toString().replace("[", "").replace("]", "");
    }

    @Override
    protected void initIndexes() {
        if (this.qpRpt.isShowRpt() || this.qpRpt.isShowOrg()) {
            this.orgIndex = this.queryField.indexOf("org");
        }
        this.comAssistIndexer = this.qpRpt.getCommonAssists().stream().map(comAssist -> this.queryField.indexOf(comAssist.key)).collect(Collectors.toList());
        this.accountIndex = this.queryField.indexOf("account");
        this.currencyIndex = this.queryField.indexOf("currency");
        if (this.qpRpt.isShowAssist()) {
            this.assgrpIndex = this.queryField.indexOf("assgrp");
        }
        this.operationIndex = this.queryField.indexOf("operation");
        this.measureunitIndex = this.queryField.indexOf("measureunit");
        this.startPeriodIndex = this.queryField.indexOf("period");
        this.debitIndexes = this.setIndexes("debit");
        this.creditIndexes = this.setIndexes("credit");
    }

    @Override
    protected final QFilter[] initQFilters() {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("org", "in", (Object)this.qpRpt.getAllEntityOrgs()));
        list.addAll(this.qpRpt.getComAssistFiltersForBill(key -> key));
        list.add(new QFilter("booktype", "=", (Object)this.qpRpt.getBookType()));
        list.add(new QFilter("accounttable", "=", (Object)this.qpRpt.getAccountTable()));
        list.add(new QFilter("calculated", "=", (Object)Character.valueOf('0')));
        list.add(new QFilter("period", "<=", (Object)this.qpRpt.getStartPeriod()));
        list.add(new QFilter("account", "in", this.reportQuery.getAllQueryMids()));
        if (!this.qpRpt.isSynCurrency() && !this.qpRpt.isAllCurrency()) {
            list.add(new QFilter("currency", "=", (Object)this.qpRpt.getCurrency()));
        }
        return list.toArray(new QFilter[0]);
    }
}

