/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashBasedTable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.gl.dataset.GroupKey;
import kd.fi.gl.dataset.TreeNode;
import kd.fi.gl.report.CurType;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.common.ICollector;
import kd.fi.gl.report.common.IReportQuery;
import kd.fi.gl.report.common.ISelector;
import kd.fi.gl.report.common.OutPutFunction;
import kd.fi.gl.report.common.RptUtil;
import kd.fi.gl.report.subledger.OpAccountUtil;
import kd.fi.gl.report.subledger.SubLedgerOutPutIndex;
import kd.fi.gl.report.subledger.SubLedgerPLVouSelector;
import kd.fi.gl.report.subledger.SubLedgerReportQuery;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.MulCurReportUtil;
import kd.fi.gl.vo.RateBean;

public class SubLedgerCollector
implements ICollector {
    private static final Log logger = LogFactory.getLog(SubLedgerCollector.class);
    private List<Object[]> leafDataList;
    private SubLedgerReportQuery reportQuery;
    private SubLedgerOutPutIndex opIndex;
    private List<ISelector> selectors;
    private QueryParamRpt qpRpt;
    private Map<GroupKey, TreeNode> periodTreeMap;
    private DateFormat dFormat;
    private static final String DATE_STR = "z";
    private int voucherLimit = BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"fi.gl.report.subledger.voucherlimit", (int)101000);
    private int voucherCurIndex = 0;
    private Map<Long, VoucherEntity> vouMap = new HashMap<Long, VoucherEntity>();
    private final List<Object[]> curOpAccountBatch = new ArrayList<Object[]>(1000);

    public SubLedgerCollector(IReportQuery reportQuery) {
        this.reportQuery = (SubLedgerReportQuery)reportQuery;
        this.selectors = new ArrayList<ISelector>();
        this.leafDataList = new ArrayList<Object[]>();
        this.opIndex = this.reportQuery.getOutPutIndex();
        this.qpRpt = this.reportQuery.getQueryParam();
        this.dFormat = new SimpleDateFormat("yyyy-MM-dd");
    }

    @Override
    public void collect(Object[] data) {
        int searchType = this.qpRpt.getSearchType();
        boolean needSumDaily = true;
        if (searchType == 2) {
            Date bookedate = (Date)data[this.opIndex.getBookDateIndex()];
            try {
                bookedate = this.dFormat.parse(this.dFormat.format(bookedate));
            }
            catch (ParseException e) {
                data[this.opIndex.getBookDateIndex()] = null;
            }
            Date startDate = this.qpRpt.getStartDate();
            Date endDate = this.qpRpt.getEndDate();
            if (bookedate.before(startDate)) {
                int[] creIndex;
                int[] debIndex;
                Object[] beginData = this.copyData(data);
                for (int i : debIndex = this.opIndex.getDebitIndexes()) {
                    beginData[i] = new BigDecimal(0);
                }
                for (int i : creIndex = this.opIndex.getCreditIndexes()) {
                    beginData[i] = new BigDecimal(0);
                }
                beginData[this.opIndex.getPeriodIndex()] = 0L;
                beginData[this.opIndex.getRowTypeIndex()] = "1";
                beginData[this.opIndex.getRowIndex()] = "1";
                beginData[this.opIndex.getBookDateStrIndex()] = "";
                this.reportQuery.getBeginPeriodSchema().outPutData(beginData);
                needSumDaily = false;
            } else if (bookedate.after(endDate)) {
                return;
            }
        }
        boolean isSumYear = true;
        if (needSumDaily) {
            ++this.voucherCurIndex;
        }
        if (this.voucherCurIndex <= this.voucherLimit && needSumDaily) {
            if (this.qpRpt.isShowOpAccount()) {
                this.handleOpAccount(data);
            } else {
                this.leafDataList.add(data);
            }
        }
        if (this.qpRpt.isShowDailySum() && needSumDaily) {
            Object[] dailyData = this.copyData(data);
            dailyData[this.opIndex.getRowTypeIndex()] = "3";
            dailyData[this.opIndex.getRowIndex()] = "2";
            String dateStr = (String)dailyData[this.opIndex.getBookDateStrIndex()];
            try {
                Date parse = this.dFormat.parse(dateStr);
                dailyData[this.opIndex.getBookDateIndex()] = parse;
            }
            catch (ParseException e) {
                dailyData[this.opIndex.getBookDateIndex()] = null;
            }
            this.reportQuery.getDailySchema().outPutData(dailyData);
        }
        this.outPutPeriodData(data, (Long)data[this.opIndex.getPeriodIndex()], needSumDaily);
        this.outPutYearData(data, (Long)data[this.opIndex.getPeriodIndex()], needSumDaily, isSumYear);
    }

    private void handleOpAccount(Object[] data) {
        long vouId = (Long)data[this.opIndex.getVouIdIndex()];
        if (this.vouMap.size() <= 1000 || this.vouMap.containsKey(vouId)) {
            this.collectEntry(data);
        } else {
            this._handleOpAccount(this.vouMap, this.curOpAccountBatch);
            this.vouMap.clear();
            this.curOpAccountBatch.clear();
            this.collectEntry(data);
        }
    }

    private void collectEntry(Object[] data) {
        long vouId = (Long)data[this.opIndex.getVouIdIndex()];
        long accId = (Long)data[this.opIndex.getAccountIndex()];
        int seq = (Integer)data[this.opIndex.getAccountSeqIndex()];
        this.vouMap.computeIfAbsent(vouId, k -> new VoucherEntity(vouId)).add(seq, accId, data);
        this.curOpAccountBatch.add(data);
    }

    private void _handleOpAccount(Map<Long, VoucherEntity> vouMap, List<Object[]> curOpAccountBatch) {
        HashMap<Long, VoucherEntity> vouAllMap = new HashMap<Long, VoucherEntity>();
        Set<Long> vouIds = vouMap.keySet();
        if (OpAccountUtil.checkIsLargeVoucher(new ArrayList<Long>(vouIds))) {
            this.leafDataList.addAll(curOpAccountBatch);
            return;
        }
        QFilter[] filter = new QFilter[]{new QFilter("id", "in", vouIds)};
        HashBasedTable accountIDTable = HashBasedTable.create();
        try (DataSet vouSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_voucher", (String)MulCurReportUtil.replaceVchLocalAmountFields((String)"id,entries.account.masterid,entries.seq,entries.assgrp,entries.entrydc,entries.debitlocal,entries.creditlocal,entries.account, org", (String)this.qpRpt.getLocaleCurType()), (QFilter[])filter, null);){
            for (Row row : vouSet) {
                Long vouId = row.getLong(0);
                Long accMid = this.reportQuery.getAccountLevelTransfer().transfer(row.getLong(8), row.getLong(1));
                Integer seq = row.getInteger(2);
                Long assgrpId = row.getLong(3);
                String dc = row.getString(4);
                BigDecimal value = row.getBigDecimal(5).subtract(row.getBigDecimal(6));
                Long accountID = row.getLong(7);
                accountIDTable.put((Object)vouId, (Object)seq, (Object)accountID);
                vouAllMap.computeIfAbsent(vouId, k -> new VoucherEntity(vouId)).add(seq, accMid, assgrpId, dc, value);
            }
        }
        for (Map.Entry<Long, VoucherEntity> mapEntry : vouMap.entrySet()) {
            VoucherEntity voucherEntityAll = (VoucherEntity)vouAllMap.get(mapEntry.getKey());
            for (VoucherEntry entry : mapEntry.getValue().entryList) {
                BigDecimal[] sum = new BigDecimal[this.opIndex.getDebitIndexes().length];
                for (int i = 0; i < sum.length; ++i) {
                    sum[i] = BigDecimal.ZERO;
                }
                Object[] data = entry.data;
                List<VoucherEntry> opList = voucherEntityAll.getOpAccountList(entry);
                for (int jj = 0; jj < opList.size(); ++jj) {
                    VoucherEntry opEntry = opList.get(jj);
                    Object[] copy = this.copyData(data);
                    copy[this.opIndex.getAccountSeqIndex()] = opEntry.seq;
                    copy[this.opIndex.getOpAccountIndex()] = accountIDTable.get((Object)opEntry.getVid(), (Object)opEntry.seq);
                    copy[this.opIndex.getOpAssgrpIndex()] = opEntry.assgrpId;
                    int[] opIndexDebitIndexes = this.opIndex.getDebitIndexes();
                    int[] opIndexCreditIndexes = this.opIndex.getCreditIndexes();
                    if (opIndexDebitIndexes.length >= 2) {
                        this.copyValueByRate(jj == opList.size() - 1, sum, opEntry.opDebitLocal, copy, opIndexDebitIndexes);
                        this.copyValueByRate(jj == opList.size() - 1, sum, opEntry.opCreditLocal, copy, opIndexCreditIndexes);
                    }
                    copy[opIndexDebitIndexes[0]] = opEntry.opDebitLocal;
                    copy[opIndexCreditIndexes[0]] = opEntry.opCreditLocal;
                    int[] opEndIndexes = this.opIndex.getEndIndexesArr();
                    for (int i = 0; i < opEndIndexes.length; ++i) {
                        copy[opEndIndexes[i]] = RptUtil.subtract(copy[opIndexDebitIndexes[i]], copy[opIndexCreditIndexes[i]]);
                    }
                    this.leafDataList.add(copy);
                }
            }
        }
    }

    private void copyValueByRate(boolean isLast, BigDecimal[] sum, BigDecimal opLocal, Object[] copy, int[] opIndexDebitIndexes) {
        BigDecimal local = (BigDecimal)copy[opIndexDebitIndexes[0]];
        BigDecimal rate = local.compareTo(BigDecimal.ZERO) == 0 ? null : opLocal.divide(local, 2);
        for (int i = 1; i < opIndexDebitIndexes.length; ++i) {
            if (isLast) {
                copy[opIndexDebitIndexes[i]] = rate == null ? BigDecimal.ZERO : ((BigDecimal)copy[opIndexDebitIndexes[i]]).subtract(sum[i]);
                continue;
            }
            copy[opIndexDebitIndexes[i]] = rate == null ? BigDecimal.ZERO : ((BigDecimal)copy[opIndexDebitIndexes[i]]).multiply(rate);
            sum[i] = sum[i].add((BigDecimal)copy[opIndexDebitIndexes[i]]);
        }
    }

    private void outPutPeriodData(Object[] data, long period, boolean needSumDaily) {
        GroupKey groupKey = this.getPeriodGroupKey(period, data);
        TreeNode node = this.periodTreeMap.get(groupKey);
        if (node != null) {
            long ipPeriod;
            Object[] copy = this.copyData(data);
            copy[this.opIndex.getPeriodIndex()] = period;
            copy[this.opIndex.getRowTypeIndex()] = "4";
            copy[this.opIndex.getRowIndex()] = "4";
            copy[this.opIndex.getBookDateStrIndex()] = DATE_STR;
            if (!needSumDaily) {
                int[] creIndex;
                int[] debIndex;
                for (int i : debIndex = this.opIndex.getDebitIndexes()) {
                    copy[i] = new BigDecimal(0);
                }
                for (int i : creIndex = this.opIndex.getCreditIndexes()) {
                    copy[i] = new BigDecimal(0);
                }
            }
            if ((ipPeriod = ((Long)data[this.opIndex.getPeriodIndex()]).longValue()) != period) {
                this.clearPeriodValue(copy);
            }
            this.reportQuery.getPeriodSchema().outPutData(copy);
            copy[this.reportQuery.getOutPutIndex().getCountIndex()] = 0;
            this.outPutPeriodData(copy, node.getParentId(), needSumDaily);
        }
    }

    private void outPutYearData(Object[] data, long period, boolean needSumDaily, boolean isSumYear) {
        GroupKey groupKey = this.getPeriodGroupKey(period, data);
        TreeNode node = this.periodTreeMap.get(groupKey);
        if (node != null) {
            long ipPeriod;
            Object[] copy = this.copyData(data);
            copy[this.opIndex.getPeriodIndex()] = period;
            copy[this.opIndex.getRowTypeIndex()] = "5";
            copy[this.opIndex.getRowIndex()] = "5";
            copy[this.opIndex.getBookDateStrIndex()] = DATE_STR;
            if (!needSumDaily || !isSumYear) {
                int[] creIndex;
                int[] debIndex;
                for (int i : debIndex = this.opIndex.getDebitIndexes()) {
                    copy[i] = new BigDecimal(0);
                }
                for (int i : creIndex = this.opIndex.getCreditIndexes()) {
                    copy[i] = new BigDecimal(0);
                }
            }
            if ((ipPeriod = ((Long)data[this.opIndex.getPeriodIndex()]).longValue()) / GLUtil.YEAR_PERIOD_L != period / GLUtil.YEAR_PERIOD_L) {
                this.clearPeriodValue(copy);
            }
            this.reportQuery.getYearSchema().outPutData(copy);
            copy[this.reportQuery.getOutPutIndex().getCountIndex()] = 0;
            this.outPutYearData(data, node.getParentId(), needSumDaily, isSumYear);
        }
    }

    private void clearPeriodValue(Object[] copy) {
        int[] creditIndexes;
        int[] opIndexDebitIndexes;
        for (int opIndexDebitIndex : opIndexDebitIndexes = this.opIndex.getDebitIndexes()) {
            copy[opIndexDebitIndex] = BigDecimal.ZERO;
        }
        for (int creditIndex : creditIndexes = this.opIndex.getCreditIndexes()) {
            copy[creditIndex] = BigDecimal.ZERO;
        }
    }

    private Object[] copyData(Object[] data) {
        Object[] result = new Object[data.length];
        System.arraycopy(data, 0, result, 0, data.length);
        return result;
    }

    @Override
    public void addSelector(ISelector selector) {
        this.selectors.add(selector);
    }

    @Override
    public DataSet finish() {
        this.startQuery();
        if (this.qpRpt.isShowOpAccount()) {
            this._handleOpAccount(this.vouMap, this.curOpAccountBatch);
            this.vouMap.clear();
            this.curOpAccountBatch.clear();
        }
        return this.createDataSet();
    }

    private DataSet createDataSet() {
        long tick = System.currentTimeMillis();
        Collection<Object[]> beginDataList = this.reportQuery.getBeginPeriodSchema().getData().values();
        Collection<Object[]> periodList = this.reportQuery.getPeriodSchema().getData().values();
        Collection<Object[]> yearList = this.reportQuery.getYearSchema().getData().values();
        logger.info("report_query begin query : beginDataList size:" + beginDataList.size());
        this.leafDataList.addAll(beginDataList);
        if (this.qpRpt.isShowDailySum()) {
            this.leafDataList.addAll(this.reportQuery.getDailySchema().getData().values());
        }
        String dc = this.reportQuery.getSelObj() == null ? "0" : this.reportQuery.getSelObj().getString("dc");
        this.leafDataList.addAll(periodList);
        this.leafDataList.addAll(yearList);
        List<String> orderIndexes = this.opIndex.getOrderIndexes();
        boolean isExportAll = this.qpRpt.isExportAll();
        logger.info("report_query \u660e\u7ec6\u5206\u7c7b\u8d26\u79d1\u76ee\u9884\u67e5\u96c6\u5408reportQuery.getMasterIdMap()\uff1a" + this.reportQuery.getMasterIdMap().toString());
        logger.info("report_query leafDataList size: " + this.leafDataList.size() + ", cost\uff1a" + (System.currentTimeMillis() - tick));
        long sortTick = System.currentTimeMillis();
        HashSet acctSet = new HashSet();
        int accountIndex = this.opIndex.getAccountIndex();
        LoadingCache acctNumCache = CacheBuilder.newBuilder().build(CacheLoader.from(mid -> Optional.ofNullable(BusinessDataServiceHelper.loadSingleFromCache((Object)mid, (String)"bd_accountview", (String)"number")).map(dyo -> dyo.getString("number")).orElse("")));
        this.leafDataList.sort((a, b) -> {
            for (String idx : orderIndexes) {
                String[] str = idx.split("\\|");
                String sort = str[1];
                int index = Integer.parseInt(str[0]);
                Object obj1 = a[index];
                Object obj2 = b[index];
                int compare = 0;
                if (isExportAll && index == accountIndex) {
                    long mid1 = (Long)obj1;
                    long mid2 = (Long)obj2;
                    acctSet.add(mid1);
                    acctSet.add(mid2);
                    String accNum1 = (String)acctNumCache.getUnchecked((Object)mid1);
                    String accNum2 = (String)acctNumCache.getUnchecked((Object)mid2);
                    compare = accNum1.compareTo(accNum2);
                } else if (obj1 == null && obj2 == null) {
                    compare = 0;
                } else if (obj1 == null) {
                    compare = 1;
                } else if (obj2 == null) {
                    compare = -1;
                } else if (obj1 instanceof Long) {
                    compare = Long.compare((Long)obj1, (Long)obj2);
                } else if (obj1 instanceof Integer) {
                    compare = Integer.compare((Integer)obj1, (Integer)obj2);
                } else if (obj1 instanceof String) {
                    compare = ((String)obj1).compareTo((String)obj2);
                } else if (obj1 instanceof Date) {
                    compare = ((Date)obj1).compareTo((Date)obj2);
                } else if (obj1 instanceof Timestamp) {
                    compare = ((Timestamp)obj1).compareTo((Timestamp)obj2);
                } else {
                    compare = 0;
                    logger.info("undeal type :index-> " + index + ", obj1->" + obj1.getClass() + ",obj2->" + obj2.getClass());
                }
                if (compare == 0) continue;
                if ("1".equals(sort)) {
                    return compare;
                }
                if ("-1".equals(sort)) {
                    return -compare;
                }
                if (!"dc".equals(sort)) continue;
                if ("1".equals(dc)) {
                    return -compare;
                }
                return compare;
            }
            return 0;
        });
        logger.info("\u660e\u7ec6\u5206\u7c7b\u8d26\u79d1\u76eeMasterId\u96c6\u5408\uff1a" + ((Object)acctSet).toString());
        logger.info("report_query sort leafDataList, cost\uff1a" + (System.currentTimeMillis() - sortTick));
        int[] endIndexes = this.opIndex.getEndIndexesArr();
        HashMap<GroupKey, BigDecimal[]> sumMap = new HashMap<GroupKey, BigDecimal[]>(64);
        for (Object[] obj : beginDataList) {
            sumMap.put(this.getGroupKey(obj), this.getEndValues(obj));
        }
        long loopTick = System.currentTimeMillis();
        for (int i = 0; i < this.leafDataList.size(); ++i) {
            Object[] data = this.leafDataList.get(i);
            String rowType = (String)data[this.opIndex.getRowTypeIndex()];
            if ("2".equals(rowType)) {
                if (sumMap.isEmpty()) continue;
                GroupKey groupKey = this.getGroupKey(data);
                BigDecimal[] endValues = this.getEndValues(data);
                Object[] oldEndValues = (Object[])sumMap.get(groupKey);
                if (Objects.nonNull(oldEndValues)) {
                    for (int j = 0; j < endIndexes.length; ++j) {
                        oldEndValues[j] = RptUtil.sum(endValues[j], oldEndValues[j]);
                        data[endIndexes[j]] = oldEndValues[j];
                    }
                }
            } else if ("3".equals(rowType)) {
                for (int endIndex : endIndexes) {
                    Object[] preData = this.leafDataList.get(i - 1);
                    data[endIndex] = preData[endIndex];
                }
            }
            if (!this.qpRpt.isShowRpt()) continue;
            Map<Integer, Integer> map = this.opIndex.getRptLocalIndexMap();
            Collection values = this.qpRpt.getOrgRateMap().values();
            if (!values.iterator().hasNext()) continue;
            RateBean value = (RateBean)values.iterator().next();
            for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
                BigDecimal localValue = (BigDecimal)data[entry.getValue()];
                if (localValue == null || value == null) {
                    data[entry.getKey().intValue()] = BigDecimal.ZERO;
                    continue;
                }
                data[entry.getKey().intValue()] = value.isDirect() ? localValue.multiply(value.getRateVal()) : localValue.divide(value.getRateVal(), value.getPrecision(), RoundingMode.HALF_UP);
            }
        }
        logger.info("report_query loop leaf data list cost:" + (System.currentTimeMillis() - loopTick) + ", size:" + this.leafDataList.size());
        RowMeta rowMeta = this.reportQuery.getRowMeta();
        logger.info("report_query build result dataset with size: " + this.leafDataList.size());
        DataSet finish = Algo.create((String)this.getClass().getName()).createDataSet(this.leafDataList.iterator(), rowMeta);
        int curIndex = rowMeta.getFieldIndex("currency", false);
        if (curIndex == -1) {
            if (this.qpRpt.getCurType() == CurType.BASE) {
                this.qpRpt.setCurrency(this.qpRpt.getCurLocal());
            }
            finish = this.qpRpt.addCurOri(finish);
        }
        finish = this.qpRpt.addCurLocal("org", finish);
        if (this.qpRpt.isShowRpt()) {
            finish = finish.addField("" + this.qpRpt.getCurRpt(), "currencyrptid");
        }
        return finish;
    }

    private BigDecimal[] getEndValues(Object[] obj) {
        int[] endIndexes = this.opIndex.getEndIndexesArr();
        BigDecimal[] result = new BigDecimal[endIndexes.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (BigDecimal)obj[endIndexes[i]];
        }
        return result;
    }

    private void startQuery() {
        for (ISelector selector : this.selectors) {
            OutPutFunction outPutFunction = selector.getOutPutFunction();
            int cnt = 0;
            long tick = System.currentTimeMillis();
            DataSet dataSet = selector.getDataSet(null);
            Throwable throwable = null;
            try {
                for (Row row : dataSet) {
                    ++cnt;
                    outPutFunction.output(row, this);
                }
                logger.info("report_query_ISelector " + selector.getClass().getName() + " read rows count:" + cnt + ", cost:" + (System.currentTimeMillis() - tick));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataSet == null) continue;
                if (throwable != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dataSet.close();
            }
        }
    }

    public void initPlValue(SubLedgerPLVouSelector plVouSelector) {
        OutPutFunction outPutFunction = plVouSelector.getOutPutFunction();
        try (DataSet dataSet = plVouSelector.getDataSet(null);){
            for (Row row : dataSet) {
                outPutFunction.output(row, this);
            }
        }
    }

    public void collectPLVoucher(Object[] data) {
        long startPeriod = this.qpRpt.getStartPeriod();
        long endPeriod = this.qpRpt.getEndPeriod();
        List periodIds = GLUtil.getPeriodIds((Long)startPeriod, (Long)endPeriod);
        int index = 0;
        BigDecimal flag = new BigDecimal(-1);
        long dataYear = GLUtil.getYear((long)((Long)data[this.opIndex.getPeriodIndex()]));
        for (int i = index; i < periodIds.size(); ++i) {
            Long periodId = (Long)periodIds.get(i);
            long periodYear = GLUtil.getYear((long)periodId);
            int[] debIndexs = this.opIndex.getDebitIndexes();
            int[] creIndexs = this.opIndex.getCreditIndexes();
            int[] endIndexs = this.opIndex.getEndIndexesArr();
            Object[] yearData = this.copyData(data);
            if (periodYear == dataYear) {
                for (int debIndex : debIndexs) {
                    yearData[debIndex] = flag.multiply((BigDecimal)yearData[debIndex]);
                }
                for (int creIndex : creIndexs) {
                    yearData[creIndex] = flag.multiply((BigDecimal)yearData[creIndex]);
                }
            } else {
                for (int debIndex : debIndexs) {
                    yearData[debIndex] = BigDecimal.ZERO;
                }
                for (int creIndex : creIndexs) {
                    yearData[creIndex] = BigDecimal.ZERO;
                }
            }
            for (int endIndex : endIndexs) {
                yearData[endIndex] = flag.multiply((BigDecimal)yearData[endIndex]);
            }
            yearData[this.opIndex.getPeriodIndex()] = periodId;
            yearData[this.opIndex.getRowTypeIndex()] = "5";
            yearData[this.opIndex.getRowIndex()] = "5";
            yearData[this.opIndex.getBookDateStrIndex()] = DATE_STR;
            this.reportQuery.getYearSchema().outPutData(yearData);
            if (i == index) {
                Object[] beginData = this.copyData(data);
                for (int debIndex : debIndexs) {
                    beginData[debIndex] = new BigDecimal(0);
                }
                for (int creIndex : creIndexs) {
                    beginData[creIndex] = new BigDecimal(0);
                }
                for (int endIndex : endIndexs) {
                    beginData[endIndex] = flag.multiply((BigDecimal)beginData[endIndex]);
                }
                beginData[this.opIndex.getPeriodIndex()] = 0L;
                beginData[this.opIndex.getRowTypeIndex()] = "1";
                beginData[this.opIndex.getRowIndex()] = "1";
                beginData[this.opIndex.getBookDateStrIndex()] = "";
                this.reportQuery.getBeginPeriodSchema().outPutData(beginData);
            }
            Object[] periodData = this.copyData(data);
            for (int debIndex : debIndexs) {
                periodData[debIndex] = new BigDecimal(0);
            }
            for (int creIndex : creIndexs) {
                periodData[creIndex] = new BigDecimal(0);
            }
            for (int endIndex : endIndexs) {
                periodData[endIndex] = flag.multiply((BigDecimal)periodData[endIndex]);
            }
            periodData[this.opIndex.getPeriodIndex()] = periodId;
            periodData[this.opIndex.getRowTypeIndex()] = "4";
            periodData[this.opIndex.getRowIndex()] = "4";
            periodData[this.opIndex.getBookDateStrIndex()] = DATE_STR;
            this.reportQuery.getPeriodSchema().outPutData(periodData);
        }
    }

    public void collectBeginData(Object[] data) {
        this.reportQuery.getBeginPeriodSchema().outPutData(data);
    }

    public void initBeginValue(ISelector[] balSelectors) {
        for (ISelector iSelector : balSelectors) {
            OutPutFunction outPutFunction = iSelector.getOutPutFunction();
            int cnt = 0;
            try (DataSet dataSet = iSelector.getDataSet(null);){
                for (Row row : dataSet) {
                    outPutFunction.output(row, this);
                    if (++cnt % 10000 != 0) continue;
                    logger.info("report_query ISelector " + iSelector.getClass().getName() + " read rows count:" + cnt);
                }
            }
        }
        Collection<Object[]> beginDataList = this.reportQuery.getBeginPeriodSchema().getData().values();
        long startPeriod = this.qpRpt.getStartPeriod();
        long endPeriod = this.qpRpt.getEndPeriod();
        List periodIds = GLUtil.getPeriodIds((Long)startPeriod, (Long)endPeriod);
        this.periodTreeMap = new HashMap<GroupKey, TreeNode>();
        int[] opDebitIndexes = this.opIndex.getDebitIndexes();
        int length = opDebitIndexes.length;
        int[] opCreditIndexes = this.opIndex.getCreditIndexes();
        for (int i = 0; i < periodIds.size(); ++i) {
            Long periodId = (Long)periodIds.get(i);
            for (Object[] beginData : beginDataList) {
                Object[] yearValue = this.copyData(beginData);
                if (startPeriod / GLUtil.YEAR_PERIOD_L != periodId / GLUtil.YEAR_PERIOD_L) {
                    for (int j = 0; j < length; ++j) {
                        yearValue[opDebitIndexes[j]] = BigDecimal.ZERO;
                        yearValue[opCreditIndexes[j]] = BigDecimal.ZERO;
                    }
                }
                yearValue[this.opIndex.getPeriodIndex()] = periodId;
                yearValue[this.opIndex.getRowTypeIndex()] = "5";
                yearValue[this.opIndex.getRowIndex()] = "5";
                yearValue[this.opIndex.getBookDateStrIndex()] = DATE_STR;
                this.reportQuery.getYearSchema().outPutData(yearValue);
                Object[] periodData = this.copyData(beginData);
                periodData[this.opIndex.getPeriodIndex()] = periodId;
                periodData[this.opIndex.getRowTypeIndex()] = "4";
                periodData[this.opIndex.getRowIndex()] = "4";
                periodData[this.opIndex.getBookDateStrIndex()] = DATE_STR;
                for (int j = 0; j < length; ++j) {
                    periodData[opDebitIndexes[j]] = BigDecimal.ZERO;
                    periodData[opCreditIndexes[j]] = BigDecimal.ZERO;
                }
                this.reportQuery.getPeriodSchema().outPutData(periodData);
                GroupKey periodGroupKey = this.getPeriodGroupKey(periodId, beginData);
                TreeNode node = new TreeNode(periodId.longValue());
                if (i != periodIds.size() - 1) {
                    Long pid = (Long)periodIds.get(i + 1);
                    GroupKey periodGroupPKey = this.getPeriodGroupKey(periodId, beginData);
                    node.setPropValue("key", (Object)periodGroupPKey);
                    node.setParentId(pid.longValue());
                }
                this.periodTreeMap.put(periodGroupKey, node);
            }
        }
        for (TreeNode node : this.periodTreeMap.values()) {
            GroupKey key = (GroupKey)node.getPropValue("key");
            TreeNode pNode = this.periodTreeMap.get(key);
            node.setParent(pNode);
        }
        for (Object[] beginData : beginDataList) {
            for (int j = 0; j < opDebitIndexes.length; ++j) {
                beginData[opDebitIndexes[j]] = BigDecimal.ZERO;
                beginData[opCreditIndexes[j]] = BigDecimal.ZERO;
            }
        }
    }

    private GroupKey getPeriodGroupKey(long period, Object[] data) {
        int[] grpIndexes = this.opIndex.getGrpIndexes();
        Object[] grpKey = new Object[grpIndexes.length + 1];
        grpKey[0] = period;
        for (int j = 0; j < grpIndexes.length; ++j) {
            grpKey[j + 1] = data[grpIndexes[j]];
        }
        return new GroupKey(grpKey);
    }

    private GroupKey getGroupKey(Object[] data) {
        int[] grpIndexes = this.opIndex.getGrpIndexes();
        Object[] grpKey = new Object[grpIndexes.length];
        for (int j = 0; j < grpIndexes.length; ++j) {
            grpKey[j] = data[grpIndexes[j]];
        }
        return new GroupKey(grpKey);
    }

    public static class VoucherEntry {
        private long vid;
        private int seq;
        private long accountId;
        private long assgrpId;
        private String dc;
        private BigDecimal value;
        private int groupKey;
        private BigDecimal startValue;
        private BigDecimal endValue;
        private BigDecimal opDebitLocal;
        private BigDecimal opCreditLocal;
        private Object[] data;

        VoucherEntry(int seq, long accountId) {
            this.seq = seq;
            this.accountId = accountId;
        }

        VoucherEntry(int seq, long accountId, Object[] data) {
            this(seq, accountId);
            this.data = data;
        }

        public VoucherEntry(int seq, long accountId, long assgrpId, String dc, BigDecimal value) {
            this(seq, accountId);
            this.assgrpId = assgrpId;
            this.dc = dc;
            this.value = value;
        }

        public int getSeq() {
            return this.seq;
        }

        public String getDc() {
            return this.dc;
        }

        public BigDecimal getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof VoucherEntry) {
                VoucherEntry other = (VoucherEntry)obj;
                return this.seq == other.seq && this.accountId == other.accountId;
            }
            return false;
        }

        public int hashCode() {
            return Integer.hashCode(this.seq) + 31 * Long.hashCode(this.accountId);
        }

        public String toString() {
            return String.format("seq: %d; groupKey: %d; value: %f", this.seq, this.groupKey, this.value);
        }

        public long getAccountId() {
            return this.accountId;
        }

        public long getAssgrpId() {
            return this.assgrpId;
        }

        public BigDecimal getOpDebitLocal() {
            return this.opDebitLocal;
        }

        public long getVid() {
            return this.vid;
        }

        public void setVid(long vid) {
            this.vid = vid;
        }

        public BigDecimal getOpCreditLocal() {
            return this.opCreditLocal;
        }
    }

    public static class VoucherEntity {
        private long vouId;
        private List<VoucherEntry> entryList;
        private int groupSize;
        private boolean isGrouped;

        public VoucherEntity(long vouId) {
            this.vouId = vouId;
            this.entryList = new ArrayList<VoucherEntry>();
        }

        public void add(int seq, long accountId, long assgrpId, String dc, BigDecimal value) {
            VoucherEntry voucherEntry = new VoucherEntry(seq, accountId, assgrpId, dc, value);
            voucherEntry.setVid(this.vouId);
            this.entryList.add(voucherEntry);
        }

        public void add(VoucherEntry entry) {
            entry.setVid(this.vouId);
            this.entryList.add(entry);
        }

        public void add(int seq, long accountId, Object[] data) {
            VoucherEntry entry = new VoucherEntry(seq, accountId, data);
            entry.setVid(this.vouId);
            this.entryList.add(entry);
        }

        private void sort() {
            this.entryList.sort(Comparator.comparingInt(VoucherEntry::getSeq));
        }

        private void group() {
            if (!this.isGrouped) {
                this.sort();
                this.groupSize = 0;
                HashMap<BigDecimal, List> map = new HashMap<BigDecimal, List>();
                for (VoucherEntry entry : this.entryList) {
                    BigDecimal value = entry.getValue();
                    List entries = (List)map.get(value.negate());
                    if (entries != null && entries.size() > 0) {
                        ++this.groupSize;
                        VoucherEntry otherEntry = (VoucherEntry)entries.get(0);
                        entry.groupKey = this.groupSize;
                        otherEntry.groupKey = this.groupSize;
                        entries.remove(otherEntry);
                        continue;
                    }
                    map.computeIfAbsent(value, k -> new ArrayList()).add(entry);
                }
                List leftList = this.entryList.stream().filter(x -> ((VoucherEntry)x).groupKey == 0).collect(Collectors.toList());
                if (leftList.size() <= 1000) {
                    block1: for (int i = 0; i < leftList.size(); ++i) {
                        VoucherEntry a = (VoucherEntry)leftList.get(i);
                        if (a.groupKey != 0) continue;
                        HashMap<BigDecimal, List> triMap = new HashMap<BigDecimal, List>();
                        for (int j = i + 1; j < leftList.size(); ++j) {
                            VoucherEntry b = (VoucherEntry)leftList.get(j);
                            if (b.groupKey != 0) continue;
                            BigDecimal c = a.value.add(b.value);
                            List entries = (List)triMap.get(b.value.negate());
                            if (entries != null && entries.size() > 0) {
                                ++this.groupSize;
                                VoucherEntry otherEntry = (VoucherEntry)entries.get(0);
                                a.groupKey = this.groupSize;
                                b.groupKey = this.groupSize;
                                otherEntry.groupKey = this.groupSize;
                                entries.remove(otherEntry);
                                continue block1;
                            }
                            triMap.computeIfAbsent(c, k -> new ArrayList()).add(b);
                        }
                    }
                }
                this.isGrouped = true;
            }
        }

        public List<VoucherEntry> getOpAccountList(VoucherEntry sourceEntry) {
            this.sort();
            int entryIdx = this.entryList.indexOf(sourceEntry);
            VoucherEntry entry = this.entryList.get(entryIdx);
            int groupKey = entry.groupKey;
            ArrayList<VoucherEntry> opList = new ArrayList<VoucherEntry>();
            BigDecimal debitValue = BigDecimal.ZERO;
            BigDecimal creditValue = BigDecimal.ZERO;
            boolean accB = entry.value.compareTo(BigDecimal.ZERO) >= 0;
            for (VoucherEntry ve : this.entryList) {
                boolean veB;
                if (ve.groupKey != groupKey) continue;
                boolean bl = veB = ve.value.compareTo(BigDecimal.ZERO) >= 0;
                if (veB) {
                    ve.startValue = debitValue;
                    debitValue = debitValue.add(ve.value);
                    ve.endValue = debitValue;
                } else {
                    ve.startValue = creditValue;
                    creditValue = creditValue.add(ve.value.negate());
                    ve.endValue = creditValue;
                }
                if (accB == veB) continue;
                opList.add(ve);
            }
            ArrayList<VoucherEntry> result = new ArrayList<VoucherEntry>();
            int idx = this.getEntryByValue(opList, entry.startValue, 0, opList.size() - 1);
            if (idx == -1) {
                return result;
            }
            BigDecimal dcB = entry.value.compareTo(BigDecimal.ZERO) >= 0 ? new BigDecimal(entry.dc) : new BigDecimal(entry.dc).negate();
            BigDecimal total = entry.endValue.subtract(entry.startValue);
            for (int i = idx; i < opList.size(); ++i) {
                VoucherEntry ve = (VoucherEntry)opList.get(i);
                BigDecimal opValue = ve.endValue.subtract(ve.startValue);
                if (i == idx) {
                    opValue = ve.endValue.subtract(entry.startValue);
                }
                if (opValue.compareTo(total) >= 0) {
                    if ("1".equals(entry.dc)) {
                        ve.opDebitLocal = dcB.multiply(total);
                        ve.opCreditLocal = BigDecimal.ZERO;
                    } else {
                        ve.opCreditLocal = dcB.multiply(total);
                        ve.opDebitLocal = BigDecimal.ZERO;
                    }
                    result.add(ve);
                    break;
                }
                if ("1".equals(entry.dc)) {
                    ve.opDebitLocal = dcB.multiply(opValue);
                    ve.opCreditLocal = BigDecimal.ZERO;
                } else {
                    ve.opCreditLocal = dcB.multiply(opValue);
                    ve.opDebitLocal = BigDecimal.ZERO;
                }
                result.add(ve);
                total = total.subtract(opValue);
            }
            return result;
        }

        private int getEntryByValue(List<VoucherEntry> opList, BigDecimal value, int start, int end) {
            if (start <= end) {
                int idx = (start + end) / 2;
                VoucherEntry entry = opList.get(idx);
                int cpStart = value.compareTo(entry.startValue);
                if (cpStart >= 0 && value.compareTo(entry.endValue) < 0) {
                    return idx;
                }
                if (cpStart < 0) {
                    return this.getEntryByValue(opList, value, start, idx - 1);
                }
                return this.getEntryByValue(opList, value, idx + 1, end);
            }
            return -1;
        }

        public List<VoucherEntry> getSourceEntryList() {
            return this.entryList;
        }

        public String toString() {
            return String.format("vouId: %d, groupSize: %d", this.vouId, this.groupSize);
        }
    }
}

