/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger;

import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Row;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.entity.report.ReportQueryParam;
import kd.fi.bd.model.Context;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.gl.report.common.RptUtil;
import kd.fi.gl.report.subledger.SubLedgerQueryRpt;
import kd.fi.gl.report.subledger.SubLedgerReportQuery;
import kd.fi.gl.report.subsidiary.DetailQuery;
import kd.fi.gl.util.DataSetHelper;

public class SubLedgerDetailQuery
implements DetailQuery<Object> {
    private SubLedgerQueryRpt subLedgerQueryRpt;
    private int detailLimit;
    private int detailSize;

    @Override
    public DataSet query(ReportQueryParam queryParam, Object selectedObj, Context context) {
        this.subLedgerQueryRpt = new SubLedgerQueryRpt(queryParam, selectedObj);
        DataSet detailDS = this.subLedgerQueryRpt.query();
        SubLedgerReportQuery reportQuery = this.subLedgerQueryRpt.getReportQuery();
        this.detailLimit = reportQuery.voucherDisplayLimit;
        this.detailSize = reportQuery.getVchDataSetSize();
        boolean needRemoveTotalRow = this.detailSize > this.detailLimit && !reportQuery.getQueryParam().isExportAll() && BillParamUtil.getBooleanValue((String)"83bfebc8000017ac", (String)"fi.gl.report.subledger.enableasynctotalcal", (boolean)true);
        context.registerContext("totalRowRemoved", (Object)needRemoveTotalRow);
        if (needRemoveTotalRow) {
            Row curBeginRow = null;
            Row vchBeginRow = null;
            int i = 1;
            int lastVchRowIndex = -1;
            for (Row row : detailDS.copy()) {
                if ("1".equals(row.getString("rowtype")) || "4".equals(row.getString("rowtype"))) {
                    curBeginRow = row;
                }
                if ("2".equals(row.getString("rowtype"))) {
                    lastVchRowIndex = i;
                    vchBeginRow = curBeginRow;
                }
                ++i;
            }
            DataSet dsAfterLastVch = detailDS.copy().limit(lastVchRowIndex, Integer.MAX_VALUE);
            DataSetHelper.logDataSet((String)"dsAfterLastVch", (DataSet)dsAfterLastVch);
            Row yearRowAfterLastVch = dsAfterLastVch.copy().filter("rowtype = '5'").next();
            Row periodRowAfterLastVch = dsAfterLastVch.copy().filter("rowtype = '4'").next();
            assert (yearRowAfterLastVch != null);
            Object[] yearValues = ((AbstractRow)yearRowAfterLastVch).values();
            Object[] periodValues = ((AbstractRow)periodRowAfterLastVch).values();
            yearValues = this.sub(reportQuery.getOutPutIndex().getCreditIndexes(), yearValues, periodValues);
            yearValues = this.sub(reportQuery.getOutPutIndex().getDebitIndexes(), yearValues, periodValues);
            DataSetBuilder builder = Algo.create((String)(this.getClass().getSimpleName() + "#resultBuild")).createDataSetBuilder(detailDS.getRowMeta());
            builder.append(vchBeginRow);
            builder.append(yearValues);
            DataSet beginAndYearDS = builder.build();
            DataSetHelper.logDataSet((String)"beginAndYearCache", (DataSet)beginAndYearDS);
            context.registerContext("beginAndYearCacheID", (Object)beginAndYearDS.cache(CacheHint.getDefault()).getCacheId());
            detailDS = detailDS.limit(0, lastVchRowIndex);
        }
        return detailDS;
    }

    public Object[] sub(int[] absIndex, Object[] oldValue, Object[] newValue) {
        for (int index : absIndex) {
            oldValue[index] = RptUtil.subtract(oldValue[index], newValue[index]);
        }
        return oldValue;
    }

    @Override
    public int getDetailLimit() {
        return this.detailLimit;
    }

    @Override
    public int getDetailDsSize() {
        return this.detailSize;
    }

    protected SubLedgerQueryRpt getSubLedgerQueryRpt() {
        return this.subLedgerQueryRpt;
    }
}

