/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.gl.enums.SubLedgerSortFieldEnum;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.common.OutPutIndex;
import kd.fi.gl.report.subledger.SubLedgerReportQuery;

public class SubLedgerOutPutIndex
implements OutPutIndex {
    private int orgIndex;
    private List<Integer> comAssistIndexer;
    private int accountIndex;
    private int bookDateIndex;
    private int bookDateStrIndex;
    private int bizDateIndex;
    private int vouNoIndex;
    private int vouRateIndex;
    private int descIndex;
    private int rowTypeIndex;
    private int rowIndex;
    private int vouIdIndex;
    private int vouEntryIdIndex;
    private static final String VOUENTRY_ID = "fentryid";
    private int currencyIndex;
    private int assgrpIndex;
    private int measureunitIndex;
    private int opAccountIndex;
    private int opAssgrpIndex;
    private int accountSeqIndex;
    private int[] debitIndexes;
    private int[] creditIndexes;
    private int[] endIndexes;
    private int debitQtyIndex;
    private int creditQtyIndex;
    private int debitPriceIndex;
    private int creditPriceIndex;
    private int vtNoIndex;
    private int noIndex;
    private int entryDcIndex;
    private Map<Integer, Integer> rptLocalIndexMap;
    private int periodIndex;
    private int[] grpIndexes;
    private List<String> orderIndexes;
    private String types;
    private RowMeta rowMeta;
    private QueryParamRpt qpRpt;
    private List<Object> sort;
    private static final String SORTCOMBO = "sortcombo";
    private static final String FIELDCOMBO = "fieldcombo";
    private int nozeroIndex;
    private int countIndex;
    private int[] extSortFieldIndex;

    public SubLedgerOutPutIndex(SubLedgerReportQuery reportQuery) {
        this.qpRpt = reportQuery.getQueryParam();
        this.types = this.initTypes(this.qpRpt);
        this.rowMeta = reportQuery.getRowMeta();
        this.sort = reportQuery.getSortEntry();
        this.initIndexes();
        this.rptLocalIndexMap = new HashMap<Integer, Integer>();
        if (this.qpRpt.isShowRpt()) {
            String[] split;
            for (String s : split = "debit#,credit#,end#".split(",")) {
                int rptIndex = this.rowMeta.getFieldIndex(s.replace("#", "rpt"));
                int localIndex = this.rowMeta.getFieldIndex(s.replace("#", "local"));
                this.rptLocalIndexMap.put(rptIndex, localIndex);
            }
        }
    }

    private void initIndexes() {
        this.orgIndex = this.rowMeta.getFieldIndex("org");
        this.comAssistIndexer = this.qpRpt.getCommonAssists().stream().map(comAssist -> this.rowMeta.getFieldIndex(comAssist.key)).collect(Collectors.toList());
        this.accountIndex = this.rowMeta.getFieldIndex("account");
        this.bookDateIndex = this.rowMeta.getFieldIndex("bookeddate");
        this.bookDateStrIndex = this.rowMeta.getFieldIndex("bookeddatestr");
        this.bizDateIndex = this.rowMeta.getFieldIndex("bizdate");
        this.vouNoIndex = this.rowMeta.getFieldIndex("voucherno");
        this.vouRateIndex = this.rowMeta.getFieldIndex("localrate");
        this.descIndex = this.rowMeta.getFieldIndex("desc");
        this.rowTypeIndex = this.rowMeta.getFieldIndex("rowtype");
        this.rowIndex = this.rowMeta.getFieldIndex("rowindex");
        this.vouIdIndex = this.rowMeta.getFieldIndex("voucherid");
        this.vouEntryIdIndex = this.rowMeta.getFieldIndex(VOUENTRY_ID);
        this.noIndex = this.rowMeta.getFieldIndex("billno");
        this.vtNoIndex = this.rowMeta.getFieldIndex("vtnumber");
        this.currencyIndex = this.rowMeta.getFieldIndex("currency", false);
        this.assgrpIndex = this.rowMeta.getFieldIndex("assgrp", false);
        this.measureunitIndex = this.rowMeta.getFieldIndex("measureunit", false);
        this.accountSeqIndex = this.rowMeta.getFieldIndex("accountseq", false);
        this.opAccountIndex = this.rowMeta.getFieldIndex("opaccount", false);
        this.opAssgrpIndex = this.rowMeta.getFieldIndex("opassgrp", false);
        this.debitQtyIndex = this.rowMeta.getFieldIndex("debitqty", false);
        this.creditQtyIndex = this.rowMeta.getFieldIndex("creditqty", false);
        this.debitPriceIndex = this.rowMeta.getFieldIndex("debitprice", false);
        this.creditPriceIndex = this.rowMeta.getFieldIndex("creditprice", false);
        this.debitIndexes = this.setIndexes("debit");
        this.creditIndexes = this.setIndexes("credit");
        this.endIndexes = this.setIndexes("end");
        this.entryDcIndex = this.rowMeta.getFieldIndex("entrydc");
        this.periodIndex = this.rowMeta.getFieldIndex("period");
        ArrayList<Integer> grpList = new ArrayList<Integer>();
        grpList.add(this.orgIndex);
        if (this.qpRpt.isShowComAssistSum().booleanValue()) {
            for (int i = 0; i < this.qpRpt.getCommonAssistsForGroup().size(); ++i) {
                grpList.add(this.comAssistIndexer.get(i));
            }
        }
        if (this.qpRpt.isExportAll()) {
            grpList.add(this.accountIndex);
        }
        if (this.currencyIndex != -1) {
            grpList.add(this.currencyIndex);
        }
        if (this.qpRpt.isShowSumQty()) {
            grpList.add(this.measureunitIndex);
        }
        this.nozeroIndex = this.rowMeta.getFieldIndex("nozero", false);
        this.countIndex = this.rowMeta.getFieldIndex("count", false);
        this.grpIndexes = grpList.stream().mapToInt(x -> x).toArray();
        this.initOrderByIndex();
        this.initExtSortFieldIndex();
    }

    private void initExtSortFieldIndex() {
        ArrayList<Integer> indexs = new ArrayList<Integer>(10);
        if (this.sort != null && !this.sort.isEmpty()) {
            for (Object obj : this.sort) {
                DynamicObject sortRow = (DynamicObject)obj;
                String field = sortRow.getString(FIELDCOMBO);
                if (SubLedgerSortFieldEnum.isIn((String)field)) continue;
                if (field.startsWith("entries")) {
                    field = field.substring("entries.".length());
                }
                indexs.add(this.rowMeta.getFieldIndex(field));
            }
        }
        this.extSortFieldIndex = indexs.stream().mapToInt(x -> x).toArray();
    }

    private void initOrderByIndex() {
        this.orderIndexes = new ArrayList<String>(16);
        if (this.qpRpt.isShowOrg()) {
            this.orderIndexes.add(this.orgIndex + "|1");
        }
        List<String> allCommonAssists = this.qpRpt.getCommonAssists().stream().map(commonAssist -> commonAssist.key).collect(Collectors.toList());
        List commonAssistsForGroup = this.qpRpt.getCommonAssistsForGroup();
        for (int i = 0; i < commonAssistsForGroup.size(); ++i) {
            this.orderIndexes.add(this.comAssistIndexer.get(i) + "|1");
            allCommonAssists.remove(commonAssistsForGroup.get(i));
        }
        if (this.qpRpt.isExportAll()) {
            this.orderIndexes.add(this.accountIndex + "|1");
        }
        if (this.qpRpt.isShowSumQty()) {
            this.orderIndexes.add(this.measureunitIndex + "|1");
        }
        if (this.currencyIndex != -1) {
            this.orderIndexes.add(this.currencyIndex + "|1");
        }
        this.orderIndexes.add(this.periodIndex + "|1");
        allCommonAssists.forEach(key -> this.orderIndexes.add(this.comAssistIndexer.get(Integer.parseInt(key.replace("comassist", "")) - 1) + "|1"));
        if (this.sort == null || this.sort.isEmpty()) {
            this.orderIndexes.add(this.bookDateStrIndex + "|1");
            this.orderIndexes.add(this.rowTypeIndex + "|1");
            this.orderIndexes.add(this.vtNoIndex + "|1");
            this.orderIndexes.add(this.noIndex + "|1");
            this.orderIndexes.add(this.accountSeqIndex + "|1");
        } else {
            ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(this.rowMeta.getFieldNames()));
            for (Object obj : this.sort) {
                int sort;
                DynamicObject sortentry = (DynamicObject)obj;
                String field = sortentry.getString(FIELDCOMBO);
                String sortDesc = sortentry.getString(SORTCOMBO);
                int n = sort = sortDesc.equals("desc") ? -1 : 1;
                if (field.startsWith("entries")) {
                    field = field.substring("entries.".length());
                }
                if (SubLedgerSortFieldEnum.BILLNO.getNumber().equals(field)) {
                    if (!this.orderIndexes.contains(this.rowTypeIndex + "|1")) {
                        this.orderIndexes.add(this.rowTypeIndex + "|1");
                    }
                    this.orderIndexes.add(this.noIndex + "|" + sort);
                    this.orderIndexes.add(this.accountSeqIndex + "|1");
                    continue;
                }
                if (SubLedgerSortFieldEnum.BOOKDATE.getNumber().equals(field)) {
                    this.orderIndexes.add(this.rowIndex + "|1");
                    this.orderIndexes.add(this.bookDateStrIndex + "|" + sort);
                    this.orderIndexes.add(this.rowTypeIndex + "|1");
                    continue;
                }
                if (SubLedgerSortFieldEnum.BIZDATE.getNumber().equals(field)) {
                    if (!this.orderIndexes.contains(this.rowTypeIndex + "|1")) {
                        this.orderIndexes.add(this.rowTypeIndex + "|1");
                    }
                    this.orderIndexes.add(this.bizDateIndex + "|" + sort);
                    continue;
                }
                if (SubLedgerSortFieldEnum.TYPENUMBER.getNumber().equals(field)) {
                    if (!this.orderIndexes.contains(this.rowTypeIndex + "|1")) {
                        this.orderIndexes.add(this.rowTypeIndex + "|1");
                    }
                    this.orderIndexes.add(this.vtNoIndex + "|" + sort);
                    continue;
                }
                if (SubLedgerSortFieldEnum.DC.getNumber().equals(field)) {
                    if (!this.orderIndexes.contains(this.rowTypeIndex + "|1")) {
                        this.orderIndexes.add(this.rowTypeIndex + "|1");
                    }
                    this.orderIndexes.add(this.entryDcIndex + "|dc");
                    continue;
                }
                if (!fieldNames.contains(field)) continue;
                if (!this.orderIndexes.contains(this.rowTypeIndex + "|1")) {
                    this.orderIndexes.add(this.rowTypeIndex + "|1");
                }
                int fieldIndex = this.rowMeta.getFieldIndex(field);
                this.orderIndexes.add(fieldIndex + "|" + sort);
            }
        }
    }

    private String initTypes(QueryParamRpt qpRpt) {
        StringBuilder sb = new StringBuilder();
        sb.append("local");
        if (qpRpt.isQueryCurrency()) {
            sb.append(",for");
        }
        if (qpRpt.isShowSumQty()) {
            sb.append(",qty");
        }
        if (qpRpt.isShowQty() && qpRpt.isShowPrice()) {
            sb.append(",price");
        }
        return sb.toString();
    }

    private int[] setIndexes(String flag) {
        ArrayList<Integer> list = new ArrayList<Integer>(8);
        for (String field : this.merge(flag)) {
            list.add(this.rowMeta.getFieldIndex(field));
        }
        return list.stream().mapToInt(x -> x).toArray();
    }

    private String[] merge(String prefix) {
        ArrayList<String> list = new ArrayList<String>();
        for (String pre : prefix.split(",")) {
            for (String suf : this.types.split(",")) {
                list.add(pre + suf);
            }
        }
        return list.toArray(new String[0]);
    }

    public int getComAssistIndex(int num) {
        return this.comAssistIndexer.get(num);
    }

    @Override
    public int getOrgIndex() {
        return this.orgIndex;
    }

    @Override
    public int getAccountIndex() {
        return this.accountIndex;
    }

    public int getBookDateIndex() {
        return this.bookDateIndex;
    }

    public int getBizDateIndex() {
        return this.bizDateIndex;
    }

    public int getVouNoIndex() {
        return this.vouNoIndex;
    }

    public int getVouRateIndex() {
        return this.vouRateIndex;
    }

    public int getDescIndex() {
        return this.descIndex;
    }

    public int getRowTypeIndex() {
        return this.rowTypeIndex;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public int getVouIdIndex() {
        return this.vouIdIndex;
    }

    public int getVouEntryIdIndex() {
        return this.vouEntryIdIndex;
    }

    @Override
    public int getCurrencyIndex() {
        return this.currencyIndex;
    }

    @Override
    public int getAssgrpIndex() {
        return this.assgrpIndex;
    }

    @Override
    public int getMeasureunitIndex() {
        return this.measureunitIndex;
    }

    @Override
    public int[] getDebitIndexes() {
        return this.debitIndexes;
    }

    @Override
    public int[] getCreditIndexes() {
        return this.creditIndexes;
    }

    public int[] getEndIndexesArr() {
        return this.endIndexes;
    }

    public int getPeriodIndex() {
        return this.periodIndex;
    }

    public String getTypes() {
        return this.types;
    }

    public int[] getGrpIndexes() {
        return this.grpIndexes;
    }

    public int getBookDateStrIndex() {
        return this.bookDateStrIndex;
    }

    public Map<Integer, Integer> getRptLocalIndexMap() {
        return this.rptLocalIndexMap;
    }

    public int getAccountSeqIndex() {
        return this.accountSeqIndex;
    }

    public int getOpAccountIndex() {
        return this.opAccountIndex;
    }

    public int getOpAssgrpIndex() {
        return this.opAssgrpIndex;
    }

    public int getDebitQtyIndex() {
        return this.debitQtyIndex;
    }

    public int getCreditQtyIndex() {
        return this.creditQtyIndex;
    }

    public int getDebitPriceIndex() {
        return this.debitPriceIndex;
    }

    public int getCreditPriceIndex() {
        return this.creditPriceIndex;
    }

    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    public void setGrpIndexes(int[] grpIndexes) {
        this.grpIndexes = grpIndexes;
    }

    public int getVtNoIndex() {
        return this.vtNoIndex;
    }

    public int getNoIndex() {
        return this.noIndex;
    }

    public List<String> getOrderIndexes() {
        return this.orderIndexes;
    }

    public void setOrderIndexes(List<String> orderIndexes) {
        this.orderIndexes = orderIndexes;
    }

    public int getEntryDcIndex() {
        return this.entryDcIndex;
    }

    public int getNozeroIndex() {
        return this.nozeroIndex;
    }

    public int getCountIndex() {
        return this.countIndex;
    }

    public int[] getExtSortFieldIndex() {
        return this.extSortFieldIndex;
    }

    public void setExtSortFieldIndex(int[] extSortFieldIndex) {
        this.extSortFieldIndex = extSortFieldIndex;
    }
}

