/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.common.ICollector;
import kd.fi.gl.report.common.OutPutFunction;
import kd.fi.gl.report.common.RptUtil;
import kd.fi.gl.report.subledger.SubLedgerCollector;
import kd.fi.gl.report.subledger.SubLedgerOutPutIndex;
import kd.fi.gl.report.subledger.SubLedgerPLVouSelector;
import kd.fi.gl.report.subledger.SubLedgerReportQuery;

public class SubLedgerPLVouFunction
implements OutPutFunction {
    protected SubLedgerPLVouSelector selector;
    protected SubLedgerOutPutIndex opIndex;
    private int fieldCount;
    private DateFormat dFormat;
    private QueryParamRpt qpRpt;
    private final SubLedgerReportQuery reportQuery;

    public SubLedgerPLVouFunction(SubLedgerPLVouSelector selector) {
        this.selector = selector;
        this.reportQuery = selector.getReportQuery();
        this.qpRpt = this.reportQuery.getQueryParam();
        this.fieldCount = this.reportQuery.getRowMeta().getFieldCount();
        this.opIndex = this.reportQuery.getOutPutIndex();
        this.dFormat = new SimpleDateFormat("yyyy-MM-dd");
    }

    @Override
    public void output(Row row, ICollector collector) {
        Object[] result = this.getData(row);
        ((SubLedgerCollector)collector).collectPLVoucher(result);
    }

    protected Object[] getData(Row row) {
        Object[] result = new Object[this.fieldCount];
        Long orgID = row.getLong(this.selector.getOrgIndex());
        result[this.opIndex.getOrgIndex()] = orgID;
        for (int i = 0; i < this.qpRpt.getCommonAssists().size(); ++i) {
            result[this.opIndex.getComAssistIndex((int)i)] = row.get(this.selector.getComAssistIndex(i));
        }
        result[this.opIndex.getPeriodIndex()] = row.get(this.selector.getPeriodIndex());
        result[this.opIndex.getAccountIndex()] = this.reportQuery.getAcctMidOnLevel(orgID, row.getLong(this.selector.getAccountIndex()));
        result[this.opIndex.getBookDateIndex()] = row.get(this.selector.getBookDateIndex());
        result[this.opIndex.getBookDateStrIndex()] = this.dFormat.format(row.get(this.selector.getBookDateIndex()));
        result[this.opIndex.getBizDateIndex()] = row.get(this.selector.getBizDateIndex());
        result[this.opIndex.getVtNoIndex()] = ((DynamicObject)this.reportQuery.getVchTypeCache().getUnchecked((Object)row.getLong(this.selector.getVouTypeIndex()))).getString("number");
        String vtName = ((DynamicObject)this.reportQuery.getVchTypeCache().getUnchecked((Object)row.getLong(this.selector.getVouTypeIndex()))).getString("name");
        result[this.opIndex.getVouNoIndex()] = vtName + row.getString(this.selector.getVouNoIndex());
        result[this.opIndex.getDescIndex()] = row.get(this.selector.getDescIndex());
        result[this.opIndex.getVouIdIndex()] = row.get(this.selector.getVouIdIndex());
        result[this.opIndex.getVouEntryIdIndex()] = row.get(this.selector.getVouEntryIdIndex());
        if (this.opIndex.getCurrencyIndex() != -1) {
            result[this.opIndex.getCurrencyIndex()] = row.get(this.selector.getCurrencyIndex());
        }
        if (this.opIndex.getAssgrpIndex() != -1) {
            result[this.opIndex.getAssgrpIndex()] = row.get(this.selector.getAssgrpIndex());
        }
        if (this.opIndex.getMeasureunitIndex() != -1) {
            result[this.opIndex.getMeasureunitIndex()] = row.get(this.selector.getMeasureunitIndex());
        }
        int[] opDebitIndexes = this.opIndex.getDebitIndexes();
        int[] opCreditIndexes = this.opIndex.getCreditIndexes();
        int[] opEndIndexes = this.opIndex.getEndIndexesArr();
        this.copyValue(result, row, opDebitIndexes, this.selector.getDebitIndexes());
        this.copyValue(result, row, opCreditIndexes, this.selector.getCreditIndexes());
        if (this.qpRpt.isShowQty()) {
            String entrydc = row.getString(this.selector.getEntryDCIndex());
            if ("1".equals(entrydc)) {
                result[this.opIndex.getCreditQtyIndex()] = BigDecimal.ZERO;
                int creditPriceIndex = this.opIndex.getCreditPriceIndex();
                if (creditPriceIndex != -1) {
                    result[creditPriceIndex] = BigDecimal.ZERO;
                }
            } else {
                result[this.opIndex.getDebitQtyIndex()] = BigDecimal.ZERO;
                int debitPriceIndex = this.opIndex.getDebitPriceIndex();
                if (debitPriceIndex != -1) {
                    result[debitPriceIndex] = BigDecimal.ZERO;
                }
            }
        }
        for (int i = 0; i < opEndIndexes.length; ++i) {
            result[opEndIndexes[i]] = RptUtil.subtract(result[opDebitIndexes[i]], result[opCreditIndexes[i]]);
        }
        int accountSeqIndex = this.opIndex.getAccountSeqIndex();
        if (accountSeqIndex != -1) {
            result[accountSeqIndex] = row.get(this.selector.getSeqIndex());
        }
        result[this.opIndex.getRowTypeIndex()] = "2";
        result[this.opIndex.getRowIndex()] = "2";
        return result;
    }

    private void copyValue(Object[] result, Row row, int[] opIndexes, int[] ipIndexes) {
        for (int i = 0; i < opIndexes.length; ++i) {
            result[opIndexes[i]] = row.get(ipIndexes[i]);
        }
    }
}

