/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.gl.configuration.ReportConfiguration;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.common.ISelector;
import kd.fi.gl.report.common.RptUtil;
import kd.fi.gl.report.fiilter.ReportGroupFilter;
import kd.fi.gl.report.subledger.SubLedgerBalLogSelector;
import kd.fi.gl.report.subledger.SubLedgerBalSelector;
import kd.fi.gl.report.subledger.SubLedgerCollector;
import kd.fi.gl.report.subledger.SubLedgerInitBalSelector;
import kd.fi.gl.report.subledger.SubLedgerPLVouSelector;
import kd.fi.gl.report.subledger.SubLedgerReportQuery;
import kd.fi.gl.report.subledger.SubLedgerVouSelector;

public class SubLedgerQueryRpt {
    private static final Log logger = LogFactory.getLog(SubLedgerQueryRpt.class);
    private MulOrgQPRpt qpRpt;
    private final ReportQueryParam reportQueryParam;
    private final Object obj;
    private SubLedgerReportQuery reportQuery;
    private static final String CUSTOMSORTENTRY = "customsortentry";

    public SubLedgerQueryRpt(ReportQueryParam queryParam, Object selectObj) {
        this.reportQueryParam = queryParam;
        this.obj = selectObj;
    }

    public DataSet query() {
        try {
            return this.execute();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    private DataSet execute() {
        ISelector[] is;
        this.initReportQuery();
        QFilter voucherFilter = this.reportQueryParam.getFilter().getCommFilter("gl_voucher");
        SubLedgerCollector collector = new SubLedgerCollector(this.reportQuery);
        collector.addSelector(new SubLedgerVouSelector(this.reportQuery, voucherFilter));
        SubLedgerBalSelector balSelector = new SubLedgerBalSelector(this.reportQuery);
        SubLedgerBalLogSelector balLogSelector = new SubLedgerBalLogSelector(this.reportQuery);
        if (this.qpRpt.isSubstractPL()) {
            SubLedgerInitBalSelector initbalSelector = new SubLedgerInitBalSelector(this.reportQuery);
            is = new ISelector[]{balSelector, balLogSelector, initbalSelector};
        } else {
            is = new ISelector[]{balSelector, balLogSelector};
        }
        collector.initBeginValue(is);
        if (this.qpRpt.isSubstractPL()) {
            collector.initPlValue(new SubLedgerPLVouSelector(this.reportQuery, voucherFilter));
        }
        return this.doCheckBoxFilter(collector.finish());
    }

    private DataSet doCheckBoxFilter(DataSet ds) {
        RowMeta rowMeta = ds.getRowMeta();
        FilterInfo filterInfo = this.reportQueryParam.getFilter();
        List<String> grpFields = Arrays.stream(this.reportQuery.getOutPutIndex().getGrpIndexes()).mapToObj(arg_0 -> ((RowMeta)rowMeta).getFieldName(arg_0)).collect(Collectors.toList());
        ReportGroupFilter filter = new ReportGroupFilter(grpFields);
        if (filterInfo.getBoolean("nodisplayforzero")) {
            filter.addFilterFunction(new ReportGroupFilter.IGroupFilterFunction(){

                @Override
                public boolean needRemain(Row row) {
                    return true;
                }

                @Override
                public boolean isCharacteristicRow(Row row) {
                    return "2".equals(row.getString("rowtype"));
                }
            });
        }
        if (filterInfo.getBoolean("balancezero")) {
            HashSet<String> checkFields = new HashSet<String>();
            checkFields.add("endlocal");
            if (this.qpRpt.isQueryCurrency()) {
                checkFields.add("endfor");
            }
            if (this.qpRpt.isShowSumQty()) {
                checkFields.add("endqty");
            }
            final long endPeriod = filterInfo.getLong("endperiod");
            final List endFieldsIdxes = checkFields.stream().map(field -> rowMeta.getFieldIndex(field, false)).filter(i -> i != -1).collect(Collectors.toList());
            filter.addFilterFunction(new ReportGroupFilter.IGroupFilterFunction(){

                @Override
                public boolean needRemain(Row row) {
                    return endFieldsIdxes.stream().anyMatch(f -> row.getBigDecimal(f.intValue()) != null && row.getBigDecimal(f.intValue()).compareTo(BigDecimal.ZERO) != 0);
                }

                @Override
                public boolean isCharacteristicRow(Row row) {
                    return "4".equals(row.getString("rowtype")) && row.getLong("period") == endPeriod;
                }
            });
        }
        ds = filter.doFilter(ds);
        if (filterInfo.getBoolean("nodisplayforzeroamount")) {
            grpFields.add("period");
            ReportGroupFilter grpFilter = new ReportGroupFilter(grpFields);
            grpFilter.addFilterFunction(new ReportGroupFilter.IGroupFilterFunction(){

                @Override
                public boolean needRemain(Row row) {
                    Integer count = row.getInteger(SubLedgerQueryRpt.this.reportQuery.getOutPutIndex().getCountIndex());
                    if (count == null) {
                        count = 0;
                    }
                    return "1".equals(row.getString("rowtype")) || count > 0;
                }

                @Override
                public boolean isCharacteristicRow(Row row) {
                    return "4".equals(row.getString("rowtype")) || "1".equals(row.getString("rowtype"));
                }
            });
            ds = grpFilter.doFilter(ds);
        }
        return ds;
    }

    protected void initReportQuery() {
        boolean isExportAll;
        this.qpRpt = new MulOrgQPRpt(this.reportQueryParam.getFilter(), "gl_rpt_subledger");
        this.qpRpt.setShowOrg(true);
        this.qpRpt.setShowAssist(true);
        if (this.qpRpt.isShowLeafAccount()) {
            this.qpRpt.setAccountLevel(Integer.MAX_VALUE);
        }
        boolean bl = isExportAll = this.obj == null || this.obj instanceof DynamicObjectCollection;
        if (isExportAll) {
            this.qpRpt.setExportAll(true);
        } else {
            HashSet<String> filterNumSet;
            DynamicObject dyn = (DynamicObject)this.obj;
            this.qpRpt.setAccountLevel(dyn.getInt("level"));
            HashSet<Long> masterIdSet = new HashSet<Long>();
            HashSet<String> numberSet = new HashSet<String>();
            masterIdSet.add(dyn.getLong("masterid"));
            numberSet.add(dyn.getString("number"));
            Set filterMSet = this.qpRpt.getMasterIdSet();
            DynamicObjectCollection accountDyos = this.reportQueryParam.getFilter().getDynamicObjectCollection("account");
            Set<String> set = filterNumSet = accountDyos == null ? new HashSet<String>() : accountDyos.stream().map(dyo -> dyo.getString("number")).collect(Collectors.toSet());
            if (filterMSet == null || filterMSet.isEmpty()) {
                ArrayList<Long> accIdSet = new ArrayList<Long>();
                accIdSet.add(dyn.getLong("id"));
                this.qpRpt.setAccountList(accIdSet);
                this.qpRpt.setMasterIdSet(masterIdSet);
            } else {
                Map<Long, Long> leftTreeMap = RptUtil.getAllLeafAccountByNums(numberSet, this.qpRpt.getAccountTable(), null);
                Map<Long, Long> filterMap = RptUtil.getAllLeafAccountByNums(filterNumSet, this.qpRpt.getAccountTable(), null);
                Set<Long> leftTreeIds = leftTreeMap.keySet();
                Map<Long, Long> collect = filterMap.entrySet().stream().filter(x -> leftTreeIds.contains(x.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                HashSet<Long> mid = new HashSet<Long>(collect.values());
                ArrayList<Long> ids = new ArrayList<Long>(collect.keySet());
                this.qpRpt.setAccountList(ids);
                this.qpRpt.setMasterIdSet(mid);
            }
        }
        List sortEntry = (List)this.reportQueryParam.getFilter().getOtherEntryFilter().get(CUSTOMSORTENTRY);
        this.reportQuery = new SubLedgerReportQuery((QueryParamRpt)this.qpRpt, sortEntry);
        if (this.obj instanceof DynamicObjectCollection) {
            this.reportQuery.setSelObj((DynamicObject)((DynamicObjectCollection)this.getSelectedObj()).get(0));
        } else {
            this.reportQuery.setSelObj((DynamicObject)this.getSelectedObj());
        }
        if (!isExportAll && ReportConfiguration.SL_ENABLE_NEW_LEVEL_CONTROL.getBoolean()) {
            this.reportQuery.setAccountLevelTransfer((DynamicObject)this.obj);
        }
    }

    private Object getSelectedObj() {
        return this.obj;
    }

    public SubLedgerReportQuery getReportQuery() {
        return this.reportQuery;
    }
}

