/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger;

import com.google.common.cache.LoadingCache;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.gl.dataset.TreeNode;
import kd.fi.gl.enums.SubLedgerSortFieldEnum;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.common.AbstractAccReportQuery;
import kd.fi.gl.report.common.DataSchema;
import kd.fi.gl.report.subledger.AccountLevelTransferLazy;
import kd.fi.gl.report.subledger.DefaultAccountLevelTransfer;
import kd.fi.gl.report.subledger.IAccountLevelTransfer;
import kd.fi.gl.report.subledger.SubLedgerOutPutIndex;
import kd.fi.gl.util.GLUtil;

public class SubLedgerReportQuery
extends AbstractAccReportQuery {
    private RowMeta rowMeta;
    private SubLedgerOutPutIndex opIndex;
    private DataSchema dailySchema;
    private DataSchema periodSchema;
    private DataSchema yearSchema;
    private List<Object> sortEntry;
    private DataSchema beginPeriodSchema;
    private DynamicObject selObj;
    private final String[] dailyGrp;
    private final String[] grp;
    private Set<Long> mids = null;
    private Set<Long> ids = null;
    private Map<Long, Long> acctID2MIDMap;
    private IAccountLevelTransfer accountLevelTransfer;
    private LoadingCache<Long, DynamicObject> vchTypeCache;
    public final int voucherDisplayLimit;
    private int vchDataSetSize = -1;

    public SubLedgerReportQuery(QueryParamRpt qpRpt, List<Object> sortEntry) {
        super(qpRpt);
        int displayLimit;
        List comAssistKeys = qpRpt.getCommonAssistsForGroup();
        this.dailyGrp = this.addComAssistFields(comAssistKeys, 1, "org", "account", "currency", "period", "bookeddatestr", "rowtype", "bookeddate", "rowindex");
        this.grp = this.addComAssistFields(comAssistKeys, 1, "org", "account", "currency", "period", "bookeddatestr", "rowtype", "rowindex");
        this.sortEntry = sortEntry;
        this.rowMeta = this.initRowMeta();
        this.opIndex = new SubLedgerOutPutIndex(this);
        this.initSumSchema();
        this.voucherDisplayLimit = qpRpt.getFilterInfo().containProp("voucherdisplaylimit") ? ((displayLimit = qpRpt.getFilterInfo().getInt("voucherdisplaylimit")) > 0 ? displayLimit : 100000) : BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"fi.gl.report.subledger.voucherdisplaylimit", (int)100000);
    }

    private String[] addComAssistFields(List<String> comAssists, int comAssistAt, String ... fields) {
        List<String> collect = Stream.of(fields).collect(Collectors.toList());
        if (this.qpRpt.isShowComAssistSum().booleanValue()) {
            for (int i = comAssists.size() - 1; i >= 0; --i) {
                collect.add(comAssistAt, comAssists.get(i));
            }
        }
        return collect.toArray(new String[0]);
    }

    private void initSumSchema() {
        this.dailySchema = this.getSchemaDaily();
        this.periodSchema = this.getSchema();
        this.yearSchema = this.getSchema();
        this.beginPeriodSchema = this.getSchema();
    }

    private DataSchema getSchemaDaily() {
        return this.getDataSchema(this.dailyGrp, this.getSumBy());
    }

    private String[] addMeasureunit(String[] munGrp) {
        ArrayList<String> grpList = new ArrayList<String>(Arrays.asList(munGrp));
        if (this.qpRpt.isShowSumQty()) {
            grpList.add("measureunit");
        }
        return grpList.toArray(new String[0]);
    }

    private DataSchema getSchema() {
        return this.getDataSchema(this.grp, this.getSumBy());
    }

    protected String[] getSumBy() {
        String str = "";
        if (this.qpRpt.isQueryCurrency()) {
            str = str + "," + this.getAmountField().replace("#", "for");
        }
        str = str + "," + this.getAmountField().replace("#", "local");
        if (this.qpRpt.isShowRpt()) {
            str = str + "," + this.getAmountField().replace("#", "rpt");
        }
        if (this.qpRpt.isShowSumQty()) {
            str = str + "," + this.getAmountField().replace("#", "qty");
        }
        List<String> sumBys = Arrays.stream(str.split(",")).collect(Collectors.toList());
        sumBys.add("count");
        return sumBys.toArray(new String[0]);
    }

    private String getAmountField() {
        return "debit#,credit#,end#";
    }

    protected DataSchema getDataSchema(String[] groupBy, String[] sumBy) {
        return DataSchema.getDataSchema(this.addMeasureunit(groupBy), sumBy, this.getRowMeta());
    }

    private RowMeta initRowMeta() {
        ArrayList<Field> fieldList = new ArrayList<Field>(16);
        fieldList.add(new Field("org", (DataType)DataType.LongType));
        this.qpRpt.getCommonAssists().forEach(commonAssist -> fieldList.add(new Field(commonAssist.key, (DataType)DataType.LongType)));
        fieldList.add(new Field("account", (DataType)DataType.LongType));
        fieldList.add(new Field("bookeddate", (DataType)DataType.DateType));
        fieldList.add(new Field("bookeddatestr", (DataType)DataType.StringType));
        fieldList.add(new Field("bizdate", (DataType)DataType.DateType));
        fieldList.add(new Field("voucherno", (DataType)DataType.StringType));
        fieldList.add(new Field("localrate", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("desc", (DataType)DataType.StringType));
        fieldList.add(new Field("rowtype", (DataType)DataType.StringType));
        fieldList.add(new Field("rowindex", (DataType)DataType.StringType));
        fieldList.add(new Field("voucherid", (DataType)DataType.LongType));
        fieldList.add(new Field("fentryid", (DataType)DataType.LongType));
        fieldList.add(new Field("entrydc", (DataType)DataType.StringType));
        if (this.qpRpt.isQueryCurrency()) {
            fieldList.add(new Field("currency", (DataType)DataType.LongType));
        }
        if (this.qpRpt.isShowAssist()) {
            fieldList.add(new Field("assgrp", (DataType)DataType.LongType));
        }
        if (this.qpRpt.isShowQty()) {
            fieldList.add(new Field("measureunit", (DataType)DataType.LongType));
        }
        fieldList.add(new Field("debitlocal", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("creditlocal", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("endlocal", (DataType)DataType.BigDecimalType));
        if (this.qpRpt.isQueryCurrency()) {
            fieldList.add(new Field("debitfor", (DataType)DataType.BigDecimalType));
            fieldList.add(new Field("creditfor", (DataType)DataType.BigDecimalType));
            fieldList.add(new Field("endfor", (DataType)DataType.BigDecimalType));
        }
        if (this.qpRpt.isShowQty()) {
            fieldList.add(new Field("debitqty", (DataType)DataType.BigDecimalType));
            fieldList.add(new Field("creditqty", (DataType)DataType.BigDecimalType));
            fieldList.add(new Field("endqty", (DataType)DataType.BigDecimalType));
        }
        if (this.qpRpt.isShowPrice()) {
            fieldList.add(new Field("debitprice", (DataType)DataType.BigDecimalType));
            fieldList.add(new Field("creditprice", (DataType)DataType.BigDecimalType));
            fieldList.add(new Field("endprice", (DataType)DataType.BigDecimalType));
        }
        if (this.qpRpt.isShowRpt()) {
            fieldList.add(new Field("debitrpt", (DataType)DataType.BigDecimalType));
            fieldList.add(new Field("creditrpt", (DataType)DataType.BigDecimalType));
            fieldList.add(new Field("endrpt", (DataType)DataType.BigDecimalType));
        }
        fieldList.add(new Field("period", (DataType)DataType.LongType));
        if (this.qpRpt.isShowOpAccount()) {
            fieldList.add(new Field("opaccount", (DataType)DataType.LongType));
            fieldList.add(new Field("opassgrp", (DataType)DataType.LongType));
        }
        fieldList.add(new Field("accountseq", (DataType)DataType.IntegerType));
        fieldList.add(new Field("vtnumber", (DataType)DataType.StringType));
        fieldList.add(new Field("billno", (DataType)DataType.StringType));
        fieldList.add(new Field("nozero", (DataType)DataType.StringType));
        fieldList.add(new Field("count", (DataType)DataType.StringType));
        MainEntityType voucherEntityType = MetadataServiceHelper.getDataEntityType((String)"gl_voucher");
        Map allFields = voucherEntityType.getAllFields();
        if (this.sortEntry != null && !this.sortEntry.isEmpty()) {
            for (Object obj : this.sortEntry) {
                Class fieldClass;
                DynamicObject sortentry = (DynamicObject)obj;
                String fieldName = sortentry.getString("fieldcombo");
                if (SubLedgerSortFieldEnum.isIn((String)fieldName)) continue;
                if (fieldName.startsWith("entries")) {
                    fieldName = fieldName.substring(8);
                }
                if ((fieldClass = ((IDataEntityProperty)allFields.get(fieldName)).getPropertyType()) == String.class) {
                    fieldList.add(new Field(fieldName, (DataType)DataType.StringType));
                    continue;
                }
                if (fieldClass == Long.TYPE || fieldClass == DynamicObject.class) {
                    fieldList.add(new Field(fieldName, (DataType)DataType.LongType));
                    continue;
                }
                if (fieldClass == Integer.class) {
                    fieldList.add(new Field(fieldName, (DataType)DataType.IntegerType));
                    continue;
                }
                if (fieldClass == BigDecimal.class) {
                    fieldList.add(new Field(fieldName, (DataType)DataType.BigDecimalType));
                    continue;
                }
                if (fieldClass == Date.class) {
                    fieldList.add(new Field(fieldName, (DataType)DataType.DateType));
                    continue;
                }
                if (fieldClass != Boolean.class) continue;
                fieldList.add(new Field(fieldName, (DataType)DataType.BooleanType));
            }
        }
        return new RowMeta(fieldList.toArray(new Field[0]));
    }

    @Override
    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    @Override
    public SubLedgerOutPutIndex getOutPutIndex() {
        return this.opIndex;
    }

    public DataSchema getDailySchema() {
        return this.dailySchema;
    }

    public DataSchema getPeriodSchema() {
        return this.periodSchema;
    }

    public DataSchema getYearSchema() {
        return this.yearSchema;
    }

    public DataSchema getBeginPeriodSchema() {
        return this.beginPeriodSchema;
    }

    public void setRowMeta(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public void setOpIndex(SubLedgerOutPutIndex opIndex) {
        this.opIndex = opIndex;
    }

    public void setDailySchema(DataSchema dailySchema) {
        this.dailySchema = dailySchema;
    }

    public void setPeriodSchema(DataSchema periodSchema) {
        this.periodSchema = periodSchema;
    }

    public void setYearSchema(DataSchema yearSchema) {
        this.yearSchema = yearSchema;
    }

    public void setBeginPeriodSchema(DataSchema beginPeriodSchema) {
        this.beginPeriodSchema = beginPeriodSchema;
    }

    public List<Object> getSortEntry() {
        return this.sortEntry;
    }

    public DynamicObject getSelObj() {
        return this.selObj;
    }

    public void setSelObj(DynamicObject selObj) {
        this.selObj = selObj;
    }

    private void initQueryIds() {
        HashSet<Object> mids = new HashSet<Object>(this.getMasterIdMap().keySet());
        Map<Object, TreeNode> allMap = this.getAllMasterIdMap();
        if (!allMap.isEmpty()) {
            mids.addAll(allMap.keySet());
        }
        QFilter facct = new QFilter("masterid", "in", mids);
        this.acctID2MIDMap = QueryServiceHelper.query((String)"bd_accountview", (String)"id, masterid", (QFilter[])new QFilter[]{facct}).stream().collect(Collectors.toMap(acctDyo -> acctDyo.getLong("id"), acctDyo -> acctDyo.getLong("masterid")));
        this.ids = this.acctID2MIDMap.keySet();
        this.mids = new HashSet<Long>(this.acctID2MIDMap.values());
    }

    public Set<Long> getAllQueryMids() {
        if (this.mids == null) {
            this.initQueryIds();
        }
        return this.mids;
    }

    public Set<Long> getAllQueryIds() {
        if (this.ids == null) {
            this.initQueryIds();
        }
        return this.ids;
    }

    public Long getAcctMidOnLevel(Long orgID, Long acctID) {
        return this.getAccountLevelTransfer().transfer(orgID, this.acctID2MIDMap.get(acctID));
    }

    public void setAccountLevelTransfer(DynamicObject selectedAcct) {
        if (selectedAcct != null) {
            this.accountLevelTransfer = new DefaultAccountLevelTransfer(selectedAcct.getLong("masterid"));
        }
    }

    public IAccountLevelTransfer getAccountLevelTransfer() {
        if (this.accountLevelTransfer == null) {
            this.accountLevelTransfer = new AccountLevelTransferLazy(this.qpRpt.getAccountTable(), this.qpRpt.getEndPeriod(), this.qpRpt.getAccountLevel(), new QFilter[0]);
        }
        return this.accountLevelTransfer;
    }

    public LoadingCache<Long, DynamicObject> getVchTypeCache() {
        if (this.vchTypeCache == null) {
            this.vchTypeCache = GLUtil.getDyoLoadingCache((String)"gl_vouchertype", (String)"name, number", (long)500L, (QFilter[])new QFilter[]{BaseDataServiceHelper.getBaseDataFilter((String)"gl_vouchertype", (List)this.qpRpt.getOrgs(), (boolean)true)});
        }
        return this.vchTypeCache;
    }

    public int getVchDataSetSize() {
        return this.vchDataSetSize;
    }

    public void setVchDataSetSize(int vchDataSetSize) {
        this.vchDataSetSize = vchDataSetSize;
    }
}

