/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.bd.util.QFBuilder;
import kd.fi.gl.enums.SubLedgerSortFieldEnum;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.common.ISelector;
import kd.fi.gl.report.common.OutPutFunction;
import kd.fi.gl.report.subledger.SubLedgerReportQuery;
import kd.fi.gl.report.subledger.SubLedgerVouFunction;
import kd.fi.gl.util.MulCurReportUtil;
import kd.fi.gl.voucher.dimquery.LimitSizeDimVchQuery;

public class SubLedgerVouSelector
implements ISelector {
    private static final Log LOG = LogFactory.getLog(SubLedgerVouSelector.class);
    protected QueryParamRpt qpRpt;
    protected String selField;
    private List<String> queryField;
    protected QFilter[] qFilters;
    private SubLedgerReportQuery reportQuery;
    private SubLedgerVouFunction outPutFunction;
    private int orgIndex;
    private List<Integer> comAssistIndexer;
    private int accountIndex;
    private int bookDateIndex;
    private int bizDateIndex;
    private int vouNoIndex;
    private int vouRateIndex;
    private int vouTypeIDIndex;
    private int descIndex;
    private int vouIdIndex;
    private int vouEntryIdIndex;
    private static final String FENTRY_ID = "fentryid";
    private int currencyIndex;
    private int assgrpIndex;
    private int measureunitIndex;
    private int entryDcIndex;
    private int[] debitIndexes;
    private int[] creditIndexes;
    private int debitQtyIndexes;
    private int creditQtyIndexes;
    private int debitPriceIndexes;
    private int creditPriceIndexes;
    private int periodIndex;
    private int seqIndex;
    private QFilter voucherFilter;
    private int[] extSortFieldIndex;

    public int getDebitQtyIndexes() {
        return this.debitQtyIndexes;
    }

    public int getCreditQtyIndexes() {
        return this.creditQtyIndexes;
    }

    public int getDebitPriceIndexes() {
        return this.debitPriceIndexes;
    }

    public int getCreditPriceIndexes() {
        return this.creditPriceIndexes;
    }

    public SubLedgerVouSelector(SubLedgerReportQuery reportQuery, QFilter voucherFilter) {
        this.voucherFilter = voucherFilter;
        this.reportQuery = reportQuery;
        this.qpRpt = reportQuery.getQueryParam();
        this.selField = this.initSel();
        this.qFilters = this.initQFilters();
        this.outPutFunction = new SubLedgerVouFunction(this);
        this.initIndexes();
        this.initExtSortFieldIndex();
    }

    private void initExtSortFieldIndex() {
        ArrayList<Integer> indexs = new ArrayList<Integer>(10);
        List<Object> sort = this.reportQuery.getSortEntry();
        if (sort != null && !sort.isEmpty()) {
            for (Object obj : sort) {
                DynamicObject sortRow = (DynamicObject)obj;
                String field = sortRow.getString("fieldcombo");
                if (SubLedgerSortFieldEnum.isIn((String)field)) continue;
                if (field.startsWith("entries")) {
                    field = field.substring("entries.".length());
                }
                indexs.add(this.queryField.indexOf(field));
            }
        }
        this.extSortFieldIndex = indexs.stream().mapToInt(x -> x).toArray();
    }

    private void initIndexes() {
        this.orgIndex = this.queryField.indexOf("org");
        this.comAssistIndexer = this.qpRpt.getCommonAssists().stream().map(comAssist -> this.queryField.indexOf(comAssist.key)).collect(Collectors.toList());
        this.accountIndex = this.queryField.indexOf("account");
        this.bookDateIndex = this.queryField.indexOf("bookeddate");
        this.bizDateIndex = this.queryField.indexOf("bizdate");
        this.vouNoIndex = this.queryField.indexOf("billno");
        this.vouRateIndex = this.queryField.indexOf("localrate");
        this.vouTypeIDIndex = this.queryField.indexOf("vchtype_id");
        this.descIndex = this.queryField.indexOf("edescription");
        this.vouIdIndex = this.queryField.indexOf("id");
        this.vouEntryIdIndex = this.queryField.indexOf(FENTRY_ID);
        this.currencyIndex = this.queryField.indexOf("currency");
        this.assgrpIndex = this.queryField.indexOf("assgrp");
        this.measureunitIndex = this.queryField.indexOf("measureunit");
        this.entryDcIndex = this.queryField.indexOf("entrydc");
        this.debitIndexes = this.setIndexes("debit");
        this.creditIndexes = this.setIndexes("credit");
        this.periodIndex = this.queryField.indexOf("period");
        this.seqIndex = this.queryField.indexOf("seq");
        this.debitQtyIndexes = this.queryField.indexOf("debitqty");
        this.creditQtyIndexes = this.queryField.indexOf("creditqty");
        this.debitPriceIndexes = this.queryField.indexOf("debitprice");
        this.creditPriceIndexes = this.queryField.indexOf("creditprice");
    }

    private int[] setIndexes(String flag) {
        ArrayList<Integer> list = new ArrayList<Integer>(4);
        for (String field : this.merge(flag)) {
            list.add(this.queryField.indexOf(field));
        }
        return list.stream().mapToInt(x -> x).toArray();
    }

    private String[] merge(String prefix) {
        ArrayList<String> list = new ArrayList<String>();
        for (String pre : prefix.split(",")) {
            for (String suf : this.reportQuery.getOutPutIndex().getTypes().split(",")) {
                list.add(pre + suf);
            }
        }
        return list.toArray(new String[0]);
    }

    private String initSel() {
        ArrayList<String> sel = new ArrayList<String>(16);
        sel.add("id");
        sel.add("billno");
        sel.add(String.join((CharSequence)"", "entries", ".", "localrate", " ", "localrate"));
        sel.add("vouchertype vchtype_id");
        sel.add("bookeddate");
        sel.add("bizdate");
        sel.add("period");
        sel.add(String.join((CharSequence)"", "entries", ".", "id", " ", FENTRY_ID));
        sel.add(String.join((CharSequence)"", "entries", ".", "edescription", " ", "edescription"));
        sel.add(String.join((CharSequence)"", "entries", ".", "account", " ", "account"));
        sel.add("org");
        this.qpRpt.getCommonAssists().forEach(commonAssist -> sel.add("entries." + commonAssist.key + " " + commonAssist.key));
        if (this.qpRpt.isQueryCurrency()) {
            sel.add(String.join((CharSequence)"", "entries", ".", "currency", " ", "currency"));
        }
        if (this.qpRpt.isShowAssist()) {
            sel.add(String.join((CharSequence)"", "entries", ".", "assgrp", " ", "assgrp"));
        }
        if (this.qpRpt.isShowQty()) {
            sel.add(String.join((CharSequence)"", "entries", ".", "measureunit", " ", "measureunit"));
        }
        sel.addAll(MulCurReportUtil.getVoucherLocalAmountFields3((String)this.qpRpt.getLocaleCurType()));
        if (this.qpRpt.isQueryCurrency()) {
            sel.add(String.join((CharSequence)"", "entries", ".", "debitori", " ", "debitfor"));
            sel.add(String.join((CharSequence)"", "entries", ".", "creditori", " ", "creditfor"));
        }
        sel.add(String.join((CharSequence)"", "entries", ".", "entrydc", " ", "entrydc"));
        if (this.qpRpt.isShowQty()) {
            sel.add(String.join((CharSequence)"", "entries", ".", "quantity", " ", "debitqty"));
            sel.add(String.join((CharSequence)"", "entries", ".", "quantity", " ", "creditqty"));
        }
        if (this.qpRpt.isShowPrice()) {
            sel.add(String.join((CharSequence)"", "entries", ".", "price", " ", "debitprice"));
            sel.add(String.join((CharSequence)"", "entries", ".", "price", " ", "creditprice"));
        }
        sel.add(String.join((CharSequence)"", "entries", ".", "seq", " ", "seq"));
        List<Object> sortEntry = this.reportQuery.getSortEntry();
        if (Objects.nonNull(sortEntry)) {
            for (Object obj : sortEntry) {
                DynamicObject sortentry = (DynamicObject)obj;
                String field = sortentry.getString("fieldcombo");
                if (SubLedgerSortFieldEnum.isIn((String)field)) continue;
                if (field.contains(".")) {
                    String entriesField = String.join((CharSequence)" ", field, field.substring(field.indexOf(".") + 1));
                    if (sel.indexOf(entriesField) != -1) continue;
                    sel.add(entriesField);
                    continue;
                }
                if (sel.indexOf(field) != -1) continue;
                sel.add(field);
            }
        }
        this.queryField = new ArrayList<String>();
        for (String s : sel) {
            String[] split = s.split(" ");
            if (split.length == 1) {
                this.queryField.add(split[0]);
                continue;
            }
            this.queryField.add(split[1]);
        }
        return ((Object)sel).toString().replace("[", "").replace("]", "");
    }

    private QFilter[] initQFilters() {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("org", "in", (Object)this.qpRpt.getAllEntityOrgs()));
        list.add(new QFilter("booktype", "=", (Object)this.qpRpt.getBookType()));
        list.addAll(this.qpRpt.getComAssistFiltersForBill(key -> "entries." + key));
        int searchType = this.qpRpt.getSearchType();
        if (searchType == 2) {
            Date startDate = this.qpRpt.getStartDate();
            Date endDate = this.qpRpt.getEndDate();
            QFBuilder periodFilterBuilder = new QFBuilder("periodtype", "=", (Object)this.qpRpt.getPeriodType());
            periodFilterBuilder.add("begindate", "<=", (Object)endDate);
            periodFilterBuilder.add("enddate", ">=", (Object)startDate);
            List periodPkValueList = QueryServiceHelper.queryPrimaryKeys((String)"bd_period", (QFilter[])periodFilterBuilder.toArray(), null, (int)-1).stream().map(x -> (Long)x).collect(Collectors.toList());
            if (!periodPkValueList.isEmpty()) {
                list.add(new QFilter("period", "in", periodPkValueList));
                this.qpRpt.setStartPeriod(((Long)Collections.min(periodPkValueList)).longValue());
                this.qpRpt.setEndPeriod(((Long)Collections.max(periodPkValueList)).longValue());
            }
        } else {
            list.add(new QFilter("period", ">=", (Object)this.qpRpt.getStartPeriod()));
            list.add(new QFilter("period", "<=", (Object)this.qpRpt.getEndPeriod()));
        }
        list.add(new QFilter("billstatus", "in", (Object)new String[]{"B", "C"}));
        if (this.qpRpt.isSubstractPL()) {
            list.add(new QFilter("sourcetype", "!=", (Object)"1"));
        }
        Set<Long> accIds = this.reportQuery.getAllQueryIds();
        list.add(new QFilter("entries.account", "in", accIds));
        if (!this.qpRpt.isSynCurrency() && !this.qpRpt.isAllCurrency()) {
            list.add(new QFilter("entries.currency", "=", (Object)this.qpRpt.getCurrency()));
        }
        if (this.voucherFilter != null) {
            list.add(this.voucherFilter);
        }
        return list.toArray(new QFilter[0]);
    }

    @Override
    public List<String> getQueryFields() {
        return this.queryField;
    }

    @Override
    public QFilter[] getQFilters() {
        return this.qFilters;
    }

    @Override
    public SubLedgerReportQuery getReportQuery() {
        return this.reportQuery;
    }

    @Override
    public DataSet getDataSet(QFilter[] filter) {
        Object[] vchFilters = filter == null ? this.qFilters : filter;
        LOG.info("report query filter as: " + StringUtils.join((Object[])vchFilters));
        if (this.qpRpt.isExportAll() || this.qpRpt.getSearchType() == 2) {
            this.reportQuery.setVchDataSetSize(-1);
            return VoucherQueryUtils.queryDataSet((String)this.selField, (QFilter[])vchFilters, null, (int)-1);
        }
        int voucherDisplayLimit = this.reportQuery.voucherDisplayLimit;
        Tuple queryResult = (Tuple)new LimitSizeDimVchQuery(this.reportQuery.getQueryParam().getFilterInfo()).query((QFilter[])vchFilters, this.selField, null, voucherDisplayLimit + 1);
        DataSet vchDS = (DataSet)queryResult.item1;
        int vchDSCount = (Integer)queryResult.item2;
        this.reportQuery.setVchDataSetSize(vchDSCount);
        if (vchDSCount > voucherDisplayLimit) {
            vchDS = vchDS.limit(0, voucherDisplayLimit);
        }
        return vchDS;
    }

    public int getComAssistIndex(int num) {
        return this.comAssistIndexer.get(num);
    }

    @Override
    public OutPutFunction getOutPutFunction() {
        return this.outPutFunction;
    }

    public int getAccountIndex() {
        return this.accountIndex;
    }

    public int getBookDateIndex() {
        return this.bookDateIndex;
    }

    public int getBizDateIndex() {
        return this.bizDateIndex;
    }

    public int getVouNoIndex() {
        return this.vouNoIndex;
    }

    public int getVouRateIndex() {
        return this.vouRateIndex;
    }

    public int getDescIndex() {
        return this.descIndex;
    }

    public int getVouIdIndex() {
        return this.vouIdIndex;
    }

    public int getVouEntryIdIndex() {
        return this.vouEntryIdIndex;
    }

    public int getCurrencyIndex() {
        return this.currencyIndex;
    }

    public int getAssgrpIndex() {
        return this.assgrpIndex;
    }

    public int getMeasureunitIndex() {
        return this.measureunitIndex;
    }

    public int getEntryDCIndex() {
        return this.entryDcIndex;
    }

    public int[] getDebitIndexes() {
        return this.debitIndexes;
    }

    public int[] getCreditIndexes() {
        return this.creditIndexes;
    }

    public int getPeriodIndex() {
        return this.periodIndex;
    }

    public int getSeqIndex() {
        return this.seqIndex;
    }

    public int getOrgIndex() {
        return this.orgIndex;
    }

    public void setOutPutFunction(SubLedgerVouFunction outPutFunction) {
        this.outPutFunction = outPutFunction;
    }

    public int getVouTypeIDIndex() {
        return this.vouTypeIDIndex;
    }

    public QFilter[] getFilters() {
        return this.qFilters;
    }

    public int[] getExtSortFieldIndex() {
        return this.extSortFieldIndex;
    }

    public void setExtSortFieldIndex(int[] extSortFieldIndex) {
        this.extSortFieldIndex = extSortFieldIndex;
    }
}

