/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger.export;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.dataset.PersistedArrayRow;
import kd.fi.gl.report.export.RecyclableRowStorage;
import kd.fi.gl.report.subledger.export.SubLedgerQueryContext;

public class OrderedDataSetMerger {
    private final List<DataSet> sources;
    private final Comparator<Row> comparator;
    private final RecyclableRowStorage rowStorage;

    public OrderedDataSetMerger(List<DataSet> sources, Comparator<Row> comparator, RecyclableRowStorage rowStorage) {
        this.sources = sources;
        this.comparator = (r1, r2) -> {
            int res = comparator.compare((Row)r1, (Row)r2);
            return res == 0 ? ((AbstractRow)r1).getRowMeta().hashCode() - ((AbstractRow)r2).getRowMeta().hashCode() : res;
        };
        this.rowStorage = rowStorage;
        sources.forEach(ds -> rowStorage.openStorage(ds.getRowMeta(), SubLedgerQueryContext.getCurrent().getBatchSize().intValue()));
    }

    public Iterator<Row> getIterator() {
        return new MyMergerIterator();
    }

    private class MyMergerIterator
    implements Iterator<Row> {
        private final TreeMap<Row, DataSet> rowTree;

        public MyMergerIterator() {
            this.rowTree = new TreeMap(OrderedDataSetMerger.this.comparator);
        }

        @Override
        public boolean hasNext() {
            return !this.rowTree.isEmpty() || OrderedDataSetMerger.this.sources.stream().anyMatch(DataSet::hasNext);
        }

        @Override
        public Row next() {
            Map.Entry<Row, DataSet> firstEntry;
            DataSet source;
            if (!this.hasNext()) {
                throw new IllegalStateException("iterator has come to the very end.");
            }
            if (this.rowTree.isEmpty()) {
                OrderedDataSetMerger.this.sources.stream().filter(DataSet::hasNext).forEach(sourceDS -> this.rowTree.put(this.persist((AbstractRow)sourceDS.next()), (DataSet)sourceDS));
            }
            if ((source = (firstEntry = this.rowTree.pollFirstEntry()).getValue()).hasNext()) {
                this.rowTree.put(this.persist((AbstractRow)source.next()), source);
            }
            return firstEntry.getKey();
        }

        private Row persist(AbstractRow row) {
            return new PersistedArrayRow(row.getRowMeta(), this.defaultConvertValues(row), false);
        }

        private Object[] defaultConvertValues(AbstractRow row) {
            Object[] storage = OrderedDataSetMerger.this.rowStorage.useOne(row.getRowMeta());
            int len = row.size();
            for (int i = 0; i < len; ++i) {
                storage[i] = row.get(i);
            }
            return storage;
        }
    }
}

