/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger.export;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDException;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.export.ExportProgress;
import kd.bos.mvc.report.ReportView;
import kd.bos.report.ReportList;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.model.Context;
import kd.fi.bd.model.JsonObjectAdapter;
import kd.fi.gl.report.export.ExportOption;
import kd.fi.gl.report.subledger.export.ExportAllProgressImpl;
import kd.fi.gl.report.subledger.export.SubLedgerExporter;

public class SubLedgerExportAllTask
extends AbstractTask {
    protected static final String REPORT_LIST_AP = "reportlistap";
    private ExportProgress exportProgress;

    public ExportProgress getExportProgress() {
        if (this.exportProgress == null) {
            this.exportProgress = new ExportAllProgressImpl(this.taskId);
        }
        return this.exportProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try {
            Map selectObj = (Map)SerializationUtils.deSerializeFromBase64((String)((String)map.get("selectobj")));
            List orgIdList = (List)selectObj.get("orgIdList");
            String pageId = (String)map.get("parentpageid");
            ReportView view = (ReportView)SessionManager.getCurrent().getView(pageId);
            ReportList list = (ReportList)view.getControl(REPORT_LIST_AP);
            String queyrparam = (String)map.get("queryparam");
            ReportQueryParam queryParam = (ReportQueryParam)SerializationUtils.deSerializeFromBase64((String)queyrparam);
            orgIdList.sort(Long::compareTo);
            Long[] orgs = orgIdList.toArray(new Long[0]);
            ExportOption exportOption = new ExportOption();
            exportOption.setSplitByOrg(false);
            exportOption.setExportProgress(this.getExportProgress());
            exportOption.setRecycleRowStorage(true);
            exportOption.setEntityID("gl_rpt_subledger");
            Context context = SubLedgerExporter.export(list, exportOption, queryParam.getFilter(), orgs);
            int total = Optional.ofNullable(context.query("totalCount")).map(Integer.class::cast).orElse(0);
            List urls = (List)context.query("downloadUrl");
            if (CollectionUtils.isNotEmpty((Collection)urls)) {
                HashMap<String, List> data = new HashMap<String, List>();
                data.put("downloadurl", urls);
                this.exportProgress.feedbackCustData(data);
            } else {
                this.exportProgress.feedbackCustData((Map)JsonObjectAdapter.getEmpty().registerContext("failReason", (Object)ResManager.loadKDString((String)"\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u5bfc\u51fa\u3002", (String)"ReportExportAllTask_2", (String)"fi-gl-formplugin", (Object[])new Object[0])).getSource());
            }
            this.exportProgress.feedbackProgress(total, total);
        }
        finally {
            if (this.exportProgress != null) {
                this.exportProgress.complete();
            }
        }
    }
}

