/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger.export.cms;

import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.entity.report.FilterInfo;
import kd.fi.gl.report.subledger.export.SubLedgerQueryContext;
import kd.fi.gl.report.subledger.export.SubLedgerRow;
import kd.fi.gl.report.subledger.export.cms.SubLedgerColumnManager;

public class MeasureUnitColumnManager
extends SubLedgerColumnManager {
    private boolean showMeasureUnitSummary = true;
    private static final String VCH_QTY = "vch_qty";
    private static final String VCH_PRICE = "vch_price";

    @Override
    public List<Field> getFields() {
        LinkedList<Field> res = new LinkedList<Field>();
        res.add(new Field("measureunit", (DataType)DataType.LongType));
        res.add(new Field("creditqty", (DataType)DataType.BigDecimalType));
        res.add(new Field("creditprice", (DataType)DataType.BigDecimalType));
        res.add(new Field("debitqty", (DataType)DataType.BigDecimalType));
        res.add(new Field("debitprice", (DataType)DataType.BigDecimalType));
        res.add(new Field("endqty", (DataType)DataType.BigDecimalType));
        res.add(new Field("endprice", (DataType)DataType.BigDecimalType));
        return res;
    }

    @Override
    public void addDimensionFields(List<String> theirs) {
        if (this.showMeasureUnitSummary) {
            theirs.add("measureunit");
        }
    }

    @Override
    public Set<String> getVoucherSelectors() {
        Set<String> res = super.getVoucherSelectors();
        res.add(String.join((CharSequence)"", "entries", ".", "measureunit", " ", "measureunit"));
        res.add(String.join((CharSequence)"", "entries", ".", "quantity", " ", VCH_QTY));
        res.add(String.join((CharSequence)"", "entries", ".", "price", " ", VCH_PRICE));
        return res;
    }

    @Override
    protected void fillVoucherRow(Row sourceRow, SubLedgerRow newRowToFill) {
        super.fillVoucherRow(sourceRow, newRowToFill);
        RowMeta rowMeta = newRowToFill.getRowMeta();
        newRowToFill.setValue(rowMeta.getFieldIndex("measureunit"), sourceRow.getBigDecimal("measureunit"));
        if ("1".equals(newRowToFill.getString("dc"))) {
            newRowToFill.setValue(rowMeta.getFieldIndex("debitqty"), sourceRow.getBigDecimal(VCH_QTY));
            newRowToFill.setValue(rowMeta.getFieldIndex("debitprice"), sourceRow.getBigDecimal(VCH_PRICE));
            newRowToFill.setValue(rowMeta.getFieldIndex("creditqty"), BigDecimal.ZERO);
            newRowToFill.setValue(rowMeta.getFieldIndex("creditprice"), BigDecimal.ZERO);
        } else {
            newRowToFill.setValue(rowMeta.getFieldIndex("debitqty"), BigDecimal.ZERO);
            newRowToFill.setValue(rowMeta.getFieldIndex("debitprice"), BigDecimal.ZERO);
            newRowToFill.setValue(rowMeta.getFieldIndex("creditqty"), sourceRow.getBigDecimal(VCH_QTY));
            newRowToFill.setValue(rowMeta.getFieldIndex("creditprice"), sourceRow.getBigDecimal(VCH_PRICE));
        }
    }

    @Override
    public Set<String> getBeginBalSelectors() {
        Set<String> res = super.getBeginBalSelectors();
        if (this.showMeasureUnitSummary) {
            res.add(String.join((CharSequence)"", "measureunit", " ", "measureunit"));
            res.add(String.join((CharSequence)"", "beginqty", " ", "endqty"));
        }
        return res;
    }

    @Override
    protected void fillBeginBalanceRow(Row sourceRow, SubLedgerRow newRowToFill) {
        super.fillBeginBalanceRow(sourceRow, newRowToFill);
        RowMeta rowMeta = newRowToFill.getRowMeta();
        if (this.showMeasureUnitSummary) {
            BigDecimal endQty;
            newRowToFill.setValue(rowMeta.getFieldIndex("measureunit"), sourceRow.getBigDecimal("measureunit"));
            newRowToFill.setValue(rowMeta.getFieldIndex("debitqty"), BigDecimal.ZERO);
            newRowToFill.setValue(rowMeta.getFieldIndex("creditqty"), BigDecimal.ZERO);
            if (((AbstractRow)sourceRow).getRowMeta().getFieldIndex("voucherid", false) != -1) {
                String accountDc = newRowToFill.getString(rowMeta.getFieldIndex("dc"));
                String vchDc = sourceRow.getString("dc");
                endQty = sourceRow.getBigDecimal(VCH_QTY).multiply(new BigDecimal(vchDc));
            } else {
                endQty = sourceRow.getBigDecimal("endqty");
            }
            newRowToFill.setValue(rowMeta.getFieldIndex("endqty"), endQty);
        }
    }

    @Override
    public Set<String> getYearBalSelectors() {
        Set<String> res = super.getYearBalSelectors();
        if (this.showMeasureUnitSummary) {
            res.add(String.join((CharSequence)"", "measureunit", " ", "measureunit"));
            res.add(String.join((CharSequence)"", "creditqty"));
            res.add(String.join((CharSequence)"", "yearcreditqty"));
            res.add(String.join((CharSequence)"", "debitqty"));
            res.add(String.join((CharSequence)"", "yeardebitqty"));
        }
        return res;
    }

    @Override
    protected void fillYearBalanceRow(Row sourceRow, SubLedgerRow newRowToFill) {
        super.fillYearBalanceRow(sourceRow, newRowToFill);
        RowMeta rowMeta = newRowToFill.getRowMeta();
        if (this.showMeasureUnitSummary) {
            newRowToFill.setValue(rowMeta.getFieldIndex("measureunit"), sourceRow.getBigDecimal("measureunit"));
            newRowToFill.setValue(rowMeta.getFieldIndex("debitqty"), sourceRow.getBigDecimal("yeardebitqty").subtract(sourceRow.getBigDecimal("debitqty")));
            newRowToFill.setValue(rowMeta.getFieldIndex("creditqty"), sourceRow.getBigDecimal("yearcreditqty").subtract(sourceRow.getBigDecimal("creditqty")));
        }
    }

    @Override
    public boolean enable(FilterInfo filterInfo) {
        SubLedgerQueryContext.QueryStateChart stateChart = SubLedgerQueryContext.getCurrent().getStateChart();
        boolean showQty = stateChart.showQty();
        this.showMeasureUnitSummary = stateChart.showQtySummary();
        return showQty;
    }
}

