/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger.export.cms;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.entity.report.FilterInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.report.subledger.OpAccountUtil;
import kd.fi.gl.report.subledger.SubLedgerCollector;
import kd.fi.gl.report.subledger.export.SubLedgerQueryContext;
import kd.fi.gl.report.subledger.export.SubLedgerRow;
import kd.fi.gl.report.subledger.export.cms.SubLedgerColumnManager;
import kd.fi.gl.report.subledger.export.worker.AbstractWorker;
import kd.fi.gl.util.MulCurReportUtil;

public class OpColumnManager
extends SubLedgerColumnManager {
    @Override
    public List<Field> getFields() {
        LinkedList<Field> res = new LinkedList<Field>();
        res.add(new Field("opaccount", (DataType)DataType.LongType));
        res.add(new Field("opacctname", (DataType)DataType.StringType));
        res.add(new Field("opassgrp", (DataType)DataType.LongType));
        return res;
    }

    @Override
    public void addDimensionFields(List<String> theirs) {
    }

    @Override
    public boolean enable(FilterInfo filterInfo) {
        return SubLedgerQueryContext.getCurrent().getStateChart().showOpAccount();
    }

    public static class OpVoucherWorker
    extends AbstractWorker<SubLedgerRow, SubLedgerRow> {
        private final Map<Long, SubLedgerCollector.VoucherEntity> vchIDIndexMap = new HashMap<Long, SubLedgerCollector.VoucherEntity>();
        private final Map<Long, SubLedgerCollector.VoucherEntry> entryIDIndexMap = new HashMap<Long, SubLedgerCollector.VoucherEntry>();
        private final SubLedgerQueryContext context = SubLedgerQueryContext.getCurrent();
        private final RowMeta rowMeta = this.context.getRowMeta();
        private final int dcIndex = this.rowMeta.getFieldIndex("dc");
        private final int orgIndex = this.rowMeta.getFieldIndex("org");
        private final int opAccountNameIndex = this.rowMeta.getFieldIndex("opacctname", false);
        private final int opAccountIndex = this.rowMeta.getFieldIndex("opaccount", false);
        private final int opAssgrpIndex = this.rowMeta.getFieldIndex("opassgrp", false);
        private final int creditLocalIndex = this.rowMeta.getFieldIndex("creditlocal");
        private final int debitLocalIndex = this.rowMeta.getFieldIndex("debitlocal");
        private final int creditForIndex = this.rowMeta.getFieldIndex("creditfor", false);
        private final int debitForIndex = this.rowMeta.getFieldIndex("debitfor", false);

        @Override
        public List<SubLedgerRow> process(List<SubLedgerRow> dataEntry) {
            super.process(dataEntry);
            List<Long> vchIDs = dataEntry.stream().filter(row -> "2".equals(row.getString("rowtype"))).map(row -> row.getLong("voucherid")).collect(Collectors.toList());
            if (OpAccountUtil.checkIsLargeVoucher(vchIDs)) {
                return dataEntry;
            }
            String mulCurType = this.context.getFilterInfo().getString("mulcur");
            try (DataSet vouSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_voucher", (String)MulCurReportUtil.replaceVchLocalAmountFields((String)"id,entries.account.masterid,entries.seq,entries.assgrp,entries.entrydc,entries.debitlocal,entries.creditlocal,entries.id fentryid", (String)mulCurType), (QFilter[])new QFilter("id", "in", vchIDs).toArray(), null);){
                for (Row row2 : vouSet) {
                    Long vouId = row2.getLong(0);
                    Long accId = row2.getLong(1);
                    Integer seq = row2.getInteger(2);
                    Long assgrpId = row2.getLong(3);
                    String dc = row2.getString(4);
                    Long entryID = row2.getLong("fentryid");
                    BigDecimal value = row2.getBigDecimal(5).subtract(row2.getBigDecimal(6));
                    SubLedgerCollector.VoucherEntry entry = new SubLedgerCollector.VoucherEntry(seq, accId, assgrpId, dc, value);
                    this.vchIDIndexMap.computeIfAbsent(vouId, k -> new SubLedgerCollector.VoucherEntity(vouId)).add(entry);
                    this.entryIDIndexMap.put(entryID, entry);
                }
            }
            LinkedList<SubLedgerRow> res = new LinkedList<SubLedgerRow>();
            dataEntry.forEach(row -> {
                if (!"2".equals(row.getString("rowtype"))) {
                    res.add((SubLedgerRow)((Object)row));
                    return;
                }
                Long vchID = row.getLong("voucherid");
                Long vchEntryID = row.getLong("fentryid");
                SubLedgerCollector.VoucherEntity voucherEntity = this.vchIDIndexMap.get(vchID);
                SubLedgerCollector.VoucherEntry vchEntry = this.entryIDIndexMap.get(vchEntryID);
                List<SubLedgerCollector.VoucherEntry> opAccountList = voucherEntity.getOpAccountList(vchEntry);
                opAccountList.sort(Comparator.comparingInt(SubLedgerCollector.VoucherEntry::getSeq));
                SubLedgerCollector.VoucherEntry lastEntry = opAccountList.size() > 0 ? opAccountList.get(opAccountList.size() - 1) : null;
                BigDecimal forAmountSummary = BigDecimal.ZERO;
                for (SubLedgerCollector.VoucherEntry opAccountEntry : opAccountList) {
                    boolean isLastOne = opAccountEntry.equals(lastEntry);
                    SubLedgerRow opAccountRow = row.copy();
                    Long orgID = row.getLong(this.orgIndex);
                    Long acctMID = opAccountEntry.getAccountId();
                    opAccountRow.setValue(this.opAccountIndex, acctMID);
                    opAccountRow.setValue(this.opAccountNameIndex, this.context.getAccountNumberFromCache(orgID, acctMID) + " " + this.context.getAccountNameFromCache(orgID, acctMID));
                    opAccountRow.setValue(this.opAssgrpIndex, opAccountEntry.getAssgrpId());
                    opAccountRow.setValue(this.creditLocalIndex, opAccountEntry.getOpCreditLocal());
                    opAccountRow.setValue(this.debitLocalIndex, opAccountEntry.getOpDebitLocal());
                    if (this.creditForIndex != -1 && this.debitForIndex != -1) {
                        BigDecimal rate;
                        BigDecimal opLocal;
                        BigDecimal local;
                        BigDecimal opFor;
                        BigDecimal forAmount;
                        if ("1".equals(row.get("dc"))) {
                            forAmount = row.getBigDecimal("debitfor");
                            opFor = null;
                            if (isLastOne) {
                                opFor = forAmount.subtract(forAmountSummary);
                            } else {
                                local = row.getBigDecimal("debitlocal");
                                opLocal = opAccountEntry.getOpDebitLocal();
                                rate = local.compareTo(BigDecimal.ZERO) == 0 ? null : opLocal.divide(local, RoundingMode.CEILING);
                                opFor = rate == null ? BigDecimal.ZERO : forAmount.multiply(rate);
                                forAmountSummary = forAmountSummary.add(opFor);
                            }
                            opAccountRow.setValue(this.debitForIndex, opFor);
                            opAccountRow.setValue(this.creditForIndex, BigDecimal.ZERO);
                        } else {
                            forAmount = row.getBigDecimal("creditfor");
                            opFor = null;
                            if (isLastOne) {
                                opFor = forAmount.subtract(forAmountSummary);
                            } else {
                                local = row.getBigDecimal("creditlocal");
                                opLocal = opAccountEntry.getOpCreditLocal();
                                rate = local.compareTo(BigDecimal.ZERO) == 0 ? null : opLocal.divide(local, RoundingMode.CEILING);
                                opFor = rate == null ? BigDecimal.ZERO : forAmount.multiply(rate);
                                forAmountSummary = forAmountSummary.add(opFor);
                            }
                            opAccountRow.setValue(this.debitForIndex, BigDecimal.ZERO);
                            opAccountRow.setValue(this.creditForIndex, opFor);
                        }
                    }
                    res.add(opAccountRow);
                }
            });
            return res;
        }

        @Override
        public boolean isEnable() {
            return SubLedgerQueryContext.getCurrent().getStateChart().showOpAccount();
        }
    }
}

