/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger.export.cms;

import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.entity.report.FilterInfo;
import kd.fi.bd.rate.ExchangeRate;
import kd.fi.bd.rate.IRateCalculator;
import kd.fi.gl.report.subledger.export.SubLedgerQueryContext;
import kd.fi.gl.report.subledger.export.SubLedgerRow;
import kd.fi.gl.report.subledger.export.cms.SubLedgerColumnManager;
import kd.fi.gl.report.subledger.export.worker.SubLedgerSummaryWorker;

public class ReportCurrencyColumn
extends SubLedgerColumnManager {
    private final Long currencyRpt;

    public ReportCurrencyColumn() {
        this.currencyRpt = this.context.getFilterInfo().getLong("currencyrpt");
    }

    @Override
    public List<Field> getFields() {
        LinkedList<Field> res = new LinkedList<Field>();
        res.add(new Field("endrpt", (DataType)DataType.BigDecimalType));
        res.add(new Field("creditrpt", (DataType)DataType.BigDecimalType));
        res.add(new Field("debitrpt", (DataType)DataType.BigDecimalType));
        res.add(new Field("currencyrptid", (DataType)DataType.LongType));
        return res;
    }

    @Override
    protected void fillBeginBalanceRow(Row sourceRow, SubLedgerRow newRowToFill) {
        super.fillBeginBalanceRow(sourceRow, newRowToFill);
        newRowToFill.setValue(this.context.getRowMeta().getFieldIndex("currencyrptid"), this.currencyRpt);
    }

    @Override
    protected void fillYearBalanceRow(Row sourceRow, SubLedgerRow newRowToFill) {
        super.fillYearBalanceRow(sourceRow, newRowToFill);
        newRowToFill.setValue(this.context.getRowMeta().getFieldIndex("currencyrptid"), this.currencyRpt);
    }

    @Override
    protected void fillVoucherRow(Row sourceRow, SubLedgerRow newRowToFill) {
        super.fillVoucherRow(sourceRow, newRowToFill);
        newRowToFill.setValue(this.context.getRowMeta().getFieldIndex("currencyrptid"), this.currencyRpt);
    }

    @Override
    public void addDimensionFields(List<String> theirs) {
    }

    @Override
    public boolean enable(FilterInfo filterInfo) {
        assert (SubLedgerQueryContext.getCurrent().getStateChart().queryForeignCurrency());
        return SubLedgerQueryContext.getCurrent().getStateChart().showReportCurrency();
    }

    public static final class ReportAmountWorker
    extends SubLedgerSummaryWorker {
        private int creditRptIndex;
        private int debitRptIndex;
        private int endRptIndex;
        private int rptCurrencyScale = -1;

        @Override
        public void consumeGoods(SubLedgerRow current, SubLedgerRow nextDetailRow) {
            ExchangeRate rate = (ExchangeRate)this.context.rateCache.getUnchecked((Object)nextDetailRow.getLong("basecurrency"));
            IRateCalculator rateCalculator = rate.getRateType().getRateCalculator();
            BigDecimal endRpt = rateCalculator.calLocAmount(rate.getValue(), nextDetailRow.getBigDecimal(this.endLocalIndex), this.rptCurrencyScale);
            BigDecimal debitRpt = rateCalculator.calLocAmount(rate.getValue(), nextDetailRow.getBigDecimal(this.debitLocalIndex), this.rptCurrencyScale);
            BigDecimal creditRpt = rateCalculator.calLocAmount(rate.getValue(), nextDetailRow.getBigDecimal(this.creditLocalIndex), this.rptCurrencyScale);
            nextDetailRow.setValue(this.endRptIndex, endRpt);
            nextDetailRow.setValue(this.debitRptIndex, debitRpt);
            nextDetailRow.setValue(this.creditRptIndex, creditRpt);
        }

        @Override
        public boolean needConsumeNext(SubLedgerRow currentProduct, SubLedgerRow nextGoods) {
            return true;
        }

        @Override
        public boolean isEnable() {
            boolean isEnabled = this.context.getStateChart().showReportCurrency();
            if (isEnabled) {
                this.rptCurrencyScale = this.context.getCurrencyFromCache(this.context.getFilterInfo().getLong("currencyrpt")).getInt("amtprecision");
                this.creditRptIndex = this.rowMeta.getFieldIndex("creditrpt");
                this.debitRptIndex = this.rowMeta.getFieldIndex("debitrpt");
                this.endRptIndex = this.rowMeta.getFieldIndex("endrpt");
            }
            return isEnabled;
        }

        @Override
        public SubLedgerRow createNextProduct(SubLedgerRow preSumProduct, SubLedgerRow nextGoods) {
            return null;
        }
    }
}

