/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger.export.source;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.entity.report.FilterInfo;
import kd.fi.gl.report.subledger.export.SubLedgerQueryContext;
import kd.fi.gl.report.subledger.export.cms.SubLedgerColumnManager;
import kd.fi.gl.report.subledger.export.source.ExportDimVchQuery;

public class BaseBuilder {
    final SubLedgerQueryContext context = SubLedgerQueryContext.getCurrent();
    final Long[] orgs;
    final FilterInfo filterInfo = this.context.getFilterInfo();

    public BaseBuilder(Long[] orgs) {
        this.orgs = orgs;
        assert (orgs.length == 1);
    }

    String getSelectField(Function<SubLedgerColumnManager, ? extends Set<String>> selectorsSupplier) {
        HashSet selectors = new HashSet(16);
        SubLedgerQueryContext.getCurrent().getCms().stream().map(selectorsSupplier).forEach(selectors::addAll);
        return String.join((CharSequence)", ", selectors);
    }

    DataSet wrapperAccountNumberCompare(DataSet oldDS) {
        return oldDS.map((MapFunction)new ExportDimVchQuery.AccountNumOnLevelMapper(oldDS.getRowMeta(), "accountmasterid", "accountnumber"));
    }

    static class CustomCompareString
    implements Comparable<CustomCompareString> {
        private final String innerStr;
        private final Comparator<Object> acctNumComparator;

        CustomCompareString(String innerStr, Comparator<Object> acctNumComparator) {
            if (innerStr == null) {
                innerStr = "";
            }
            this.innerStr = innerStr;
            this.acctNumComparator = acctNumComparator;
        }

        @Override
        public int compareTo(CustomCompareString other) {
            if (other == null) {
                return 1;
            }
            return this.acctNumComparator.compare(this, other);
        }

        public String toString() {
            return this.innerStr;
        }

        public int hashCode() {
            return this.innerStr.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof CustomCompareString) {
                return this.innerStr.equalsIgnoreCase(((CustomCompareString)obj).innerStr);
            }
            return false;
        }
    }
}

