/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger.export.worker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import kd.bos.algo.RowMeta;
import kd.fi.gl.report.subledger.export.SubLedgerQueryContext;
import kd.fi.gl.report.subledger.export.SubLedgerRow;
import kd.fi.gl.report.subledger.export.cms.SubLedgerColumnManager;
import kd.fi.gl.report.subledger.export.worker.AbstractSummaryWorker;

public abstract class SubLedgerSummaryWorker
extends AbstractSummaryWorker<SubLedgerRow, SubLedgerRow> {
    private List<String> baseDimensionColumns;
    private List<String> copyFields;
    private static final List<String> baseCopyFields = Arrays.asList("orgname", "accountname", "basecurrency", "accountmasterid");
    protected final SubLedgerQueryContext context = SubLedgerQueryContext.getCurrent();
    protected final SubLedgerQueryContext.QueryStateChart stateChart = this.context.getStateChart();
    protected final RowMeta rowMeta = this.context.getRowMeta();
    protected final int dcIndex = this.rowMeta.getFieldIndex("dc");
    protected final int localRateIndex = this.rowMeta.getFieldIndex("localrate", false);
    protected final int rowTypeIndex = this.rowMeta.getFieldIndex("rowtype");
    protected final int detailCountIndex = this.rowMeta.getFieldIndex("detailcount");
    protected final int creditLocalIndex = this.rowMeta.getFieldIndex("creditlocal");
    protected final int debitLocalIndex = this.rowMeta.getFieldIndex("debitlocal");
    protected final int endLocalIndex = this.rowMeta.getFieldIndex("endlocal");
    protected final int creditForIndex = this.rowMeta.getFieldIndex("creditfor", false);
    protected final int debitForIndex = this.rowMeta.getFieldIndex("debitfor", false);
    protected final int endForIndex = this.rowMeta.getFieldIndex("endfor", false);
    protected final boolean isShowQty = this.context.getStateChart().showQty();
    protected final boolean isShowQtySum = this.context.getStateChart().showQtySummary();
    protected final boolean isShowRpt = this.context.getStateChart().showReportCurrency();
    protected final int creditQtyIndex = this.rowMeta.getFieldIndex("creditqty", false);
    protected final int debitQtyIndex = this.rowMeta.getFieldIndex("debitqty", false);
    protected final int endQtyIndex = this.rowMeta.getFieldIndex("endqty", false);
    protected final int creditPriceIndex = this.rowMeta.getFieldIndex("creditprice", false);
    protected final int debitPriceIndex = this.rowMeta.getFieldIndex("debitprice", false);
    protected final int endPriceIndex = this.rowMeta.getFieldIndex("endprice", false);

    @Override
    public void consumeGoods(SubLedgerRow current, SubLedgerRow nextDetailRow) {
        current.setValue(this.debitLocalIndex, current.getBigDecimal(this.debitLocalIndex).add(nextDetailRow.getBigDecimal(this.debitLocalIndex)));
        current.setValue(this.creditLocalIndex, current.getBigDecimal(this.creditLocalIndex).add(nextDetailRow.getBigDecimal(this.creditLocalIndex)));
        if (this.debitForIndex != -1 && this.creditForIndex != -1) {
            current.setValue(this.debitForIndex, current.getBigDecimal(this.debitForIndex).add(nextDetailRow.getBigDecimal(this.debitForIndex)));
            current.setValue(this.creditForIndex, current.getBigDecimal(this.creditForIndex).add(nextDetailRow.getBigDecimal(this.creditForIndex)));
        }
        if (this.isShowQtySum) {
            current.setValue(this.debitQtyIndex, current.getBigDecimal(this.debitQtyIndex).add(nextDetailRow.getBigDecimal(this.debitQtyIndex)));
            current.setValue(this.creditQtyIndex, current.getBigDecimal(this.creditQtyIndex).add(nextDetailRow.getBigDecimal(this.creditQtyIndex)));
        }
        current.setValue(this.detailCountIndex, current.getInteger(this.detailCountIndex) + 1);
    }

    protected final List<String> getDimensionColumns() {
        if (this.baseDimensionColumns == null) {
            this.baseDimensionColumns = new LinkedList<String>();
            for (SubLedgerColumnManager cm : SubLedgerQueryContext.getCurrent().getCms()) {
                cm.addDimensionFields(this.baseDimensionColumns);
            }
        }
        return this.baseDimensionColumns;
    }

    protected final List<String> getCopyFields() {
        if (this.copyFields == null) {
            this.copyFields = new ArrayList<String>(baseCopyFields);
            this.copyFields.addAll(this.getDimensionColumns());
            if (this.context.getStateChart().showReportCurrency()) {
                this.copyFields.add("currencyrptid");
            }
        }
        return this.copyFields;
    }

    protected boolean isBaseDimensionMatched(SubLedgerRow currentProduct, SubLedgerRow nextGoods) {
        List<String> baseDims = this.getDimensionColumns();
        return baseDims.stream().allMatch(column -> {
            Object o1 = currentProduct.get((String)column);
            Object o2 = nextGoods.get((String)column);
            if (o1 == null || o2 == null) {
                this.logger.warn(String.format("%s caught empty base dimension with cur[%s] next[%s].", new Object[]{this.getClass().getSimpleName(), currentProduct, nextGoods}));
                throw new IllegalStateException("caught empty base dimension.");
            }
            return Objects.equals(o1, o2);
        });
    }

    @Override
    public boolean isEnable() {
        return true;
    }
}

