/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger.export.worker;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.gl.report.subledger.export.SubLedgerQueryContext;
import kd.fi.gl.report.subledger.export.SubLedgerRow;
import kd.fi.gl.report.subledger.export.worker.SubLedgerSummaryWorker;
import kd.fi.gl.util.GLApp;

public class YearBalanceSummaryWorker
extends SubLedgerSummaryWorker {
    private final RowMeta rowMeta = SubLedgerQueryContext.getCurrent().getRowMeta();
    private final int debitLocalIndex = this.rowMeta.getFieldIndex("debitlocal");
    private final int creditLocalIndex = this.rowMeta.getFieldIndex("creditlocal");
    private BigDecimal debitLocal = BigDecimal.ZERO;
    private BigDecimal creditLocal = BigDecimal.ZERO;
    private BigDecimal debitFor = BigDecimal.ZERO;
    private BigDecimal creditFor = BigDecimal.ZERO;
    private BigDecimal debitQty = BigDecimal.ZERO;
    private BigDecimal creditQty = BigDecimal.ZERO;
    private boolean isBaseDimensionChanged = false;

    @Override
    public boolean needThrowNextGoods(SubLedgerRow goods) {
        return "5".equals(goods.getString("rowtype"));
    }

    @Override
    protected void beforeOutputCurrentProduct(SubLedgerRow current) {
        super.beforeOutputCurrentProduct(current);
        this.debitLocal = current.getBigDecimal(this.debitLocalIndex);
        this.creditLocal = current.getBigDecimal(this.creditLocalIndex);
        if (this.debitForIndex != -1 && this.creditForIndex != -1) {
            this.debitFor = current.getBigDecimal(this.debitForIndex);
            this.creditFor = current.getBigDecimal(this.creditForIndex);
        }
        if (this.isShowQtySum) {
            this.debitQty = current.getBigDecimal(this.debitQtyIndex);
            this.creditQty = current.getBigDecimal(this.creditQtyIndex);
        }
        if (this.isBaseDimensionChanged) {
            this.debitLocal = BigDecimal.ZERO;
            this.creditLocal = BigDecimal.ZERO;
            this.debitFor = BigDecimal.ZERO;
            this.creditFor = BigDecimal.ZERO;
            this.debitQty = BigDecimal.ZERO;
            this.creditQty = BigDecimal.ZERO;
            this.isBaseDimensionChanged = false;
        }
    }

    @Override
    public void consumeGoods(SubLedgerRow current, SubLedgerRow nextDetailRow) {
        super.consumeGoods(current, nextDetailRow);
        String rowType = nextDetailRow.getString("rowtype");
        int detailCount = 0;
        if ("4".equals(rowType)) {
            detailCount = nextDetailRow.getInteger(this.detailCountIndex);
        }
        current.setValue(this.detailCountIndex, detailCount);
    }

    @Override
    public boolean needConsumeNext(SubLedgerRow currentProduct, SubLedgerRow nextGoods) {
        return super.needConsumeNext(currentProduct, nextGoods) && ("4".equals(nextGoods.getString("rowtype")) || "5".equals(nextGoods.getString("rowtype")));
    }

    @Override
    public boolean needOutputCurrent(SubLedgerRow currentProduct, SubLedgerRow nextGoods) {
        if (currentProduct == null) {
            return false;
        }
        this.isBaseDimensionChanged = !this.isBaseDimensionMatched(currentProduct, nextGoods);
        boolean isPeriodMatched = Objects.equals(currentProduct.get("period").toString(), nextGoods.get("period").toString());
        return this.isBaseDimensionChanged || !isPeriodMatched;
    }

    @Override
    public SubLedgerRow createNextProduct(SubLedgerRow preSumProduct, SubLedgerRow nextGoods) {
        String rowType = nextGoods.getString("rowtype");
        if (!"4".equals(rowType) && !"5".equals(rowType)) {
            return null;
        }
        Long periodID = nextGoods.getLong("period");
        DynamicObject nextPeriod = this.context.getPeriodFromCache(periodID);
        if (nextPeriod.getInt("periodnumber") == 1) {
            this.debitLocal = BigDecimal.ZERO;
            this.creditLocal = BigDecimal.ZERO;
            this.debitFor = BigDecimal.ZERO;
            this.creditFor = BigDecimal.ZERO;
            this.debitQty = BigDecimal.ZERO;
            this.creditQty = BigDecimal.ZERO;
        }
        SubLedgerRow newCurrent = new SubLedgerRow("5");
        this.getCopyFields().forEach(column -> newCurrent.setValue(this.rowMeta.getFieldIndex(column), nextGoods.get((String)column)));
        newCurrent.setValue(this.rowMeta.getFieldIndex("period"), periodID);
        Date periodEndDate = nextPeriod.getDate("enddate");
        Date queryEndDate = this.context.getEndDate();
        newCurrent.setValue(this.rowMeta.getFieldIndex("bookeddate"), queryEndDate.compareTo(periodEndDate) < 0 ? queryEndDate : periodEndDate);
        newCurrent.setValue(this.rowMeta.getFieldIndex("desc"), ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1", (String)"AbstractSummaryWorker_3", (String)GLApp.instance.reportModule(), (Object[])new Object[0]));
        newCurrent.setValue(this.debitLocalIndex, this.debitLocal);
        newCurrent.setValue(this.creditLocalIndex, this.creditLocal);
        if (this.debitForIndex != -1 && this.creditForIndex != -1) {
            newCurrent.setValue(this.debitForIndex, this.debitFor);
            newCurrent.setValue(this.creditForIndex, this.creditFor);
        }
        if (this.isShowQtySum) {
            newCurrent.setValue(this.debitQtyIndex, this.debitQty);
            newCurrent.setValue(this.creditQtyIndex, this.creditQty);
        }
        newCurrent.setValue(this.rowMeta.getFieldIndex("dc"), "1");
        return newCurrent;
    }
}

