/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subsidiary;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.CacheHint;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.model.Context;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.TimerFactory;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.enums.SubsiDiarySortFieldEnum;
import kd.fi.gl.enums.basedata.AssistValueType;
import kd.fi.gl.enums.basedata.CurrencyReportEnum;
import kd.fi.gl.model.schema.VoucherTypeSchema;
import kd.fi.gl.model.schema.report.SubsidiarySchema;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.report.fiilter.ReportGroupFilter;
import kd.fi.gl.report.subsidiary.AssistBalanceQuery;
import kd.fi.gl.report.subsidiary.DetailQuery;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.MulCurReportUtil;
import kd.fi.gl.util.SubsiDiaryHelper;

public class SubsidiaryDetailQuery
implements DetailQuery<Map<String, HashSet<Object>>> {
    private static final Log LOG = LogFactory.getLog(SubsidiaryDetailQuery.class);
    private static final String startPeriod = "startperiod";
    private static final String period = "period";
    private static final String endPeriod = "endperiod";
    private static final String account = "account";
    private static final String billStatus = "billstatus";
    private static final String TYPE_TXT = "type_txt";
    private static final String TYPE_BASE_STRING = "type_base_str";
    private static final String TYPE_BASE_LONG = "type_base_long";
    private long currLocal = 0L;
    private final List<String> sortExtFields = new ArrayList<String>(4);
    private final List<String> sortExtVoucherFields = new ArrayList<String>(4);
    private final List<String> allFlexFieldSelected = new ArrayList<String>(4);
    private final List<String> txtFlexFieldSelected = new ArrayList<String>(2);
    private String accountNameField = "name";
    private FilterInfo filterInfo = null;
    private AssistBalanceQuery assistBalanceQuery;
    private Context context;
    private DataSet queryPeriod;
    private List<String> COMASSIST_BAL_LIST = new ArrayList<String>(8);
    private List<String> COMASSIST_VOUCHER_LIST = new ArrayList<String>(8);
    private List<String> COMASSIST_LIST = new ArrayList<String>(8);
    List<Tuple2<String, Set<Long>>> COMASSIST_VALUE_LIST = new ArrayList<Tuple2<String, Set<Long>>>(16);
    private int detailSize = -1;
    private final TimerFactory.Timer timer = TimerFactory.getTimer(this.getClass());
    private QueryParamRpt queryParamRpt;
    private static final String[] SUMBY = new String[]{"debitlocal", "creditlocal"};
    private static final String[] uinitField = new String[]{"currencycolumn", "localrate", "measureunit", "basecurrency", "enddate", "periodyear", "dc", "voucherid", "fentryid", "accountnumber", "accountname", "accountdc", "period", "datefield", "bizdate", "vouchernumber", "desc", "debitfor", "creditfor", "endfor", "debitlocal", "creditlocal", "endlocal", "debitqty", "creditqty", "endqty", "rowtype", "debitprice", "creditprice"};
    private static final String[] uinit_gperiodField = new String[]{"currencycolumn", "localrate", "measureunit", "basecurrency", "enddate", "periodyear", "dc", "voucherid", "fentryid", "accountnumber", "accountname", "accountdc", "period", "datefield", "bizdate", "vouchernumber", "desc", "debitfor", "creditfor", "endfor", "debitlocal", "creditlocal", "endlocal", "debitqty", "creditqty", "endqty", "rowtype", "debitprice", "creditprice"};
    private static final String[] gfieldField = new String[]{"accountnumber", "accountname", "accountdc", "currencycolumn", "measureunit"};
    private static final String[] gperiodField = new String[]{"period", "enddate", "periodyear", "accountnumber", "accountname", "accountdc", "currencycolumn", "localrate", "measureunit"};
    private static final String[] byearbalField = new String[]{"accountnumber", "currencycolumn", "localrate", "measureunit", "yeardebitfor", "yearcreditfor", "yeardebitlocal", "yearcreditlocal", "yeardebitqty", "yearcreditqty"};

    @Override
    public DataSet query(ReportQueryParam param, Map<String, HashSet<Object>> obj, Context context) {
        this.context = context;
        return obj != null ? this.query(param, obj) : GLUtil.getEmptyDS(this.getClass());
    }

    @Override
    public int getDetailDsSize() {
        return this.detailSize;
    }

    @Override
    public int getDetailLimit() {
        return BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"fi.gl.report.subsidiary.voucherlimit", (int)100000);
    }

    private DataSet query(ReportQueryParam param, Map<String, HashSet<Object>> obj) {
        this.preInit(param, obj);
        this.setComassist(param);
        this.timer.time("very begin init");
        this.context.registerContext(SubsidiarySchema.schema.Key_isExport, (Object)SubsiDiaryHelper.isExport((FilterInfo)this.filterInfo));
        this.context.registerContext(SubsidiarySchema.schema.Key_baseCurrencyID, (Object)this.currLocal);
        this.context.registerContext(SubsidiarySchema.schema.Key_assTypeSel, this.allFlexFieldSelected);
        this.context.registerContext(SubsidiarySchema.schema.Key_sumBy, (Object)SUMBY);
        Tuple2<DataSet, DataSet> balanceAndAsistDS = this.queryBalanceAndAssist();
        DataSet balanceData = (DataSet)balanceAndAsistDS.t1;
        this.timer.time("balance query");
        Set<Long> hgIds = this.collectHgIdSet(balanceData);
        this.context.registerContext(SubsidiarySchema.schema.Key_hgIDs, hgIds);
        this.timer.time("hgSet init");
        DataSet queryVoucher = this.queryVoucher(this.filterInfo, hgIds);
        this.timer.time("voucher query");
        this.detailSize = queryVoucher.copy().count("voucherid", false);
        queryVoucher = queryVoucher.limit(0, this.getDetailLimit());
        this.timer.time("voucher query copy");
        DataSet beginYearBal = this.queryYearTotalBalance(hgIds);
        this.timer.time("beginYearBal query");
        balanceData = this.handleBalanceDS(balanceData);
        this.timer.time("balanceData handle");
        ThreeTuple<DataSet, DataSet, DataSet> tuple = this.checkBoxFilter(this.filterInfo, queryVoucher, balanceData, beginYearBal);
        queryVoucher = (DataSet)tuple.item1;
        balanceData = (DataSet)tuple.item2;
        beginYearBal = (DataSet)tuple.item3;
        this.timer.time("check box filter");
        List fieldsList = GLUtil.getDataSetCols((DataSet)balanceData);
        fieldsList.remove("beginlocal");
        fieldsList.remove("endlocal");
        fieldsList.add("beginlocal endlocal");
        balanceData = balanceData.select(fieldsList.toArray(new String[fieldsList.size()]));
        if (SubsiDiaryHelper.isExport((FilterInfo)this.filterInfo)) {
            queryVoucher = this.joinAssistDs(queryVoucher, (DataSet)balanceAndAsistDS.t2);
            beginYearBal = this.joinAssistDs(beginYearBal, (DataSet)balanceAndAsistDS.t2);
        }
        DataSet begin = this.createBeginBalance(balanceData, queryVoucher);
        this.context.registerContext(SubsidiarySchema.schema.Key_beginBalanceCacheID, (Object)begin.copy().cache(CacheHint.getDefault()).getCacheId());
        this.timer.time("create beginBalance");
        DataSet result = this.setGroupData(queryVoucher, begin, beginYearBal, this.filterInfo, this.queryPeriod.copy());
        this.timer.time("group and union all DS");
        this.queryPeriod.close();
        balanceData.close();
        return result;
    }

    private DataSet joinAssistDs(DataSet dsToAdd, DataSet assistDs) {
        String[] leftSelector = (String[])Arrays.stream(dsToAdd.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        String[] rightSelector = (String[])Arrays.stream(assistDs.getRowMeta().getFields()).map(Field::getAlias).filter(field -> !"assgrpid".equals(field)).toArray(String[]::new);
        return dsToAdd.leftJoin(assistDs).on("assgrpid", "assgrpid").select(leftSelector, rightSelector).finish();
    }

    private DataSet handleBalanceDS(DataSet balanceData) {
        List balList = ReportUtils.getSetField((DataSet)balanceData);
        balList.removeIf(x -> x.equals("currencycolumn"));
        balList.add(this.isBaseCur(this.currLocal, "currencycolumn", this.filterInfo));
        return balanceData.select(balList.toArray(new String[0])).addField("0.0", "localrate");
    }

    private DataSet queryYearTotalBalance(Set<Long> hgIDs) {
        DynamicObject prePeriod = GLUtil.getPreviousPeriod((Object)this.filterInfo.getLong(startPeriod));
        int preYear = 0;
        if (prePeriod != null) {
            preYear = prePeriod.getInt("periodyear");
        }
        String beginYearBalSel = String.format("account,account.number accountnumber,account.%s accountname,account.dc accountdc,measureunit,yeardebitfor yeardebitfor, yearcreditfor yearcreditfor, yeardebitlocal, yearcreditlocal, yeardebitqty, yearcreditqty,debitfor, debitlocal, debitqty, creditfor, creditlocal, creditqty,assgrp assgrpid", this.accountNameField);
        beginYearBalSel = this.setMulCurrencyFields(beginYearBalSel, "gl_balance");
        if (!"basecurrency".equals(this.filterInfo.getString("currency"))) {
            beginYearBalSel = beginYearBalSel + ",currency currencycolumn";
        }
        DataSet beginYearBal = this.getBalance(beginYearBalSel, hgIDs);
        if ("basecurrency".equals(this.filterInfo.getString("currency"))) {
            beginYearBal = beginYearBal.addField(this.currLocal + "L", "currencycolumn");
        }
        List beginYearList = ReportUtils.getSetField((DataSet)beginYearBal);
        beginYearList.remove("yeardebitfor");
        beginYearList.remove("yeardebitlocal");
        beginYearList.remove("yearcreditfor");
        beginYearList.remove("yearcreditlocal");
        beginYearList.remove("yeardebitqty");
        beginYearList.remove("yearcreditqty");
        beginYearList.add("yeardebitfor-debitfor yeardebitfor");
        beginYearList.add("yeardebitlocal-debitlocal yeardebitlocal");
        beginYearList.add("yearcreditfor-creditfor yearcreditfor");
        beginYearList.add("yearcreditlocal-creditlocal yearcreditlocal");
        beginYearList.add("yeardebitqty-debitqty yeardebitqty");
        beginYearList.add("yearcreditqty-creditqty yearcreditqty");
        beginYearList.addAll(this.COMASSIST_LIST);
        beginYearList.addAll(this.sortExtFields);
        beginYearBal = this.addNullComAssistField(beginYearBal);
        beginYearBal = beginYearBal.select(beginYearList.toArray(new String[beginYearList.size()]));
        beginYearBal = beginYearBal.addField(preYear + "", "periodyear").addField("0.0", "localrate");
        return beginYearBal;
    }

    private Set<Long> collectHgIdSet(DataSet balanceDS) {
        HashSet<Long> hgSets = new HashSet<Long>();
        balanceDS.copy().forEachRemaining(row -> hgSets.add(row.getLong("assgrpid")));
        return hgSets;
    }

    private void setComassist(ReportQueryParam param) {
        Map customParam = param.getCustomParam();
        if (!this.filterInfo.getBoolean("showcomassist")) {
            customParam.put("ComAssistEntityListStr", null);
            return;
        }
        DynamicObject acctTableDyn = this.filterInfo.getDynamicObject("accounttable");
        if (acctTableDyn == null) {
            return;
        }
        DynamicObjectCollection accTableColl = acctTableDyn.getDynamicObjectCollection("comassistentry");
        ArrayList<Object[]> entityList = new ArrayList<Object[]>(8);
        int i = 1;
        for (DynamicObject row : accTableColl) {
            String valType = row.getString("valuesourcetype");
            if (valType == null) continue;
            String entityId = null;
            ILocaleString locaName = row.getLocaleString("comassistname");
            if (AssistValueType.isAssistData((String)valType)) {
                entityId = "bos_assistantdata_detail";
            } else if (row.getDynamicObject("valuesource") != null) {
                DynamicObject valTypeObj = row.getDynamicObject("valuesource");
                entityId = valTypeObj.getString("number");
            }
            String fieldKey = "comassist" + i;
            if (this.filterInfo.containProp(fieldKey)) {
                DynamicObjectCollection coll = this.filterInfo.getDynamicObjectCollection(fieldKey);
                String fieldKeyId = fieldKey + "id";
                if (coll != null) {
                    Set ids = coll.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
                    this.COMASSIST_VALUE_LIST.add((Tuple2<String, Set<Long>>)new Tuple2((Object)fieldKey, ids));
                } else {
                    this.COMASSIST_VALUE_LIST.add((Tuple2<String, Set<Long>>)new Tuple2((Object)fieldKey, new HashSet(8)));
                }
                this.COMASSIST_BAL_LIST.add(fieldKey + " " + fieldKeyId);
                this.COMASSIST_VOUCHER_LIST.add("entries." + fieldKey + " " + fieldKeyId);
                this.COMASSIST_LIST.add(fieldKeyId);
                entityList.add(new Object[]{fieldKeyId, entityId, locaName});
            }
            ++i;
        }
        String entityStr = SerializationUtils.toJsonString(entityList);
        customParam.put("ComAssistEntityListStr", entityStr);
    }

    private String addComassFieldStr(List<String> fieldList) {
        if (fieldList == null || fieldList.isEmpty()) {
            return "";
        }
        String comassistBalStr = fieldList.toString();
        comassistBalStr = comassistBalStr.substring(1, comassistBalStr.length() - 1);
        return "," + comassistBalStr;
    }

    private Tuple2<DataSet, DataSet> queryBalanceAndAssist() {
        String balanceSel = String.format("account,account.number accountnumber,account.%s accountname,account.dc accountdc, currency currencycolumn,measureunit, debitfor debitfor, creditfor creditfor, debitlocal, creditlocal, beginfor endfor, beginlocal, endlocal, beginqty endqty, assgrp assgrpid", this.accountNameField);
        balanceSel = this.setMulCurrencyFields(balanceSel, "gl_balance");
        balanceSel = balanceSel + this.addComassFieldStr(this.COMASSIST_BAL_LIST);
        AssistBalanceQuery query = this.assistBalanceQuery;
        if (SubsiDiaryHelper.isExport((FilterInfo)this.filterInfo)) {
            DataSet balanceDS = query.query(this.getParam(this.filterInfo, null), balanceSel, new String[]{AssistBalanceQuery.CustomFlexProperty.ofNoneDetailAlia((String)"assval")});
            StringBuilder builder = new StringBuilder("assgrpid");
            Map customFlexProperties = query.getCustomFlexProperties();
            customFlexProperties.values().forEach(flexProperty -> builder.append(", ").append(flexProperty.getInnerPropAlia(AssistBalanceQuery.CustomFlexProperty.ofNoneDetailAlia((String)"assval"))));
            DataSet assistDS = balanceDS.copy().groupBy(builder.toString().split(", ")).finish().select(builder.toString());
            return new Tuple2((Object)balanceDS, (Object)assistDS);
        }
        DataSet balanceDS = query.query(this.getParam(this.filterInfo, null), balanceSel, new String[0]);
        return new Tuple2((Object)balanceDS, null);
    }

    private DataSet getBalance(String balanceSel, Set<Long> assgrpIds) {
        AccountBookInfo defaultBook;
        long orgId = this.filterInfo.getLong("org");
        Set childOrgId = SubsiDiaryHelper.getChildOrgId((FilterInfo)this.filterInfo);
        childOrgId.add(orgId);
        long bookTypeId = this.filterInfo.getLong("booktype");
        if (bookTypeId == 0L && (defaultBook = AccSysUtil.getDefaultBookFromAccSys((Long)((Long)this.filterInfo.getDynamicObject("org").getPkValue()))) != null) {
            bookTypeId = defaultBook.getBookTypeId();
        }
        return BalanceQueryExecutor.getInstance().getBalance(balanceSel, childOrgId.toArray(new Long[0]), bookTypeId, this.filterInfo.getLong("accounttable"), this.filterInfo.getLong(startPeriod), this.filterInfo.getLong(startPeriod), this.getParam(this.filterInfo, assgrpIds));
    }

    private QueryParam getParam(FilterInfo filterInfo, Set<Long> hgIDs) {
        String currencyVal;
        QueryParam param = new QueryParam();
        param.setSubstractPL(filterInfo.getBoolean("issubstractpl"));
        param.setAccountVersionPeriodId(filterInfo.getLong(endPeriod));
        if (filterInfo.getDynamicObjectCollection(account) != null) {
            Set accountIds = filterInfo.getDynamicObjectCollection(account).stream().map(DataEntityBase::getPkValue).map(Long.class::cast).collect(Collectors.toSet());
            param.setAccountFilter(new QFilter("id", "in", accountIds));
        } else {
            Set flexField = filterInfo.getFlexFilterItems().stream().map(FilterItemInfo::getPropName).collect(Collectors.toSet());
            Set accountIds = ReportUtils.getAccIdsByFlexFieldsForBalance(Collections.singletonList(filterInfo.getLong("org")), (long)filterInfo.getLong("accounttable"), flexField, (long)filterInfo.getLong(endPeriod));
            param.setAccountFilter(new QFilter("id", "in", (Object)accountIds));
        }
        param.setOnlyLeafAcctBal(true);
        if (filterInfo.getDynamicObjectCollection("measureunits") != null) {
            DynamicObjectCollection unitsDynColl = filterInfo.getDynamicObjectCollection("measureunits");
            ArrayList<Long> uList = new ArrayList<Long>(unitsDynColl.size());
            for (DynamicObject dyn : unitsDynColl) {
                uList.add(dyn.getLong("id"));
            }
            param.setMeasureUnitIds(uList.toArray(new Long[0]));
        }
        if (!CurrencyReportEnum.baseCurrency((String)(currencyVal = filterInfo.getString("currency"))) && !CurrencyReportEnum.allCurrency((String)currencyVal)) {
            param.setCurrencyIds(new Long[]{Long.parseLong(filterInfo.getString("currency"))});
        } else if (CurrencyReportEnum.baseCurrency((String)currencyVal)) {
            param.setAddAmountFilter(false);
        }
        if (hgIDs != null) {
            if (hgIDs.isEmpty()) {
                hgIDs = Sets.newHashSet((Object[])new Long[]{0L});
            }
            param.setAssGrpIds(hgIDs);
        }
        param.getCustomFilter().addAll(this.queryParamRpt.getComAssistFiltersForBal());
        return param;
    }

    private void preInit(ReportQueryParam param, Map<String, HashSet<Object>> selectAssistValueGroup) {
        FilterInfo customFilterInfo = param.getFilter().clone();
        List clonedFilterItems = param.getFilter().getFlexFilterItems().stream().filter(Objects::nonNull).map(FilterItemInfo::clone).collect(Collectors.toList());
        customFilterInfo.setFlexFilterItems(clonedFilterItems);
        if (!SubsiDiaryHelper.isExportAll((FilterInfo)customFilterInfo)) {
            Map<String, FilterItemInfo> collect = clonedFilterItems.stream().collect(Collectors.toMap(FilterItemInfo::getPropName, filterItemInfo -> filterItemInfo));
            selectAssistValueGroup.forEach((flexField, assistValue) -> {
                if (Objects.equals(assistValue.iterator().next(), -1L)) {
                    assistValue.remove(-1L);
                    assistValue.add(0L);
                }
                ((FilterItemInfo)collect.get(flexField)).setValue(assistValue);
            });
        }
        customFilterInfo.setCommFilter(param.getFilter().getCommFilter());
        customFilterInfo.setFastFilter(param.getFilter().getFastFilter());
        customFilterInfo.setQFilters(param.getFilter().getQFilters());
        customFilterInfo.setOtherEntryFilter(param.getFilter().getOtherEntryFilter());
        customFilterInfo.setTableHeadFilterItems(param.getFilter().getTableHeadFilterItems());
        this.filterInfo = customFilterInfo;
        this.assistBalanceQuery = new AssistBalanceQuery(this.filterInfo);
        Map customFlexProperties = this.assistBalanceQuery.getCustomFlexProperties();
        if (SubsiDiaryHelper.isExport((FilterInfo)this.filterInfo)) {
            for (FilterItemInfo flexItem : param.getFilter().getFlexFilterItems()) {
                this.allFlexFieldSelected.add(flexItem.getPropName());
                if (!AssistValueType.isManualTxt((String)((AssistBalanceQuery.CustomFlexProperty)customFlexProperties.get((Object)flexItem.getPropName())).property.getValueType())) continue;
                this.txtFlexFieldSelected.add(flexItem.getPropName());
            }
        }
        List itemInfoList = this.filterInfo.getFilterItems();
        for (FilterItemInfo filterItemInfo2 : itemInfoList) {
            String sortFieldName;
            String propName = filterItemInfo2.getPropName();
            if (!propName.startsWith("sort") || SubsiDiarySortFieldEnum.isIn((String)(sortFieldName = propName.substring(4))) || "entries.entrydc".equals(sortFieldName)) continue;
            if (sortFieldName.startsWith("entries")) {
                String fieldName = sortFieldName.substring("entries.".length());
                this.sortExtFields.add(fieldName);
                this.sortExtVoucherFields.add(sortFieldName + " " + fieldName);
                continue;
            }
            this.sortExtFields.add(sortFieldName);
            this.sortExtVoucherFields.add(sortFieldName);
        }
        AccountBookInfo book = AccSysUtil.getBookFromAccSys((long)this.filterInfo.getLong("org"), (long)this.filterInfo.getLong("booktype"));
        this.currLocal = MulCurReportUtil.getMulCurrency((String)this.filterInfo.getString("mulcur"), (long)this.filterInfo.getLong("org"), (long)this.filterInfo.getLong("booktype"), (long)book.getBaseCurrencyId());
        this.accountNameField = GLUtil.getAcctNameBySysParam((Long)this.filterInfo.getLong("org"));
        this.queryPeriod = this.queryPeriod(this.filterInfo);
        this.queryParamRpt = new QueryParamRpt(this.filterInfo, "gl_rpt_subsidiaryledger");
    }

    private String[] addDateAndVchNumberAndCustomSort(String[] otherOrderBy, FilterInfo filterInfo) {
        List itemInfoList = filterInfo.getFilterItems();
        List<String> otherOrderByList = Arrays.asList(otherOrderBy);
        ArrayList<String> orderByList = new ArrayList<String>(8);
        orderByList.addAll(otherOrderByList);
        boolean hasCustomSort = false;
        for (FilterItemInfo filterItemInfo : itemInfoList) {
            String propName = filterItemInfo.getPropName();
            if (!propName.startsWith("sort")) continue;
            propName = propName.substring("sort".length());
            String orderField = propName + " " + filterItemInfo.getValue();
            if (propName.startsWith("entries")) {
                if ("entrydc".equals(propName = propName.substring("entries.".length()))) {
                    propName = "dc";
                }
                orderField = propName + " " + filterItemInfo.getValue();
            }
            orderByList.remove(propName);
            orderByList.add(orderField);
            hasCustomSort = true;
        }
        if (!hasCustomSort) {
            orderByList.add("datefield");
            orderByList.add("vouchernumber");
        } else {
            orderByList.remove("vouchernumber");
            orderByList.add("vouchernumber");
        }
        return orderByList.toArray(new String[0]);
    }

    private DataSet queryVoucher(FilterInfo filterInfo, Set<Long> hgIds) {
        Object[] acctFilters = this.filterVoucher(filterInfo, hgIds);
        this.context.registerContext(SubsidiarySchema.schema.Key_vchFilterStr, (Object)GLUtil.serializeQFilter((QFilter[])acctFilters));
        String voucherSel = "id voucherid,entries.id fentryid,bookeddate datefield,period,entries.currency currencycolumn,entries.localrate localrate,entries.measureunit measureunit,entries.entrydc entrydc,bizdate, vouchertype, billno,entries.edescription desc,entries.debitori debitfor,entries.creditori creditfor,entries.debitlocal debitlocal,entries.creditlocal creditlocal,entries.quantity quantity, entries.assgrp assgrpid, entries.account accountid,entries.price price";
        LOG.info("report query filter as: " + StringUtils.join((Object[])acctFilters));
        voucherSel = this.setMulCurrencyFields(voucherSel, "gl_voucher");
        voucherSel = voucherSel + this.addComassFieldStr(this.COMASSIST_VOUCHER_LIST) + this.addComassFieldStr(this.sortExtVoucherFields);
        this.timer.time("voucher query prepare");
        DataSet queryVoucher = VoucherQueryUtils.queryDataSet((String)voucherSel, (QFilter[])acctFilters, null, (int)(this.getDetailLimit() + 1));
        this.timer.time("voucher query sql");
        queryVoucher = this.addVchTypeField(queryVoucher);
        queryVoucher = this.addPeriodField(queryVoucher);
        queryVoucher = this.addAccountFields(queryVoucher);
        this.timer.time("voucher query add fields");
        String selLocal = this.isBaseCur(this.currLocal, "currencycolumn", filterInfo) + ", localrate, measureunit," + this.currLocal + "  basecurrency, enddate, periodyear, dc, voucherid, fentryid,accountnumber, accountname, accountdc, period, datefield, bizdate,typename+' '+billno vouchernumber, desc, debitfor, creditfor, 0.0 endfor, debitlocal,creditlocal, 0.0 endlocal, case when entrydc='1' then quantity else 0.0 end as debitqty,case when entrydc='-1' then quantity else 0.0 end as creditqty, 0.0 endqty, assgrpid,typenumber, billno, case when entrydc='1' then price else 0.0 end as debitprice,case when entrydc='-1' then price else 0.0 end as creditprice";
        selLocal = selLocal + this.addComassFieldStr(this.COMASSIST_LIST) + this.addComassFieldStr(this.sortExtFields);
        queryVoucher = queryVoucher.select(selLocal).addField("2", "rowtype");
        return queryVoucher;
    }

    private String setMulCurrencyFields(String fieldSel, String tableName) {
        if ("gl_voucher".equals(tableName)) {
            fieldSel = MulCurReportUtil.mulCurVoucherAmountToLocalAlias((String)fieldSel, (String)this.queryParamRpt.getMulCur());
        } else if ("gl_balance".equals(tableName)) {
            fieldSel = MulCurReportUtil.mulCurBalAmountToLocalAlias((String)fieldSel, (String)this.queryParamRpt.getMulCur());
        }
        return fieldSel;
    }

    private DataSet addAccountFields(DataSet queryVoucher) {
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)this.filterInfo.getLong(endPeriod), (String)"bd_period");
        QFilter atFilter = new QFilter("startdate", "<=", (Object)period.getDate("enddate"));
        atFilter.and(new QFilter("enddate", ">=", (Object)period.getDate("enddate")));
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(atFilter);
        DataSet acctNameNumberDs = AccountUtils.queryAccountDataSet((long)this.filterInfo.getLong("org"), (long)this.filterInfo.getLong("accounttable"), (String)("masterid,number," + this.accountNameField), filters);
        DataSet acctIDMasterIDDs = QueryServiceHelper.queryDataSet((String)(this.getClass() + ".acctQuery"), (String)"bd_accountview", (String)"id, masterid, dc", (QFilter[])new QFilter("id", "in", (Object)SubsiDiaryHelper.getAcctIDs((FilterInfo)this.filterInfo)).toArray(), null);
        DataSet acctDs = acctIDMasterIDDs.leftJoin(acctNameNumberDs).on("masterid", "masterid").select(new String[]{"masterid", "number", "id", "dc", this.accountNameField}).finish().addField("dc", "accountdc");
        return queryVoucher.join(acctDs).on("accountid", "id").select(GLUtil.getDataSetCols((DataSet)queryVoucher).toArray(new String[0]), new String[]{"number accountnumber", this.accountNameField + " accountname", "dc", "accountdc"}).finish();
    }

    private DataSet addVchTypeField(DataSet vchDS) {
        DataSet vchTypeDS = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "#vchTypeName"), (String)VoucherTypeSchema.INSTANCE.entity, (String)"id, name, number", (QFilter[])new QFilter[]{QFilter.of((String)"1=1", (Object[])new Object[0])}, null);
        return vchDS.leftJoin(vchTypeDS).on("vouchertype", "id").select(GLUtil.getDataSetCols((DataSet)vchDS).toArray(new String[0]), new String[]{"name typename", "number typenumber"}).finish();
    }

    private DataSet addPeriodField(DataSet vchDs) {
        return vchDs.leftJoin(this.queryPeriod.copy()).on(period, period).select(GLUtil.getDataSetCols((DataSet)vchDs).toArray(new String[0]), new String[]{"enddate", "periodyear"}).finish();
    }

    private DataSet createBeginBalance(DataSet balanceData, DataSet queryVoucher) {
        DataSet begin = null;
        String[] fileds = new String[]{"currencycolumn", "localrate", "measureunit", this.currLocal + " basecurrency", "null enddate", "null periodyear", "'0' dc", "0L voucherid", "0L fentryid", "accountnumber", "accountname", "accountdc", "null period", "null datefield", "null bizdate", "null vouchernumber", String.format(ResManager.loadKDString((String)"%1$s\u671f\u521d\u4f59\u989d%2$s", (String)"SubsiDiaryRightQueryRpt_0", (String)"fi-gl-report", (Object[])new Object[0]), "'", "' desc"), "0.0 debitfor", "0.0 creditfor", "0.0 endfor", "0.0 debitlocal", "0.0 creditlocal", "0.0 endlocal", "0.0 debitqty", "0.0 creditqty", "0.0 endqty", "null typenumber", "null billno", "0.0 debitprice", "0.0 creditprice"};
        String[] resulSel = this.addFlexFields(fileds);
        String[] unionFiled = new String[]{"currencycolumn", "0.0 localrate", "measureunit", this.currLocal + " basecurrency", "null enddate", "null periodyear", "case when endlocal>0 then '1' when endlocal<0 then '-1' else '0' end as dc", "0L voucherid", "0L fentryid", "accountnumber", "accountname", "accountdc", "null period", "null datefield", "null bizdate", "null vouchernumber", String.format(ResManager.loadKDString((String)"%1$s\u671f\u521d\u4f59\u989d%2$s", (String)"SubsiDiaryRightQueryRpt_0", (String)"fi-gl-report", (Object[])new Object[0]), "'", "' desc"), "0.0 debitfor", "0.0 creditfor", "endfor", "0.0 debitlocal", "0.0 creditlocal", "endlocal", "0.0 debitqty", "0.0 creditqty", "endqty", "null typenumber", "null billno", "0.0 debitprice", "0.0 creditprice"};
        String[] unionSel = this.addFlexFields(unionFiled);
        begin = queryVoucher.copy().select(resulSel);
        begin = begin.union(balanceData.select(unionSel));
        begin = begin.groupBy(this.addFlexFields(new String[]{"accountnumber", "accountname", "accountdc", "currencycolumn", "measureunit"})).sum("endfor").sum("endlocal").sum("endqty").finish().select(unionSel).addField("1", "rowtype");
        begin = this.addNullComAssistField(begin);
        return begin;
    }

    private DataSet queryPeriod(FilterInfo filterInfo) {
        QFilter filter1 = new QFilter("id", ">=", (Object)filterInfo.getLong(startPeriod));
        QFilter filter2 = new QFilter("id", "<=", (Object)filterInfo.getLong(endPeriod));
        QFilter filter3 = new QFilter("periodtype", "=", (Object)filterInfo.getLong("periodtype"));
        DataSet periods = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_period", (String)"id period, enddate, periodyear", (QFilter[])new QFilter[]{filter1, filter2, filter3}, (String)"enddate");
        return periods;
    }

    private ThreeTuple<DataSet, DataSet, DataSet> checkBoxFilter(FilterInfo filterInfo, DataSet queryVoucher, DataSet balanceData, DataSet beginYearBal) {
        if (!filterInfo.getBoolean("showqty")) {
            queryVoucher = queryVoucher.updateField("measureunit", "0L");
            beginYearBal = beginYearBal.updateField("localrate", "0.0").updateField("measureunit", "0L");
            balanceData = balanceData.updateField("localrate", "0.0").updateField("measureunit", "0L");
        }
        if (filterInfo.getBoolean("balancezero")) {
            List fields = ReportUtils.getSetField((DataSet)queryVoucher);
            String[] groupByFields = "accountnumber,accountname,currencycolumn,measureunit,assgrpid".split(",");
            DataSet joinBalSet = this.joinGroupBySet(balanceData, groupByFields);
            queryVoucher = queryVoucher.join(joinBalSet, JoinType.INNER).on("accountnumber", "accountnumber").on("accountname", "accountname").on("currencycolumn", "currencycolumn").on("measureunit", "measureunit").on("assgrpid", "assgrpid").select(fields.toArray(new String[0])).finish();
        }
        return new ThreeTuple((Object)queryVoucher, (Object)balanceData, (Object)beginYearBal);
    }

    private DataSet joinGroupBySet(DataSet dataSet, String[] groupByFields) {
        DataSet resultSet = dataSet.groupBy(groupByFields).finish();
        return resultSet;
    }

    private String isBaseCur(long curLocId, String curKey, FilterInfo filterInfo) {
        if (CurrencyReportEnum.baseCurrency((String)filterInfo.getString("currency"))) {
            return curLocId + "L " + curKey;
        }
        if (!CurrencyReportEnum.allCurrency((String)filterInfo.getString("currency"))) {
            return filterInfo.getString("currency") + "L " + curKey;
        }
        return curKey;
    }

    public DataSet setGroupData(DataSet queryData, DataSet begin, DataSet beginYearBal, FilterInfo filterInfo, DataSet queryPeriods) {
        queryData = queryData.addField("2", "rowtype").select(this.addSortField(this.addAssType(this.getGroupField("uinit"))));
        begin = begin.addField("1", "rowtype").select(this.addSortField(this.addAssType(this.getGroupField("uinit"))));
        DataSet union = queryData.union(begin);
        String[] groupField = this.getGroupField("gfield");
        DataSet periodSet = queryPeriods.join(union.groupBy(this.addFlexFields(groupField)).finish(), JoinType.CROSS).select(new String[]{period, "enddate", "periodyear"}, this.addFlexFields(groupField)).finish();
        DataSet periodAcct = union.groupBy(this.addFlexFields(new String[]{"accountnumber", "accountname", "accountdc", "currencycolumn", "measureunit", period})).sum("debitfor").sum("creditfor").sum("debitlocal").sum("creditlocal").sum("debitqty").sum("creditqty").finish().filter("period!=null").orderBy(new String[]{period});
        JoinDataSet joinPeriodSet = periodSet.join(periodAcct, JoinType.LEFT).on("accountnumber", "accountnumber").on("accountname", "accountname").on("accountdc", "accountdc").on("currencycolumn", "currencycolumn").on("measureunit", "measureunit").on(period, period);
        for (String assType : this.allFlexFieldSelected) {
            joinPeriodSet.on(assType, assType);
        }
        periodSet = joinPeriodSet.select(this.addFlexFields(new String[]{period, "enddate datefield", "periodyear", "accountnumber", "accountname", "accountdc", "currencycolumn", "measureunit"}), new String[]{this.currLocal + " basecurrency", "null dc", "null voucherid", "null fentryid", "null bizdate", "null vouchernumber", String.format(ResManager.loadKDString((String)"%1$s\u672c\u671f\u5408\u8ba1%2$s", (String)"SubsiDiaryRightQueryRpt_1", (String)"fi-gl-report", (Object[])new Object[0]), "'", "' desc"), "debitfor", "creditfor", "0.0 endfor", "debitlocal", "creditlocal", "0.0 endlocal", "debitqty", "creditqty", "0.0 endqty", "null typenumber", "null billno"}).finish().addField("3", "rowtype");
        periodSet = this.addNullComAssistField(periodSet);
        periodSet = periodSet.select(this.addSortField(this.addAssType(new String[]{"currencycolumn", "0.0 localrate", "measureunit", "basecurrency", "periodyear", "dc", "voucherid", "fentryid", "accountnumber", "accountname", "accountdc", period, "datefield", "bizdate", "vouchernumber", String.format(ResManager.loadKDString((String)"%1$s\u672c\u671f\u5408\u8ba1%2$s", (String)"SubsiDiaryRightQueryRpt_1", (String)"fi-gl-report", (Object[])new Object[0]), "'", "' desc"), "debitfor", "creditfor", "endfor", "debitlocal", "creditlocal", "endlocal", "debitqty", "creditqty", "endqty", "rowtype", "0.0 debitprice", "0.0 creditprice"})));
        DataSet yearSet = periodSet.removeFields(new String[]{"rowtype", "desc"}).addField("4", "rowtype").addField(String.format(ResManager.loadKDString((String)"%1$s\u672c\u5e74\u7d2f\u8ba1%2$s", (String)"SubsiDiaryRightQueryRpt_2", (String)"fi-gl-report", (Object[])new Object[0]), "'", "'"), "desc");
        beginYearBal = beginYearBal.addField("0", "rowtype");
        beginYearBal = beginYearBal.select(this.addAssType(new String[]{"currencycolumn", "measureunit", "null basecurrency", "0.0 localrate", "periodyear", "null dc", "null voucherid", "null fentryid", "accountnumber", "accountname", "accountdc", "null period", "null datefield", "null bizdate", "null vouchernumber", "null desc", "yeardebitfor debitfor", "yearcreditfor creditfor", "0.0 endfor", "yeardebitlocal debitlocal", "yearcreditlocal creditlocal", "0.0 endlocal", "yeardebitqty debitqty", "yearcreditqty creditqty", "0.0 endqty", "rowtype", "null typenumber", "null billno"}));
        yearSet = yearSet.select(this.addAssType(this.addSortField(new String[]{"currencycolumn", "measureunit", "basecurrency", "0.0 localrate", "periodyear", "dc", "voucherid", "fentryid", "accountnumber", "accountname", "accountdc", period, "datefield", "bizdate", "vouchernumber", "desc", "debitfor", "creditfor", "endfor", "debitlocal", "creditlocal", "endlocal", "debitqty", "creditqty", "endqty", "rowtype"})));
        yearSet = yearSet.union(beginYearBal).orderBy(this.addAssType(new String[]{"accountnumber", "accountname", "accountdc", "currencycolumn", "measureunit", "rowtype", period}));
        beginYearBal.close();
        String caseWhen = this.addAssTypeCase("case when cast(PreRowValue(accountnumber) as string)==accountnumber and cast(PreRowValue(accountname) as string)==accountname and cast(PreRowValue(accountdc) as string)==accountdc and cast(PreRowValue(currencycolumn) as long)==currencycolumn and cast(PreRowValue(measureunit) as long)==measureunit ");
        String preRowSel = caseWhen + "and cast(PreRowValue(periodyear) as integer)==periodyear then cast(PreRowValue() as decimal)";
        yearSet = yearSet.select(this.addSortField(this.addAssType(new String[]{"currencycolumn", "localrate", "measureunit", "basecurrency", "periodyear", "dc", "voucherid", "fentryid", "accountnumber", "accountname", "accountdc", period, "datefield", "bizdate", "vouchernumber", String.format(ResManager.loadKDString((String)"%1$s\u672c\u5e74\u7d2f\u8ba1%2$s", (String)"SubsiDiaryRightQueryRpt_2", (String)"fi-gl-report", (Object[])new Object[0]), "'", "' desc"), preRowSel + "+debitfor else debitfor end as debitfor", preRowSel + "+creditfor else creditfor end as creditfor", "endfor", preRowSel + "+debitlocal else debitlocal end as debitlocal", preRowSel + "+creditlocal else creditlocal end as creditlocal", "endlocal", preRowSel + "+debitqty else debitqty end as debitqty", preRowSel + "+creditqty else creditqty end as creditqty", "endqty", "rowtype", "0.0 debitprice", "0.0 creditprice"}))).filter("rowtype!=0");
        union = union.orderBy(this.addDateAndVchNumberAndCustomSort(this.addAssType(new String[]{"accountnumber", "accountname", "accountdc", "currencycolumn", "measureunit", period, "rowtype"}), filterInfo));
        String group = caseWhen + "then cast(PreRowValue() as decimal) ";
        union = union.select(this.addSortField(this.addAssType(new String[]{"currencycolumn", "localrate", "measureunit", "basecurrency", "periodyear", "dc", "voucherid", "fentryid", "accountnumber", "accountname", "accountdc", period, "datefield", "bizdate", "vouchernumber", "desc", "debitfor", "creditfor", group + "+debitfor-creditfor else endfor end as endfor", "debitlocal", "creditlocal", group + "+debitlocal-creditlocal else endlocal end as endlocal", "debitqty", "creditqty", group + "+debitqty-creditqty else endqty end as endqty", "rowtype", "debitprice", "creditprice"})));
        union = union.union(periodSet).union(yearSet);
        union = union.orderBy(this.addDateAndVchNumberAndCustomSort(this.addAssType(new String[]{"accountnumber", "accountname", "accountdc", "currencycolumn", "measureunit", period, "rowtype"}), filterInfo));
        String preCon = caseWhen + "and rowtype!=1 and rowtype!=2 then cast(PreRowValue() as decimal) ";
        String basecurrencyStr = this.currLocal + " basecurrency";
        if (filterInfo.getBoolean("nozeroperiod")) {
            basecurrencyStr = "basecurrency";
        }
        union = union.select(this.addAssType(new String[]{"currencycolumn", "localrate", "measureunit", basecurrencyStr, "periodyear", "dc", "voucherid", "fentryid", "accountnumber", "accountname", "accountdc", period, "datefield", "bizdate", "vouchernumber", "desc", "debitfor", "creditfor", preCon + "else endfor end as endfor", "debitlocal", "creditlocal", preCon + "else endlocal end as endlocal", "debitqty", "creditqty", preCon + "else endqty end as endqty", "rowtype", "debitprice oridebitprice", "creditprice oricreditprice"}));
        if (filterInfo.getBoolean("showqty")) {
            String[] fieldNames;
            List fields = ReportUtils.getSetField((DataSet)union);
            for (String fieldName : fieldNames = "debit,credit,end".split(",")) {
                String casePrice = "";
                if (Objects.equals(fieldName, "end")) {
                    casePrice = "case when " + fieldName + "qty!=0 and " + fieldName + "for!=0 then abs(" + fieldName + "for/" + fieldName + "qty) when " + fieldName + "local!=0 and " + fieldName + "qty!=0 then abs(" + fieldName + "local/" + fieldName + "qty) else 0 end as " + fieldName + "price";
                    if (CurrencyReportEnum.baseCurrency((String)filterInfo.getString("currency"))) {
                        casePrice = "case when " + fieldName + "local!=0 and " + fieldName + "qty!=0 then abs(" + fieldName + "local/" + fieldName + "qty) when " + fieldName + "qty!=0 and " + fieldName + "for!=0 then abs(" + fieldName + "for/" + fieldName + "qty) else 0 end as " + fieldName + "price";
                    }
                } else {
                    casePrice = "case when rowtype!=2 and " + fieldName + "qty!=0 and " + fieldName + "for!=0 then abs(" + fieldName + "for/" + fieldName + "qty) when rowtype!=2 and " + fieldName + "local!=0 and " + fieldName + "qty!=0 then abs(" + fieldName + "local/" + fieldName + "qty) when rowtype=2 then ori" + fieldName + "price else 0 end as " + fieldName + "price";
                    if (CurrencyReportEnum.baseCurrency((String)filterInfo.getString("currency"))) {
                        casePrice = "case when rowtype!=2 and " + fieldName + "local!=0 and " + fieldName + "qty!=0 then abs(" + fieldName + "local/" + fieldName + "qty) when rowtype!=2 and " + fieldName + "qty!=0 and " + fieldName + "for!=0 then abs(" + fieldName + "for/" + fieldName + "qty) when rowtype=2 then ori" + fieldName + "price else 0 end as " + fieldName + "price";
                    }
                }
                fields.add(casePrice);
            }
            union = union.select(fields.toArray(new String[0]));
        }
        periodSet.close();
        yearSet.close();
        return this.doCheckBoxFilter(union);
    }

    private DataSet doCheckBoxFilter(DataSet ds) {
        ArrayList<String> assTypeList = new ArrayList<String>();
        assTypeList.addAll(this.allFlexFieldSelected);
        assTypeList.add("accountnumber");
        assTypeList.add("currencycolumn");
        assTypeList.add("measureunit");
        ReportGroupFilter filter = new ReportGroupFilter(assTypeList);
        if (this.filterInfo.getBoolean("nodisplayforzero")) {
            filter.addFilterFunction(new ReportGroupFilter.IGroupFilterFunction(){

                @Override
                public boolean needRemain(Row row) {
                    return true;
                }

                @Override
                public boolean isCharacteristicRow(Row row) {
                    return 2 == row.getInteger("rowtype");
                }
            });
        }
        if (this.filterInfo.getBoolean("balancezero")) {
            HashSet<String> checkFields = new HashSet<String>();
            checkFields.add("endlocal");
            if (this.queryParamRpt.isQueryCurrency()) {
                checkFields.add("endfor");
            }
            if (this.queryParamRpt.isShowQty()) {
                checkFields.add("endqty");
            }
            final long endPeriod = this.filterInfo.getLong(endPeriod);
            RowMeta rowMeta = ds.getRowMeta();
            final List endFieldsIdxes = checkFields.stream().map(field -> rowMeta.getFieldIndex(field, false)).filter(i -> i != -1).collect(Collectors.toList());
            filter.addFilterFunction(new ReportGroupFilter.IGroupFilterFunction(){

                @Override
                public boolean needRemain(Row row) {
                    return endFieldsIdxes.stream().anyMatch(f -> row.getBigDecimal(f.intValue()) != null && row.getBigDecimal(f.intValue()).compareTo(BigDecimal.ZERO) != 0);
                }

                @Override
                public boolean isCharacteristicRow(Row row) {
                    return row.getInteger("rowtype") == 3 && row.getLong(SubsidiaryDetailQuery.period) == endPeriod;
                }
            });
        }
        ds = filter.doFilter(ds);
        if (this.filterInfo.getBoolean("nozeroperiod")) {
            ds = ds.filter("basecurrency != null");
        }
        return ds;
    }

    private DataSet addNullComAssistField(DataSet dataSet) {
        for (String comAssistField : this.COMASSIST_LIST) {
            dataSet = dataSet.addField("0L", comAssistField);
        }
        for (String field : this.sortExtFields) {
            dataSet = dataSet.addField("null ", field);
        }
        return dataSet;
    }

    private String addAssTypeCase(String sel) {
        StringBuilder selBuilder = new StringBuilder(sel);
        for (String ass : this.allFlexFieldSelected) {
            if (this.txtFlexFieldSelected.contains(ass)) {
                selBuilder.append("and cast(PreRowValue(").append(ass).append(") as String)==").append(ass).append(" ");
                continue;
            }
            selBuilder.append("and cast(PreRowValue(").append(ass).append(") as long)==").append(ass).append(" ");
        }
        sel = selBuilder.toString();
        return sel;
    }

    private String addComAssistCase(String sel) {
        StringBuilder selBuilder = new StringBuilder(sel);
        for (String ass : this.COMASSIST_LIST) {
            selBuilder.append("and cast(PreRowValue(").append(ass).append(") as long)==").append(ass).append(" ");
        }
        sel = selBuilder.toString();
        return sel;
    }

    private String[] addAssType(String[] sel) {
        List<String> list = Arrays.asList(sel);
        ArrayList<String> assTypeList = new ArrayList<String>();
        assTypeList.addAll(this.allFlexFieldSelected);
        assTypeList.addAll(list);
        assTypeList.addAll(this.COMASSIST_LIST);
        assTypeList.addAll(this.sortExtFields);
        String[] resultSel = assTypeList.toArray(new String[0]);
        return resultSel;
    }

    private String[] addFlexFields(String[] sel) {
        List<String> list = Arrays.asList(sel);
        ArrayList<String> assTypeList = new ArrayList<String>();
        assTypeList.addAll(this.allFlexFieldSelected);
        assTypeList.addAll(list);
        String[] resultSel = assTypeList.toArray(new String[0]);
        return resultSel;
    }

    public List<String> nullToZero(List<String> fields) {
        ArrayList<String> cList = new ArrayList<String>(fields.size());
        String nFields = "currencycolumn,measureunit,basecurrency,debitfor,creditfor,endfor,debitlocal,creditlocal,endlocal,debitqty,creditqty,endqty";
        Iterator<String> iterator = fields.iterator();
        while (iterator.hasNext()) {
            String field;
            String cfield = field = iterator.next();
            if (nFields.contains(field)) {
                cfield = "case when " + field + "==null then 0 else " + field + " end as " + field;
            }
            cList.add(cfield);
        }
        return cList;
    }

    private String[] getGroupField(String groupSel) {
        String[] group = null;
        switch (groupSel) {
            case "uinit": {
                group = uinitField;
                break;
            }
            case "uinit_gperiod": {
                group = uinit_gperiodField;
                break;
            }
            case "gfield": {
                group = gfieldField;
                break;
            }
            case "gperiod": {
                group = gperiodField;
                break;
            }
            case "byearbal": {
                group = byearbalField;
            }
        }
        return group;
    }

    private String[] addComAssistField(String[] group) {
        List<String> list = Arrays.asList(group);
        ArrayList<String> addComAssistList = new ArrayList<String>(list);
        addComAssistList.addAll(this.COMASSIST_LIST);
        return addComAssistList.toArray(new String[0]);
    }

    private String[] addSortField(String[] group) {
        List<String> list = Arrays.asList(group);
        ArrayList<String> addedSortList = new ArrayList<String>(list);
        addedSortList.add("typenumber");
        addedSortList.add("billno");
        return addedSortList.toArray(new String[0]);
    }

    private QFilter[] filterVoucher(FilterInfo filter, Set<Long> hgIds) {
        Map deFilterMap;
        String currencyVal;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DynamicObject periodFrom = filter.getDynamicObject(startPeriod);
        DynamicObject periodTo = filter.getDynamicObject(endPeriod);
        QFilter fperiod = new QFilter(period, ">=", periodFrom.getPkValue()).and(new QFilter(period, "<=", periodTo.getPkValue()));
        filters.add(fperiod);
        String[] fBillStatus = "B,C".split(",");
        if (filter.getBoolean("issubstractpl")) {
            filters.add(new QFilter("sourcetype", "!=", (Object)"1"));
        }
        QFilter billFilter = new QFilter(billStatus, "in", (Object)fBillStatus);
        filters.add(billFilter);
        QFilter orgf = new QFilter("org", "=", (Object)filter.getLong("org"));
        filters.add(orgf);
        filters.add(new QFilter("booktype", "=", (Object)filter.getLong("booktype")));
        filters.add(new QFilter("entries.account", "in", (Object)SubsiDiaryHelper.getAcctIDs((FilterInfo)filter)));
        filters.add(new QFilter("entries.assgrp", "in", hgIds));
        if (filter.getString("currency") != null && !CurrencyReportEnum.baseCurrency((String)(currencyVal = filter.getString("currency"))) && !CurrencyReportEnum.allCurrency((String)currencyVal)) {
            QFilter fcurrency = new QFilter("entries.currency", "=", (Object)Long.parseLong(filter.getString("currency")));
            filters.add(fcurrency);
        }
        if (filter.getDynamicObjectCollection("measureunits") != null) {
            DynamicObjectCollection unitsDynColl = filter.getDynamicObjectCollection("measureunits");
            ArrayList<Long> ids = new ArrayList<Long>(unitsDynColl.size());
            for (DynamicObject dyn : unitsDynColl) {
                ids.add(dyn.getLong("id"));
            }
            QFilter funits = new QFilter("entries.measureunit", "in", (Object)ids.toArray());
            filters.add(funits);
        }
        if ((deFilterMap = filter.getCommFilters()).get("gl_voucher") != null) {
            filters.addAll((Collection)deFilterMap.get("gl_voucher"));
        }
        filters.addAll(this.queryParamRpt.getComAssistFiltersForBill(key -> "entries." + key));
        return filters.toArray(new QFilter[0]);
    }

    private List<QFilter> buildComAssistQfilters(String prefix) {
        ArrayList<QFilter> comAssistList = new ArrayList<QFilter>(8);
        for (Tuple2<String, Set<Long>> tuple2 : this.COMASSIST_VALUE_LIST) {
            Set ids = (Set)tuple2.t2;
            if (ids.isEmpty()) continue;
            String fieldKey = (String)tuple2.t1;
            comAssistList.add(new QFilter(prefix + fieldKey, "in", (Object)ids));
        }
        return comAssistList;
    }
}

