/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subsidiary;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.fi.gl.report.ReportDsExtProcessHelper;
import kd.fi.gl.report.subsidiary.DetailQuery;
import kd.fi.gl.report.subsidiary.SubsidiaryDetailQuery;
import kd.fi.gl.report.subsidiary.SubsidiaryTotalQuery;
import kd.fi.gl.report.subsidiary.TotalCalculateReportPlugin;
import kd.fi.gl.util.ReportFieldSettingUtil;
import kd.fi.gl.util.SubsiDiaryHelper;

public class SubsidiaryReportListPlugin
extends TotalCalculateReportPlugin<Map<String, HashSet<Object>>> {
    public SubsidiaryReportListPlugin() {
        super(new SubsidiaryDetailQuery(), new SubsidiaryTotalQuery());
    }

    @Override
    public DataSet query(ReportQueryParam queryParam, Object selectedObj) throws Throwable {
        DataSet dataSet = super.query(queryParam, selectedObj);
        dataSet = ReportDsExtProcessHelper.doExtProcess(queryParam, dataSet, "gl_rpt_subsidiaryledger");
        return dataSet;
    }

    @Override
    protected boolean needCalculateTotalWithDetailAfterDetailQuery(DetailQuery<Map<String, HashSet<Object>>> detailQuery) {
        return SubsiDiaryHelper.isExport((FilterInfo)this.getQueryParam().getFilter()) || super.needCalculateTotalWithDetailAfterDetailQuery(detailQuery);
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        super.getColumns(columns);
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        columns.addAll(ReportFieldSettingUtil.createCustomColumns((String)"gl_rpt_subsidiaryledger"));
        columns.add((AbstractReportColumn)this.createVentryColumn());
        this.addComassistColunms(columns);
        if (SubsiDiaryHelper.isExport((FilterInfo)filterInfo)) {
            return this.addLeftColumn(columns, filterInfo);
        }
        return columns;
    }

    private void addComassistColunms(List<AbstractReportColumn> columns) {
        String comAssistValsListStr = (String)this.getQueryParam().getCustomParam().get("ComAssistEntityListStr");
        if (comAssistValsListStr == null) {
            return;
        }
        List comAssistList = (List)SerializationUtils.fromJsonString((String)comAssistValsListStr, List.class);
        if (!comAssistList.isEmpty()) {
            for (int i = 0; i < comAssistList.size(); ++i) {
                List tuplMap = (List)comAssistList.get(i);
                String comFieldKey = (String)tuplMap.get(0);
                String entityId = (String)tuplMap.get(1);
                LocaleString nameLocal = new LocaleString();
                LinkedHashMap nameMap = (LinkedHashMap)tuplMap.get(2);
                for (Map.Entry map : nameMap.entrySet()) {
                    String key = (String)map.getKey();
                    String val = (String)map.getValue();
                    nameLocal.setItem(key, (Object)val);
                }
                columns.add((AbstractReportColumn)this.createComAssist(comFieldKey, entityId, nameLocal));
            }
        }
    }

    private ReportColumn createComAssist(LocaleString caption, String fieldKey, String fieldType) {
        ReportColumn column = new ReportColumn();
        column.setCaption(caption);
        column.setFieldKey(fieldKey);
        column.setFieldType(fieldType);
        return column;
    }

    private ReportColumn createComAssist(String fieldKey, String entityId, LocaleString nameLocal) {
        ReportColumn reportColumn = this.createComAssist(nameLocal, fieldKey, "basedata");
        reportColumn.setEntityId(entityId);
        return reportColumn;
    }

    private List<AbstractReportColumn> addLeftColumn(List<AbstractReportColumn> columns, FilterInfo filterInfo) {
        ArrayList leftColumns = new ArrayList();
        SubsiDiaryHelper.createAccountancyTypeColumns2(leftColumns, (FilterInfo)filterInfo);
        columns.addAll(0, leftColumns);
        return columns;
    }

    private ReportColumn createVentryColumn() {
        ReportColumn ventryColumn = new ReportColumn();
        ventryColumn.setHide(true);
        ventryColumn.setFieldKey("fentryid");
        ventryColumn.setFieldType("text");
        return ventryColumn;
    }
}

