/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subsidiary;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.fi.bd.model.Context;
import kd.fi.bd.model.JsonObjectAdapter;
import kd.fi.bd.model.schema.property.Prop;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.report.subsidiary.DetailQuery;
import kd.fi.gl.report.subsidiary.TotalQuery;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.GLUtil;

public abstract class TotalCalculateReportPlugin<T>
extends AbstractReportListDataPlugin {
    private static final Prop Key_isTotalCalculateWithDetailDS = new Prop(TotalCalculateReportPlugin.class.getSimpleName(), "isTotalCalculateWithDetailDS");
    private static final Prop Key_selectObject = new Prop(TotalCalculateReportPlugin.class.getSimpleName(), "selectObject");
    protected static final Prop Key_detailRowMeta = new Prop(TotalCalculateReportPlugin.class.getSimpleName(), "detailRowMeta");
    private final DistributeCache distributeCache = CacheHelper.getDistributeCache((CacheModule)CacheModule.report);
    private final DetailQuery<T> detailQuery;
    private final TotalQuery<T> totalQuery;
    private Context context;
    private T selectedObj;
    private ReportQueryParam queryParam;
    private DataSet result = GLUtil.getEmptyDS(((Object)((Object)this)).getClass());
    private QueryStateChart stateChart = null;

    protected TotalCalculateReportPlugin(DetailQuery<T> detailQuery, TotalQuery<T> totalQuery) {
        this.detailQuery = detailQuery;
        this.totalQuery = totalQuery;
    }

    public T getSelectedObj() {
        Object selectedObj = super.getSelectedObj();
        if (selectedObj != null) {
            if (this.context.query(Key_selectObject) == null) {
                this.context.registerContext(Key_selectObject, (Object)this.serializeSelectObj(selectedObj));
            }
        } else {
            String serializeStr = (String)this.context.query(Key_selectObject);
            if (serializeStr != null) {
                selectedObj = this.deSerializeSelectObj(serializeStr);
            }
        }
        return (T)selectedObj;
    }

    protected String serializeSelectObj(T selectedObj) {
        return SerializationUtils.serializeToBase64(selectedObj);
    }

    protected T deSerializeSelectObj(String str) {
        return (T)SerializationUtils.deSerializeFromBase64((String)str);
    }

    public DataSet query(ReportQueryParam queryParam, Object selectedObj) throws Throwable {
        if (queryParam.getFilter().getFilterItems().isEmpty()) {
            return GLUtil.getEmptyDS(TotalCalculateReportPlugin.class);
        }
        this.queryParam = queryParam;
        this.beforeQuery();
        this.result = this.query();
        this.afterQuery();
        return this.result;
    }

    protected void beforeQuery() {
        Boolean isTotalRow = ((Row)this.queryParam.byBatchInfo().getCurrentBatchRows().get(0)).getBoolean(0);
        String queryID = this.findQueryID(this.queryParam);
        this.context = Optional.ofNullable(this.distributeCache.get(queryID)).map(contextJson -> new Context((Map)JsonObjectAdapter.fromJson((String)contextJson).getSource())).orElseGet(() -> {
            if (isTotalRow.booleanValue()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u6570\u636e\u7f13\u5b58\u5df2\u7ecf\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762\u3002", (String)"TotalCalculateReportPlugin_0", (String)GLApp.instance.reportModule(), (Object[])new Object[0]));
            }
            return new Context();
        });
        this.stateChart = new QueryStateChart(isTotalRow, (Boolean)Optional.ofNullable(this.context.query(Key_isTotalCalculateWithDetailDS)).orElse(Boolean.FALSE));
        this.selectedObj = this.getSelectedObj();
    }

    protected DataSet query() {
        if (this.stateChart.isTotalQuery.booleanValue()) {
            return this.doTotalQuery();
        }
        return this.doDetailQuery();
    }

    protected DataSet doDetailQuery() {
        Field[] fields;
        boolean existOrgField;
        DataSet detail = this.detailQuery.query(this.queryParam, this.selectedObj, this.context);
        this.stateChart.isCalculateTotalWithDetailDS = this.needCalculateTotalWithDetailAfterDetailQuery(this.detailQuery);
        if (this.stateChart.isCalculateTotalWithDetailDS.booleanValue()) {
            detail = detail.union(this.totalQuery.query(this.queryParam, this.selectedObj, detail, this.context));
        }
        if (existOrgField = Arrays.stream(fields = detail.getRowMeta().getFields()).anyMatch(x -> x.getAlias().equals("org"))) {
            detail = detail.addField("org", "orgid").addField("org", "flexorgid");
        }
        return detail;
    }

    protected DataSet doTotalQuery() {
        if (this.stateChart.isCalculateTotalWithDetailDS.booleanValue()) {
            return GLUtil.getEmptyDS(((Object)((Object)this)).getClass());
        }
        String rowMetaDSCacheID = (String)this.context.query(Key_detailRowMeta);
        RowMeta detailRowMeta = Algo.getCacheDataSet((String)rowMetaDSCacheID).getRowMeta();
        this.context.registerContext(Key_detailRowMeta, (Object)detailRowMeta);
        DataSet total = this.totalQuery.query(this.queryParam, this.selectedObj, this.context);
        Field[] fields = total.getRowMeta().getFields();
        boolean existOrgField = Arrays.stream(fields).anyMatch(x -> x.getAlias().equals("org"));
        if (existOrgField) {
            total = total.addField("org", "orgid").addField("org", "flexorgid");
        }
        return total;
    }

    protected boolean needCalculateTotalWithDetailAfterDetailQuery(DetailQuery<T> detailQuery) {
        return detailQuery.getDetailDsSize() <= detailQuery.getDetailLimit();
    }

    protected void afterQuery() {
        CachedDataSet cache = Algo.create((String)(((Object)((Object)this)).getClass().getName() + "#rowMetaCache")).createDataSetBuilder(this.result.getRowMeta()).build().cache(CacheHint.getDefault());
        this.context.registerContext(Key_detailRowMeta, (Object)cache.getCacheId());
        this.context.registerContext(Key_isTotalCalculateWithDetailDS, (Object)this.stateChart.isCalculateTotalWithDetailDS);
        this.distributeCache.put(this.findQueryID(this.queryParam), JsonObjectAdapter.fromContext((Context)this.context).toJsonStr());
    }

    private String findQueryID(ReportQueryParam queryParam) {
        return queryParam.byBatchInfo().getBatchBy().getCacheId() + "#queryID";
    }

    public DataSet queryBatchBy(ReportQueryParam queryParam) {
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("totalRow", (DataType)DataType.BooleanType)});
        DataSetBuilder batchByDSBuilder = Algo.create((String)"").createDataSetBuilder(rowMeta);
        batchByDSBuilder.append(new Object[]{false});
        batchByDSBuilder.append(new Object[]{true});
        queryParam.byBatchInfo().setCountPerBatch(1);
        return batchByDSBuilder.build();
    }

    protected Context getContext() {
        return this.context;
    }

    public static class QueryStateChart {
        protected Boolean isTotalQuery;
        protected Boolean isCalculateTotalWithDetailDS;

        protected QueryStateChart(Boolean isTotalRow, Boolean isCalculateTotalWithDetailDS) {
            this.isTotalQuery = isTotalRow;
            this.isCalculateTotalWithDetailDS = isCalculateTotalWithDetailDS;
        }
    }
}

