/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subsidiary.v2;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.vo.CommonAssist;
import kd.fi.gl.configuration.ReportConfiguration;
import kd.fi.gl.report.QueryParamFactory;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.ReportDsExtProcessHelper;
import kd.fi.gl.report.batchquery.AbstractReportBatchQueryPlugin;
import kd.fi.gl.report.batchquery.IBatchService;
import kd.fi.gl.report.batchquery.IQueryService;
import kd.fi.gl.report.subsidiary.v2.batch.SubsiBatchRow;
import kd.fi.gl.report.subsidiary.v2.batch.SubsiDiaryBatchServiceFactory;
import kd.fi.gl.report.subsidiary.v2.core.SubsidiaryQueryService;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.DataSetHelper;
import kd.fi.gl.util.MulCurReportUtil;
import kd.fi.gl.util.ReportFieldSettingUtil;
import kd.fi.gl.util.SubsiDiaryHelper;

public class SubsidiaryReportListPluginNew
extends AbstractReportBatchQueryPlugin<SubsiBatchRow> {
    private static final Log logger = LogFactory.getLog(SubsidiaryReportListPluginNew.class);

    @Override
    protected Class<SubsiBatchRow> getBatchRowClazz() {
        return SubsiBatchRow.class;
    }

    @Override
    protected IBatchService<SubsiBatchRow> getBatchService(ReportQueryParam reportQueryParam) {
        return SubsiDiaryBatchServiceFactory.getInstance().getBatchService(reportQueryParam);
    }

    @Override
    protected IQueryService<SubsiBatchRow> getQueryService(ReportQueryParam reportQueryParam, Object o) {
        return new SubsidiaryQueryService();
    }

    @Override
    public DataSet queryBatchBy(ReportQueryParam queryParam) {
        DataSet set = super.queryBatchBy(queryParam);
        queryParam.byBatchInfo().setCountPerBatch(ReportConfiguration.SUBSIDIARY_ROW_SIZE_PER_BATCH.getInt());
        return set;
    }

    @Override
    public DataSet query(ReportQueryParam queryParam, Object o) throws Throwable {
        try {
            DataSet res = super.query(queryParam, o);
            res = this.setMeasureMulCurrency(queryParam, res);
            res = ReportDsExtProcessHelper.doExtProcess(queryParam, res, "gl_rpt_subsidiaryledger");
            return res;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    private DataSet setMeasureMulCurrency(ReportQueryParam queryParam, DataSet res) {
        FilterInfo filterInfo = queryParam.getFilter();
        String mulCur = filterInfo.getString("mulcur");
        if (MulCurReportUtil.localCurrency((String)mulCur)) {
            return res;
        }
        LocalCurrencyConfigVO configVO = LocalCurrencyConfigService.getCurrencyConfig((String)mulCur);
        long baseCurrencyId = configVO.getCurrencyId(filterInfo.getLong("org"), filterInfo.getLong("booktype"));
        List resList = DataSetHelper.getDataSetCols((DataSet)res);
        int indexPriceCur = resList.indexOf("pricecurrency");
        if (indexPriceCur < 0) {
            return res;
        }
        resList.set(indexPriceCur, "case when rowtype != 2 then " + baseCurrencyId + " else pricecurrency end as pricecurrency");
        res = res.select(resList.toArray(new String[resList.size()]));
        return res;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        super.getColumns(columns);
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        columns.addAll(ReportFieldSettingUtil.createCustomColumns((String)"gl_rpt_subsidiaryledger"));
        columns.add((AbstractReportColumn)this.createVentryColumn());
        this.addComassistColunms(columns);
        if (SubsiDiaryHelper.isExport((FilterInfo)filterInfo)) {
            return this.addLeftColumn(columns, this.getQueryParam());
        }
        return columns;
    }

    private void addComassistColunms(List<AbstractReportColumn> columns) {
        if (CommonAssistUtil.isCommonAssistEnabled()) {
            QueryParamRpt queryParam = QueryParamFactory.createOrGetWithThreadCache((FilterInfo)this.getQueryParam().getFilter(), (String)"gl_rpt_subsidiaryledger");
            for (CommonAssist commonAssist : queryParam.getCommonAssists()) {
                columns.add((AbstractReportColumn)this.createComAssist(commonAssist.getKey() + "id", commonAssist.getValueSource(), commonAssist.getLocaleName()));
            }
        }
    }

    private ReportColumn createComAssist(LocaleString caption, String fieldKey, String fieldType) {
        ReportColumn column = new ReportColumn();
        column.setCaption(caption);
        column.setFieldKey(fieldKey);
        column.setFieldType(fieldType);
        return column;
    }

    private ReportColumn createComAssist(String fieldKey, String entityId, LocaleString nameLocal) {
        ReportColumn reportColumn = this.createComAssist(nameLocal, fieldKey, "basedata");
        reportColumn.setEntityId(entityId);
        return reportColumn;
    }

    private List<AbstractReportColumn> addLeftColumn(List<AbstractReportColumn> columns, ReportQueryParam queryParam) {
        ArrayList leftColumns = new ArrayList();
        SubsiDiaryHelper.createAccountancyTypeColumns2(leftColumns, (FilterInfo)queryParam.getFilter());
        List treeFlexFields = JSONArray.parseArray((String)queryParam.getCustomParam().get("treeflexfields").toString()).stream().map(Object::toString).collect(Collectors.toList());
        ArrayList<Object> leftColumns2 = new ArrayList<Object>(4);
        for (AbstractReportColumn column : leftColumns) {
            if (column instanceof ReportColumn) {
                String fieldKey = ((ReportColumn)column).getFieldKey();
                boolean treeFlexFieldRef = treeFlexFields.stream().anyMatch(fieldKey::startsWith);
                boolean treeFlexField = treeFlexFields.stream().anyMatch(fieldKey::equals);
                if (treeFlexField) {
                    if (!SubsiDiaryHelper.isExportAll((FilterInfo)queryParam.getFilter())) {
                        FlexProperty flexProp = FlexEntityMetaUtils.getFlexProperty((String)fieldKey);
                        ReportColumn c = new ReportColumn();
                        c.setFieldType("text");
                        c.setCaption(flexProp.getName());
                        c.setFieldKey(fieldKey);
                        leftColumns2.add(c);
                        continue;
                    }
                    leftColumns2.add(column);
                    continue;
                }
                if (treeFlexFieldRef) continue;
                leftColumns2.add(column);
                continue;
            }
            leftColumns2.add(column);
        }
        columns.addAll(0, leftColumns2);
        return columns;
    }

    private ReportColumn createVentryColumn() {
        ReportColumn ventryColumn = new ReportColumn();
        ventryColumn.setHide(true);
        ventryColumn.setFieldKey("fentryid");
        ventryColumn.setFieldType("text");
        return ventryColumn;
    }
}

