/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subsidiary.v2.batch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithDistinctable;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.gl.business.service.PeriodService;
import kd.fi.gl.report.QueryParamFactory;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.util.AccountUtils;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.SubsiDiaryHelper;
import org.apache.commons.lang3.tuple.Triple;

public class BatchUtil {
    static int queryTotalCount(List<FlexUtils.AssistFilterEntry> assistEntries, ReportQueryParam reportQueryParam, boolean isExportAll) {
        DataSet batchDs = BatchUtil.queryBatchAndCount(assistEntries, reportQueryParam, isExportAll);
        DataSet totalCount = batchDs.copy().groupBy().sum("count").finish();
        return totalCount.hasNext() ? totalCount.next().getInteger(0) : 0;
    }

    static DataSet queryBatchAndCount(List<FlexUtils.AssistFilterEntry> assistEntries, ReportQueryParam reportQueryParam, boolean selectBd) {
        return (DataSet)ThreadCache.get((Object)("BatchUtil#" + Objects.hash(assistEntries, reportQueryParam, selectBd)), () -> {
            boolean filterNoZeroAmount;
            QueryParamRpt qpRpt = QueryParamFactory.createOrGetWithThreadCache((FilterInfo)reportQueryParam.getFilter(), (String)"gl_rpt_subsidiaryledger");
            ArrayList<QFilter> baseFilter = new ArrayList<QFilter>(BatchUtil.getBaseFilter(qpRpt));
            Triple triple = FlexUtils.buildDynamicORMAssistOnBalanceWithZero((Collection)assistEntries, (String)"gl_balance", (boolean)true);
            baseFilter.addAll((Collection)triple.getMiddle());
            ArrayList<String> grpFields = new ArrayList<String>(8);
            grpFields.add("account");
            if (selectBd) {
                ((List)triple.getRight()).stream().map(f -> f.split(" ")[0]).forEach(grpFields::add);
            }
            ArrayList<String> rsFields = new ArrayList<String>(Arrays.asList("account", "count"));
            if (selectBd) {
                rsFields.addAll((Collection)triple.getRight());
            }
            String[] resFieldsArr = rsFields.toArray(new String[0]);
            ORM orm = ORM.create();
            orm.setDataEntityType("gl_balance", (IDataEntityType)triple.getLeft());
            ArrayList<QFilter> tmpFilters = new ArrayList<QFilter>(baseFilter);
            tmpFilters.add(new QFilter("period", "in", (Object)GLUtil.getPeriodIds((Long)qpRpt.getStartPeriod(), (Long)qpRpt.getEndPeriod())));
            boolean bl = filterNoZeroAmount = qpRpt.isNoZeroAmount() && !qpRpt.isNoZeroBalance();
            if (filterNoZeroAmount) {
                tmpFilters.add(new QFilter("count", ">", (Object)0));
            }
            String[] grpFieldArr = grpFields.toArray(new String[0]);
            DataSet grpDs = orm.aggregate("SubsidiaryBatchManager.queryAccountBatch", "gl_balance", new String[]{"sum(count) count"}, tmpFilters.toArray(new QFilter[0]), grpFieldArr).select(resFieldsArr);
            if (!filterNoZeroAmount) {
                baseFilter.add(new QFilter("period", "<", (Object)qpRpt.getStartPeriod()));
                baseFilter.add(new QFilter("period", ">=", (Object)(qpRpt.getStartPeriod() / GLUtil.TYPE_PERIOD_L * GLUtil.TYPE_PERIOD_L)));
                grpDs = grpDs.union(orm.queryDataSet("SubsidiaryBatchManager.queryAccountBatch2", "gl_balance", String.join((CharSequence)",", grpFields), baseFilter.toArray(new QFilter[0]), null, -1, (Distinctable)WithDistinctable.get()).addField("0", "count").select(resFieldsArr));
                List<String> resFields = Arrays.stream(grpDs.getRowMeta().getFields()).map(Field::getAlias).collect(Collectors.toList());
                resFields.remove("count");
                grpDs = grpDs.groupBy(resFields.toArray(resFields.toArray(new String[0]))).sum("count").finish();
            }
            return grpDs;
        });
    }

    public static DataSet insertTotalRow(DataSet batchDs) {
        batchDs = batchDs.addField("0", "isTotal");
        final RowMeta rowMeta = batchDs.getRowMeta();
        List<String> grpFields = Arrays.stream(rowMeta.getFields()).map(Field::getAlias).collect(Collectors.toList());
        grpFields.remove("account");
        grpFields.remove("count");
        grpFields.remove("isTotal");
        final int countIndex = rowMeta.getFieldIndex("count");
        batchDs = batchDs.groupBy(grpFields.toArray(new String[0])).reduceGroup(new ReduceGroupFunction(){
            private static final long serialVersionUID = -6133211729975334885L;

            public Iterator<Object[]> reduce(Iterator<Row> iterator) {
                ArrayList<Object[]> res = new ArrayList<Object[]>(16);
                iterator.forEachRemaining(r -> res.add(((AbstractRow)r).values()));
                if (res.size() > 0) {
                    Object[] totalRow = Arrays.copyOf((Object[])res.get(0), rowMeta.getFieldCount());
                    totalRow[rowMeta.getFieldCount() - 1] = 1;
                    totalRow[countIndex] = 0;
                    res.add(totalRow);
                }
                return res.iterator();
            }

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }
        });
        return batchDs;
    }

    public static DataSet order(ReportQueryParam reportQueryParam, DataSet grpDs) {
        QueryParamRpt queryParam = QueryParamFactory.createOrGetWithThreadCache((FilterInfo)reportQueryParam.getFilter(), (String)"gl_rpt_subsidiaryledger");
        HashSet acctMids = new HashSet();
        grpDs.copy().forEach(r -> acctMids.add(r.getLong("account")));
        Map<Long, String> mid2Num = AccountUtils.getAccountDOs((long)((Long)queryParam.getOrgs().get(0)), (long)queryParam.getAccountTable(), (Date)PeriodService.getEndDate((long)queryParam.getEndPeriod()), (boolean)false, (QFilter)new QFilter("masterid", "in", acctMids), (String[])new String[]{"masterid", "number"}).stream().collect(Collectors.toMap(d -> d.getLong("masterid"), d -> d.getString("number"), (s, s2) -> s));
        return BatchUtil.order(grpDs, mid2Num);
    }

    public static DataSet order(DataSet grpDs, Map<Long, String> mid2Num) {
        RowMeta rowMeta = grpDs.getRowMeta();
        List<String> orderBy = Arrays.stream(rowMeta.getFields()).map(Field::getAlias).filter(f -> !"account".equals(f) && !"count".equals(f) && !"isTotal".equals(f)).collect(Collectors.toList());
        if (rowMeta.getFieldIndex("isTotal", false) != -1) {
            orderBy.add("isTotal");
        }
        orderBy.add("accountNum");
        grpDs = grpDs.map((MapFunction)new AccountNumMapper(rowMeta, "account", "accountNum", mid2Num));
        grpDs = grpDs.orderBy(orderBy.toArray(new String[0]));
        return grpDs;
    }

    static List<QFilter> getBaseFilter(QueryParamRpt qpRpt) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("org", "in", (Object)qpRpt.getAllEntityOrgs()));
        filters.add(new QFilter("booktype", "=", (Object)qpRpt.getBookType()));
        filters.add(new QFilter("accounttable", "=", (Object)qpRpt.getAccountTable()));
        filters.addAll(qpRpt.getComAssistFiltersForBal());
        filters.add(new QFilter("account", "in", (Object)SubsiDiaryHelper.getAcctMasterIds((FilterInfo)qpRpt.getFilterInfo(), (long)qpRpt.getPorg())));
        if (!qpRpt.isSynCurrency() && !qpRpt.isAllCurrency()) {
            filters.add(new QFilter("currency", "=", (Object)qpRpt.getCurrency()));
        }
        filters.add(new QFilter("endperiod", "in", (Object)PeriodUtil.getAvailableEndPeriodIds((String)">", (Long)qpRpt.getStartPeriod(), (Long[])qpRpt.getAllEntityOrgs().toArray(new Long[0]))));
        return filters;
    }

    static class AccountNumMapper
    extends MapFunction {
        private static final long serialVersionUID = -3241833624629092797L;
        final RowMeta oldRowMeta;
        private final Map<Long, String> mid2Num;
        final RowMeta newRowMeta;
        final int accountNumIndex;
        final int accountMidIndex;

        AccountNumMapper(RowMeta oldRowMeta, String accountMidFK, String accountNumFK, Map<Long, String> mid2Num) {
            this.oldRowMeta = oldRowMeta;
            this.mid2Num = mid2Num;
            Field[] oriFields = oldRowMeta.getFields();
            Field[] newFields = new Field[oriFields.length + 1];
            int midIndex = oldRowMeta.getFieldIndex(accountMidFK);
            for (int i = 0; i < oriFields.length; ++i) {
                if (i < midIndex) {
                    newFields[i] = oriFields[i];
                    continue;
                }
                if (i == midIndex) {
                    newFields[i] = oriFields[i];
                    newFields[i + 1] = new Field(accountNumFK, (DataType)DataType.StringType);
                    continue;
                }
                newFields[i + 1] = oriFields[i];
            }
            this.newRowMeta = new RowMeta(newFields);
            this.accountNumIndex = this.newRowMeta.getFieldIndex(accountNumFK);
            this.accountMidIndex = oldRowMeta.getFieldIndex(accountMidFK);
        }

        public Object[] map(Row row) {
            Object[] values = ((AbstractRow)row).values();
            Object[] result = new Object[values.length + 1];
            for (int i = 0; i < result.length; ++i) {
                result[i] = i < this.accountNumIndex ? values[i] : (i == this.accountNumIndex ? this.mid2Num.getOrDefault(row.getLong(this.accountMidIndex), "") : values[i - 1]);
            }
            return result;
        }

        public RowMeta getResultRowMeta() {
            return this.newRowMeta;
        }
    }
}

