/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subsidiary.v2.core;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.report.subsidiary.v2.core.ResultField;
import kd.fi.gl.report.subsidiary.v2.core.collector.IReportCollector;
import kd.fi.gl.report.subsidiary.v2.core.ds.IDataSource;
import kd.fi.gl.report.subsidiary.v2.core.handler.IReportQueryHandler;
import kd.fi.gl.report.subsidiary.v2.core.model.IRptRow;
import kd.fi.gl.report.subsidiary.v2.core.model.RowType;

public class ReportQueryEngine<ROW extends IRptRow> {
    private final IReportQueryHandler<ROW> queryHandler;
    private List<IReportCollector<ROW>> collectors = new ArrayList<IReportCollector<ROW>>();
    private final HashMultimap<IReportCollector<ROW>, RowType> sourceRowTypesMap = HashMultimap.create((int)4, (int)4);
    List<IDataSource<ROW>> dataSources = new ArrayList<IDataSource<ROW>>();

    public ReportQueryEngine(IReportQueryHandler<ROW> queryHandler) {
        this.queryHandler = queryHandler;
    }

    public final void setCollectors(List<IReportCollector<ROW>> collectors) {
        for (IReportCollector<ROW> collector : collectors) {
            this.sourceRowTypesMap.putAll(collector, collector.getSourceTypes());
        }
        this.collectors = collectors;
    }

    public void addDataSource(IDataSource<ROW> dataSource) {
        this.dataSources.add(dataSource);
    }

    public Tuple<DataSet, Integer> run() {
        List<Object> result = new LinkedList<ROW>();
        for (IDataSource<ROW> iDataSource : this.dataSources) {
            for (IRptRow row : iDataSource.getData()) {
                this.collectors.stream().filter(collector -> this.needSum((IReportCollector<ROW>)collector, row.getRowType())).forEach(collector -> collector.collectSourceRow(row));
            }
        }
        for (IReportCollector iReportCollector : this.collectors) {
            List summaryRows = iReportCollector.getSummaryRows();
            iReportCollector.getPostCollectors().forEach(postC -> summaryRows.forEach(postC::collectSummaryRow));
            result.addAll(summaryRows);
        }
        result.sort(this.queryHandler.getRowComparator());
        result = this.queryHandler.fireFinished(result);
        List<ResultField<ROW>> fields = this.queryHandler.getResultFields();
        return new Tuple((Object)ResultField.toDataSet(fields, result), (Object)result.size());
    }

    private boolean needSum(IReportCollector<ROW> collector, RowType rowType) {
        return this.sourceRowTypesMap.get(collector).contains(rowType);
    }
}

