/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subsidiary.v2.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.gl.configuration.ReportConfiguration;
import kd.fi.gl.enums.SubsiDiarySortFieldEnum;
import kd.fi.gl.report.QueryParamFactory;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.subsidiary.v2.batch.SubsiBatchRow;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.SubsiDiaryHelper;

public class SubsidiaryQueryContext
implements AutoCloseable {
    private static final ThreadLocal<SubsidiaryQueryContext> current = new ThreadLocal();
    private final SubsiBatchRow batchRow;
    private final FilterInfo filter;
    private final ReportQueryParam reportQueryParam;
    private final QueryParamRpt queryParam;
    private final List<FlexUtils.AssistFilterEntry> assistFilterEntries;
    private int detailLimit = ReportConfiguration.SUBSIDIARY_DISPLAY_LIMIT.getInt();
    private Map<Long, Long> id2MidCache;
    private Map<Long, ThreeTuple<String, String, Long>> mid2IdNumDcCache;
    private Map<Long, String> vchTypeCache;
    private List<String> sortExtFieldAlias;
    private List<String> sortExtVoucherFields;
    private List<String> sortType;
    private static final String MASK = "s_";
    private static final Map<String, String> PRESET_SORT_FIELDS = new HashMap<String, String>(){
        private static final long serialVersionUID = -7941447971478101630L;
        {
            this.put(SubsiDiarySortFieldEnum.BILLNO.getNumber(), "billno");
            this.put(SubsiDiarySortFieldEnum.TYPENUMBER.getNumber(), "vouchertype.number");
            this.put(SubsiDiarySortFieldEnum.BIZDATE.getNumber(), "bizdate");
            this.put(SubsiDiarySortFieldEnum.BOOKDATE.getNumber(), "bookeddate");
        }
    };
    private final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();

    private SubsidiaryQueryContext(SubsiBatchRow batchRow, ReportQueryParam reportQueryParam) {
        this.batchRow = batchRow;
        this.filter = reportQueryParam.getFilter();
        this.queryParam = QueryParamFactory.createOrGetWithThreadCache((FilterInfo)this.filter, (String)"gl_rpt_subsidiaryledger");
        this.reportQueryParam = reportQueryParam;
        this.assistFilterEntries = new ArrayList<FlexUtils.AssistFilterEntry>(batchRow.getAssistEntryValues());
    }

    public static SubsidiaryQueryContext open(SubsiBatchRow batchRow, ReportQueryParam reportQueryParam) {
        current.set(new SubsidiaryQueryContext(batchRow, reportQueryParam));
        return current.get();
    }

    public boolean isExportAll() {
        return SubsiDiaryHelper.isExportAll((FilterInfo)this.getQueryParam().getFilterInfo());
    }

    public long getOrgId() {
        return (Long)this.queryParam.getOrgs().get(0);
    }

    public Set<Long> getAcctMids() {
        return this.batchRow.isSingleBatchRow() || this.batchRow.isTotalBatch() ? SubsiDiaryHelper.getAcctMasterIds2((FilterInfo)this.filter, (long)this.getOrgId()) : Collections.singleton(this.batchRow.getAcctMid());
    }

    public List<FlexUtils.AssistFilterEntry> getAssistEntries() {
        return this.assistFilterEntries;
    }

    private void initAccountCache() {
        this.mid2IdNumDcCache = new HashMap<Long, ThreeTuple<String, String, Long>>(128);
        this.id2MidCache = new HashMap<Long, Long>(128);
        DynamicObject periodDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getQueryParam().getEndPeriod(), (String)"bd_period", (String)"begindate, enddate");
        if (periodDyo == null) {
            return;
        }
        Set<Long> acctMidRange = this.getAcctMids();
        QFilter useRangeF = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)this.getOrgId());
        QFilter startPeriodF = new QFilter("startdate", "<=", (Object)periodDyo.getDate("enddate"));
        QFilter endPeriodF = new QFilter("enddate", ">=", (Object)periodDyo.getDate("enddate"));
        QFilter midF = new QFilter("masterid", "in", acctMidRange);
        QFilter acctTableF = new QFilter("accounttable", "=", (Object)this.queryParam.getAccountTable());
        QueryServiceHelper.query((String)(this.getClass() + "#accountCache"), (String)"bd_accountview", (String)"id, masterid, number, dc", (QFilter[])new QFilter[]{useRangeF, startPeriodF, endPeriodF, acctTableF, midF}, null, (int)-1).forEach(accountDyo -> {
            long mid = accountDyo.getLong("masterid");
            long id = accountDyo.getLong("id");
            String number = accountDyo.getString("number");
            this.mid2IdNumDcCache.put(mid, (ThreeTuple<String, String, Long>)new ThreeTuple((Object)number, (Object)accountDyo.getString("dc"), (Object)id));
        });
        for (Long mid : acctMidRange) {
            ThreeTuple<String, String, Long> tuple = this.mid2IdNumDcCache.get(mid);
            long id = tuple == null ? 0L : (Long)tuple.item3;
            this.id2MidCache.put(id, mid);
        }
    }

    public Long getAccountMidFromCache(Long acctIdOnEndPeriod) {
        if (this.id2MidCache == null) {
            this.initAccountCache();
        }
        return this.id2MidCache.getOrDefault(acctIdOnEndPeriod, 0L);
    }

    public Long getAccountIdFromCache(Long acctMasterId) {
        if (this.mid2IdNumDcCache == null) {
            this.initAccountCache();
        }
        return Optional.ofNullable(this.mid2IdNumDcCache.get(acctMasterId)).map(t -> (Long)t.item3).orElse(0L);
    }

    public String getAccountDcFromCache(Long acctMasterID) {
        if (this.mid2IdNumDcCache == null) {
            this.initAccountCache();
        }
        return Optional.ofNullable(this.mid2IdNumDcCache.get(acctMasterID)).map(t -> (String)t.item2).orElse("1");
    }

    public String getAccountNumberFromCache(Long acctMasterID) {
        if (this.mid2IdNumDcCache == null) {
            this.initAccountCache();
        }
        return Optional.ofNullable(this.mid2IdNumDcCache.get(acctMasterID)).map(t -> (String)t.item1).orElse("");
    }

    public String getVchTypeFromCache(Long pk) {
        if (this.vchTypeCache == null) {
            this.vchTypeCache = new HashMap<Long, String>();
            BusinessDataServiceHelper.loadFromCache((String)"gl_vouchertype", (String)"number", (QFilter[])new QFilter[0]).forEach((id, vchType) -> this.vchTypeCache.put((Long)id, vchType.getString("number")));
        }
        return this.vchTypeCache.getOrDefault(pk, "");
    }

    public List<String> getSortType() {
        return this.sortType;
    }

    public List<String> getSortExtFieldAlias() {
        return this.sortExtFieldAlias;
    }

    public List<String> getSortExtVoucherFields() {
        if (this.sortExtVoucherFields == null) {
            this.sortExtFieldAlias = new ArrayList<String>(4);
            this.sortExtVoucherFields = new ArrayList<String>(4);
            this.sortType = new ArrayList<String>(4);
            List itemInfoList = this.queryParam.getFilterInfo().getFilterItems();
            for (FilterItemInfo filterItemInfo : itemInfoList) {
                String propName = filterItemInfo.getPropName();
                if (!propName.startsWith("sort")) continue;
                String sortFieldName = propName.substring(4);
                if (!PRESET_SORT_FIELDS.containsKey(sortFieldName) && !"entries.entrydc".equals(sortFieldName)) {
                    if (sortFieldName.startsWith("entries")) {
                        String fieldName = sortFieldName.substring("entries.".length());
                        this.sortExtFieldAlias.add(MASK + fieldName);
                        this.sortExtVoucherFields.add(sortFieldName + " " + MASK + fieldName);
                    } else {
                        this.sortExtFieldAlias.add(MASK + sortFieldName);
                        this.sortExtVoucherFields.add(sortFieldName + " " + MASK + sortFieldName);
                    }
                } else {
                    this.sortExtFieldAlias.add(MASK + sortFieldName);
                    this.sortExtVoucherFields.add(PRESET_SORT_FIELDS.get(sortFieldName) + " " + MASK + sortFieldName);
                }
                this.sortType.add(filterItemInfo.getValue().toString());
            }
        }
        return this.sortExtVoucherFields;
    }

    public void cache(String key, String value) {
        String cacheKey = this.getReportQueryParam().byBatchInfo().getBatchBy().getCacheId() + "#" + key;
        this.cache.put(cacheKey, (Object)value, 1800);
    }

    public String get(String key) {
        String cacheKey = this.getReportQueryParam().byBatchInfo().getBatchBy().getCacheId() + "#" + key;
        return (String)this.cache.get(cacheKey);
    }

    @Override
    public void close() {
        current.set(null);
    }

    public static SubsidiaryQueryContext getCurrent() {
        SubsidiaryQueryContext context = current.get();
        assert (context != null);
        return context;
    }

    public static SubsidiaryQueryContext setCurrent(SubsidiaryQueryContext context) {
        current.set(context);
        return SubsidiaryQueryContext.getCurrent();
    }

    public QueryParamRpt getQueryParam() {
        return this.queryParam;
    }

    public SubsiBatchRow getBatchRow() {
        return this.batchRow;
    }

    public ReportQueryParam getReportQueryParam() {
        return this.reportQueryParam;
    }

    public boolean isNoZeroAmountHideGrp() {
        return this.queryParam.isNoZeroAmount();
    }

    public boolean isNoZeroAmountHidePeriod() {
        return this.queryParam.getFilterInfo().getBoolean("nozeroperiod");
    }

    public int getDetailLimit() {
        return this.detailLimit;
    }

    public void setDetailLimit(int detailLimit) {
        this.detailLimit = detailLimit;
    }
}

