/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subsidiary.v2.core;

import java.util.Arrays;
import java.util.Collections;
import kd.bos.algo.DataSet;
import kd.bos.entity.report.ReportQueryParam;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.report.batchquery.IQueryService;
import kd.fi.gl.report.subsidiary.v2.batch.SubsiBatchRow;
import kd.fi.gl.report.subsidiary.v2.core.ReportQueryEngine;
import kd.fi.gl.report.subsidiary.v2.core.SubsidiaryQueryContext;
import kd.fi.gl.report.subsidiary.v2.core.collector.impl.SubsidiaryBeginCollector;
import kd.fi.gl.report.subsidiary.v2.core.collector.impl.SubsidiaryLeafCollector;
import kd.fi.gl.report.subsidiary.v2.core.collector.impl.SubsidiaryPeriodCollector;
import kd.fi.gl.report.subsidiary.v2.core.collector.impl.SubsidiaryPeriodTotalCollector;
import kd.fi.gl.report.subsidiary.v2.core.collector.impl.SubsidiaryYearCollector;
import kd.fi.gl.report.subsidiary.v2.core.ds.impl.SubsidiaryBalanceDS;
import kd.fi.gl.report.subsidiary.v2.core.ds.impl.SubsidiaryPeriodTotalDS;
import kd.fi.gl.report.subsidiary.v2.core.ds.impl.SubsidiaryVoucherDS;
import kd.fi.gl.report.subsidiary.v2.core.handler.impl.SubsidiaryQueryHandler;
import kd.fi.gl.report.subsidiary.v2.core.model.SubsidiaryRow;

public class SubsidiaryQueryService
implements IQueryService<SubsiBatchRow> {
    private static DataSet doSingleBatchQuery(SubsiBatchRow batchRow, ReportQueryParam reportQueryParam) {
        try (SubsidiaryQueryContext context = SubsidiaryQueryContext.open(batchRow, reportQueryParam);){
            ReportQueryEngine<SubsidiaryRow> queryEngine = new ReportQueryEngine<SubsidiaryRow>(new SubsidiaryQueryHandler());
            if (!batchRow.isTotalBatch()) {
                SubsidiaryLeafCollector leafCollector = new SubsidiaryLeafCollector();
                SubsidiaryYearCollector yearCollector = new SubsidiaryYearCollector();
                SubsidiaryBeginCollector beginCollector = new SubsidiaryBeginCollector();
                SubsidiaryPeriodTotalCollector totalCollector = new SubsidiaryPeriodTotalCollector();
                SubsidiaryPeriodCollector periodCollector = new SubsidiaryPeriodCollector();
                periodCollector.setPostCollectors(Arrays.asList(yearCollector, beginCollector, totalCollector));
                queryEngine.setCollectors(Arrays.asList(leafCollector, periodCollector, yearCollector, beginCollector, totalCollector));
                queryEngine.addDataSource(new SubsidiaryBalanceDS());
                queryEngine.addDataSource(new SubsidiaryVoucherDS());
            } else {
                queryEngine.setCollectors(Collections.singletonList(new SubsidiaryPeriodTotalCollector()));
                queryEngine.addDataSource(new SubsidiaryPeriodTotalDS());
            }
            Tuple<DataSet, Integer> res2DetailSize = queryEngine.run();
            DataSet dataSet = (DataSet)res2DetailSize.item1;
            return dataSet;
        }
    }

    @Override
    public DataSet queryByBatch(SubsiBatchRow batchRow, ReportQueryParam queryParam, Object selectObj) {
        return SubsidiaryQueryService.doSingleBatchQuery(batchRow, queryParam);
    }
}

