/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subsidiary.v2.core.collector.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.subsidiary.v2.core.SubsidiaryQueryContext;
import kd.fi.gl.report.subsidiary.v2.core.SubsidiaryRowFactory;
import kd.fi.gl.report.subsidiary.v2.core.collector.AbstractReportCollector;
import kd.fi.gl.report.subsidiary.v2.core.model.RowType;
import kd.fi.gl.report.subsidiary.v2.core.model.SubsidiaryGroup;
import kd.fi.gl.report.subsidiary.v2.core.model.SubsidiaryRow;

public class SubsidiaryPeriodCollector
extends AbstractReportCollector<SubsidiaryRow> {
    private final Map<String, Tuple<Long, Long>> acctNum2IdMid = new HashMap<String, Tuple<Long, Long>>(32);
    TreeMap<SubsidiaryGroup, Map<Long, SubsidiaryRow>> grp2Period2SumRow = new TreeMap();

    @Override
    public List<RowType> getSourceTypes() {
        return Arrays.asList(RowType.YEAR, RowType.BEGIN, RowType.LEAF);
    }

    @Override
    public void collectSourceRow(SubsidiaryRow row) {
        Map sumRows = this.grp2Period2SumRow.computeIfAbsent(row.getGroup(), group -> {
            this.acctNum2IdMid.put(group.getAcctNum(), (Tuple<Long, Long>)new Tuple((Object)row.getAccountId(), (Object)row.getAccountMasterId()));
            return new HashMap(8);
        });
        if (row.getRowType() == RowType.LEAF) {
            SubsidiaryRow sumRow = sumRows.computeIfAbsent(row.getPeriodId(), period -> SubsidiaryRowFactory.createPeriodRowWithZeroAmount(row, period));
            baseDCSumConsumer.accept(row, sumRow);
            sumRow.setCount(sumRow.getCount() + 1);
        }
    }

    @Override
    public void collectSummaryRow(SubsidiaryRow row) {
    }

    @Override
    public List<SubsidiaryRow> getSummaryRows() {
        SubsidiaryQueryContext context = SubsidiaryQueryContext.getCurrent();
        QueryParamRpt queryParam = context.getQueryParam();
        ArrayList<SubsidiaryRow> res = new ArrayList<SubsidiaryRow>(16);
        if (context.isNoZeroAmountHidePeriod() && !context.getQueryParam().isNoZeroBalance()) {
            this.grp2Period2SumRow.forEach((grp, rows) -> res.addAll(rows.values()));
        } else {
            List periodIds = PeriodUtil.getPeriodIds((Long)queryParam.getStartPeriod(), (Long)queryParam.getEndPeriod());
            res.addAll(SubsidiaryPeriodCollector.fillNotExistedPeriodRow(this.grp2Period2SumRow, periodIds, this.acctNum2IdMid));
        }
        return res;
    }

    static List<SubsidiaryRow> fillNotExistedPeriodRow(Map<SubsidiaryGroup, Map<Long, SubsidiaryRow>> sumRowTreeMap, List<Long> periodIdRange, Map<String, Tuple<Long, Long>> acctNum2IdMid) {
        ArrayList<SubsidiaryRow> res = new ArrayList<SubsidiaryRow>();
        Map<SubsidiaryGroup, List> grp2Rows = sumRowTreeMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new ArrayList(((Map)e.getValue()).values())));
        grp2Rows.forEach((grp, singleGrpRows) -> {
            ArrayList noAmountPeriodIds = new ArrayList(periodIdRange);
            for (SubsidiaryRow row : singleGrpRows) {
                noAmountPeriodIds.remove(row.getPeriodId());
                res.add(row);
            }
            Tuple id2Mid = (Tuple)acctNum2IdMid.get(grp.getAcctNum());
            noAmountPeriodIds.stream().map(period -> SubsidiaryRowFactory.createPeriodRowWithZeroAmount(grp, period, (Long)id2Mid.item1, (Long)id2Mid.item2)).forEach(res::add);
        });
        return res;
    }
}

