/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subsidiary.v2.core.ds.impl;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.FilterInfo;
import kd.bos.orm.query.QFilter;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.subsidiary.v2.core.SubsidiaryQueryContext;
import kd.fi.gl.report.subsidiary.v2.core.SubsidiaryRowFactory;
import kd.fi.gl.report.subsidiary.v2.core.ds.IDataSource;
import kd.fi.gl.report.subsidiary.v2.core.model.AssistValueGroup;
import kd.fi.gl.report.subsidiary.v2.core.model.RowType;
import kd.fi.gl.report.subsidiary.v2.core.model.SubsidiaryRow;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.MulCurReportUtil;
import org.apache.commons.lang3.tuple.Triple;

public class SubsidiaryBalanceDS
implements IDataSource<SubsidiaryRow> {
    @Override
    public Iterable<SubsidiaryRow> getData() {
        SubsidiaryQueryContext context = SubsidiaryQueryContext.getCurrent();
        String balSelectField = SubsidiaryBalanceDS.getBalSelectField(context);
        long beginPeriodId = context.getQueryParam().getStartPeriod();
        DataSet balance = this.getBalance(balSelectField, beginPeriodId, beginPeriodId);
        return SubsidiaryBalanceDS.createRows(balance, context);
    }

    static List<SubsidiaryRow> createRows(DataSet beginBalance, SubsidiaryQueryContext context) {
        LinkedList<SubsidiaryRow> result = new LinkedList<SubsidiaryRow>();
        for (Row row : beginBalance) {
            AssistValueGroup assistValueGroup = AssistValueGroup.create(context.getAssistEntries(), row, context.isExportAll());
            QueryParamRpt queryParam = context.getQueryParam();
            Long currencyId = queryParam.isQueryCurrency() ? row.getLong("currency") : 0L;
            Long unitId = queryParam.isShowQty() ? row.getLong("measureunit") : 0L;
            Long acctId = row.getLong("account");
            Long acctMid = context.getAccountMidFromCache(acctId);
            String acctNumber = context.getAccountNumberFromCache(acctMid);
            SubsidiaryRow beginRow = SubsidiaryRowFactory.createNewRow(RowType.BEGIN, assistValueGroup, acctNumber, currencyId, unitId, 0L, acctMid, acctId);
            SubsidiaryRow beginYearRow = SubsidiaryRowFactory.createNewRow(RowType.YEAR, assistValueGroup, acctNumber, currencyId, unitId, 0L, acctMid, acctId);
            beginRow.setEndLocal(row.getBigDecimal("beginlocal"));
            beginYearRow.setDebitLocal(row.getBigDecimal("yeardebitlocal").subtract(row.getBigDecimal("debitlocal")));
            beginYearRow.setCreditLocal(row.getBigDecimal("yearcreditlocal").subtract(row.getBigDecimal("creditlocal")));
            if (queryParam.isQueryCurrency()) {
                beginRow.setEndFor(row.getBigDecimal("beginfor"));
                beginYearRow.setDebitFor(row.getBigDecimal("yeardebitfor").subtract(row.getBigDecimal("debitfor")));
                beginYearRow.setCreditLocal(row.getBigDecimal("yearcreditfor").subtract(row.getBigDecimal("creditfor")));
            }
            if (queryParam.isShowQty()) {
                beginRow.setEndQty(row.getBigDecimal("beginqty"));
                beginYearRow.setDebitQty(row.getBigDecimal("yeardebitqty").subtract(row.getBigDecimal("debitqty")));
                beginYearRow.setCreditQty(row.getBigDecimal("yearcreditqty").subtract(row.getBigDecimal("creditqty")));
            }
            result.add(beginRow);
            result.add(beginYearRow);
        }
        return result;
    }

    static String getBalSelectField(SubsidiaryQueryContext context) {
        QueryParamRpt qpRpt = context.getQueryParam();
        List<String> queryFields = new ArrayList<String>(16);
        queryFields.add("account");
        queryFields.add("beginlocal");
        queryFields.add("debitlocal");
        queryFields.add("creditlocal");
        queryFields.add("yeardebitlocal");
        queryFields.add("yearcreditlocal");
        if (qpRpt.isQueryCurrency()) {
            queryFields.add("currency");
            queryFields.add("beginfor");
            queryFields.add("debitfor");
            queryFields.add("creditfor");
            queryFields.add("yeardebitfor");
            queryFields.add("yearcreditfor");
        }
        if (qpRpt.isShowQty()) {
            queryFields.add("measureunit");
            queryFields.add("beginqty");
            queryFields.add("debitqty");
            queryFields.add("creditqty");
            queryFields.add("yeardebitqty");
            queryFields.add("yearcreditqty");
        }
        queryFields = MulCurReportUtil.mulCurBalAmountToLocalAlias(queryFields, (String)qpRpt.getMulCur());
        return String.join((CharSequence)",", queryFields);
    }

    private DataSet getBalance(String balanceSel, Long startPeriod, Long endPeriod) {
        AccountBookInfo defaultBook;
        SubsidiaryQueryContext context = SubsidiaryQueryContext.getCurrent();
        QueryParamRpt queryParam = context.getQueryParam();
        QueryParam balanceQueryParam = SubsidiaryBalanceDS.getBalanceQueryParam(context);
        Triple triple = FlexUtils.buildDynamicORMAssistOnBalanceWithZero(context.getAssistEntries(), (String)"gl_balance", (boolean)true);
        balanceQueryParam.setBalEntityType((MainEntityType)triple.getLeft());
        balanceQueryParam.setCustomFilter((List)triple.getMiddle());
        balanceSel = balanceSel + "," + String.join((CharSequence)",", (Iterable)triple.getRight());
        long bookTypeId = queryParam.getBookType();
        if (bookTypeId == 0L && (defaultBook = AccSysUtil.getDefaultBookFromAccSys((Long)context.getOrgId())) != null) {
            bookTypeId = defaultBook.getBookTypeId();
        }
        DataSet balance = BalanceQueryExecutor.getInstance().getBalance(balanceSel, new Long[]{context.getOrgId()}, bookTypeId, queryParam.getAccountTable(), startPeriod.longValue(), endPeriod.longValue(), balanceQueryParam);
        return balance;
    }

    static QueryParam getBalanceQueryParam(SubsidiaryQueryContext context) {
        String currencyVal;
        QueryParam param = new QueryParam();
        QueryParamRpt queryParam = context.getQueryParam();
        param.setSubstractPL(queryParam.isSubstractPL());
        param.setAccountVersionPeriodId(queryParam.getEndPeriod());
        param.getCustomFilter().addAll(queryParam.getComAssistFiltersForBal());
        FilterInfo filterInfo = queryParam.getFilterInfo();
        param.setAccountFilter(new QFilter("masterid", "in", context.getAcctMids()));
        param.setOnlyLeafAcctBal(true);
        if (filterInfo.getDynamicObjectCollection("measureunits") != null) {
            DynamicObjectCollection unitsDynColl = filterInfo.getDynamicObjectCollection("measureunits");
            ArrayList<Long> uList = new ArrayList<Long>(unitsDynColl.size());
            for (DynamicObject dyn : unitsDynColl) {
                uList.add(dyn.getLong("id"));
            }
            param.setMeasureUnitIds(uList.toArray(new Long[0]));
        }
        if (!"basecurrency".equals(currencyVal = filterInfo.getString("currency")) && !"allcurrency".equals(currencyVal)) {
            param.setCurrencyIds(new Long[]{Long.parseLong(filterInfo.getString("currency"))});
        } else if ("basecurrency".equals(currencyVal)) {
            param.setAddAmountFilter(false);
        }
        return param;
    }
}

