/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subsidiary.v2.core.ds.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.report.FilterInfo;
import kd.bos.orm.query.QFilter;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.bd.vo.CommonAssist;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.subsidiary.v2.core.SubsidiaryQueryContext;
import kd.fi.gl.report.subsidiary.v2.core.SubsidiaryRowFactory;
import kd.fi.gl.report.subsidiary.v2.core.ds.IDataSource;
import kd.fi.gl.report.subsidiary.v2.core.model.AssistValueGroup;
import kd.fi.gl.report.subsidiary.v2.core.model.RowType;
import kd.fi.gl.report.subsidiary.v2.core.model.SubsidiaryRow;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.MulCurReportUtil;
import kd.fi.gl.util.SubsiDiaryHelper;
import org.apache.commons.lang3.tuple.Triple;

public class SubsidiaryVoucherDS
implements IDataSource<SubsidiaryRow> {
    @Override
    public Iterable<SubsidiaryRow> getData() {
        SubsidiaryQueryContext context = SubsidiaryQueryContext.getCurrent();
        DataSet ds = this.doQuery(context);
        return SubsidiaryVoucherDS.createRow(ds, context.getQueryParam());
    }

    static List<SubsidiaryRow> createRow(DataSet ds, QueryParamRpt queryParam) {
        RowMeta rowMeta = ds.getRowMeta();
        SubsidiaryQueryContext context = SubsidiaryQueryContext.getCurrent();
        int voucherId = rowMeta.getFieldIndex("voucherid", false);
        int entryId = rowMeta.getFieldIndex("fentryid", false);
        int bookedDate = rowMeta.getFieldIndex("bookeddate", false);
        int period = rowMeta.getFieldIndex("period", false);
        int currency = rowMeta.getFieldIndex("currency", false);
        int measureunit = rowMeta.getFieldIndex("measureunit", false);
        int entrydc = rowMeta.getFieldIndex("entrydc", false);
        int voucherType = rowMeta.getFieldIndex("vouchertype", false);
        int voucherNo = rowMeta.getFieldIndex("billno", false);
        int debitfor = rowMeta.getFieldIndex("debitfor", false);
        int creditfor = rowMeta.getFieldIndex("creditfor", false);
        int debitlocal = rowMeta.getFieldIndex("debitlocal", false);
        int creditlocal = rowMeta.getFieldIndex("creditlocal", false);
        int quantity = rowMeta.getFieldIndex("quantity", false);
        int acctMid = rowMeta.getFieldIndex("account", false);
        int forCurrency = rowMeta.getFieldIndex("forcurrency");
        LinkedList<SubsidiaryRow> result = new LinkedList<SubsidiaryRow>();
        List commonAssists = queryParam.getCommonAssists().stream().map(CommonAssist::getKey).collect(Collectors.toList());
        boolean queryCurrency = queryParam.isQueryCurrency();
        boolean showQty = queryParam.isShowQty();
        boolean noComAssist = commonAssists.size() == 0;
        boolean hasNoSortExtField = context.getSortExtFieldAlias().size() == 0;
        for (Row row : ds) {
            Long acctMasterID = row.getLong(acctMid);
            String acctNumber = context.getAccountNumberFromCache(acctMasterID);
            Long acctId = context.getAccountIdFromCache(acctMasterID);
            AssistValueGroup assistValueGroup = AssistValueGroup.create(context.getAssistEntries(), row, context.isExportAll());
            Long currencyId = queryCurrency ? row.getLong(currency) : 0L;
            Long unitId = showQty ? row.getLong(measureunit) : 0L;
            Long periodId = row.getLong(period);
            SubsidiaryRow subsidiaryRow = SubsidiaryRowFactory.createNewRow(RowType.LEAF, assistValueGroup, acctNumber, currencyId, unitId, periodId, acctMasterID, acctId);
            long[] comAssistIds = noComAssist ? new long[]{} : commonAssists.stream().mapToLong(arg_0 -> ((Row)row).getLong(arg_0)).toArray();
            HashMap<String, Object> extSortFields = hasNoSortExtField ? new HashMap<String, Object>() : context.getSortExtFieldAlias().stream().collect(Collectors.toMap(field -> field, arg_0 -> ((Row)row).get(arg_0)));
            subsidiaryRow.setForCurrency(row.getLong(forCurrency));
            subsidiaryRow.setVoucherId(row.getLong(voucherId));
            subsidiaryRow.setVoucherEntryId(row.getLong(entryId));
            subsidiaryRow.setExtSortVoucherFields(extSortFields);
            subsidiaryRow.setComAssistValues(comAssistIds);
            subsidiaryRow.setPeriodId(periodId);
            subsidiaryRow.setBookedDate(row.getDate(bookedDate));
            subsidiaryRow.setVtNum(context.getVchTypeFromCache(row.getLong(voucherType)));
            subsidiaryRow.setVoucherNo(row.getString(voucherNo));
            subsidiaryRow.setEndDC(row.getInteger(entrydc));
            if (queryCurrency) {
                subsidiaryRow.setDebitFor(row.getBigDecimal(debitfor));
                subsidiaryRow.setCreditFor(row.getBigDecimal(creditfor));
            }
            subsidiaryRow.setDebitLocal(row.getBigDecimal(debitlocal));
            subsidiaryRow.setCreditLocal(row.getBigDecimal(creditlocal));
            if (showQty) {
                if ("1".equals(row.getString(entrydc))) {
                    subsidiaryRow.setDebitQty(row.getBigDecimal(quantity));
                } else {
                    subsidiaryRow.setCreditQty(row.getBigDecimal(quantity));
                }
            }
            result.add(subsidiaryRow);
        }
        return result;
    }

    private DataSet doQuery(SubsidiaryQueryContext context) {
        List<QFilter> baseFilters = this.getBaseFilters(context);
        Triple triple = FlexUtils.buildDynamicORMAssistOnVoucherWithZero(context.getAssistEntries(), (boolean)true);
        baseFilters.addAll((Collection)triple.getMiddle());
        if (!context.isExportAll()) {
            ((List)triple.getRight()).clear();
        }
        return VoucherQueryUtils.ormQueryDataSet((IDataEntityType)((IDataEntityType)triple.getLeft()), (String)this.getSelectFields(context, (List)triple.getRight()), (QFilter[])baseFilters.toArray(new QFilter[0]), null, (int)-1);
    }

    String getSelectFields(SubsidiaryQueryContext context, List<String> right) {
        String voucherSel = "id voucherid,entries.id fentryid,bookeddate,period,vouchertype, billno, entries.entrydc entrydc, entries.account.masterid account,entries.debitlocal debitlocal,entries.creditlocal creditlocal, entries.currency forcurrency";
        QueryParamRpt queryParam = context.getQueryParam();
        if (queryParam.isQueryCurrency()) {
            voucherSel = voucherSel + ",entries.currency currency,entries.debitori debitfor,entries.creditori creditfor";
        }
        if (queryParam.isShowQty()) {
            voucherSel = voucherSel + ", entries.measureunit measureunit, entries.quantity quantity";
        }
        voucherSel = MulCurReportUtil.mulCurVoucherAmountToLocalAlias((String)voucherSel, (String)queryParam.getMulCur());
        String sortExtVoucherFields = String.join((CharSequence)",", context.getSortExtVoucherFields());
        String comAssistFields = queryParam.getCommonAssists().stream().map(commonAssist -> "entries." + commonAssist.key + " " + commonAssist.key).collect(Collectors.joining(", "));
        String assistBdFields = String.join((CharSequence)",", right);
        return Arrays.stream(new String[]{voucherSel, sortExtVoucherFields, comAssistFields, assistBdFields}).filter(s -> s.length() > 0).collect(Collectors.joining(", "));
    }

    List<QFilter> getBaseFilters(SubsidiaryQueryContext context) {
        FilterInfo filter;
        QueryParamRpt qpRpt = context.getQueryParam();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)context.getOrgId()));
        filters.add(new QFilter("booktype", "=", (Object)qpRpt.getBookType()));
        filters.add(new QFilter("entries.account", "in", (Object)SubsiDiaryHelper.getAcctIdByMasterId(context.getAcctMids())));
        filters.add(new QFilter("billstatus", "in", (Object)new String[]{"B", "C"}));
        filters.add(new QFilter("period", ">=", (Object)qpRpt.getStartPeriod()));
        filters.add(new QFilter("period", "<=", (Object)qpRpt.getEndPeriod()));
        if (!qpRpt.isSynCurrency() && !qpRpt.isAllCurrency()) {
            filters.add(new QFilter("entries.currency", "=", (Object)qpRpt.getCurrency()));
        }
        if ((filter = qpRpt.getFilterInfo()).getDynamicObjectCollection("measureunits") != null) {
            Object[] ids = filter.getDynamicObjectCollection("measureunits").stream().map(DataEntityBase::getPkValue).map(Long.class::cast).toArray();
            filters.add(new QFilter("entries.measureunit", "in", (Object)ids));
        }
        if (qpRpt.isSubstractPL()) {
            filters.add(new QFilter("sourcetype", "!=", (Object)"1"));
        }
        filters.addAll(qpRpt.getComAssistFiltersForBill(key -> "entries." + key));
        QFilter commonFilter = filter.getCommFilter("gl_voucher");
        if (commonFilter != null) {
            filters.add(commonFilter);
        }
        return filters;
    }
}

