/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.acccurrent.constant;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.acccurrent.constant.AcccurrentFormula;
import kd.fi.gl.acccurrent.constant.AcctAssistKey;
import kd.fi.gl.acccurrent.formater.AccountNumIDParam;
import kd.fi.gl.acccurrent.iterator.IntArraySequenceIterator;
import kd.fi.gl.acccurrent.iterator.IntArraySequenceIteratorBuilder;

public class AccFormulaBuildMap {
    private static final Log log = LogFactory.getLog(AccFormulaBuildMap.class);
    private AccountNumIDParam numIDParam;
    private Map<Long, Map<String, Set<Object>>> acctToAssistMap;

    public AccFormulaBuildMap(AccountNumIDParam numIDParam, Map<Long, Map<String, Set<Object>>> acctToAssistMap) {
        this.numIDParam = numIDParam;
        this.acctToAssistMap = acctToAssistMap;
    }

    public void buildMap(AcccurrentFormula formula, Map<AcctAssistKey, Set<AcccurrentFormula>> acctAssistFormulaKeyMap, Set<Set<String>> valFlexsSet) {
        if (DebugTrace.enable()) {
            this.logInfo("buildMap param(formula):" + SerializationUtils.toJsonString((Object)formula));
            this.logInfo("buildMap param(acctAssistFormulaKeyMap):" + SerializationUtils.toJsonString(acctAssistFormulaKeyMap));
            this.logInfo("buildMap param(valFlexsSet):" + SerializationUtils.toJsonString(valFlexsSet));
        }
        IntArraySequenceIteratorBuilder builder = new IntArraySequenceIteratorBuilder();
        Collection<Map<String, Set<Object>>> coll = this.acctToAssistMap.values();
        HashMap<String, Set<Object>> assMap = new HashMap<String, Set<Object>>(coll.size());
        if (!coll.isEmpty()) {
            assMap.putAll(coll.iterator().next());
        }
        HashSet<String> valFlexs = new HashSet<String>(assMap.size());
        for (Map.Entry assEntry : assMap.entrySet()) {
            String flex = (String)assEntry.getKey();
            Set vals = (Set)assEntry.getValue();
            if (vals == null || vals.isEmpty()) continue;
            valFlexs.add(flex);
            HashSet valSet = new HashSet(vals.size());
            for (Object val : vals) {
                if (val instanceof Set) {
                    Set setV = (Set)val;
                    valSet.addAll(setV);
                    continue;
                }
                valSet.add(val);
            }
            builder.addArrayValue(valSet.toArray(new Object[0]));
        }
        Set allFlexs = assMap.keySet();
        HashSet<String> flexSet = new HashSet<String>(valFlexs.size());
        flexSet.addAll(valFlexs);
        valFlexsSet.add(flexSet);
        IntArraySequenceIterator iterator = builder.build();
        LinkedList<Object[]> objFlexList = new LinkedList<Object[]>();
        while (iterator.hasNext()) {
            objFlexList.add(iterator.next().toArray());
        }
        Map<Long, Set<String>> acctToAcccurrentFlexsMap = this.numIDParam.getAcctToAcccurrentFlexsMap();
        for (Long acct : this.acctToAssistMap.keySet()) {
            Set<Long> leafAcctIds = this.numIDParam.getAllLeafAccounts(acct);
            if (!CollectionUtils.isNotEmpty(leafAcctIds)) continue;
            for (Long leafAcctId : leafAcctIds) {
                Long masterId = this.numIDParam.getMasterIdByAcctId(leafAcctId);
                Set<String> allAcccurrentFlexs = acctToAcccurrentFlexsMap.get(leafAcctId);
                if (!allAcccurrentFlexs.containsAll(allFlexs)) continue;
                if (valFlexs.isEmpty()) {
                    HashMap<String, Object> assgMap = new HashMap<String, Object>(8);
                    AcctAssistKey key = new AcctAssistKey(masterId, assgMap);
                    Set tmpFormulas = acctAssistFormulaKeyMap.computeIfAbsent(key, k -> new HashSet(1024));
                    tmpFormulas.add(formula);
                    continue;
                }
                for (Object[] objFlex : objFlexList) {
                    HashMap<String, Object> assgMap = new HashMap<String, Object>(8);
                    int index = 0;
                    for (String flexKey : valFlexs) {
                        assgMap.put(flexKey, objFlex[index]);
                        ++index;
                    }
                    AcctAssistKey key = new AcctAssistKey(masterId, assgMap);
                    Set tmpFormulas = acctAssistFormulaKeyMap.computeIfAbsent(key, k -> new HashSet(1024));
                    tmpFormulas.add(formula);
                }
            }
        }
    }

    private void logInfo(String msg) {
        log.info("acctagedebug:" + msg);
    }
}

