/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.acccurrent.constant;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.acccurrent.constant.AccFormulaBuildMap;
import kd.fi.gl.acccurrent.constant.AcccurrentBatchKey;
import kd.fi.gl.acccurrent.constant.AcccurrentFormula;
import kd.fi.gl.acccurrent.constant.AcctAssistKey;
import kd.fi.gl.acccurrent.formater.AccountNumIDParam;
import kd.fi.gl.acccurrent.formater.AccountNumberIDFormater;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.acct.AcctUtil;
import kd.fi.gl.reciprocal.ReciprocalScheme;
import kd.fi.gl.reciprocal.ReciprocalUtils;
import kd.fi.gl.reciprocal.simulate.WriteOff;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.service.GLThreadService;
import kd.fi.gl.util.InterfacePermissionService;
import kd.fi.gl.util.PermissionType;
import kd.fi.gl.util.ReClassUtils;

public class BCMAcccurrentContext {
    private static final int TIME = 86400000;
    private static final int RESULT_TYPE_DECIMAL = 1;
    private static final int RESULT_TYPE_ERROR = -1;
    private static final String RESULT_TYPE = "type";
    private static final String RESULT_VAL = "v";
    private static final int INIT_ORG_CAPACITY = 8;
    private static final int INIT_CAPACITY = 1024;
    private static final int MAPSIZE_MAX = 100000;
    private static final String BASECURRENCY = "basecurrency";
    private Map<AcccurrentBatchKey, List<AcccurrentFormula>> orgAndFormulaMap = new HashMap<AcccurrentBatchKey, List<AcccurrentFormula>>(1024);
    private Set<String> currencyNumbers = new HashSet<String>(8);
    private Map<String, Long> currencyNumberToIdsMap;
    private static final Log log = LogFactory.getLog(BCMAcccurrentContext.class);
    private String defaultOrgNumber;
    private String defaultBookTypeNumber;
    private String defaultCurNumber;
    private int defaultFy;
    private int defaultPeriod;
    private Map<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>(1024);
    private HasPermOrgResult permOrgResult;
    private String permName;

    public void addFormula(String orgNum, String bookTypeNum, Date bookedDate, AcccurrentFormula formula) {
        AcccurrentBatchKey batchKey = new AcccurrentBatchKey(orgNum, bookTypeNum, bookedDate);
        List formulas = this.orgAndFormulaMap.computeIfAbsent(batchKey, p -> new ArrayList(1024));
        formulas.add(formula);
        this.currencyNumbers.add(formula.getCurrencyNumber());
    }

    public Map<String, Map<String, Object>> complie() throws Exception {
        this.currencyNumberToIdsMap = ReClassUtils.numbersToIds("bd_currency", this.currencyNumbers, null);
        this.permOrgResult = InterfacePermissionService.getAllPermOrgs(PermissionType.ACCTAGE);
        this.permName = InterfacePermissionService.getPermName(PermissionType.ACCTAGE);
        ArrayList<Future> futures = new ArrayList<Future>(this.orgAndFormulaMap.size());
        for (final Map.Entry<AcccurrentBatchKey, List<AcccurrentFormula>> entry : this.orgAndFormulaMap.entrySet()) {
            futures.add(GLThreadService.computeAcct((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    BCMAcccurrentContext.this.singleOrgComplie((AcccurrentBatchKey)entry.getKey(), (List)entry.getValue());
                    return true;
                }
            }));
        }
        for (Future future : futures) {
            future.get();
        }
        this.logInfoTest("resultMap Count:" + this.resultMap.size());
        return this.resultMap;
    }

    private void singleOrgComplie(AcccurrentBatchKey batchKey, List<AcccurrentFormula> formulas) throws ParseException {
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((String)batchKey.getOrgNum(), (String)batchKey.getBookTypeNum());
        if (bookInfo == null) {
            String msg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u8d26\u7c3f\u7c7b\u578b%2$s\u65e0\u6cd5\u627e\u5230\u76f8\u5e94\u7684\u8d26\u7c3f\u3002", (String)"BCMAcccurrentContext_0", (String)"fi-gl-mservice", (Object[])new Object[0]), batchKey.getOrgNum(), batchKey.getBookTypeNum());
            for (AcccurrentFormula formula : formulas) {
                this.addErrorRst(formula.getKey(), msg);
            }
            this.logInfo(msg);
        } else {
            Date periodEndDate;
            Long orgId = bookInfo.getOrgId();
            String errorMsg = AcctUtil.checkPermByOrgId(batchKey.getOrgNum(), this.permName, orgId, this.permOrgResult);
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                for (AcccurrentFormula formula : formulas) {
                    this.addErrorRst(formula.getKey(), errorMsg);
                }
                this.logInfo(errorMsg);
                return;
            }
            Long bookTypeId = bookInfo.getBookTypeId();
            if (batchKey.getBookedDate() == null) {
                periodEndDate = this.getDefaultDate(bookInfo.getPeriodTypeId());
                if (periodEndDate == null) {
                    String msg = String.format(ResManager.loadKDString((String)"\u62a5\u8868\u9ed8\u8ba4\u5e74%1$s\u6708%2$s\uff0c\u672a\u627e\u5230\u76f8\u5e94\u671f\u95f4\u3002", (String)"BCMAcccurrentContext_2", (String)"fi-gl-mservice", (Object[])new Object[0]), this.defaultFy, this.defaultPeriod);
                    for (AcccurrentFormula formula : formulas) {
                        this.addErrorRst(formula.getKey(), msg);
                    }
                    return;
                }
            } else {
                periodEndDate = batchKey.getBookedDate();
            }
            Date bookedDate = batchKey.getBookedDate() == null ? periodEndDate : batchKey.getBookedDate();
            List acctTableIds = ReportUtils.getVerAcctTable((long)orgId, (long)bookInfo.getBookTypeId(), (long)bookInfo.getPeriodTypeId(), (Date)bookedDate);
            Long accountTableId = (Long)acctTableIds.get(0);
            this.logInfo(String.format("org:%s, booktype:%s, accounttable:%s, bookdate:%s", orgId, bookTypeId, accountTableId, bookedDate));
            AccountNumIDParam numIDParam = new AccountNumIDParam(orgId, bookTypeId, accountTableId, formulas, bookedDate);
            this.addFormatError(numIDParam);
            Set<Long> allLeafMasterIds = numIDParam.getAllLeafMasterIds();
            long pTime = System.currentTimeMillis();
            DataSet records = this.queryAcccurrentBal(bookInfo, accountTableId, bookedDate, allLeafMasterIds);
            long aTime = System.currentTimeMillis();
            this.logInfoTest("queryAcccurrentBal Reciprocal Simulate Time" + (aTime - pTime));
            if (DebugTrace.enable()) {
                this.printLogRecord(records.copy());
            }
            long pTime1 = System.currentTimeMillis();
            this.dealFormulaMap(records, formulas, numIDParam, bookInfo, accountTableId, bookedDate, periodEndDate);
            long aTime1 = System.currentTimeMillis();
            this.logInfoTest("dealFormulaMap Formula Map Time\uff1a" + (aTime1 - pTime1));
        }
    }

    private Date getDefaultDate(long peirodType) {
        Date periodEndDate = this.queryPeriodEndDate(this.defaultFy, this.defaultPeriod, peirodType);
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            periodEndDate = simpleDateFormat.parse(simpleDateFormat.format(periodEndDate));
        }
        catch (Exception e) {
            this.logInfoTest(String.format("%s periodEndDate parse error: %s", periodEndDate, e.getStackTrace()));
            periodEndDate = null;
        }
        return periodEndDate;
    }

    private void printLogRecord(DataSet records) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (Row record : records) {
            ++count;
            sb.append("id:");
            sb.append(record.getLong("id"));
            sb.append("amountbal:");
            sb.append(record.getBigDecimal("amountbalfor"));
            sb.append(',');
        }
        sb.append(String.format("return record size: %s, ", count));
        this.logInfo(sb.toString());
    }

    private void updateFormulaAmount(Map<AcctAssistKey, Set<AcccurrentFormula>> accountAndFormulaKeyMap, DataSet records, Date defaultExpireDate, Set<Set<String>> valFlexsSet) {
        if (DebugTrace.enable()) {
            if (null != accountAndFormulaKeyMap && !accountAndFormulaKeyMap.isEmpty()) {
                for (Map.Entry<AcctAssistKey, Set<AcccurrentFormula>> entry : accountAndFormulaKeyMap.entrySet()) {
                    log.info("=====BCMAcccurrentContext_updateFormulaAmount_key:{}=====", (Object)(entry.getKey() == null ? "null" : JSON.toJSONString((Object)entry.getKey())));
                    if (entry.getValue() != null) {
                        for (AcccurrentFormula acccurrentFormula : entry.getValue()) {
                            log.info("=====BCMAcccurrentContext_updateFormulaAmount_acccurrentFormula:{}=====", (Object)(acccurrentFormula == null ? "null" : JSON.toJSONString((Object)acccurrentFormula)));
                        }
                    }
                    this.logInfo(String.format("updateFormulaAmount param(accountAndFormulaKeyMap) entry: %s - %s", entry.getKey() == null ? "null" : entry.getKey().toString(), entry.getValue() == null || entry.getValue().isEmpty() ? "nullOrEmpty" : SerializationUtils.toJsonString(entry.getValue())));
                }
            }
            this.logInfo("updateFormulaAmount param(defaultExpireDate):" + defaultExpireDate);
            this.logInfo("updateFormulaAmount param(valFlexsSet):" + SerializationUtils.toJsonString(valFlexsSet));
        }
        for (Row record : records) {
            if (DebugTrace.enable()) {
                StringBuilder sb = new StringBuilder();
                sb.append("id:").append(record.getLong("id"));
                sb.append(",assgrp:").append(record.getLong("assgrp"));
                sb.append(",assval:").append(record.getString("assval"));
                sb.append(",amountbal:").append(record.getBigDecimal("amountbal"));
                sb.append(",amountbalfor:").append(record.getBigDecimal("amountbalfor"));
                sb.append(",bizDate:").append(record.getDate("bizDate"));
                sb.append(",expiredate:").append(record.getDate("expiredate"));
                sb.append(",currencyfor:").append(record.getLong("currencyfor"));
                sb.append(",currencylocal:").append(record.getLong("currencylocal"));
                log.info("ACCTAGE:updateFormulaAmount on ReciprocalRecord :{}", (Object)sb.toString());
            }
            Long accountId = record.getLong("accountid");
            JSONObject assMap = JSONObject.parseObject((String)record.getString("assval"));
            for (Set<String> valFlexs : valFlexsSet) {
                HashMap<String, Object> valFlexMap = new HashMap<String, Object>(8);
                boolean isMatchFlex = true;
                for (String flex : valFlexs) {
                    if (assMap.get(flex) != null) {
                        valFlexMap.put(flex, assMap.get(flex));
                        continue;
                    }
                    isMatchFlex = false;
                    break;
                }
                if (!isMatchFlex) {
                    if (!DebugTrace.enable()) continue;
                    this.logInfo("updateFormulaAmount isMatchFlex:false on " + SerializationUtils.toJsonString(valFlexs));
                    continue;
                }
                AcctAssistKey key = new AcctAssistKey(accountId, valFlexMap);
                Set<AcccurrentFormula> acctFormulas = accountAndFormulaKeyMap.get(key);
                if (acctFormulas == null) {
                    if (!DebugTrace.enable()) continue;
                    this.logInfo("updateFormulaAmount acctFormulas is null on AcctAssistKey:" + key.toString());
                    continue;
                }
                for (AcccurrentFormula acctFormula : acctFormulas) {
                    boolean islocalCurrency;
                    if (!this.isMatch(record, acctFormula, accountId, defaultExpireDate)) {
                        if (!DebugTrace.enable()) continue;
                        this.logInfo(String.format("updateFormulaAmount acctFormula isMatch: false, record: %s, acctFormula: %s, accountId: %s, defaultExpireDate: %s", key.toString(), SerializationUtils.toJsonString((Object)acctFormula), accountId, defaultExpireDate));
                        continue;
                    }
                    if (DebugTrace.enable()) {
                        this.logInfo(String.format("updateFormulaAmount acctFormula isMatch: true, record: %s, acctFormula: %s, accountId: %s, defaultExpireDate: %s", key.toString(), SerializationUtils.toJsonString((Object)acctFormula), accountId, defaultExpireDate));
                    }
                    Map<String, Object> result = this.resultMap.get(acctFormula.getKey());
                    boolean bl = islocalCurrency = acctFormula.isLocalCurrency() || BASECURRENCY.equalsIgnoreCase(acctFormula.getCurrencyNumber()) || "".equalsIgnoreCase(acctFormula.getCurrencyNumber());
                    if (result == null) {
                        result = new HashMap<String, Object>(8);
                        result.put(RESULT_VAL, islocalCurrency ? record.getBigDecimal("amountbal") : record.getBigDecimal("amountbalfor"));
                        result.put(RESULT_TYPE, 1);
                        this.resultMap.put(acctFormula.getKey(), result);
                        continue;
                    }
                    int resultType = (Integer)result.get(RESULT_TYPE);
                    if (resultType == -1) continue;
                    BigDecimal amt = (BigDecimal)result.get(RESULT_VAL);
                    result.put(RESULT_VAL, amt.add(islocalCurrency ? record.getBigDecimal("amountbal") : record.getBigDecimal("amountbalfor")));
                }
            }
        }
        if (accountAndFormulaKeyMap != null) {
            accountAndFormulaKeyMap.clear();
        }
        valFlexsSet.clear();
    }

    private boolean isMatch(Row record, AcccurrentFormula acctFormula, Long accountId, Date defaultExpireDate) {
        Long currencyId;
        String currencyNum = acctFormula.getCurrencyNumber();
        if (!(BASECURRENCY.equals(currencyNum) || StringUtils.isEmpty((CharSequence)currencyNum) || (currencyId = this.currencyNumberToIdsMap.get(currencyNum)) != null && (currencyId == null || record.getLong("currencyfor").equals(currencyId)))) {
            return false;
        }
        int ageDayFrom = acctFormula.getAgingDayFrom();
        int ageDayTo = acctFormula.getAgingDayTo();
        Date recordDate = acctFormula.isCaculatebyExpireDate() ? record.getDate("expiredate") : record.getDate("bizDate");
        Date expireDate = acctFormula.getExpireDate() == null ? defaultExpireDate : acctFormula.getExpireDate();
        recordDate = this.clearDateHMS(recordDate);
        expireDate = this.clearDateHMS(expireDate);
        int diff = (int)((expireDate.getTime() - recordDate.getTime()) / 86400000L);
        return !(acctFormula.isUnDue() ? diff > ageDayFrom * -1 || diff < ageDayTo * -1 : diff < ageDayFrom || diff > ageDayTo);
    }

    private Date clearDateHMS(Date date) {
        date.setHours(0);
        date.setMinutes(0);
        date.setSeconds(0);
        return date;
    }

    public int clear(Map<Long, Set<AcccurrentFormula>> accountAndFormulaKeyMap) {
        if (null != accountAndFormulaKeyMap) {
            accountAndFormulaKeyMap.clear();
        }
        return 0;
    }

    private Date queryPeriodEndDate(int defaultFy, int defaultPeriod, long periodTypeId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        QFilter fperiodTypeId = new QFilter("periodtype", "=", (Object)periodTypeId);
        QFilter ffy = new QFilter("periodyear", "=", (Object)defaultFy);
        QFilter fperiod = new QFilter("periodnumber", "=", (Object)defaultPeriod);
        filters.add(fperiod);
        filters.add(fperiodTypeId);
        filters.add(ffy);
        DataSet periodSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_period", (String)"enddate", (QFilter[])filters.toArray(new QFilter[0]), null);
        Date endDate = null;
        for (Row row : periodSet) {
            endDate = row.getDate("enddate");
        }
        return endDate;
    }

    private void addFormatError(AccountNumIDParam numIDParam) {
        Map<String, String> errMap = numIDParam.getErrorInfoMap();
        for (Map.Entry<String, String> entry : errMap.entrySet()) {
            this.addErrorRst(entry.getKey(), entry.getValue());
        }
    }

    private void dealFormulaMap(DataSet records, List<AcccurrentFormula> formulas, AccountNumIDParam numIDParam, AccountBookInfo bookInfo, long accountTableId, Date bookedDate, Date periodEndDate) {
        HashMap<AcctAssistKey, Set<AcccurrentFormula>> acctAssistFormulaKeyMap = new HashMap<AcctAssistKey, Set<AcccurrentFormula>>(1024);
        HashSet<Set<String>> valFlexs = new HashSet<Set<String>>(8);
        long pTime = System.currentTimeMillis();
        for (AcccurrentFormula formula : formulas) {
            Map<Long, Map<String, Set<Object>>> acctToAssistMap = AccountNumberIDFormater.parseAcctAssistList(formula.getAcctAssistListStr(), numIDParam, formula.getKey());
            formula.setAcctToAssistMap(acctToAssistMap);
            if (DebugTrace.enable()) {
                this.logInfo("buildMap on acctToAssistMap:" + SerializationUtils.toJsonString(acctToAssistMap));
            }
            AccFormulaBuildMap buildMap = new AccFormulaBuildMap(numIDParam, acctToAssistMap);
            buildMap.buildMap(formula, acctAssistFormulaKeyMap, valFlexs);
            if (acctAssistFormulaKeyMap.size() <= 100000) continue;
            long aTime = System.currentTimeMillis();
            this.logInfoTest("buildMap 10W Formula Map Time\uff1a" + (aTime - pTime));
            this.updateFormulaAmount(acctAssistFormulaKeyMap, records.copy(), periodEndDate, valFlexs);
            long aTime1 = System.currentTimeMillis();
            this.logInfoTest("updateFormulaAmount 10W Formula Map Time\uff1a" + (aTime1 - aTime));
        }
        if (!acctAssistFormulaKeyMap.isEmpty()) {
            long aTime = System.currentTimeMillis();
            int count = acctAssistFormulaKeyMap.size();
            this.logInfoTest("buildMap " + count + " Formula Map Time\uff1a" + (aTime - pTime));
            this.updateFormulaAmount(acctAssistFormulaKeyMap, records.copy(), periodEndDate, valFlexs);
            long aTime1 = System.currentTimeMillis();
            this.logInfoTest("updateFormulaAmount " + count + " Formula Map Time\uff1a" + (aTime1 - aTime));
        }
    }

    private DataSet queryAcccurrentBal(AccountBookInfo bookInfo, Long accountTableId, Date bookedDate, Set<Long> detailAcctMasterIds) {
        List<ReciprocalScheme> schemes = this.buildDefaultReciprocalScheme(bookInfo, accountTableId, bookedDate, detailAcctMasterIds);
        StringBuilder sb = new StringBuilder();
        for (ReciprocalScheme scheme : schemes) {
            sb.append("scheme:");
            sb.append(scheme.getNumber());
            sb.append(",org:");
            sb.append(scheme.getOrg());
            sb.append(",account:");
            sb.append(scheme.getAccountList());
            sb.append(',');
        }
        this.logInfo(sb.toString());
        return this.doSimulateWriteOff(schemes);
    }

    private List<ReciprocalScheme> buildDefaultReciprocalScheme(AccountBookInfo bookInfo, Long accountTableId, Date bookedDate, Set<Long> detailAcctMasterIds) {
        Long orgId = bookInfo.getOrgId();
        List schemes = ReciprocalUtils.loadRcpSchemes((Long)orgId, (Long)accountTableId, detailAcctMasterIds, (Long)0L);
        HashSet existSchemeAcctIds = new HashSet(detailAcctMasterIds.size());
        for (ReciprocalScheme scheme : schemes) {
            existSchemeAcctIds.addAll(scheme.getAccountList());
        }
        detailAcctMasterIds.removeAll(existSchemeAcctIds);
        if (!detailAcctMasterIds.isEmpty()) {
            ReciprocalScheme scheme = new ReciprocalScheme();
            scheme.setOrg(orgId);
            scheme.setAccountList(new ArrayList<Long>(detailAcctMasterIds));
            schemes.add(scheme);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(bookedDate);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        bookedDate = calendar.getTime();
        for (ReciprocalScheme scheme : schemes) {
            scheme.setChildOrgs(Collections.singleton(orgId));
            scheme.setBookType(Long.valueOf(bookInfo.getBookTypeId()));
            scheme.setBookedDate(bookedDate);
            scheme.setPeriodType(Long.valueOf(bookInfo.getPeriodTypeId()));
            scheme.setAccountTableId(accountTableId);
            if (scheme.getCurrencyList() == null) {
                scheme.setCurrencyList(new ArrayList(8));
            }
            scheme.setShowByamount(true);
        }
        return schemes;
    }

    private DataSet doSimulateWriteOff(List<ReciprocalScheme> schemes) {
        long pTime = System.currentTimeMillis();
        DataSet recordsDt = WriteOff.getWriteOffInstance().schemeSimulateWriteOffDetail(schemes);
        long aTime = System.currentTimeMillis();
        this.logInfoTest("engine.run() Reciprocal Simulate Time" + (aTime - pTime));
        return recordsDt;
    }

    public void addErrorRst(String formulaKey, String msg) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        result.put(RESULT_VAL, msg);
        result.put(RESULT_TYPE, -1);
        this.resultMap.put(formulaKey, result);
    }

    private void logInfo(String msg) {
        log.info("ACCTAGE:" + msg);
    }

    private void logInfoTest(String msg) {
        log.info("ACCTAGE Take Up Time:" + msg);
    }

    public String getDefaultOrgNumber() {
        return this.defaultOrgNumber;
    }

    public void setDefaultOrgNumber(String defaultOrgNumber) {
        this.defaultOrgNumber = defaultOrgNumber;
    }

    public String getDefaultBookTypeNumber() {
        return this.defaultBookTypeNumber;
    }

    public void setDefaultBookTypeNumber(String defaultBookTypeNumber) {
        this.defaultBookTypeNumber = defaultBookTypeNumber;
    }

    public String getDefaultCurNumber() {
        return this.defaultCurNumber;
    }

    public void setDefaultCurNumber(String defaultCurNumber) {
        this.defaultCurNumber = defaultCurNumber;
    }

    public int getDefaultFy() {
        return this.defaultFy;
    }

    public void setDefaultFy(int defaultFy) {
        this.defaultFy = defaultFy;
    }

    public int getDefaultPeriod() {
        return this.defaultPeriod;
    }

    public void setDefaultPeriod(int defaultPeriod) {
        this.defaultPeriod = defaultPeriod;
    }
}

