/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.acccurrent.iterator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kd.fi.gl.acccurrent.iterator.IntArraySequenceIterator;

public class IntArraySequenceIteratorBuilder {
    private List<Object> resultArray;
    private List<MemberStep> _stepItems;
    public static final IntArraySequenceIterator EMPTY_Iterator = new EmptyIntArraySequenceIterator();

    public IntArraySequenceIteratorBuilder() {
        this.clear();
    }

    public IntArraySequenceIteratorBuilder(int[] resultArray) {
        this.resultArray = new ArrayList<Object>(resultArray.length);
        for (int i : resultArray) {
            this.resultArray.add(i);
        }
        this._stepItems = new ArrayList<MemberStep>(resultArray.length);
    }

    public List<Object> getResultArray() {
        return this.resultArray;
    }

    public final void reset() {
        if (!this._stepItems.isEmpty()) {
            for (MemberStep step : this._stepItems) {
                if (step == null) continue;
                step.reset();
            }
        }
    }

    private void clear() {
        this.resultArray = new ArrayList<Object>();
        this._stepItems = new ArrayList<MemberStep>();
    }

    public IntArraySequenceIteratorBuilder addFixedValue(Object value) {
        this._stepItems.add(null);
        this.resultArray.add(value);
        return this;
    }

    public IntArraySequenceIteratorBuilder setFixedValue(int index, Object value) {
        this._stepItems.set(index, null);
        this.resultArray.set(index, value);
        return this;
    }

    public IntArraySequenceIteratorBuilder setRangeValue(int index, int start, int end, boolean forward) {
        if (end == start) {
            this.setFixedValue(index, start);
        } else if (forward) {
            this._stepItems.set(index, new ForwardRangeStep(this.resultArray, index, start, end));
        } else {
            this._stepItems.set(index, new BackwardRangeStep(this.resultArray, index, start, end));
        }
        return this;
    }

    public IntArraySequenceIteratorBuilder addRangeValue(int start, int end, boolean forward) {
        if (end == start) {
            this.addFixedValue(start);
        } else {
            this.resultArray.add(start);
            if (forward) {
                this._stepItems.add(new ForwardRangeStep(this.resultArray, this._stepItems.size(), start, end));
            } else {
                this._stepItems.add(new BackwardRangeStep(this.resultArray, this._stepItems.size(), start, end));
            }
        }
        return this;
    }

    public IntArraySequenceIteratorBuilder setArrayValue(int index, Object[] values) {
        if (values.length == 1) {
            this.setFixedValue(index, values[0]);
        } else {
            this._stepItems.set(index, new ArrayStep(this.resultArray, index, values));
        }
        return this;
    }

    public IntArraySequenceIteratorBuilder addArrayValue(Object[] values) {
        if (values.length == 1) {
            this.addFixedValue(values[0]);
        } else {
            this.resultArray.add(values[0]);
            this._stepItems.add(new ArrayStep(this.resultArray, this._stepItems.size(), values));
        }
        return this;
    }

    public IntArraySequenceIterator build() {
        MemberStep step;
        if (this._stepItems == null || this._stepItems.isEmpty()) {
            return EMPTY_Iterator;
        }
        ArrayList<MemberStep> bufList = new ArrayList<MemberStep>(this._stepItems.size());
        this.reset();
        for (int i = 0; i < this._stepItems.size() - 1; ++i) {
            step = this._stepItems.get(i);
            if (step == null) continue;
            step = step.copy();
            step.next();
            bufList.add(step);
        }
        step = this._stepItems.get(this._stepItems.size() - 1);
        if (step != null) {
            bufList.add(step);
        }
        if (bufList.isEmpty()) {
            return new SingleStepSequenceIterator(this.resultArray);
        }
        return new IntArraySequenceIterator(bufList.toArray(new MemberStep[0]), this.resultArray);
    }

    public class ArrayStep
    extends MemberStep {
        private static final long serialVersionUID = 2159742806875910172L;
        private Object[] values;
        private int end;

        public ArrayStep(List<Object> resultArray, int writePos, Object[] values) {
            super(resultArray, writePos);
            this.values = values;
            if (values.length <= 0) {
                throw new IllegalArgumentException();
            }
            this.end = values.length - 1;
            this.currentIndex = 0;
        }

        @Override
        public String toString() {
            return "ArrayStep [values=" + Arrays.toString(this.values) + ", end=" + this.end + ", currentIndex=" + this.currentIndex + ", writePos=" + this.writePos + ", resultArray=" + this.resultArray + "]";
        }

        @Override
        public void reset() {
            this.setResultValue(this.values[0]);
            this.currentIndex = 0;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex <= this.end;
        }

        @Override
        public Integer next() {
            if (this.currentIndex <= this.end) {
                this.setResultValue(this.values[this.currentIndex]);
                ++this.currentIndex;
                return this.currentIndex;
            }
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(this.currentIndex, this.end));
        }

        public ArrayStep copy() {
            return new ArrayStep(this.resultArray, this.writePos, this.values);
        }

        @Override
        public int getMemberCnt() {
            return this.values == null ? 0 : this.values.length;
        }

        public Object[] getValues() {
            return this.values;
        }
    }

    class BackwardRangeStep
    extends ForwardRangeStep {
        private static final long serialVersionUID = 7469249027580339266L;

        public BackwardRangeStep(List<Object> resultArray, int writePos, int start, int end, int step) {
            super(resultArray, writePos, start, end, step);
        }

        public BackwardRangeStep(List<Object> resultArray, int writePos, int start, int end) {
            this(resultArray, writePos, start, end, 1);
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex >= this.end;
        }

        @Override
        public Integer next() {
            if (this.currentIndex >= this.end) {
                this.setResultValue(this.currentIndex);
                this.currentIndex -= this.stepSize;
                return this.currentIndex;
            }
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(this.currentIndex, this.end));
        }

        @Override
        public int getCurrentIndex() {
            return this.currentIndex > this.start ? this.start : this.currentIndex;
        }

        @Override
        public BackwardRangeStep copy() {
            return new BackwardRangeStep(this.resultArray, this.writePos, this.start, this.end, this.stepSize);
        }

        @Override
        public int getMemberCnt() {
            return this.start - this.end + 1;
        }
    }

    class ForwardRangeStep
    extends MemberStep {
        private static final long serialVersionUID = 6451176381642209621L;
        protected int start;
        protected int end;
        protected int stepSize;

        public ForwardRangeStep(List<Object> resultArray, int writePos, int start, int end, int step) {
            super(resultArray, writePos);
            this.validateRange();
            this.start = start;
            this.end = end;
            this.stepSize = step;
            this.reset();
        }

        @Override
        public String toString() {
            return "ForwardRangeStep [start=" + this.start + ", end=" + this.end + ", stepSize=" + this.stepSize + ", currentIndex=" + this.currentIndex + ", writePos=" + this.writePos + ", resultArray=" + this.resultArray + "]";
        }

        @Override
        public final void reset() {
            this.setResultValue(this.start);
            this.currentIndex = this.start;
        }

        public ForwardRangeStep(List<Object> resultArray, int writePos, int start, int end) {
            this(resultArray, writePos, start, end, 1);
        }

        private void validateRange() {
            if (this.start > this.end) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex <= this.end;
        }

        @Override
        public Integer next() {
            if (this.currentIndex <= this.end) {
                this.setResultValue(this.currentIndex);
                this.currentIndex += this.stepSize;
                return this.currentIndex;
            }
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(this.currentIndex, this.end));
        }

        @Override
        public int getCurrentIndex() {
            return this.currentIndex < this.start ? this.start : this.currentIndex;
        }

        public ForwardRangeStep copy() {
            return new ForwardRangeStep(this.resultArray, this.writePos, this.start, this.end, this.stepSize);
        }

        @Override
        public int getMemberCnt() {
            return this.end - this.start + 1;
        }
    }

    public static abstract class MemberStep
    implements Iterator<Integer>,
    Serializable {
        private static final long serialVersionUID = 3352113408812046890L;
        protected int currentIndex;
        protected int writePos;
        List<Object> resultArray;

        public String toString() {
            return "MemberStep [currentIndex=" + this.currentIndex + ", writePos=" + this.writePos + ", resultArray=" + this.resultArray + "]";
        }

        public MemberStep(List<Object> resultArray, int writePos) {
            this.writePos = writePos;
            this.resultArray = resultArray;
        }

        public int getCurrentIndex() {
            return this.currentIndex;
        }

        protected void setResultValue(Object value) {
            this.resultArray.set(this.writePos, value);
        }

        protected String outOfBoundsMsg(int index, int end) {
            return "Index: " + index + ", Size: " + end;
        }

        public abstract void reset();

        public abstract <T extends MemberStep> T copy();

        public abstract int getMemberCnt();

        public void setResultArray(List<Object> resultArray) {
            this.resultArray = resultArray;
        }
    }

    protected static class SingleStepSequenceIterator
    extends IntArraySequenceIterator {
        private static final long serialVersionUID = 7050734892999987259L;

        public SingleStepSequenceIterator(List<Object> outputRowValues) {
            super(null, outputRowValues);
            this.lastStepPos = 1;
        }

        @Override
        public boolean hasNext() {
            return this.lastStepPos > 0;
        }

        @Override
        public List<Object> next() {
            if (this.lastStepPos-- >= 0) {
                return this.currentRowValues;
            }
            throw new IndexOutOfBoundsException();
        }
    }

    protected static class EmptyIntArraySequenceIterator
    extends IntArraySequenceIterator {
        private static final long serialVersionUID = 2693549751283165957L;

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public List<Object> next() {
            throw new IndexOutOfBoundsException();
        }
    }
}

