/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.acccurrentfloat.constant;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.acccurrentfloat.constant.AcccurrentBatchKey;
import kd.fi.gl.acccurrentfloat.constant.AcccurrentFormula;
import kd.fi.gl.acccurrentfloat.formater.AccountNumIDParam;
import kd.fi.gl.acccurrentfloat.matchdata.AgeFormulaBuildMap;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.acct.AcctUtil;
import kd.fi.gl.enums.writeoff.WriteOffField;
import kd.fi.gl.reciprocal.ReciprocalScheme;
import kd.fi.gl.reciprocal.ReciprocalUtils;
import kd.fi.gl.reciprocal.simulate.WriteOff;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.service.GLThreadService;
import kd.fi.gl.util.InterfacePermissionService;
import kd.fi.gl.util.PermissionType;
import kd.fi.gl.util.ReClassUtils;

public class BCMAcccurrentFloatContext {
    private static final String RESULT_VAL = "v";
    private static final int INIT_ORG_CAPACITY = 8;
    private static final int INIT_CAPACITY = 64;
    private Map<AcccurrentBatchKey, List<AcccurrentFormula>> orgAndFormulaMap = new HashMap<AcccurrentBatchKey, List<AcccurrentFormula>>(64);
    private Set<String> currencyNumbers = new HashSet<String>(8);
    private Map<String, Long> currencyNumberToIdsMap;
    private static final Log log = LogFactory.getLog(BCMAcccurrentFloatContext.class);
    private String defaultOrgNumber;
    private String defaultBookTypeNumber;
    private String defaultCurNumber;
    private int defaultFy;
    private int defaultPeriod;
    private Map<String, Object> refParamMap;
    private Map<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>(64);
    private HasPermOrgResult permOrgResult;
    private String permName;

    public void addFormula(String orgNum, String bookTypeNum, Date bookedDate, AcccurrentFormula formula) {
        AcccurrentBatchKey batchKey = new AcccurrentBatchKey(orgNum, bookTypeNum, bookedDate);
        List formulas = this.orgAndFormulaMap.computeIfAbsent(batchKey, p -> new ArrayList(64));
        formulas.add(formula);
        this.currencyNumbers.add(formula.getCurrencyNumber());
    }

    public Map<String, Map<String, Object>> complie() throws Exception {
        this.currencyNumberToIdsMap = ReClassUtils.numbersToIds("bd_currency", this.currencyNumbers, null);
        this.permOrgResult = InterfacePermissionService.getAllPermOrgs(PermissionType.ACCTAGE);
        this.permName = InterfacePermissionService.getPermName(PermissionType.ACCTAGE);
        ArrayList<Future> futures = new ArrayList<Future>(this.orgAndFormulaMap.size());
        for (final Map.Entry<AcccurrentBatchKey, List<AcccurrentFormula>> entry : this.orgAndFormulaMap.entrySet()) {
            futures.add(GLThreadService.computeAcct((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    BCMAcccurrentFloatContext.this.singleOrgComplie((AcccurrentBatchKey)entry.getKey(), (List)entry.getValue());
                    return true;
                }
            }));
        }
        for (Future future : futures) {
            future.get();
        }
        this.logInfoTest("resultMap Count:" + this.resultMap.size());
        return this.resultMap;
    }

    private void singleOrgComplie(AcccurrentBatchKey batchKey, List<AcccurrentFormula> formulas) throws ParseException {
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((String)batchKey.getOrgNum(), (String)batchKey.getBookTypeNum());
        if (bookInfo == null) {
            String msg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u8d26\u7c3f\u7c7b\u578b%2$s\u65e0\u6cd5\u627e\u5230\u76f8\u5e94\u7684\u8d26\u7c3f\u3002", (String)"BCMAcccurrentContext_0", (String)"fi-gl-mservice", (Object[])new Object[0]), batchKey.getOrgNum(), batchKey.getBookTypeNum());
            for (AcccurrentFormula formula : formulas) {
                this.addErrorRst(formula.getKey(), msg);
            }
            this.logInfo(msg);
        } else {
            Date bookedDate;
            Long orgId = bookInfo.getOrgId();
            String errorMsg = AcctUtil.checkPermByOrgId(batchKey.getOrgNum(), this.permName, orgId, this.permOrgResult);
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                for (AcccurrentFormula formula : formulas) {
                    this.addErrorRst(formula.getKey(), errorMsg);
                }
                this.logInfo(errorMsg);
                return;
            }
            Long bookTypeId = bookInfo.getBookTypeId();
            Date periodEndDate = this.queryPeriodEndDate(this.defaultFy, this.defaultPeriod, bookInfo.getPeriodTypeId());
            try {
                if (periodEndDate != null) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    periodEndDate = simpleDateFormat.parse(simpleDateFormat.format(periodEndDate));
                }
            }
            catch (Exception e) {
                this.logInfoTest(periodEndDate + " periodEndDate parse error");
                throw e;
            }
            this.setFormulaDefaultExpireDate(formulas, periodEndDate);
            Date date = bookedDate = batchKey.getBookedDate() == null ? periodEndDate : batchKey.getBookedDate();
            if (bookedDate == null) {
                String msg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u8d26\u7c3f\u7c7b\u578b%2$s\u65e0\u6cd5\u627e\u5230\u76f8\u5e94\u671f\u95f4\u7684\u65e5\u671f\u3002", (String)"BCMAcccurrentContext_1", (String)"fi-gl-mservice", (Object[])new Object[0]), batchKey.getOrgNum(), batchKey.getBookTypeNum());
                for (AcccurrentFormula formula : formulas) {
                    this.addErrorRst(formula.getKey(), msg);
                }
                this.logInfo(msg);
                return;
            }
            List acctTableIds = ReportUtils.getVerAcctTable((long)orgId, (long)bookInfo.getBookTypeId(), (long)bookInfo.getPeriodTypeId(), (Date)bookedDate);
            Long accountTableId = (Long)acctTableIds.get(0);
            this.logInfo(String.format("org:%s, booktype:%s, accounttable:%s, bookdate:%s", orgId, bookTypeId, accountTableId, bookedDate));
            AccountNumIDParam numIDParam = new AccountNumIDParam(orgId, bookTypeId, accountTableId, formulas, bookedDate, this.refParamMap);
            this.addFormatError(numIDParam);
            long pTimeAgeMap = System.currentTimeMillis();
            AgeFormulaBuildMap ageFormulaMap = new AgeFormulaBuildMap(this.currencyNumberToIdsMap, formulas, numIDParam);
            long aTimeAgeMap = System.currentTimeMillis();
            this.logInfoTest("AgeFormulaBuildMap build Time" + (pTimeAgeMap - aTimeAgeMap));
            HashSet<String> flexSet = new HashSet<String>(8);
            for (AcccurrentFormula formula : formulas) {
                flexSet.addAll(formula.getFloatFlexList());
                flexSet.addAll(formula.getNonFloatAssgrpMap().keySet());
            }
            Set<Long> allLeafMasterIds = numIDParam.getAllLeafMasterIds();
            long pTime = System.currentTimeMillis();
            DataSet records = this.queryAcccurrentBal(bookInfo, accountTableId, bookedDate, allLeafMasterIds, flexSet);
            long aTime = System.currentTimeMillis();
            this.logInfoTest("queryAcccurrentBal Reciprocal Simulate Time" + (aTime - pTime));
            if (DebugTrace.enable()) {
                this.printLogRecord(records.copy(), flexSet);
            }
            long pTime1 = System.currentTimeMillis();
            Map<String, Map<String, Object>> formulaMap = ageFormulaMap.getResultMap(records);
            formulaMap.entrySet().stream().forEach(x -> this.resultMap.putIfAbsent((String)x.getKey(), (Map<String, Object>)x.getValue()));
            long aTime1 = System.currentTimeMillis();
            this.logInfoTest("AgeFormulaBuildMap Formula Map Time\uff1a" + (aTime1 - pTime1));
        }
    }

    private void setFormulaDefaultExpireDate(List<AcccurrentFormula> formulas, Date periodEndDate) {
        formulas.forEach(x -> x.setDefaultExpireDate(periodEndDate));
    }

    private void printLogRecord(DataSet records, Set<String> flexSet) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (Row record : records) {
            ++count;
            sb.append("amountbal:");
            sb.append(record.getBigDecimal("amountbalfor"));
            sb.append(',');
            for (String flex : flexSet) {
                sb.append(flex);
                sb.append(":");
                sb.append(record.get(flex));
                sb.append(',');
            }
            sb.append("]");
        }
        sb.append(String.format("return record size: %s, ", count));
        this.logInfo(sb.toString());
    }

    public int clear(Map<Long, Set<AcccurrentFormula>> accountAndFormulaKeyMap) {
        if (null != accountAndFormulaKeyMap) {
            accountAndFormulaKeyMap.clear();
        }
        return 0;
    }

    private Date queryPeriodEndDate(int defaultFy, int defaultPeriod, long periodTypeId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        QFilter fperiodTypeId = new QFilter("periodtype", "=", (Object)periodTypeId);
        QFilter ffy = new QFilter("periodyear", "=", (Object)defaultFy);
        QFilter fperiod = new QFilter("periodnumber", "=", (Object)defaultPeriod);
        filters.add(fperiod);
        filters.add(fperiodTypeId);
        filters.add(ffy);
        DataSet periodSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_period", (String)"enddate", (QFilter[])filters.toArray(new QFilter[0]), null);
        Date endDate = null;
        for (Row row : periodSet) {
            endDate = row.getDate("enddate");
        }
        return endDate;
    }

    private void addFormatError(AccountNumIDParam numIDParam) {
        Map<String, String> errMap = numIDParam.getErrorInfoMap();
        for (Map.Entry<String, String> entry : errMap.entrySet()) {
            this.addErrorRst(entry.getKey(), entry.getValue());
        }
    }

    private DataSet queryAcccurrentBal(AccountBookInfo bookInfo, Long accountTableId, Date bookedDate, Set<Long> detailAcctMasterIds, Set<String> flexSet) {
        List<ReciprocalScheme> schemes = this.buildDefaultReciprocalScheme(bookInfo, accountTableId, bookedDate, detailAcctMasterIds);
        StringBuilder sb = new StringBuilder();
        for (ReciprocalScheme scheme : schemes) {
            sb.append("scheme:");
            sb.append(scheme.getNumber());
            sb.append(",org:");
            sb.append(scheme.getOrg());
            sb.append(",account:");
            sb.append(scheme.getAccountList());
            sb.append(',');
        }
        this.logInfo(sb.toString());
        return this.doSimulateWriteOff(schemes, flexSet);
    }

    private List<ReciprocalScheme> buildDefaultReciprocalScheme(AccountBookInfo bookInfo, Long accountTableId, Date bookedDate, Set<Long> detailAcctMasterIds) {
        Long orgId = bookInfo.getOrgId();
        List schemes = ReciprocalUtils.loadRcpSchemes((Long)orgId, (Long)accountTableId, detailAcctMasterIds, (Long)0L);
        HashSet existSchemeAcctIds = new HashSet(detailAcctMasterIds.size());
        for (ReciprocalScheme scheme : schemes) {
            existSchemeAcctIds.addAll(scheme.getAccountList());
        }
        detailAcctMasterIds.removeAll(existSchemeAcctIds);
        if (!detailAcctMasterIds.isEmpty()) {
            ReciprocalScheme scheme = new ReciprocalScheme();
            scheme.setOrg(orgId);
            scheme.setAccountList(new ArrayList<Long>(detailAcctMasterIds));
            schemes.add(scheme);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(bookedDate);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        bookedDate = calendar.getTime();
        for (ReciprocalScheme scheme : schemes) {
            scheme.setChildOrgs(Collections.singleton(orgId));
            scheme.setBookType(Long.valueOf(bookInfo.getBookTypeId()));
            scheme.setBookedDate(bookedDate);
            scheme.setPeriodType(Long.valueOf(bookInfo.getPeriodTypeId()));
            scheme.setAccountTableId(accountTableId);
            if (scheme.getCurrencyList() == null) {
                scheme.setCurrencyList(new ArrayList(8));
            }
            scheme.setShowByamount(true);
        }
        return schemes;
    }

    private DataSet doSimulateWriteOff(List<ReciprocalScheme> schemes, Set<String> flexSelector) {
        ArrayList<WriteOffField> sumFields = new ArrayList<WriteOffField>(8);
        sumFields.add(WriteOffField.AMOUNTBAL);
        sumFields.add(WriteOffField.AMOUNTBALFOR);
        ArrayList<WriteOffField> groupFields = new ArrayList<WriteOffField>(8);
        groupFields.add(WriteOffField.ACCOUNT);
        groupFields.add(WriteOffField.CURRENCYFOR);
        groupFields.add(WriteOffField.EXPIREDATE);
        groupFields.add(WriteOffField.BIZDATE);
        long pTime = System.currentTimeMillis();
        DataSet recordsDt = WriteOff.getWriteOffInstance().schemeSimulateWriteOff(schemes, groupFields, sumFields, new ArrayList<String>(flexSelector));
        long aTime = System.currentTimeMillis();
        this.logInfoTest("engine.run() Reciprocal Simulate Time" + (aTime - pTime));
        return recordsDt;
    }

    public void addErrorRst(String formulaKey, String msg) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        result.put(RESULT_VAL, null);
        result.put("success", false);
        result.put("failmsg", msg);
        this.resultMap.put(formulaKey, result);
    }

    private void logInfo(String msg) {
        log.info("ACCTAGE:" + msg);
    }

    private void logInfoTest(String msg) {
        log.info("ACCTAGE Take Up Time:" + msg);
    }

    public String getDefaultOrgNumber() {
        return this.defaultOrgNumber;
    }

    public void setDefaultOrgNumber(String defaultOrgNumber) {
        this.defaultOrgNumber = defaultOrgNumber;
    }

    public String getDefaultBookTypeNumber() {
        return this.defaultBookTypeNumber;
    }

    public void setDefaultBookTypeNumber(String defaultBookTypeNumber) {
        this.defaultBookTypeNumber = defaultBookTypeNumber;
    }

    public String getDefaultCurNumber() {
        return this.defaultCurNumber;
    }

    public void setDefaultCurNumber(String defaultCurNumber) {
        this.defaultCurNumber = defaultCurNumber;
    }

    public int getDefaultFy() {
        return this.defaultFy;
    }

    public void setDefaultFy(int defaultFy) {
        this.defaultFy = defaultFy;
    }

    public int getDefaultPeriod() {
        return this.defaultPeriod;
    }

    public void setDefaultPeriod(int defaultPeriod) {
        this.defaultPeriod = defaultPeriod;
    }

    public Map<String, Object> getRefParamMap() {
        return this.refParamMap;
    }

    public void setRefParamMap(Map<String, Object> refParamMap) {
        this.refParamMap = refParamMap;
    }
}

