/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.acct.buildparam;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.exception.KDBizException;

public class AssistIdCollectionType {
    private static final String _CACHE_KEY = "fi.gl.acct.AssistIdCollectionType.cache";
    private static final String _INDEX_CACHE_KEY = "fi.gl.acct.AssistIdCollectionType.index";
    private final String assistType;
    private final String groupNumber;
    private final Set<Long> mids;

    public AssistIdCollectionType(String assistType, String groupNumber, Collection<Long> mids) {
        this.assistType = assistType;
        this.groupNumber = groupNumber;
        this.mids = mids instanceof Set ? (Set<Object>)mids : new HashSet<Long>(mids);
        Map cache = (Map)ThreadCache.get((Object)_CACHE_KEY, () -> new HashMap(), (boolean)true);
        cache.put(AssistIdCollectionType.getCacheKey(assistType, groupNumber), this);
    }

    public static void rebuildIndex() {
        HashMap<String, Map> index = new HashMap<String, Map>(8);
        ThreadCache.put((Object)_INDEX_CACHE_KEY, index);
        Map allCollTypes = (Map)ThreadCache.get((Object)_CACHE_KEY, () -> new HashMap(), (boolean)true);
        for (AssistIdCollectionType type : allCollTypes.values()) {
            String assistType = type.getAssistType();
            Map idToTypeMap = index.computeIfAbsent(assistType, x -> new HashMap(8));
            Set<Long> ids = type.getMids();
            for (Long id : ids) {
                Set typeValues = idToTypeMap.computeIfAbsent(id, x -> new HashSet(1));
                typeValues.add(type);
            }
        }
    }

    public static boolean isExistCollectionType() {
        return !((Map)ThreadCache.get((Object)_CACHE_KEY, () -> Collections.EMPTY_MAP, (boolean)false)).isEmpty();
    }

    public static Set<AssistIdCollectionType> findByAssistTypeAndId(String assistType, Long assistId) {
        Object indexObj = ThreadCache.get((Object)_INDEX_CACHE_KEY);
        if (null == indexObj) {
            throw new KDBizException("No index build");
        }
        Map index = (Map)indexObj;
        Map idToTypeMap = (Map)index.get(assistType);
        if (idToTypeMap == null) {
            return Collections.EMPTY_SET;
        }
        Set types = (Set)idToTypeMap.get(assistId);
        if (types == null) {
            return Collections.EMPTY_SET;
        }
        return types;
    }

    private static String getCacheKey(String assistType, String groupNumber) {
        return String.format("%s_%s", assistType, groupNumber);
    }

    public static AssistIdCollectionType retrievalCollectionType(String assistType, String groupNumber) {
        Map cache = (Map)ThreadCache.get((Object)_CACHE_KEY, () -> new HashMap(), (boolean)true);
        return (AssistIdCollectionType)cache.get(AssistIdCollectionType.getCacheKey(assistType, groupNumber));
    }

    public String getAssistType() {
        return this.assistType;
    }

    public String getGroupNumber() {
        return this.groupNumber;
    }

    public Set<Long> getMids() {
        return this.mids;
    }

    public String toString() {
        return "AssistIdCollectionType{assistType='" + this.assistType + '\'' + ", groupNumber='" + this.groupNumber + '\'' + ", mids=" + this.mids + '}';
    }
}

