/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.acct.buildparam;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.acct.action.QueryTask;
import kd.fi.gl.acct.buildparam.AbstractBuildParamMapAction;
import kd.fi.gl.acct.buildparam.AssistWrap;
import kd.fi.gl.acct.buildparam.BuildParamMapContext;
import kd.fi.gl.acct.combination.AssistCombination;
import kd.fi.gl.acct.combination.IBiz;
import kd.fi.gl.acct.context.AcctKeyObject;
import kd.fi.gl.acct.context.AcctMapContext;
import kd.fi.gl.acct.context.AcctMapContextKey;
import kd.fi.gl.acct.context.AssistAcctGroupMapContext;
import kd.fi.gl.acct.context.AssistKeyObject;
import kd.fi.gl.acct.param.AcctParam;
import kd.fi.gl.acct.param.FormulaParam;
import kd.fi.gl.acct.param.ReClassNumberIDParam;

public class BuildQueryTask
extends AbstractBuildParamMapAction {
    private int totalLoopCnt = 0;
    private static final Log log = LogFactory.getLog(BuildQueryTask.class);

    public BuildQueryTask(BuildParamMapContext ctx) {
        super(ctx);
    }

    @Override
    protected void action() {
        AcctMapContext acctMapContext;
        AssistAcctGroupMapContext assistAcctGroupMapContext = this.ctx.getBuildAcctMapContext().getAssistAcctGroupMapContext();
        Map<Set<String>, AcctMapContext> groupMap = assistAcctGroupMapContext.getGroupMap();
        List<AcctParam> acctParams = this.ctx.getAcctParams();
        Set<String> allFlexs = this.ctx.getAllFlexs();
        FormulaParam formulaParam = this.ctx.getFormulaParam();
        long currencyId = this.ctx.getCurrencyId();
        String fetchType = this.ctx.getFetchType();
        long bookTypeId = this.ctx.getBookTypeId();
        Long startPeriodId = this.ctx.getStartPeriodId();
        Long endPeriodId = this.ctx.getEndPeriodId();
        long acctTableId = this.ctx.getAcctTableId();
        ReClassNumberIDParam numberIDParam = this.ctx.getNumberIDParam();
        if (groupMap.containsKey(allFlexs)) {
            acctMapContext = groupMap.get(allFlexs);
        } else {
            acctMapContext = new AcctMapContext();
            groupMap.put(allFlexs, acctMapContext);
        }
        Map<AcctMapContextKey, QueryTask> acctMap = acctMapContext.getAcctKeyObjectObjectMap(fetchType, currencyId);
        AcctMapContextKey acctMapContextKey = AcctMapContextKey.retrievalFromCacheOrBuild(bookTypeId, startPeriodId, endPeriodId, acctTableId);
        QueryTask queryTask = acctMap.get(acctMapContextKey);
        if (null == queryTask) {
            HashBasedTable formulasTable = HashBasedTable.create();
            queryTask = new QueryTask(bookTypeId, startPeriodId, endPeriodId, acctTableId, (Table<AcctKeyObject, AssistKeyObject, Set<FormulaParam>>)formulasTable, numberIDParam, allFlexs);
            acctMap.put(acctMapContextKey, queryTask);
        }
        this.setQueryTaskPropertyVal(queryTask);
        int loopCnt2 = 0;
        int loopCnt3 = 0;
        Table<AcctKeyObject, AssistKeyObject, Set<FormulaParam>> formulaTable = queryTask.getMap();
        Set<Map<String, Object>> comAssistKeySet = this.buildComAssistKey(this.ctx.getComAssistIdMap());
        for (AcctParam acctParam : acctParams) {
            Set<AssistWrap> detailAssistSet = acctParam.getDetailAssistSet();
            Set<String> detailAccountNumberSet = acctParam.getDetailAccountNumberSet();
            for (String acctNumber : detailAccountNumberSet) {
                ++loopCnt2;
                for (AssistWrap singleAssistMap : detailAssistSet) {
                    ++loopCnt3;
                    ++this.totalLoopCnt;
                    AcctKeyObject acctKey = AcctKeyObject.retrievalFromCacheOrBuild(currencyId, singleAssistMap);
                    if (!CollectionUtils.isEmpty(comAssistKeySet)) {
                        comAssistKeySet.stream().forEach(x -> this.setFormulaTable(acctNumber, (Map<String, Object>)x, acctKey, formulaParam, formulaTable));
                    } else {
                        this.setFormulaTable(acctNumber, Collections.EMPTY_MAP, acctKey, formulaParam, formulaTable);
                    }
                    assistAcctGroupMapContext.autoIncrease();
                }
            }
        }
        if (DebugTrace.enable()) {
            log.info("acctdebug AcctMapContextKey_constructor instance times: {}, loop size: {}, {}, {}, total loop: {}", new Object[]{AcctMapContextKey.INIT_COUNT.get(), acctParams.size(), loopCnt2, loopCnt3, this.totalLoopCnt});
            log.info("acctdebug AcctKeyObject_constructor instance times: {}, Hit cache times: {}", (Object)AcctKeyObject.INIT_COUNT.get(), (Object)AcctKeyObject.HIT_TIMES.get());
            log.info("acctdebug AssistWrap_constructor instance times: {}, Hit cache times: {}", (Object)AssistWrap.INIT_COUNT.get(), (Object)AssistWrap.HIT_TIMES.get());
        }
    }

    private void setFormulaTable(String acctNumber, Map<String, Object> comAssistMap, AcctKeyObject acctKey, FormulaParam formulaParam, Table<AcctKeyObject, AssistKeyObject, Set<FormulaParam>> formulaTable) {
        AssistKeyObject assistKey = AssistKeyObject.retrievalFromCacheOrBuild(acctNumber, comAssistMap);
        HashSet<FormulaParam> formulaSet = (HashSet<FormulaParam>)formulaTable.get((Object)acctKey, (Object)assistKey);
        if (formulaSet == null) {
            formulaSet = new HashSet<FormulaParam>(8);
            formulaSet.add(formulaParam);
            formulaTable.put((Object)acctKey, (Object)assistKey, formulaSet);
        } else {
            formulaSet.add(formulaParam);
        }
    }

    private Set<Map<String, Object>> buildComAssistKey(Map<String, Set<Long>> comAssistIdMap) {
        HashMap combineComAssistMap = new HashMap(8);
        for (Map.Entry<String, Set<Long>> comAssistIdEntry : comAssistIdMap.entrySet()) {
            Set<Long> valueIdSet = comAssistIdEntry.getValue();
            if (!CollectionUtils.isNotEmpty(valueIdSet)) continue;
            HashSet<Long> toObjectTypeSet = new HashSet<Long>(valueIdSet.size());
            toObjectTypeSet.addAll(valueIdSet);
            combineComAssistMap.put(comAssistIdEntry.getKey(), toObjectTypeSet);
        }
        final HashSet<Map<String, Object>> comAssistCombinationSet = new HashSet<Map<String, Object>>(8);
        AssistCombination.parts(combineComAssistMap, new IBiz(){

            public void deal(Map params) {
                comAssistCombinationSet.add(params);
            }
        });
        return comAssistCombinationSet;
    }

    private void setQueryTaskPropertyVal(QueryTask queryTask) {
        queryTask.addOrgIds(this.ctx.getOrgId());
        queryTask.addCurrencyIds(this.ctx.getCurrencyId());
        queryTask.addFetchTypes(this.ctx.getFetchType());
        queryTask.addValFlexsSet(new HashSet<Set<String>>(this.ctx.getValFlexsSet()));
        queryTask.addComAssistIdMap(this.ctx.getComAssistIdMap());
        queryTask.getAllFormulas().add(this.ctx.getFormulaParam());
        Set<Long> acctIds = this.ctx.getAcctToRCAcctIdsMap().keySet();
        Map<Long, Set<Long>> acctToLeafAcctMap = this.ctx.getNumberIDParam().getAcctToAllLeafMap();
        HashSet<Long> allLeafIds = new HashSet<Long>();
        acctIds.stream().forEach(x -> allLeafIds.addAll((Collection)acctToLeafAcctMap.get(x)));
        queryTask.addLeafAcctIds(allLeafIds);
        this.ctx.getAcctParams().stream().forEach(x -> queryTask.addAcctNumbers(x.getDetailAccountNumberSet()));
    }
}

