/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.acct.context;

import java.util.ArrayList;
import java.util.Objects;
import kd.bos.cache.ThreadCache;
import kd.bos.util.ThreadLocals;
import kd.fi.gl.util.MultiIndexTreeCache;

public class AcctMapContextKey {
    private static final String _CACHE_KEY = "fi.gl.acct.acctmapcontextkey.cache";
    public static ThreadLocal<Integer> INIT_COUNT = ThreadLocals.create((Object)0);
    private long bookTypeId;
    private long startPeriodId;
    private long endPeriodId;
    private long accountTableId;

    private AcctMapContextKey(Long bookTypeId, Long startPeriodId, Long endPeriodId, Long accountTableId) {
        this.bookTypeId = bookTypeId;
        this.startPeriodId = startPeriodId;
        this.endPeriodId = endPeriodId;
        this.accountTableId = accountTableId;
    }

    public static AcctMapContextKey retrievalFromCacheOrBuild(Long bookTypeId, Long startPeriodId, Long endPeriodId, Long accountTableId) {
        MultiIndexTreeCache _keyCache = (MultiIndexTreeCache)ThreadCache.get((Object)_CACHE_KEY, () -> new MultiIndexTreeCache("AcctMapContextKey", 100000));
        ArrayList<Long> _factors = new ArrayList<Long>(6);
        _factors.add(bookTypeId);
        _factors.add(accountTableId);
        _factors.add(startPeriodId);
        _factors.add(endPeriodId);
        AcctMapContextKey value = (AcctMapContextKey)_keyCache.retrieval(_factors.toArray());
        if (null != value) {
            return value;
        }
        AcctMapContextKey key = new AcctMapContextKey(bookTypeId, startPeriodId, endPeriodId, accountTableId);
        ((MultiIndexTreeCache)ThreadCache.get((Object)_CACHE_KEY)).addData((Object)key, _factors.toArray());
        INIT_COUNT.set(INIT_COUNT.get() + 1);
        return key;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (!(obj instanceof AcctMapContextKey)) {
            return false;
        }
        AcctMapContextKey e = (AcctMapContextKey)obj;
        return e.bookTypeId == this.bookTypeId && e.startPeriodId == this.startPeriodId && e.endPeriodId == this.endPeriodId && e.accountTableId == this.accountTableId;
    }

    public int hashCode() {
        return Objects.hash(this.bookTypeId, this.startPeriodId, this.endPeriodId, this.accountTableId);
    }

    public Long getBookTypeId() {
        return this.bookTypeId;
    }

    public void setBookTypeId(Long bookTypeId) {
        this.bookTypeId = bookTypeId;
    }

    public long getStartPeriodId() {
        return this.startPeriodId;
    }

    public void setStartPeriodId(long startPeriodId) {
        this.startPeriodId = startPeriodId;
    }

    public long getEndPeriodId() {
        return this.endPeriodId;
    }

    public void setEndPeriodId(long endPeriodId) {
        this.endPeriodId = endPeriodId;
    }

    public Long getAccountTableId() {
        return this.accountTableId;
    }

    public void setAccountTableId(Long accountTableId) {
        this.accountTableId = accountTableId;
    }
}

